/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Window;
import java.awt.event.ComponentEvent;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class WindowEvent
extends ComponentEvent {
    public static final int WINDOW_FIRST = 200;
    public static final int WINDOW_OPENED = 200;
    public static final int WINDOW_CLOSING = 201;
    public static final int WINDOW_CLOSED = 202;
    public static final int WINDOW_ICONIFIED = 203;
    public static final int WINDOW_DEICONIFIED = 204;
    public static final int WINDOW_ACTIVATED = 205;
    public static final int WINDOW_DEACTIVATED = 206;
    public static final int WINDOW_GAINED_FOCUS = 207;
    public static final int WINDOW_LOST_FOCUS = 208;
    public static final int WINDOW_STATE_CHANGED = 209;
    public static final int WINDOW_LAST = 209;
    transient Window opposite;
    int oldState;
    int newState;
    private static final long serialVersionUID = -1567959133147912127L;

    public WindowEvent(Window source, int id, Window opposite, int oldState, int newState) {
        super(source, id);
        this.opposite = opposite;
        this.oldState = oldState;
        this.newState = newState;
    }

    public WindowEvent(Window source, int id, Window opposite) {
        this(source, id, opposite, 0, 0);
    }

    public WindowEvent(Window source, int id, int oldState, int newState) {
        this(source, id, null, oldState, newState);
    }

    public WindowEvent(Window source, int id) {
        this(source, id, null, 0, 0);
    }

    public Window getWindow() {
        return this.source instanceof Window ? (Window)this.source : null;
    }

    public Window getOppositeWindow() {
        if (this.opposite == null) {
            return null;
        }
        return SunToolkit.targetToAppContext(this.opposite) == AppContext.getAppContext() ? this.opposite : null;
    }

    public int getOldState() {
        return this.oldState;
    }

    public int getNewState() {
        return this.newState;
    }

    @Override
    public String paramString() {
        Object typeStr;
        switch (this.id) {
            case 200: {
                typeStr = "WINDOW_OPENED";
                break;
            }
            case 201: {
                typeStr = "WINDOW_CLOSING";
                break;
            }
            case 202: {
                typeStr = "WINDOW_CLOSED";
                break;
            }
            case 203: {
                typeStr = "WINDOW_ICONIFIED";
                break;
            }
            case 204: {
                typeStr = "WINDOW_DEICONIFIED";
                break;
            }
            case 205: {
                typeStr = "WINDOW_ACTIVATED";
                break;
            }
            case 206: {
                typeStr = "WINDOW_DEACTIVATED";
                break;
            }
            case 207: {
                typeStr = "WINDOW_GAINED_FOCUS";
                break;
            }
            case 208: {
                typeStr = "WINDOW_LOST_FOCUS";
                break;
            }
            case 209: {
                typeStr = "WINDOW_STATE_CHANGED";
                break;
            }
            default: {
                typeStr = "unknown type";
            }
        }
        typeStr = (String)typeStr + ",opposite=" + this.getOppositeWindow() + ",oldState=" + this.oldState + ",newState=" + this.newState;
        return typeStr;
    }
}

