/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.JavaAWTFontAccessImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import jdk.internal.misc.JavaAWTFontAccess;
import jdk.internal.misc.SharedSecrets;

public final class NumericShaper
implements Serializable {
    private int key;
    private int mask;
    private Range shapingRange;
    private transient Set<Range> rangeSet;
    private transient Range[] rangeArray;
    private static final int BSEARCH_THRESHOLD = 3;
    private static final long serialVersionUID = -8022764705923730308L;
    public static final int EUROPEAN = 1;
    public static final int ARABIC = 2;
    public static final int EASTERN_ARABIC = 4;
    public static final int DEVANAGARI = 8;
    public static final int BENGALI = 16;
    public static final int GURMUKHI = 32;
    public static final int GUJARATI = 64;
    public static final int ORIYA = 128;
    public static final int TAMIL = 256;
    public static final int TELUGU = 512;
    public static final int KANNADA = 1024;
    public static final int MALAYALAM = 2048;
    public static final int THAI = 4096;
    public static final int LAO = 8192;
    public static final int TIBETAN = 16384;
    public static final int MYANMAR = 32768;
    public static final int ETHIOPIC = 65536;
    public static final int KHMER = 131072;
    public static final int MONGOLIAN = 262144;
    public static final int ALL_RANGES = 524287;
    private static final int EUROPEAN_KEY = 0;
    private static final int ARABIC_KEY = 1;
    private static final int EASTERN_ARABIC_KEY = 2;
    private static final int DEVANAGARI_KEY = 3;
    private static final int BENGALI_KEY = 4;
    private static final int GURMUKHI_KEY = 5;
    private static final int GUJARATI_KEY = 6;
    private static final int ORIYA_KEY = 7;
    private static final int TAMIL_KEY = 8;
    private static final int TELUGU_KEY = 9;
    private static final int KANNADA_KEY = 10;
    private static final int MALAYALAM_KEY = 11;
    private static final int THAI_KEY = 12;
    private static final int LAO_KEY = 13;
    private static final int TIBETAN_KEY = 14;
    private static final int MYANMAR_KEY = 15;
    private static final int ETHIOPIC_KEY = 16;
    private static final int KHMER_KEY = 17;
    private static final int MONGOLIAN_KEY = 18;
    private static final int NUM_KEYS = 19;
    private static final int CONTEXTUAL_MASK = Integer.MIN_VALUE;
    private static final char[] bases;
    private static final char[] contexts;
    private static int ctCache;
    private static int ctCacheLimit;
    private volatile transient Range currentRange = Range.EUROPEAN;
    private static int[] strongTable;
    private volatile transient int stCache = 0;

    private static int getContextKey(char c) {
        block3: {
            block2: {
                if (c >= contexts[ctCache]) break block2;
                while (ctCache > 0 && c < contexts[ctCache]) {
                    --ctCache;
                }
                break block3;
            }
            if (c < contexts[ctCache + 1]) break block3;
            while (ctCache < ctCacheLimit && c >= contexts[ctCache + 1]) {
                ++ctCache;
            }
        }
        return (ctCache & 1) == 0 ? ctCache / 2 : 0;
    }

    private Range rangeForCodePoint(int codepoint) {
        if (this.currentRange.inRange(codepoint)) {
            return this.currentRange;
        }
        Range[] ranges = this.rangeArray;
        if (ranges.length > 3) {
            int lo = 0;
            int hi = ranges.length - 1;
            while (lo <= hi) {
                int mid = (lo + hi) / 2;
                Range range = ranges[mid];
                if (codepoint < range.start) {
                    hi = mid - 1;
                    continue;
                }
                if (codepoint >= range.end) {
                    lo = mid + 1;
                    continue;
                }
                this.currentRange = range;
                return range;
            }
        } else {
            for (int i = 0; i < ranges.length; ++i) {
                if (!ranges[i].inRange(codepoint)) continue;
                return ranges[i];
            }
        }
        return Range.EUROPEAN;
    }

    private boolean isStrongDirectional(char c) {
        int cachedIndex = this.stCache;
        if (c < strongTable[cachedIndex]) {
            cachedIndex = NumericShaper.search(c, strongTable, 0, cachedIndex);
        } else if (c >= strongTable[cachedIndex + 1]) {
            cachedIndex = NumericShaper.search(c, strongTable, cachedIndex + 1, strongTable.length - cachedIndex - 1);
        }
        boolean val = (cachedIndex & 1) == 1;
        this.stCache = cachedIndex;
        return val;
    }

    private static int getKeyFromMask(int mask) {
        int key;
        for (key = 0; key < 19 && (mask & 1 << key) == 0; ++key) {
        }
        if (key == 19 || (mask & ~(1 << key)) != 0) {
            throw new IllegalArgumentException("invalid shaper: " + Integer.toHexString(mask));
        }
        return key;
    }

    public static NumericShaper getShaper(int singleRange) {
        int key = NumericShaper.getKeyFromMask(singleRange);
        return new NumericShaper(key, singleRange);
    }

    public static NumericShaper getShaper(Range singleRange) {
        return new NumericShaper(singleRange, EnumSet.of(singleRange));
    }

    public static NumericShaper getContextualShaper(int ranges) {
        return new NumericShaper(0, ranges |= Integer.MIN_VALUE);
    }

    public static NumericShaper getContextualShaper(Set<Range> ranges) {
        NumericShaper shaper = new NumericShaper(Range.EUROPEAN, ranges);
        shaper.mask = Integer.MIN_VALUE;
        return shaper;
    }

    public static NumericShaper getContextualShaper(int ranges, int defaultContext) {
        int key = NumericShaper.getKeyFromMask(defaultContext);
        return new NumericShaper(key, ranges |= Integer.MIN_VALUE);
    }

    public static NumericShaper getContextualShaper(Set<Range> ranges, Range defaultContext) {
        if (defaultContext == null) {
            throw new NullPointerException();
        }
        NumericShaper shaper = new NumericShaper(defaultContext, ranges);
        shaper.mask = Integer.MIN_VALUE;
        return shaper;
    }

    private NumericShaper(int key, int mask) {
        this.key = key;
        this.mask = mask;
    }

    private NumericShaper(Range defaultContext, Set<Range> ranges) {
        this.shapingRange = defaultContext;
        this.rangeSet = EnumSet.copyOf(ranges);
        if (this.rangeSet.contains((Object)Range.EASTERN_ARABIC) && this.rangeSet.contains((Object)Range.ARABIC)) {
            this.rangeSet.remove((Object)Range.ARABIC);
        }
        if (this.rangeSet.contains((Object)Range.TAI_THAM_THAM) && this.rangeSet.contains((Object)Range.TAI_THAM_HORA)) {
            this.rangeSet.remove((Object)Range.TAI_THAM_HORA);
        }
        this.rangeArray = this.rangeSet.toArray(new Range[this.rangeSet.size()]);
        if (this.rangeArray.length > 3) {
            Arrays.sort(this.rangeArray, new Comparator<Range>(){

                @Override
                public int compare(Range s1, Range s2) {
                    return s1.base > s2.base ? 1 : (s1.base == s2.base ? 0 : -1);
                }
            });
        }
    }

    public void shape(char[] text, int start, int count) {
        this.checkParams(text, start, count);
        if (this.isContextual()) {
            if (this.rangeSet == null) {
                this.shapeContextually(text, start, count, this.key);
            } else {
                this.shapeContextually(text, start, count, this.shapingRange);
            }
        } else {
            this.shapeNonContextually(text, start, count);
        }
    }

    public void shape(char[] text, int start, int count, int context) {
        this.checkParams(text, start, count);
        if (this.isContextual()) {
            int ctxKey = NumericShaper.getKeyFromMask(context);
            if (this.rangeSet == null) {
                this.shapeContextually(text, start, count, ctxKey);
            } else {
                this.shapeContextually(text, start, count, Range.values()[ctxKey]);
            }
        } else {
            this.shapeNonContextually(text, start, count);
        }
    }

    public void shape(char[] text, int start, int count, Range context) {
        this.checkParams(text, start, count);
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.isContextual()) {
            if (this.rangeSet != null) {
                this.shapeContextually(text, start, count, context);
            } else {
                int key = Range.toRangeIndex(context);
                if (key >= 0) {
                    this.shapeContextually(text, start, count, key);
                } else {
                    this.shapeContextually(text, start, count, this.shapingRange);
                }
            }
        } else {
            this.shapeNonContextually(text, start, count);
        }
    }

    private void checkParams(char[] text, int start, int count) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (start < 0 || start > text.length || start + count < 0 || start + count > text.length) {
            throw new IndexOutOfBoundsException("bad start or count for text of length " + text.length);
        }
    }

    public boolean isContextual() {
        return (this.mask & Integer.MIN_VALUE) != 0;
    }

    public int getRanges() {
        return this.mask & Integer.MAX_VALUE;
    }

    public Set<Range> getRangeSet() {
        if (this.rangeSet != null) {
            return EnumSet.copyOf(this.rangeSet);
        }
        return Range.maskToRangeSet(this.mask);
    }

    private void shapeNonContextually(char[] text, int start, int count) {
        int base;
        char minDigit = '0';
        if (this.shapingRange != null) {
            base = this.shapingRange.getDigitBase();
            minDigit = (char)(minDigit + this.shapingRange.getNumericBase());
        } else {
            base = bases[this.key];
            if (this.key == 16) {
                minDigit = (char)(minDigit + 1);
            }
        }
        int e = start + count;
        for (int i = start; i < e; ++i) {
            char c = text[i];
            if (c < minDigit || c > '9') continue;
            text[i] = (char)(c + base);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void shapeContextually(char[] text, int start, int count, int ctxKey) {
        if ((this.mask & 1 << ctxKey) == 0) {
            ctxKey = 0;
        }
        int lastkey = ctxKey;
        char base = bases[ctxKey];
        int minDigit = ctxKey == 16 ? 49 : 48;
        Class<NumericShaper> clazz = NumericShaper.class;
        synchronized (NumericShaper.class) {
            int e = start + count;
            for (int i = start; i < e; ++i) {
                int newkey;
                int c = text[i];
                if (c >= minDigit && c <= 57) {
                    text[i] = (char)(c + base);
                }
                if (!this.isStrongDirectional((char)c) || (newkey = NumericShaper.getContextKey((char)c)) == lastkey) continue;
                lastkey = newkey;
                ctxKey = newkey;
                if ((this.mask & 4) != 0 && (ctxKey == 1 || ctxKey == 2)) {
                    ctxKey = 2;
                } else if ((this.mask & 2) != 0 && (ctxKey == 1 || ctxKey == 2)) {
                    ctxKey = 1;
                } else if ((this.mask & 1 << ctxKey) == 0) {
                    ctxKey = 0;
                }
                base = bases[ctxKey];
                minDigit = ctxKey == 16 ? 49 : 48;
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    private void shapeContextually(char[] text, int start, int count, Range ctxKey) {
        if (ctxKey == null || !this.rangeSet.contains((Object)ctxKey)) {
            ctxKey = Range.EUROPEAN;
        }
        Range lastKey = ctxKey;
        int base = ctxKey.getDigitBase();
        char minDigit = (char)(48 + ctxKey.getNumericBase());
        int end = start + count;
        for (int i = start; i < end; ++i) {
            char c = text[i];
            if (c >= minDigit && c <= '9') {
                text[i] = (char)(c + base);
                continue;
            }
            if (!this.isStrongDirectional(c) || (ctxKey = this.rangeForCodePoint(c)) == lastKey) continue;
            lastKey = ctxKey;
            base = ctxKey.getDigitBase();
            minDigit = (char)(48 + ctxKey.getNumericBase());
        }
    }

    public int hashCode() {
        int hash = this.mask;
        if (this.rangeSet != null) {
            hash &= Integer.MIN_VALUE;
            hash ^= this.rangeSet.hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o != null) {
            try {
                NumericShaper rhs = (NumericShaper)o;
                if (this.rangeSet != null) {
                    if (rhs.rangeSet != null) {
                        return this.isContextual() == rhs.isContextual() && this.rangeSet.equals(rhs.rangeSet) && this.shapingRange == rhs.shapingRange;
                    }
                    return this.isContextual() == rhs.isContextual() && this.rangeSet.equals(Range.maskToRangeSet(rhs.mask)) && this.shapingRange == Range.indexToRange(rhs.key);
                }
                if (rhs.rangeSet != null) {
                    Set<Range> rset = Range.maskToRangeSet(this.mask);
                    Range srange = Range.indexToRange(this.key);
                    return this.isContextual() == rhs.isContextual() && rset.equals(rhs.rangeSet) && srange == rhs.shapingRange;
                }
                return rhs.mask == this.mask && rhs.key == this.key;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append("[contextual:").append(this.isContextual());
        Object keyNames = null;
        if (this.isContextual()) {
            buf.append(", context:");
            buf.append((Object)(this.shapingRange == null ? Range.values()[this.key] : this.shapingRange));
        }
        if (this.rangeSet == null) {
            buf.append(", range(s): ");
            boolean first = true;
            for (int i = 0; i < 19; ++i) {
                if ((this.mask & 1 << i) == 0) continue;
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append((Object)Range.values()[i]);
            }
        } else {
            buf.append(", range set: ").append(this.rangeSet);
        }
        buf.append(']');
        return buf.toString();
    }

    private static int getHighBit(int value) {
        if (value <= 0) {
            return -32;
        }
        int bit = 0;
        if (value >= 65536) {
            value >>= 16;
            bit += 16;
        }
        if (value >= 256) {
            value >>= 8;
            bit += 8;
        }
        if (value >= 16) {
            value >>= 4;
            bit += 4;
        }
        if (value >= 4) {
            value >>= 2;
            bit += 2;
        }
        if (value >= 2) {
            ++bit;
        }
        return bit;
    }

    private static int search(int value, int[] array, int start, int length) {
        int power = 1 << NumericShaper.getHighBit(length);
        int extra = length - power;
        int probe = power;
        int index = start;
        if (value >= array[index + extra]) {
            index += extra;
        }
        while (probe > 1) {
            if (value < array[index + (probe >>= 1)]) continue;
            index += probe;
        }
        return index;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int index;
        if (this.shapingRange != null && (index = Range.toRangeIndex(this.shapingRange)) >= 0) {
            this.key = index;
        }
        if (this.rangeSet != null) {
            this.mask |= Range.toRangeMask(this.rangeSet);
        }
        stream.defaultWriteObject();
    }

    static {
        if (SharedSecrets.getJavaAWTFontAccess() == null) {
            SharedSecrets.setJavaAWTFontAccess((JavaAWTFontAccess)new JavaAWTFontAccessImpl());
        }
        bases = new char[]{'\u0000', '\u0630', '\u06c0', '\u0936', '\u09b6', '\u0a36', '\u0ab6', '\u0b36', '\u0bb6', '\u0c36', '\u0cb6', '\u0d36', '\u0e20', '\u0ea0', '\u0ef0', '\u1010', '\u1338', '\u17b0', '\u17e0'};
        contexts = new char[]{'\u0000', '\u0300', '\u0600', '\u0780', '\u0600', '\u0780', '\u0900', '\u0980', '\u0980', '\u0a00', '\u0a00', '\u0a80', '\u0a80', '\u0b00', '\u0b00', '\u0b80', '\u0b80', '\u0c00', '\u0c00', '\u0c80', '\u0c80', '\u0d00', '\u0d00', '\u0d80', '\u0e00', '\u0e80', '\u0e80', '\u0f00', '\u0f00', '\u1000', '\u1000', '\u1080', '\u1200', '\u1380', '\u1780', '\u1800', '\u1800', '\u1900', '\uffff'};
        ctCache = 0;
        ctCacheLimit = contexts.length - 2;
        strongTable = new int[]{0, 65, 91, 97, 123, 170, 171, 181, 182, 186, 187, 192, 215, 216, 247, 248, 697, 699, 706, 720, 722, 736, 741, 750, 751, 880, 884, 886, 888, 890, 894, 895, 896, 902, 903, 904, 907, 908, 909, 910, 930, 931, 1014, 1015, 1155, 1162, 1328, 1329, 1367, 1369, 1376, 1377, 1416, 1417, 1418, 1424, 1425, 1470, 1471, 1472, 1473, 1475, 1476, 1478, 1479, 1480, 1536, 1544, 1545, 1547, 1548, 1549, 1550, 1563, 1611, 1645, 1648, 1649, 1750, 1765, 1767, 1774, 1776, 1786, 1809, 1810, 1840, 1867, 1958, 1969, 2027, 2036, 2038, 2042, 2070, 2074, 2075, 2084, 2085, 2088, 2089, 2094, 2137, 2140, 2275, 2307, 2362, 2363, 2364, 2365, 2369, 2377, 2381, 2382, 2385, 2392, 2402, 2404, 2433, 2434, 2436, 2437, 2445, 2447, 2449, 2451, 2473, 2474, 2481, 2482, 2483, 2486, 2490, 2493, 2497, 2503, 2505, 2507, 2509, 2510, 2511, 2519, 2520, 2524, 2526, 2527, 2530, 2534, 2546, 2548, 2555, 2556, 2558, 2563, 2564, 2565, 2571, 2575, 2577, 2579, 2601, 2602, 2609, 2610, 2612, 2613, 2615, 2616, 2618, 2622, 2625, 2649, 2653, 2654, 2655, 2662, 2672, 2674, 2677, 2691, 2692, 2693, 2702, 2703, 2706, 2707, 2729, 2730, 2737, 2738, 2740, 2741, 2746, 2749, 2753, 2761, 2762, 2763, 2765, 2768, 2769, 2784, 2786, 2790, 2801, 2809, 2810, 2818, 2820, 2821, 2829, 2831, 2833, 2835, 2857, 2858, 2865, 2866, 2868, 2869, 2874, 2877, 2879, 2880, 2881, 2887, 2889, 2891, 2893, 2903, 2904, 2908, 2910, 2911, 2914, 2918, 2936, 2947, 2948, 2949, 2955, 2958, 2961, 2962, 2966, 2969, 2971, 2972, 2973, 2974, 2976, 2979, 2981, 2984, 2987, 2990, 3002, 3006, 3008, 3009, 3011, 3014, 3017, 3018, 3021, 3024, 3025, 3031, 3032, 3046, 3059, 3073, 3076, 3077, 3085, 3086, 3089, 3090, 3113, 3114, 3130, 3133, 3134, 3137, 3141, 3160, 3163, 3168, 3170, 3174, 3184, 3199, 3201, 3202, 3204, 3205, 3213, 3214, 3217, 3218, 3241, 3242, 3252, 3253, 3258, 3261, 3269, 3270, 3273, 3274, 3276, 3285, 3287, 3294, 3295, 3296, 3298, 3302, 3312, 3313, 3315, 3330, 3332, 3333, 3341, 3342, 3345, 3346, 3387, 3389, 3393, 3398, 3401, 3402, 3405, 3406, 3426, 3430, 3456, 3458, 3460, 3461, 3479, 3482, 3506, 3507, 3516, 3517, 3518, 3520, 3527, 3535, 3538, 3544, 3552, 3558, 3568, 3570, 3573, 3585, 3633, 3634, 3636, 3648, 3655, 3663, 3676, 3713, 3715, 3716, 3717, 3719, 3721, 3722, 3723, 3725, 3726, 3732, 3736, 3737, 3744, 3745, 3748, 3749, 3750, 3751, 3752, 3754, 3756, 3757, 3761, 3762, 3764, 3773, 3774, 3776, 3781, 3782, 3783, 3792, 3802, 3804, 3808, 3840, 3864, 3866, 3893, 3894, 3895, 3896, 3897, 3902, 3912, 3913, 3949, 3967, 3968, 3973, 3974, 3976, 3981, 4030, 4038, 4039, 4045, 4046, 4059, 4096, 4141, 4145, 4146, 4152, 4153, 4155, 4157, 4159, 4184, 4186, 4190, 4193, 4209, 4213, 4226, 4227, 4229, 4231, 4237, 4238, 4253, 4254, 4294, 4295, 4296, 4301, 4302, 4304, 4681, 4682, 4686, 4688, 4695, 4696, 4697, 4698, 4702, 4704, 4745, 4746, 4750, 4752, 4785, 4786, 4790, 4792, 4799, 4800, 4801, 4802, 4806, 4808, 4823, 4824, 4881, 4882, 4886, 4888, 4955, 4960, 4989, 4992, 5008, 5024, 5110, 5112, 5118, 5121, 5760, 5761, 5787, 5792, 5881, 5888, 5901, 5902, 5906, 5920, 5938, 5941, 5943, 5952, 5970, 5984, 5997, 5998, 6001, 6016, 6068, 6070, 6071, 6078, 6086, 6087, 6089, 6100, 6107, 6108, 6109, 6112, 6122, 6160, 6170, 6176, 6264, 6276, 6277, 6279, 6313, 6314, 6315, 6320, 6390, 6400, 6431, 6435, 6439, 6441, 6444, 6448, 6450, 6451, 6457, 6470, 6510, 6512, 6517, 6528, 6572, 6576, 6602, 6608, 6619, 6656, 6679, 6681, 6683, 6686, 6742, 6743, 6744, 6753, 6754, 6755, 6757, 6765, 6771, 6784, 6794, 6800, 6810, 6816, 6830, 6916, 6964, 6965, 6966, 6971, 6972, 6973, 6978, 6979, 6988, 6992, 7019, 7028, 7037, 7042, 7074, 7078, 7080, 7082, 7083, 7086, 7142, 7143, 7144, 7146, 7149, 7150, 7151, 7154, 7156, 7164, 7212, 7220, 7222, 7227, 7242, 7245, 7368, 7379, 7380, 7393, 7394, 7401, 7405, 7406, 7412, 7413, 7416, 7424, 7616, 7680, 7958, 7960, 7966, 7968, 8006, 8008, 8014, 8016, 8024, 8025, 8026, 8027, 8028, 8029, 8030, 8031, 8062, 8064, 8117, 8118, 8125, 8126, 8127, 8130, 8133, 8134, 8141, 8144, 8148, 8150, 8156, 8160, 8173, 8178, 8181, 8182, 8189, 8206, 8208, 8305, 8306, 8319, 8320, 8336, 8349, 8450, 8451, 8455, 8456, 8458, 8468, 8469, 8470, 8473, 8478, 8484, 8485, 8486, 8487, 8488, 8489, 8490, 8494, 8495, 8506, 8508, 8512, 8517, 8522, 8526, 8528, 8544, 8585, 9014, 9083, 9109, 9110, 9372, 9450, 9900, 9901, 10240, 10496, 11264, 11311, 11312, 11359, 11360, 11493, 11499, 11503, 11506, 11508, 11520, 11558, 11559, 11560, 11565, 11566, 11568, 11624, 11631, 11633, 11648, 11671, 11680, 11687, 11688, 11695, 11696, 11703, 11704, 11711, 11712, 11719, 11720, 11727, 11728, 11735, 11736, 11743, 12293, 12296, 12321, 12330, 12334, 12336, 12337, 12342, 12344, 12349, 12353, 12439, 12445, 12448, 12449, 12539, 12540, 12544, 12549, 12591, 12593, 12687, 12688, 12731, 12784, 12829, 12832, 12880, 12896, 12924, 12927, 12977, 12992, 13004, 13008, 13055, 13056, 13175, 13179, 13278, 13280, 13311, 13312, 19894, 19968, 40939, 40960, 42125, 42192, 42509, 42512, 42540, 42560, 42607, 42624, 42654, 42656, 42736, 42738, 42744, 42786, 42888, 42889, 42927, 42928, 42936, 42999, 43010, 43011, 43014, 43015, 43019, 43020, 43045, 43047, 43048, 43056, 43064, 43072, 43124, 43136, 43204, 43214, 43226, 43250, 43262, 43264, 43302, 43310, 43335, 43346, 43348, 43359, 43389, 43395, 43443, 43444, 43446, 43450, 43452, 43453, 43470, 43471, 43482, 43486, 43493, 43494, 43519, 43520, 43561, 43567, 43569, 43571, 43573, 43584, 43587, 43588, 43596, 43597, 43598, 43600, 43610, 43612, 43644, 43645, 43696, 43697, 43698, 43701, 43703, 43705, 43710, 43712, 43713, 43714, 43715, 43739, 43756, 43758, 43766, 43777, 43783, 43785, 43791, 43793, 43799, 43808, 43815, 43816, 43823, 43824, 43878, 43888, 44005, 44006, 44008, 44009, 44013, 44016, 44026, 44032, 55204, 55216, 55239, 55243, 55292, 57344, 64110, 64112, 64218, 64256, 64263, 64275, 64280, 64285, 64286, 64287, 64297, 64298, 64830, 64832, 64976, 65008, 65021, 65022, 65024, 65136, 65279, 65313, 65339, 65345, 65371, 65382, 65471, 65474, 65480, 65482, 65488, 65490, 65496, 65498, 65501, 65536, 65548, 65549, 65575, 65576, 65595, 65596, 65598, 65599, 65614, 65616, 65630, 65664, 65787, 65792, 65793, 65794, 65795, 65799, 65844, 65847, 65856, 65933, 65935, 66000, 66045, 66176, 66205, 66208, 66257, 66304, 66340, 66349, 66379, 66384, 66422, 66432, 66462, 66463, 66500, 66504, 66518, 66560, 66718, 66720, 66730, 66771, 66772, 66776, 66812, 66816, 66856, 66864, 66916, 66927, 66928, 67072, 67383, 67392, 67414, 67424, 67432, 67584, 67871, 67872, 68097, 68100, 68101, 68103, 68108, 68112, 68152, 68155, 68159, 68160, 68325, 68327, 68409, 68416, 69216, 69247, 69633, 69634, 69688, 69703, 69710, 69734, 69744, 69762, 69811, 69815, 69817, 69819, 69826, 69840, 69865, 69872, 69882, 69891, 69927, 69932, 69933, 69942, 69956, 69968, 70003, 70004, 70007, 70018, 70070, 70079, 70090, 70093, 70094, 70096, 70112, 70113, 70133, 70144, 70162, 70163, 70191, 70194, 70196, 70197, 70198, 70200, 70206, 70272, 70279, 70280, 70281, 70282, 70286, 70287, 70302, 70303, 70314, 70320, 70367, 70368, 70371, 70384, 70394, 70402, 70404, 70405, 70413, 70415, 70417, 70419, 70441, 70442, 70449, 70450, 70452, 70453, 70458, 70461, 70464, 70465, 70469, 70471, 70473, 70475, 70478, 70480, 70481, 70487, 70488, 70493, 70500, 70656, 70712, 70720, 70722, 70725, 70726, 70727, 70746, 70747, 70748, 70749, 70750, 70784, 70835, 70841, 70842, 70843, 70847, 70849, 70850, 70852, 70856, 70864, 70874, 71040, 71090, 71096, 71100, 71102, 71103, 71105, 71132, 71168, 71219, 71227, 71229, 71230, 71231, 71233, 71237, 71248, 71258, 71296, 71339, 71340, 71341, 71342, 71344, 71350, 71351, 71360, 71370, 71424, 71450, 71456, 71458, 71462, 71463, 71472, 71488, 71840, 71923, 71935, 71936, 72192, 72193, 72199, 72201, 72203, 72243, 72250, 72251, 72255, 72263, 72272, 72273, 72279, 72281, 72284, 72324, 72326, 72330, 72343, 72344, 72346, 72349, 72350, 72355, 72384, 72441, 72704, 72713, 72714, 72752, 72766, 72774, 72784, 72813, 72816, 72848, 72873, 72874, 72881, 72882, 72884, 72885, 72960, 72967, 72968, 72970, 72971, 73009, 73030, 73031, 73040, 73050, 73728, 74650, 74752, 74863, 74864, 74869, 74880, 75076, 77824, 78895, 82944, 83527, 92160, 92729, 92736, 92767, 92768, 92778, 92782, 92784, 92880, 92910, 92917, 92918, 92928, 92976, 92983, 92998, 93008, 93018, 93019, 93026, 93027, 93048, 93053, 93072, 93952, 94021, 94032, 94079, 94099, 94112, 94176, 94178, 94208, 100333, 100352, 101107, 110592, 110879, 110960, 111356, 113664, 113771, 113776, 113789, 113792, 113801, 113808, 113818, 113820, 113821, 113823, 113824, 118784, 119030, 119040, 119079, 119081, 119143, 119146, 119155, 119171, 119173, 119180, 119210, 119214, 119273, 119648, 119666, 119808, 119893, 119894, 119965, 119966, 119968, 119970, 119971, 119973, 119975, 119977, 119981, 119982, 119994, 119995, 119996, 119997, 120004, 120005, 120070, 120071, 120075, 120077, 120085, 120086, 120093, 120094, 120122, 120123, 120127, 120128, 120133, 120134, 120135, 120138, 120145, 120146, 120486, 120488, 120539, 120540, 120597, 120598, 120655, 120656, 120713, 120714, 120771, 120772, 120780, 120832, 121344, 121399, 121403, 121453, 121461, 121462, 121476, 121477, 121484, 124928, 125136, 125143, 125252, 125259, 126704, 126706, 126976, 127248, 127279, 127280, 127338, 127344, 127405, 127462, 127491, 127504, 127548, 127552, 127561, 127568, 127570, 131072, 173783, 173824, 177973, 177984, 178206, 178208, 183970, 183984, 191457, 194560, 195102, 983040, 1048574, 0x100000, 1114110, 0x10FFFF};
    }

    public static enum Range {
        EUROPEAN(48, 0, 768),
        ARABIC(1632, 1536, 1920),
        EASTERN_ARABIC(1776, 1536, 1920),
        DEVANAGARI(2406, 2304, 2432),
        BENGALI(2534, 2432, 2560),
        GURMUKHI(2662, 2560, 2688),
        GUJARATI(2790, 2816, 2944),
        ORIYA(2918, 2816, 2944),
        TAMIL(3046, 2944, 3072),
        TELUGU(3174, 3072, 3200),
        KANNADA(3302, 3200, 3328),
        MALAYALAM(3430, 3328, 3456),
        THAI(3664, 3584, 3712),
        LAO(3792, 3712, 3840),
        TIBETAN(3872, 3840, 4096),
        MYANMAR(4160, 4096, 4224),
        ETHIOPIC(4969, 4608, 4992){

            @Override
            char getNumericBase() {
                return '\u0001';
            }
        }
        ,
        KHMER(6112, 6016, 6144),
        MONGOLIAN(6160, 6144, 6400),
        NKO(1984, 1984, 2048),
        MYANMAR_SHAN(4240, 4096, 4256),
        LIMBU(6470, 6400, 6480),
        NEW_TAI_LUE(6608, 6528, 6624),
        BALINESE(6992, 6912, 7040),
        SUNDANESE(7088, 7040, 7104),
        LEPCHA(7232, 7168, 7248),
        OL_CHIKI(7248, 7248, 7296),
        VAI(42528, 42240, 42560),
        SAURASHTRA(43216, 43136, 43232),
        KAYAH_LI(43264, 43264, 43312),
        CHAM(43600, 43520, 43616),
        TAI_THAM_HORA(6784, 6688, 6832),
        TAI_THAM_THAM(6800, 6688, 6832),
        JAVANESE(43472, 43392, 43488),
        MEETEI_MAYEK(44016, 43968, 44032),
        SINHALA(3558, 3456, 3584),
        MYANMAR_TAI_LAING(43504, 43488, 43520);

        private final int base;
        private final int start;
        private final int end;

        private static int toRangeIndex(Range script) {
            int index = script.ordinal();
            return index < 19 ? index : -1;
        }

        private static Range indexToRange(int index) {
            return index < 19 ? Range.values()[index] : null;
        }

        private static int toRangeMask(Set<Range> ranges) {
            int m = 0;
            for (Range range : ranges) {
                int index = range.ordinal();
                if (index >= 19) continue;
                m |= 1 << index;
            }
            return m;
        }

        private static Set<Range> maskToRangeSet(int mask) {
            EnumSet<Range> set = EnumSet.noneOf(Range.class);
            Range[] a = Range.values();
            for (int i = 0; i < 19; ++i) {
                if ((mask & 1 << i) == 0) continue;
                set.add(a[i]);
            }
            return set;
        }

        private Range(int base, int start, int end) {
            this.base = base - (48 + this.getNumericBase());
            this.start = start;
            this.end = end;
        }

        private int getDigitBase() {
            return this.base;
        }

        char getNumericBase() {
            return '\u0000';
        }

        private boolean inRange(int c) {
            return this.start <= c && c < this.end;
        }
    }
}

