/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.tiff;

import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.imageio.plugins.tiff.BaselineTIFFTagSet;
import javax.imageio.plugins.tiff.ExifParentTIFFTagSet;
import javax.imageio.plugins.tiff.FaxTIFFTagSet;
import javax.imageio.plugins.tiff.GeoTIFFTagSet;
import javax.imageio.plugins.tiff.TIFFTagSet;

public final class TIFFImageReadParam
extends ImageReadParam {
    private final List<TIFFTagSet> allowedTagSets = new ArrayList<TIFFTagSet>(4);
    private boolean readUnknownTags = false;

    public TIFFImageReadParam() {
        this.addAllowedTagSet(BaselineTIFFTagSet.getInstance());
        this.addAllowedTagSet(FaxTIFFTagSet.getInstance());
        this.addAllowedTagSet(ExifParentTIFFTagSet.getInstance());
        this.addAllowedTagSet(GeoTIFFTagSet.getInstance());
    }

    public void addAllowedTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null!");
        }
        if (!this.allowedTagSets.contains(tagSet)) {
            this.allowedTagSets.add(tagSet);
        }
    }

    public void removeAllowedTagSet(TIFFTagSet tagSet) {
        if (tagSet == null) {
            throw new IllegalArgumentException("tagSet == null!");
        }
        this.allowedTagSets.remove(tagSet);
    }

    public List<TIFFTagSet> getAllowedTagSets() {
        return this.allowedTagSets;
    }

    public void setReadUnknownTags(boolean readUnknownTags) {
        this.readUnknownTags = readUnknownTags;
    }

    public boolean getReadUnknownTags() {
        return this.readUnknownTags;
    }
}

