/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;
import java.util.Vector;
import javax.print.attribute.IntegerSyntax;

public abstract class SetOfIntegerSyntax
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3666874174847632203L;
    private int[][] members;

    protected SetOfIntegerSyntax(String members) {
        this.members = SetOfIntegerSyntax.parse(members);
    }

    private static int[][] parse(String members) {
        Vector<int[]> theRanges = new Vector<int[]>();
        int n = members == null ? 0 : members.length();
        int i = 0;
        int state = 0;
        int lb = 0;
        int ub = 0;
        while (i < n) {
            char c = members.charAt(i++);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    int digit = Character.digit(c, 10);
                    if (digit != -1) {
                        lb = digit;
                        state = 1;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 1: {
                    if (Character.isWhitespace(c)) {
                        state = 2;
                        break;
                    }
                    int digit = Character.digit(c, 10);
                    if (digit != -1) {
                        lb = 10 * lb + digit;
                        state = 1;
                        break;
                    }
                    if (c == '-' || c == ':') {
                        state = 3;
                        break;
                    }
                    if (c == ',') {
                        SetOfIntegerSyntax.accumulate(theRanges, lb, lb);
                        state = 6;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 2: {
                    if (Character.isWhitespace(c)) {
                        state = 2;
                        break;
                    }
                    if (c == '-' || c == ':') {
                        state = 3;
                        break;
                    }
                    if (c == ',') {
                        SetOfIntegerSyntax.accumulate(theRanges, lb, lb);
                        state = 6;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 3: {
                    if (Character.isWhitespace(c)) {
                        state = 3;
                        break;
                    }
                    int digit = Character.digit(c, 10);
                    if (digit != -1) {
                        ub = digit;
                        state = 4;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 4: {
                    if (Character.isWhitespace(c)) {
                        state = 5;
                        break;
                    }
                    int digit = Character.digit(c, 10);
                    if (digit != -1) {
                        ub = 10 * ub + digit;
                        state = 4;
                        break;
                    }
                    if (c == ',') {
                        SetOfIntegerSyntax.accumulate(theRanges, lb, ub);
                        state = 6;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 5: {
                    if (Character.isWhitespace(c)) {
                        state = 5;
                        break;
                    }
                    if (c == ',') {
                        SetOfIntegerSyntax.accumulate(theRanges, lb, ub);
                        state = 6;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
                case 6: {
                    if (Character.isWhitespace(c)) {
                        state = 6;
                        break;
                    }
                    int digit = Character.digit(c, 10);
                    if (digit != -1) {
                        lb = digit;
                        state = 1;
                        break;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        switch (state) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                SetOfIntegerSyntax.accumulate(theRanges, lb, lb);
                break;
            }
            case 4: 
            case 5: {
                SetOfIntegerSyntax.accumulate(theRanges, lb, ub);
                break;
            }
            case 3: 
            case 6: {
                throw new IllegalArgumentException();
            }
        }
        return SetOfIntegerSyntax.canonicalArrayForm(theRanges);
    }

    private static void accumulate(Vector<int[]> ranges, int lb, int ub) {
        if (lb <= ub) {
            ranges.add(new int[]{lb, ub});
            for (int j = ranges.size() - 2; j >= 0; --j) {
                int[] rangea = ranges.elementAt(j);
                int lba = rangea[0];
                int uba = rangea[1];
                int[] rangeb = ranges.elementAt(j + 1);
                int lbb = rangeb[0];
                int ubb = rangeb[1];
                if (Math.max(lba, lbb) - Math.min(uba, ubb) <= 1) {
                    ranges.setElementAt(new int[]{Math.min(lba, lbb), Math.max(uba, ubb)}, j);
                    ranges.remove(j + 1);
                    continue;
                }
                if (lba <= lbb) break;
                ranges.setElementAt(rangeb, j);
                ranges.setElementAt(rangea, j + 1);
            }
        }
    }

    private static int[][] canonicalArrayForm(Vector<int[]> ranges) {
        return (int[][])ranges.toArray((T[])new int[ranges.size()][]);
    }

    protected SetOfIntegerSyntax(int[][] members) {
        this.members = SetOfIntegerSyntax.parse(members);
    }

    private static int[][] parse(int[][] members) {
        Vector<int[]> ranges = new Vector<int[]>();
        int n = members == null ? 0 : members.length;
        for (int i = 0; i < n; ++i) {
            int lb;
            int ub;
            if (members[i].length == 1) {
                lb = ub = members[i][0];
            } else if (members[i].length == 2) {
                lb = members[i][0];
                ub = members[i][1];
            } else {
                throw new IllegalArgumentException();
            }
            if (lb <= ub && lb < 0) {
                throw new IllegalArgumentException();
            }
            SetOfIntegerSyntax.accumulate(ranges, lb, ub);
        }
        return SetOfIntegerSyntax.canonicalArrayForm(ranges);
    }

    protected SetOfIntegerSyntax(int member) {
        if (member < 0) {
            throw new IllegalArgumentException();
        }
        this.members = new int[][]{{member, member}};
    }

    protected SetOfIntegerSyntax(int lowerBound, int upperBound) {
        int[][] nArrayArray;
        if (lowerBound <= upperBound && lowerBound < 0) {
            throw new IllegalArgumentException();
        }
        if (lowerBound <= upperBound) {
            int[][] nArrayArray2 = new int[1][];
            nArrayArray = nArrayArray2;
            nArrayArray2[0] = new int[]{lowerBound, upperBound};
        } else {
            nArrayArray = new int[][]{};
        }
        this.members = nArrayArray;
    }

    public int[][] getMembers() {
        int n = this.members.length;
        int[][] result = new int[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = new int[]{this.members[i][0], this.members[i][1]};
        }
        return result;
    }

    public boolean contains(int x) {
        int n = this.members.length;
        for (int i = 0; i < n; ++i) {
            if (x < this.members[i][0]) {
                return false;
            }
            if (x > this.members[i][1]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IntegerSyntax attribute) {
        return this.contains(attribute.getValue());
    }

    public int next(int x) {
        int n = this.members.length;
        for (int i = 0; i < n; ++i) {
            if (x < this.members[i][0]) {
                return this.members[i][0];
            }
            if (x >= this.members[i][1]) continue;
            return x + 1;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SetOfIntegerSyntax) {
            int[][] myMembers = this.members;
            int m = myMembers.length;
            int[][] otherMembers = ((SetOfIntegerSyntax)object).members;
            int n = otherMembers.length;
            if (m == n) {
                for (int i = 0; i < m; ++i) {
                    if (myMembers[i][0] == otherMembers[i][0] && myMembers[i][1] == otherMembers[i][1]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        int n = this.members.length;
        for (int i = 0; i < n; ++i) {
            result += this.members[i][0] + this.members[i][1];
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int n = this.members.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.members[i][0]);
            if (this.members[i][0] == this.members[i][1]) continue;
            result.append('-');
            result.append(this.members[i][1]);
        }
        return result.toString();
    }
}

