/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.SwingConstants;
import javax.swing.SwingContainer;

@JavaBean(description="A menu item which can be selected or deselected.")
@SwingContainer(value=false)
public class JCheckBoxMenuItem
extends JMenuItem
implements SwingConstants,
Accessible {
    private static final String uiClassID = "CheckBoxMenuItemUI";

    public JCheckBoxMenuItem() {
        this(null, null, false);
    }

    public JCheckBoxMenuItem(Icon icon) {
        this(null, icon, false);
    }

    public JCheckBoxMenuItem(String text) {
        this(text, null, false);
    }

    public JCheckBoxMenuItem(Action a) {
        this();
        this.setAction(a);
    }

    public JCheckBoxMenuItem(String text, Icon icon) {
        this(text, icon, false);
    }

    public JCheckBoxMenuItem(String text, boolean b) {
        this(text, null, b);
    }

    public JCheckBoxMenuItem(String text, Icon icon, boolean b) {
        super(text, icon);
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.setSelected(b);
        this.setFocusable(false);
    }

    @Override
    @BeanProperty(bound=false)
    public String getUIClassID() {
        return uiClassID;
    }

    public boolean getState() {
        return this.isSelected();
    }

    @BeanProperty(bound=false, hidden=true, description="The selection state of the check box menu item")
    public synchronized void setState(boolean b) {
        this.setSelected(b);
    }

    @Override
    @BeanProperty(bound=false)
    public Object[] getSelectedObjects() {
        if (!this.isSelected()) {
            return null;
        }
        Object[] selectedObjects = new Object[]{this.getText()};
        return selectedObjects;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }

    @Override
    boolean shouldUpdateSelectedStateFromAction() {
        return true;
    }

    @Override
    @BeanProperty(bound=false)
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJCheckBoxMenuItem();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJCheckBoxMenuItem
    extends JMenuItem.AccessibleJMenuItem {
        protected AccessibleJCheckBoxMenuItem() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    }
}

