/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MetalToolTipUI
extends BasicToolTipUI {
    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tip = (JToolTip)c;
        Font f = c.getFont();
        this.smallFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.tip = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int accelBL;
        JToolTip tip = (JToolTip)c;
        Font font = c.getFont();
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g, font);
        Dimension size = c.getSize();
        g.setColor(c.getForeground());
        String tipText = tip.getTipText();
        if (tipText == null) {
            tipText = "";
        }
        String accelString = this.getAcceleratorString(tip);
        FontMetrics accelMetrics = SwingUtilities2.getFontMetrics(c, g, this.smallFont);
        int accelSpacing = this.calcAccelSpacing(c, accelMetrics, accelString);
        Insets insets = tip.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left + 3, insets.top, size.width - (insets.left + insets.right) - 6 - accelSpacing, size.height - (insets.top + insets.bottom));
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            v.paint(g, paintTextR);
            accelBL = BasicHTML.getHTMLBaseline(v, paintTextR.width, paintTextR.height);
        } else {
            g.setFont(font);
            SwingUtilities2.drawString((JComponent)tip, g, tipText, paintTextR.x, paintTextR.y + metrics.getAscent());
            accelBL = metrics.getAscent();
        }
        if (!accelString.equals("")) {
            g.setFont(this.smallFont);
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            SwingUtilities2.drawString((JComponent)tip, g, accelString, tip.getWidth() - 1 - insets.right - accelSpacing + 12 - 3, paintTextR.y + accelBL);
        }
    }

    private int calcAccelSpacing(JComponent c, FontMetrics fm, String accel) {
        return accel.equals("") ? 0 : 12 + SwingUtilities2.stringWidth(c, fm, accel);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        String key = this.getAcceleratorString((JToolTip)c);
        if (!key.equals("")) {
            d.width += this.calcAccelSpacing(c, c.getFontMetrics(this.smallFont), key);
        }
        return d;
    }

    protected boolean isAcceleratorHidden() {
        Boolean b = (Boolean)UIManager.get("ToolTip.hideAccelerator");
        return b != null && b != false;
    }

    private String getAcceleratorString(JToolTip tip) {
        this.tip = tip;
        String retValue = this.getAcceleratorString();
        this.tip = null;
        return retValue;
    }

    public String getAcceleratorString() {
        Object controlKeyStr;
        block3: {
            if (this.tip == null || this.isAcceleratorHidden()) {
                return "";
            }
            JComponent comp = this.tip.getComponent();
            if (!(comp instanceof AbstractButton)) {
                return "";
            }
            KeyStroke[] keys = comp.getInputMap(2).keys();
            if (keys == null) {
                return "";
            }
            controlKeyStr = "";
            int i = 0;
            if (i >= keys.length) break block3;
            int mod = keys[i].getModifiers();
            controlKeyStr = KeyEvent.getKeyModifiersText(mod) + this.acceleratorDelimiter + KeyEvent.getKeyText(keys[i].getKeyCode());
        }
        return controlKeyStr;
    }
}

