/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.image.VolatileImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.Painter;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.nimbus.ImageCache;
import javax.swing.plaf.nimbus.ImageScalingHelper;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;
import sun.reflect.misc.MethodUtil;

public abstract class AbstractRegionPainter
implements Painter<JComponent> {
    private PaintContext ctx;
    private float f;
    private float leftWidth;
    private float topHeight;
    private float centerWidth;
    private float centerHeight;
    private float rightWidth;
    private float bottomHeight;
    private float leftScale;
    private float topScale;
    private float centerHScale;
    private float centerVScale;
    private float rightScale;
    private float bottomScale;

    protected AbstractRegionPainter() {
    }

    @Override
    public final void paint(Graphics2D g, JComponent c, int w, int h) {
        PaintContext.CacheMode cacheMode;
        if (w <= 0 || h <= 0) {
            return;
        }
        Object[] extendedCacheKeys = this.getExtendedCacheKeys(c);
        this.ctx = this.getPaintContext();
        PaintContext.CacheMode cacheMode2 = cacheMode = this.ctx == null ? PaintContext.CacheMode.NO_CACHING : this.ctx.cacheMode;
        if (cacheMode == PaintContext.CacheMode.NO_CACHING || !ImageCache.getInstance().isImageCachable(w, h) || g instanceof PrinterGraphics) {
            this.paint0(g, c, w, h, extendedCacheKeys);
        } else if (cacheMode == PaintContext.CacheMode.FIXED_SIZES) {
            this.paintWithFixedSizeCaching(g, c, w, h, extendedCacheKeys);
        } else {
            this.paintWith9SquareCaching(g, this.ctx, c, w, h, extendedCacheKeys);
        }
    }

    protected Object[] getExtendedCacheKeys(JComponent c) {
        return null;
    }

    protected abstract PaintContext getPaintContext();

    protected void configureGraphics(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected abstract void doPaint(Graphics2D var1, JComponent var2, int var3, int var4, Object[] var5);

    protected final float decodeX(float x) {
        if (x >= 0.0f && x <= 1.0f) {
            return x * this.leftWidth;
        }
        if (x > 1.0f && x < 2.0f) {
            return (x - 1.0f) * this.centerWidth + this.leftWidth;
        }
        if (x >= 2.0f && x <= 3.0f) {
            return (x - 2.0f) * this.rightWidth + this.leftWidth + this.centerWidth;
        }
        throw new IllegalArgumentException("Invalid x");
    }

    protected final float decodeY(float y) {
        if (y >= 0.0f && y <= 1.0f) {
            return y * this.topHeight;
        }
        if (y > 1.0f && y < 2.0f) {
            return (y - 1.0f) * this.centerHeight + this.topHeight;
        }
        if (y >= 2.0f && y <= 3.0f) {
            return (y - 2.0f) * this.bottomHeight + this.topHeight + this.centerHeight;
        }
        throw new IllegalArgumentException("Invalid y");
    }

    protected final float decodeAnchorX(float x, float dx) {
        if (x >= 0.0f && x <= 1.0f) {
            return this.decodeX(x) + dx * this.leftScale;
        }
        if (x > 1.0f && x < 2.0f) {
            return this.decodeX(x) + dx * this.centerHScale;
        }
        if (x >= 2.0f && x <= 3.0f) {
            return this.decodeX(x) + dx * this.rightScale;
        }
        throw new IllegalArgumentException("Invalid x");
    }

    protected final float decodeAnchorY(float y, float dy) {
        if (y >= 0.0f && y <= 1.0f) {
            return this.decodeY(y) + dy * this.topScale;
        }
        if (y > 1.0f && y < 2.0f) {
            return this.decodeY(y) + dy * this.centerVScale;
        }
        if (y >= 2.0f && y <= 3.0f) {
            return this.decodeY(y) + dy * this.bottomScale;
        }
        throw new IllegalArgumentException("Invalid y");
    }

    protected final Color decodeColor(String key, float hOffset, float sOffset, float bOffset, int aOffset) {
        if (UIManager.getLookAndFeel() instanceof NimbusLookAndFeel) {
            NimbusLookAndFeel laf = (NimbusLookAndFeel)UIManager.getLookAndFeel();
            return laf.getDerivedColor(key, hOffset, sOffset, bOffset, aOffset, true);
        }
        return Color.getHSBColor(hOffset, sOffset, bOffset);
    }

    protected final Color decodeColor(Color color1, Color color2, float midPoint) {
        return new Color(NimbusLookAndFeel.deriveARGB(color1, color2, midPoint));
    }

    protected final LinearGradientPaint decodeGradient(float x1, float y1, float x2, float y2, float[] midpoints, Color[] colors) {
        if (x1 == x2 && y1 == y2) {
            y2 += 1.0E-5f;
        }
        return new LinearGradientPaint(x1, y1, x2, y2, midpoints, colors);
    }

    protected final RadialGradientPaint decodeRadialGradient(float x, float y, float r, float[] midpoints, Color[] colors) {
        if (r == 0.0f) {
            r = 1.0E-5f;
        }
        return new RadialGradientPaint(x, y, r, midpoints, colors);
    }

    protected final Color getComponentColor(JComponent c, String property, Color defaultColor, float saturationOffset, float brightnessOffset, int alphaOffset) {
        Color color = null;
        if (c != null) {
            if ("background".equals(property)) {
                color = c.getBackground();
            } else if ("foreground".equals(property)) {
                color = c.getForeground();
            } else if (c instanceof JList && "selectionForeground".equals(property)) {
                color = ((JList)c).getSelectionForeground();
            } else if (c instanceof JList && "selectionBackground".equals(property)) {
                color = ((JList)c).getSelectionBackground();
            } else if (c instanceof JTable && "selectionForeground".equals(property)) {
                color = ((JTable)c).getSelectionForeground();
            } else if (c instanceof JTable && "selectionBackground".equals(property)) {
                color = ((JTable)c).getSelectionBackground();
            } else {
                Object value;
                String s = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
                try {
                    Method method = MethodUtil.getMethod(c.getClass(), s, null);
                    color = (Color)MethodUtil.invoke(method, c, null);
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (color == null && (value = c.getClientProperty(property)) instanceof Color) {
                    color = (Color)value;
                }
            }
        }
        if (color == null || color instanceof UIResource) {
            return defaultColor;
        }
        if (saturationOffset != 0.0f || brightnessOffset != 0.0f || alphaOffset != 0) {
            float[] tmp = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            tmp[1] = this.clamp(tmp[1] + saturationOffset);
            tmp[2] = this.clamp(tmp[2] + brightnessOffset);
            int alpha = this.clamp(color.getAlpha() + alphaOffset);
            return new Color(Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF | alpha << 24);
        }
        return color;
    }

    private void prepare(float w, float h) {
        if (this.ctx == null || this.ctx.canvasSize == null) {
            this.f = 1.0f;
            this.rightWidth = 0.0f;
            this.centerWidth = 0.0f;
            this.leftWidth = 0.0f;
            this.bottomHeight = 0.0f;
            this.centerHeight = 0.0f;
            this.topHeight = 0.0f;
            this.rightScale = 0.0f;
            this.centerHScale = 0.0f;
            this.leftScale = 0.0f;
            this.bottomScale = 0.0f;
            this.centerVScale = 0.0f;
            this.topScale = 0.0f;
            return;
        }
        Number scale = (Number)UIManager.get("scale");
        float f = this.f = scale == null ? 1.0f : scale.floatValue();
        if (this.ctx.inverted) {
            this.centerWidth = (this.ctx.b - this.ctx.a) * this.f;
            float availableSpace = w - this.centerWidth;
            this.leftWidth = availableSpace * this.ctx.aPercent;
            this.rightWidth = availableSpace * this.ctx.bPercent;
            this.centerHeight = (this.ctx.d - this.ctx.c) * this.f;
            availableSpace = h - this.centerHeight;
            this.topHeight = availableSpace * this.ctx.cPercent;
            this.bottomHeight = availableSpace * this.ctx.dPercent;
        } else {
            this.leftWidth = this.ctx.a * this.f;
            this.rightWidth = (float)(this.ctx.canvasSize.getWidth() - (double)this.ctx.b) * this.f;
            this.centerWidth = w - this.leftWidth - this.rightWidth;
            this.topHeight = this.ctx.c * this.f;
            this.bottomHeight = (float)(this.ctx.canvasSize.getHeight() - (double)this.ctx.d) * this.f;
            this.centerHeight = h - this.topHeight - this.bottomHeight;
        }
        this.leftScale = this.ctx.a == 0.0f ? 0.0f : this.leftWidth / this.ctx.a;
        this.centerHScale = this.ctx.b - this.ctx.a == 0.0f ? 0.0f : this.centerWidth / (this.ctx.b - this.ctx.a);
        this.rightScale = (float)this.ctx.canvasSize.width - this.ctx.b == 0.0f ? 0.0f : this.rightWidth / ((float)this.ctx.canvasSize.width - this.ctx.b);
        this.topScale = this.ctx.c == 0.0f ? 0.0f : this.topHeight / this.ctx.c;
        this.centerVScale = this.ctx.d - this.ctx.c == 0.0f ? 0.0f : this.centerHeight / (this.ctx.d - this.ctx.c);
        this.bottomScale = (float)this.ctx.canvasSize.height - this.ctx.d == 0.0f ? 0.0f : this.bottomHeight / ((float)this.ctx.canvasSize.height - this.ctx.d);
    }

    private void paintWith9SquareCaching(Graphics2D g, PaintContext ctx, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        Dimension canvas = ctx.canvasSize;
        Insets insets = ctx.stretchingInsets;
        if ((double)w <= (double)canvas.width * ctx.maxHorizontalScaleFactor && (double)h <= (double)canvas.height * ctx.maxVerticalScaleFactor) {
            VolatileImage img = this.getImage(g.getDeviceConfiguration(), c, canvas.width, canvas.height, extendedCacheKeys);
            if (img != null) {
                Insets dstInsets;
                if (ctx.inverted) {
                    int leftRight = (w - (canvas.width - (insets.left + insets.right))) / 2;
                    int topBottom = (h - (canvas.height - (insets.top + insets.bottom))) / 2;
                    dstInsets = new Insets(topBottom, leftRight, topBottom, leftRight);
                } else {
                    dstInsets = insets;
                }
                Object oldScaleingHints = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                ImageScalingHelper.paint(g, 0, 0, w, h, img, insets, dstInsets, ImageScalingHelper.PaintType.PAINT9_STRETCH, 512);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldScaleingHints != null ? oldScaleingHints : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            } else {
                this.paint0(g, c, w, h, extendedCacheKeys);
            }
        } else {
            this.paint0(g, c, w, h, extendedCacheKeys);
        }
    }

    private void paintWithFixedSizeCaching(Graphics2D g, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        VolatileImage img = this.getImage(g.getDeviceConfiguration(), c, w, h, extendedCacheKeys);
        if (img != null) {
            g.drawImage(img, 0, 0, null);
        } else {
            this.paint0(g, c, w, h, extendedCacheKeys);
        }
    }

    private VolatileImage getImage(GraphicsConfiguration config, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        ImageCache imageCache = ImageCache.getInstance();
        VolatileImage buffer = (VolatileImage)imageCache.getImage(config, w, h, this, extendedCacheKeys);
        int renderCounter = 0;
        do {
            int bufferStatus = 2;
            if (buffer != null) {
                bufferStatus = buffer.validate(config);
            }
            if (bufferStatus != 2 && bufferStatus != 1) continue;
            if (buffer == null || buffer.getWidth() != w || buffer.getHeight() != h || bufferStatus == 2) {
                if (buffer != null) {
                    buffer.flush();
                    buffer = null;
                }
                buffer = config.createCompatibleVolatileImage(w, h, 3);
                imageCache.setImage(buffer, config, w, h, this, extendedCacheKeys);
            }
            Graphics2D bg = buffer.createGraphics();
            bg.setComposite(AlphaComposite.Clear);
            bg.fillRect(0, 0, w, h);
            bg.setComposite(AlphaComposite.SrcOver);
            this.configureGraphics(bg);
            this.paint0(bg, c, w, h, extendedCacheKeys);
            bg.dispose();
        } while (buffer.contentsLost() && renderCounter++ < 3);
        if (renderCounter == 3) {
            return null;
        }
        return buffer;
    }

    private void paint0(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        this.prepare(width, height);
        g = (Graphics2D)g.create();
        this.configureGraphics(g);
        this.doPaint(g, c, width, height, extendedCacheKeys);
        g.dispose();
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return value;
    }

    private int clamp(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        return value;
    }

    protected static class PaintContext {
        private static Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
        private Insets stretchingInsets;
        private Dimension canvasSize;
        private boolean inverted;
        private CacheMode cacheMode;
        private double maxHorizontalScaleFactor;
        private double maxVerticalScaleFactor;
        private float a;
        private float b;
        private float c;
        private float d;
        private float aPercent;
        private float bPercent;
        private float cPercent;
        private float dPercent;

        public PaintContext(Insets insets, Dimension canvasSize, boolean inverted) {
            this(insets, canvasSize, inverted, null, 1.0, 1.0);
        }

        public PaintContext(Insets insets, Dimension canvasSize, boolean inverted, CacheMode cacheMode, double maxH, double maxV) {
            if (maxH < 1.0 || maxV < 1.0) {
                throw new IllegalArgumentException("Both maxH and maxV must be >= 1");
            }
            this.stretchingInsets = insets == null ? EMPTY_INSETS : insets;
            this.canvasSize = canvasSize;
            this.inverted = inverted;
            this.cacheMode = cacheMode == null ? CacheMode.NO_CACHING : cacheMode;
            this.maxHorizontalScaleFactor = maxH;
            this.maxVerticalScaleFactor = maxV;
            if (canvasSize != null) {
                this.a = this.stretchingInsets.left;
                this.b = canvasSize.width - this.stretchingInsets.right;
                this.c = this.stretchingInsets.top;
                this.d = canvasSize.height - this.stretchingInsets.bottom;
                this.canvasSize = canvasSize;
                this.inverted = inverted;
                if (inverted) {
                    float available = (float)canvasSize.width - (this.b - this.a);
                    this.aPercent = available > 0.0f ? this.a / available : 0.0f;
                    this.bPercent = available > 0.0f ? this.b / available : 0.0f;
                    available = (float)canvasSize.height - (this.d - this.c);
                    this.cPercent = available > 0.0f ? this.c / available : 0.0f;
                    this.dPercent = available > 0.0f ? this.d / available : 0.0f;
                }
            }
        }

        protected static enum CacheMode {
            NO_CACHING,
            FIXED_SIZES,
            NINE_SQUARE_SCALE;

        }
    }
}

