/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicColorChooserUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthColorChooserUI
extends BasicColorChooserUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthColorChooserUI();
    }

    @Override
    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        SynthContext context = this.getContext(this.chooser, 1);
        AbstractColorChooserPanel[] panels = (AbstractColorChooserPanel[])context.getStyle().get(context, "ColorChooser.panels");
        if (panels == null) {
            panels = ColorChooserComponentFactory.getDefaultChooserPanels();
        }
        return panels;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.chooser);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.chooser, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.chooser.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintColorChooserBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintColorChooserBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JColorChooser)e.getSource());
        }
    }
}

