/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthMenuItemLayoutHelper;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.MenuItemLayoutHelper;

public class SynthMenuUI
extends BasicMenuUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private SynthStyle accStyle;

    public static ComponentUI createUI(JComponent x) {
        return new SynthMenuUI();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem mi) {
        SynthStyle oldStyle = this.style;
        SynthContext context = this.getContext((JComponent)mi, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (oldStyle != this.style) {
            String prefix = this.getPropertyPrefix();
            this.defaultTextIconGap = this.style.getInt(context, prefix + ".textIconGap", 4);
            if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
                Insets insets = (Insets)this.style.get(context, prefix + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.menuItem.setMargin(insets);
            }
            this.acceleratorDelimiter = this.style.getString(context, prefix + ".acceleratorDelimiter", "+");
            if (MenuItemLayoutHelper.useCheckAndArrow(this.menuItem)) {
                this.checkIcon = this.style.getIcon(context, prefix + ".checkIcon");
                this.arrowIcon = this.style.getIcon(context, prefix + ".arrowIcon");
            } else {
                this.checkIcon = null;
                this.arrowIcon = null;
            }
            ((JMenu)this.menuItem).setDelay(this.style.getInt(context, prefix + ".delay", 200));
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        SynthContext accContext = this.getContext(mi, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle = SynthLookAndFeel.updateStyle(accContext, this);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JComponent p = MenuItemLayoutHelper.getMenuItemParent((JMenuItem)c);
        if (p != null) {
            p.putClientProperty(SynthMenuItemLayoutHelper.MAX_ACC_OR_ARROW_WIDTH, null);
        }
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.menuItem, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
        SynthContext accContext = this.getContext(this.menuItem, Region.MENU_ITEM_ACCELERATOR, 1);
        this.accStyle.uninstallDefaults(accContext);
        this.accStyle = null;
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    SynthContext getContext(JComponent c, Region region) {
        return this.getContext(c, region, this.getComponentState(c, region));
    }

    private SynthContext getContext(JComponent c, Region region, int state) {
        return SynthContext.getContext(c, region, this.accStyle, state);
    }

    private int getComponentState(JComponent c) {
        if (!c.isEnabled()) {
            return 8;
        }
        int state = this.menuItem.isArmed() ? 2 : SynthLookAndFeel.getComponentState(c);
        if (this.menuItem.isSelected()) {
            state |= 0x200;
        }
        return state;
    }

    private int getComponentState(JComponent c, Region region) {
        return this.getComponentState(c);
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        SynthContext context = this.getContext(c);
        SynthContext accContext = this.getContext(c, Region.MENU_ITEM_ACCELERATOR);
        Dimension value = SynthGraphicsUtils.getPreferredMenuItemSize(context, accContext, c, checkIcon, arrowIcon, defaultTextIconGap, this.acceleratorDelimiter, MenuItemLayoutHelper.useCheckAndArrow(this.menuItem), this.getPropertyPrefix());
        return value;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintMenuBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        SynthContext accContext = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        String prefix = this.getPropertyPrefix();
        Icon checkIcon = this.style.getIcon(context, prefix + ".checkIcon");
        Icon arrowIcon = this.style.getIcon(context, prefix + ".arrowIcon");
        SynthGraphicsUtils.paint(context, accContext, g, checkIcon, arrowIcon, this.acceleratorDelimiter, this.defaultTextIconGap, this.getPropertyPrefix());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintMenuBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e) || e.getPropertyName().equals("ancestor") && UIManager.getBoolean("Menu.useMenuBarForTopLevelMenus")) {
            this.updateStyle((JMenu)e.getSource());
        }
    }
}

