/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.plaf.synth.SynthBorder;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLabelUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import sun.swing.table.DefaultTableCellHeaderRenderer;

public class SynthTableHeaderUI
extends BasicTableHeaderUI
implements PropertyChangeListener,
SynthUI {
    private TableCellRenderer prevRenderer = null;
    private SynthStyle style;

    public static ComponentUI createUI(JComponent h) {
        return new SynthTableHeaderUI();
    }

    @Override
    protected void installDefaults() {
        this.prevRenderer = this.header.getDefaultRenderer();
        if (this.prevRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new HeaderRenderer());
        }
        this.updateStyle(this.header);
    }

    private void updateStyle(JTableHeader c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.header.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        if (this.header.getDefaultRenderer() instanceof HeaderRenderer) {
            this.header.setDefaultRenderer(this.prevRenderer);
        }
        SynthContext context = this.getContext(this.header, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
    }

    @Override
    protected void uninstallListeners() {
        this.header.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTableHeaderBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        super.paint(g, context.getComponent());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTableHeaderBorder(context, g, x, y, w, h);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    @Override
    protected void rolloverColumnUpdated(int oldColumn, int newColumn) {
        this.header.repaint(this.header.getHeaderRect(oldColumn));
        this.header.repaint(this.header.getHeaderRect(newColumn));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JTableHeader)evt.getSource());
        }
    }

    private class HeaderRenderer
    extends DefaultTableCellHeaderRenderer {
        HeaderRenderer() {
            this.setHorizontalAlignment(10);
            this.setName("TableHeader.renderer");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            block8: {
                block7: {
                    List<RowSorter.SortKey> sortKeys;
                    boolean hasRollover;
                    boolean bl = hasRollover = column == SynthTableHeaderUI.this.getRolloverColumn();
                    if (isSelected || hasRollover || hasFocus) {
                        boolean enabled = table == null ? true : table.isEnabled();
                        SynthLookAndFeel.setSelectedUI((SynthLabelUI)SynthLookAndFeel.getUIOfType(this.getUI(), SynthLabelUI.class), isSelected, hasFocus, enabled, hasRollover);
                    } else {
                        SynthLookAndFeel.resetSelectedUI();
                    }
                    RowSorter<? extends TableModel> rs = table == null ? null : table.getRowSorter();
                    List<RowSorter.SortKey> list = sortKeys = rs == null ? null : rs.getSortKeys();
                    if (sortKeys == null || sortKeys.size() <= 0 || sortKeys.get(0).getColumn() != table.convertColumnIndexToModel(column)) break block7;
                    switch (sortKeys.get(0).getSortOrder()) {
                        case ASCENDING: {
                            this.putClientProperty("Table.sortOrder", "ASCENDING");
                            break block8;
                        }
                        case DESCENDING: {
                            this.putClientProperty("Table.sortOrder", "DESCENDING");
                            break block8;
                        }
                        case UNSORTED: {
                            this.putClientProperty("Table.sortOrder", "UNSORTED");
                            break block8;
                        }
                        default: {
                            throw new AssertionError((Object)"Cannot happen");
                        }
                    }
                }
                this.putClientProperty("Table.sortOrder", "UNSORTED");
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return this;
        }

        @Override
        public void setBorder(Border border) {
            if (border instanceof SynthBorder) {
                super.setBorder(border);
            }
        }
    }
}

