/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;

class AccessibleHTML
implements Accessible {
    private JEditorPane editor;
    private Document model;
    private DocumentListener docListener;
    private PropertyChangeListener propChangeListener;
    private ElementInfo rootElementInfo;
    private RootHTMLAccessibleContext rootHTMLAccessibleContext;

    public AccessibleHTML(JEditorPane pane) {
        this.editor = pane;
        this.propChangeListener = new PropertyChangeHandler();
        this.setDocument(this.editor.getDocument());
        this.docListener = new DocumentHandler();
    }

    private void setDocument(Document document) {
        if (this.model != null) {
            this.model.removeDocumentListener(this.docListener);
        }
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.propChangeListener);
        }
        this.model = document;
        if (this.model != null) {
            if (this.rootElementInfo != null) {
                this.rootElementInfo.invalidate(false);
            }
            this.buildInfo();
            this.model.addDocumentListener(this.docListener);
        } else {
            this.rootElementInfo = null;
        }
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(this.propChangeListener);
        }
    }

    private Document getDocument() {
        return this.model;
    }

    private JEditorPane getTextComponent() {
        return this.editor;
    }

    private ElementInfo getRootInfo() {
        return this.rootElementInfo;
    }

    private View getRootView() {
        return this.getTextComponent().getUI().getRootView(this.getTextComponent());
    }

    private Rectangle getRootEditorRect() {
        Rectangle alloc = this.getTextComponent().getBounds();
        if (alloc.width > 0 && alloc.height > 0) {
            alloc.y = 0;
            alloc.x = 0;
            Insets insets = this.editor.getInsets();
            alloc.x += insets.left;
            alloc.y += insets.top;
            alloc.width -= insets.left + insets.right;
            alloc.height -= insets.top + insets.bottom;
            return alloc;
        }
        return null;
    }

    private Object lock() {
        Document document = this.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
            return document;
        }
        return null;
    }

    private void unlock(Object key) {
        if (key != null) {
            ((AbstractDocument)key).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildInfo() {
        Object lock = this.lock();
        try {
            Document doc = this.getDocument();
            Element root = doc.getDefaultRootElement();
            this.rootElementInfo = new ElementInfo(root);
            this.rootElementInfo.validate();
        }
        finally {
            this.unlock(lock);
        }
    }

    ElementInfo createElementInfo(Element e, ElementInfo parent) {
        AttributeSet attrs = e.getAttributes();
        if (attrs != null) {
            Object name = attrs.getAttribute(StyleConstants.NameAttribute);
            if (name == HTML.Tag.IMG) {
                return new IconElementInfo(e, parent);
            }
            if (name == HTML.Tag.CONTENT || name == HTML.Tag.CAPTION) {
                return new TextElementInfo(e, parent);
            }
            if (name == HTML.Tag.TABLE) {
                return new TableElementInfo(e, parent);
            }
        }
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.rootHTMLAccessibleContext == null) {
            this.rootHTMLAccessibleContext = new RootHTMLAccessibleContext(this.rootElementInfo);
        }
        return this.rootHTMLAccessibleContext;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("document")) {
                AccessibleHTML.this.setDocument(AccessibleHTML.this.editor.getDocument());
            }
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            AccessibleHTML.this.getRootInfo().update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            AccessibleHTML.this.getRootInfo().update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            AccessibleHTML.this.getRootInfo().update(e);
        }
    }

    private class ElementInfo {
        private ArrayList<ElementInfo> children;
        private Element element;
        private ElementInfo parent;
        private boolean isValid;
        private boolean canBeValid;

        ElementInfo(Element element) {
            this(element, null);
        }

        ElementInfo(Element element, ElementInfo parent) {
            this.element = element;
            this.parent = parent;
            this.isValid = false;
            this.canBeValid = true;
        }

        protected void validate() {
            this.isValid = true;
            this.loadChildren(this.getElement());
        }

        protected void loadChildren(Element parent) {
            if (!parent.isLeaf()) {
                int maxCounter = parent.getElementCount();
                for (int counter = 0; counter < maxCounter; ++counter) {
                    Element e = parent.getElement(counter);
                    ElementInfo childInfo = AccessibleHTML.this.createElementInfo(e, this);
                    if (childInfo != null) {
                        this.addChild(childInfo);
                        continue;
                    }
                    this.loadChildren(e);
                }
            }
        }

        public int getIndexInParent() {
            if (this.parent == null || !this.parent.isValid()) {
                return -1;
            }
            return this.parent.indexOf(this);
        }

        public Element getElement() {
            return this.element;
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public int indexOf(ElementInfo child) {
            ArrayList<ElementInfo> children = this.children;
            if (children != null) {
                return children.indexOf(child);
            }
            return -1;
        }

        public ElementInfo getChild(int index) {
            ArrayList<ElementInfo> children;
            if (this.validateIfNecessary() && (children = this.children) != null && index >= 0 && index < children.size()) {
                return children.get(index);
            }
            return null;
        }

        public int getChildCount() {
            this.validateIfNecessary();
            return this.children == null ? 0 : this.children.size();
        }

        protected void addChild(ElementInfo child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected View getView() {
            if (!this.validateIfNecessary()) {
                return null;
            }
            Object lock = AccessibleHTML.this.lock();
            try {
                View rootView = AccessibleHTML.this.getRootView();
                Element e = this.getElement();
                int start = e.getStartOffset();
                if (rootView != null) {
                    View view = this.getView(rootView, e, start);
                    return view;
                }
                View view = null;
                return view;
            }
            finally {
                AccessibleHTML.this.unlock(lock);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Rectangle getBounds() {
            if (!this.validateIfNecessary()) {
                return null;
            }
            Object lock = AccessibleHTML.this.lock();
            try {
                Rectangle bounds = AccessibleHTML.this.getRootEditorRect();
                View rootView = AccessibleHTML.this.getRootView();
                Element e = this.getElement();
                if (bounds != null && rootView != null) {
                    try {
                        Rectangle rectangle = rootView.modelToView(e.getStartOffset(), Position.Bias.Forward, e.getEndOffset(), Position.Bias.Backward, bounds).getBounds();
                        return rectangle;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            finally {
                AccessibleHTML.this.unlock(lock);
            }
            return null;
        }

        protected boolean isValid() {
            return this.isValid;
        }

        protected AttributeSet getAttributes() {
            if (this.validateIfNecessary()) {
                return this.getElement().getAttributes();
            }
            return null;
        }

        protected AttributeSet getViewAttributes() {
            if (this.validateIfNecessary()) {
                View view = this.getView();
                if (view != null) {
                    return view.getElement().getAttributes();
                }
                return this.getElement().getAttributes();
            }
            return null;
        }

        protected int getIntAttr(AttributeSet attrs, Object key, int deflt) {
            if (attrs != null && attrs.isDefined(key)) {
                int i;
                String val = (String)attrs.getAttribute(key);
                if (val == null) {
                    i = deflt;
                } else {
                    try {
                        i = Math.max(0, Integer.parseInt(val));
                    }
                    catch (NumberFormatException x) {
                        i = deflt;
                    }
                }
                return i;
            }
            return deflt;
        }

        protected boolean validateIfNecessary() {
            if (!this.isValid() && this.canBeValid) {
                this.children = null;
                Object lock = AccessibleHTML.this.lock();
                try {
                    this.validate();
                }
                finally {
                    AccessibleHTML.this.unlock(lock);
                }
            }
            return this.isValid();
        }

        protected void invalidate(boolean first) {
            if (!this.isValid()) {
                if (this.canBeValid && !first) {
                    this.canBeValid = false;
                }
                return;
            }
            this.isValid = false;
            this.canBeValid = first;
            if (this.children != null) {
                for (ElementInfo child : this.children) {
                    child.invalidate(false);
                }
                this.children = null;
            }
        }

        private View getView(View parent, Element e, int start) {
            if (parent.getElement() == e) {
                return parent;
            }
            int index = parent.getViewIndex(start, Position.Bias.Forward);
            if (index != -1 && index < parent.getViewCount()) {
                return this.getView(parent.getView(index), e, start);
            }
            return null;
        }

        private int getClosestInfoIndex(int index) {
            for (int counter = 0; counter < this.getChildCount(); ++counter) {
                ElementInfo info = this.getChild(counter);
                if (index >= info.getElement().getEndOffset() && index != info.getElement().getStartOffset()) continue;
                return counter;
            }
            return -1;
        }

        private void update(DocumentEvent e) {
            if (!this.isValid()) {
                return;
            }
            ElementInfo parent = this.getParent();
            Element element = this.getElement();
            do {
                DocumentEvent.ElementChange ec;
                if ((ec = e.getChange(element)) != null) {
                    if (element == this.getElement()) {
                        this.invalidate(true);
                    } else if (parent != null) {
                        parent.invalidate(parent == AccessibleHTML.this.getRootInfo());
                    }
                    return;
                }
                element = element.getParentElement();
            } while (parent != null && element != null && element != parent.getElement());
            if (this.getChildCount() > 0) {
                int index1;
                ElementInfo info;
                Element elem = this.getElement();
                int pos = e.getOffset();
                int index0 = this.getClosestInfoIndex(pos);
                if (index0 == -1 && e.getType() == DocumentEvent.EventType.REMOVE && pos >= elem.getEndOffset()) {
                    index0 = this.getChildCount() - 1;
                }
                ElementInfo elementInfo = info = index0 >= 0 ? this.getChild(index0) : null;
                if (info != null && info.getElement().getStartOffset() == pos && pos > 0) {
                    index0 = Math.max(index0 - 1, 0);
                }
                if (e.getType() != DocumentEvent.EventType.REMOVE) {
                    index1 = this.getClosestInfoIndex(pos + e.getLength());
                    if (index1 < 0) {
                        index1 = this.getChildCount() - 1;
                    }
                } else {
                    index1 = index0;
                    while (index1 + 1 < this.getChildCount() && this.getChild(index1 + 1).getElement().getEndOffset() == this.getChild(index1 + 1).getElement().getStartOffset()) {
                        ++index1;
                    }
                }
                for (int i = index0 = Math.max(index0, 0); i <= index1 && this.isValid(); ++i) {
                    this.getChild(i).update(e);
                }
            }
        }
    }

    private class TableElementInfo
    extends ElementInfo
    implements Accessible {
        protected ElementInfo caption;
        private TableCellElementInfo[][] grid;
        private AccessibleContext accessibleContext;

        TableElementInfo(Element e, ElementInfo parent) {
            super(e, parent);
        }

        public ElementInfo getCaptionInfo() {
            return this.caption;
        }

        @Override
        protected void validate() {
            super.validate();
            this.updateGrid();
        }

        @Override
        protected void loadChildren(Element e) {
            for (int counter = 0; counter < e.getElementCount(); ++counter) {
                Element child = e.getElement(counter);
                AttributeSet attrs = child.getAttributes();
                if (attrs.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TR) {
                    this.addChild(new TableRowElementInfo(child, this, counter));
                    continue;
                }
                if (attrs.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.CAPTION) continue;
                this.caption = AccessibleHTML.this.createElementInfo(child, this);
            }
        }

        private void updateGrid() {
            int counter;
            int delta = 0;
            int maxCols = 0;
            for (counter = 0; counter < this.getChildCount(); ++counter) {
                TableRowElementInfo row = this.getRow(counter);
                int prev = 0;
                for (int y = 0; y < delta; ++y) {
                    prev = Math.max(prev, this.getRow(counter - y - 1).getColumnCount(y + 2));
                }
                delta = Math.max(row.getRowCount(), delta);
                --delta;
                maxCols = Math.max(maxCols, row.getColumnCount() + prev);
            }
            int rows = this.getChildCount() + delta;
            this.grid = new TableCellElementInfo[rows][];
            for (counter = 0; counter < rows; ++counter) {
                this.grid[counter] = new TableCellElementInfo[maxCols];
            }
            for (counter = 0; counter < rows; ++counter) {
                this.getRow(counter).updateGrid(counter);
            }
        }

        public TableRowElementInfo getRow(int index) {
            return (TableRowElementInfo)this.getChild(index);
        }

        public TableCellElementInfo getCell(int r, int c) {
            if (this.validateIfNecessary() && r < this.grid.length && c < this.grid[0].length) {
                return this.grid[r][c];
            }
            return null;
        }

        public int getRowExtentAt(int r, int c) {
            TableCellElementInfo cell = this.getCell(r, c);
            if (cell != null) {
                int rows = cell.getRowCount();
                int delta = 1;
                while (r - delta >= 0 && this.grid[r - delta][c] == cell) {
                    ++delta;
                }
                return rows - delta + 1;
            }
            return 0;
        }

        public int getColumnExtentAt(int r, int c) {
            TableCellElementInfo cell = this.getCell(r, c);
            if (cell != null) {
                int cols = cell.getColumnCount();
                int delta = 1;
                while (c - delta >= 0 && this.grid[r][c - delta] == cell) {
                    ++delta;
                }
                return cols - delta + 1;
            }
            return 0;
        }

        public int getRowCount() {
            if (this.validateIfNecessary()) {
                return this.grid.length;
            }
            return 0;
        }

        public int getColumnCount() {
            if (this.validateIfNecessary() && this.grid.length > 0) {
                return this.grid[0].length;
            }
            return 0;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TableAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        private class TableCellElementInfo
        extends ElementInfo {
            private Accessible accessible;
            private boolean isHeaderCell;

            TableCellElementInfo(Element e, ElementInfo parent) {
                super(e, parent);
                this.isHeaderCell = false;
            }

            TableCellElementInfo(Element e, ElementInfo parent, boolean isHeaderCell) {
                super(e, parent);
                this.isHeaderCell = isHeaderCell;
            }

            public boolean isHeaderCell() {
                return this.isHeaderCell;
            }

            public Accessible getAccessible() {
                this.accessible = null;
                this.getAccessible(this);
                return this.accessible;
            }

            private void getAccessible(ElementInfo elementInfo) {
                if (elementInfo instanceof Accessible) {
                    this.accessible = (Accessible)((Object)elementInfo);
                } else {
                    for (int i = 0; i < elementInfo.getChildCount(); ++i) {
                        this.getAccessible(elementInfo.getChild(i));
                    }
                }
            }

            public int getRowCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.ROWSPAN, 1));
                }
                return 0;
            }

            public int getColumnCount() {
                if (this.validateIfNecessary()) {
                    return Math.max(1, this.getIntAttr(this.getAttributes(), HTML.Attribute.COLSPAN, 1));
                }
                return 0;
            }

            @Override
            protected void invalidate(boolean first) {
                super.invalidate(first);
                this.getParent().invalidate(true);
            }
        }

        private class TableRowElementInfo
        extends ElementInfo {
            private TableElementInfo parent;
            private int rowNumber;

            TableRowElementInfo(Element e, TableElementInfo parent, int rowNumber) {
                super(e, parent);
                this.parent = parent;
                this.rowNumber = rowNumber;
            }

            @Override
            protected void loadChildren(Element e) {
                for (int x = 0; x < e.getElementCount(); ++x) {
                    AttributeSet attrs = e.getElement(x).getAttributes();
                    if (attrs.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.TH) {
                        TableCellElementInfo headerElementInfo = new TableCellElementInfo(e.getElement(x), this, true);
                        this.addChild(headerElementInfo);
                        AccessibleTable at = this.parent.getAccessibleContext().getAccessibleTable();
                        TableAccessibleContext tableElement = (TableAccessibleContext)at;
                        tableElement.addRowHeader(headerElementInfo, this.rowNumber);
                        continue;
                    }
                    if (attrs.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.TD) continue;
                    this.addChild(new TableCellElementInfo(e.getElement(x), this, false));
                }
            }

            public int getRowCount() {
                int rowCount = 1;
                if (this.validateIfNecessary()) {
                    for (int counter = 0; counter < this.getChildCount(); ++counter) {
                        TableCellElementInfo cell = (TableCellElementInfo)this.getChild(counter);
                        if (!cell.validateIfNecessary()) continue;
                        rowCount = Math.max(rowCount, cell.getRowCount());
                    }
                }
                return rowCount;
            }

            public int getColumnCount() {
                int colCount = 0;
                if (this.validateIfNecessary()) {
                    for (int counter = 0; counter < this.getChildCount(); ++counter) {
                        TableCellElementInfo cell = (TableCellElementInfo)this.getChild(counter);
                        if (!cell.validateIfNecessary()) continue;
                        colCount += cell.getColumnCount();
                    }
                }
                return colCount;
            }

            @Override
            protected void invalidate(boolean first) {
                super.invalidate(first);
                this.getParent().invalidate(true);
            }

            private void updateGrid(int row) {
                if (this.validateIfNecessary()) {
                    boolean emptyRow = false;
                    while (!emptyRow) {
                        for (int counter = 0; counter < TableElementInfo.this.grid[row].length; ++counter) {
                            if (TableElementInfo.this.grid[row][counter] != null) continue;
                            emptyRow = true;
                            break;
                        }
                        if (emptyRow) continue;
                        ++row;
                    }
                    int col = 0;
                    for (int counter = 0; counter < this.getChildCount(); ++counter) {
                        TableCellElementInfo cell = (TableCellElementInfo)this.getChild(counter);
                        while (TableElementInfo.this.grid[row][col] != null) {
                            ++col;
                        }
                        for (int rowCount = cell.getRowCount() - 1; rowCount >= 0; --rowCount) {
                            for (int colCount = cell.getColumnCount() - 1; colCount >= 0; --colCount) {
                                TableElementInfo.this.grid[row + rowCount][col + colCount] = cell;
                            }
                        }
                        col += cell.getColumnCount();
                    }
                }
            }

            private int getColumnCount(int rowspan) {
                if (this.validateIfNecessary()) {
                    int cols = 0;
                    for (int counter = 0; counter < this.getChildCount(); ++counter) {
                        TableCellElementInfo cell = (TableCellElementInfo)this.getChild(counter);
                        if (cell.getRowCount() < rowspan) continue;
                        cols += cell.getColumnCount();
                    }
                    return cols;
                }
                return 0;
            }
        }

        public class TableAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleTable {
            private AccessibleHeadersTable rowHeadersTable;

            public TableAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            @Override
            public String getAccessibleName() {
                return this.getAccessibleRole().toString();
            }

            @Override
            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TABLE;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.elementInfo.getIndexInParent();
            }

            @Override
            public int getAccessibleChildrenCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount() * ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                int rowCount = ((TableElementInfo)this.elementInfo).getRowCount();
                int columnCount = ((TableElementInfo)this.elementInfo).getColumnCount();
                int r = i / rowCount;
                int c = i % columnCount;
                if (r < 0 || r >= rowCount || c < 0 || c >= columnCount) {
                    return null;
                }
                return this.getAccessibleAt(r, c);
            }

            @Override
            public AccessibleTable getAccessibleTable() {
                return this;
            }

            @Override
            public Accessible getAccessibleCaption() {
                ElementInfo captionInfo = TableElementInfo.this.getCaptionInfo();
                if (captionInfo instanceof Accessible) {
                    return (Accessible)((Object)TableElementInfo.this.caption);
                }
                return null;
            }

            @Override
            public void setAccessibleCaption(Accessible a) {
            }

            @Override
            public Accessible getAccessibleSummary() {
                return null;
            }

            @Override
            public void setAccessibleSummary(Accessible a) {
            }

            @Override
            public int getAccessibleRowCount() {
                return ((TableElementInfo)this.elementInfo).getRowCount();
            }

            @Override
            public int getAccessibleColumnCount() {
                return ((TableElementInfo)this.elementInfo).getColumnCount();
            }

            @Override
            public Accessible getAccessibleAt(int r, int c) {
                TableCellElementInfo cellInfo = TableElementInfo.this.getCell(r, c);
                if (cellInfo != null) {
                    return cellInfo.getAccessible();
                }
                return null;
            }

            @Override
            public int getAccessibleRowExtentAt(int r, int c) {
                return ((TableElementInfo)this.elementInfo).getRowExtentAt(r, c);
            }

            @Override
            public int getAccessibleColumnExtentAt(int r, int c) {
                return ((TableElementInfo)this.elementInfo).getColumnExtentAt(r, c);
            }

            @Override
            public AccessibleTable getAccessibleRowHeader() {
                return this.rowHeadersTable;
            }

            @Override
            public void setAccessibleRowHeader(AccessibleTable table) {
            }

            @Override
            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            @Override
            public void setAccessibleColumnHeader(AccessibleTable table) {
            }

            @Override
            public Accessible getAccessibleRowDescription(int r) {
                return null;
            }

            @Override
            public void setAccessibleRowDescription(int r, Accessible a) {
            }

            @Override
            public Accessible getAccessibleColumnDescription(int c) {
                return null;
            }

            @Override
            public void setAccessibleColumnDescription(int c, Accessible a) {
            }

            @Override
            public boolean isAccessibleSelected(int r, int c) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (r < 0 || r >= this.getAccessibleRowCount() || c < 0 || c >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    TableCellElementInfo cell = TableElementInfo.this.getCell(r, c);
                    if (cell != null) {
                        Element elem = cell.getElement();
                        int start = elem.getStartOffset();
                        int end = elem.getEndOffset();
                        return start >= AccessibleHTML.this.editor.getSelectionStart() && end <= AccessibleHTML.this.editor.getSelectionEnd();
                    }
                }
                return false;
            }

            @Override
            public boolean isAccessibleRowSelected(int r) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (r < 0 || r >= this.getAccessibleRowCount()) {
                        return false;
                    }
                    int nColumns = this.getAccessibleColumnCount();
                    TableCellElementInfo startCell = TableElementInfo.this.getCell(r, 0);
                    if (startCell == null) {
                        return false;
                    }
                    int start = startCell.getElement().getStartOffset();
                    TableCellElementInfo endCell = TableElementInfo.this.getCell(r, nColumns - 1);
                    if (endCell == null) {
                        return false;
                    }
                    int end = endCell.getElement().getEndOffset();
                    return start >= AccessibleHTML.this.editor.getSelectionStart() && end <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            @Override
            public boolean isAccessibleColumnSelected(int c) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (c < 0 || c >= this.getAccessibleColumnCount()) {
                        return false;
                    }
                    int nRows = this.getAccessibleRowCount();
                    TableCellElementInfo startCell = TableElementInfo.this.getCell(0, c);
                    if (startCell == null) {
                        return false;
                    }
                    int start = startCell.getElement().getStartOffset();
                    TableCellElementInfo endCell = TableElementInfo.this.getCell(nRows - 1, c);
                    if (endCell == null) {
                        return false;
                    }
                    int end = endCell.getElement().getEndOffset();
                    return start >= AccessibleHTML.this.editor.getSelectionStart() && end <= AccessibleHTML.this.editor.getSelectionEnd();
                }
                return false;
            }

            @Override
            public int[] getSelectedAccessibleRows() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int nRows = this.getAccessibleRowCount();
                    Vector<Integer> vec = new Vector<Integer>();
                    for (int i = 0; i < nRows; ++i) {
                        if (!this.isAccessibleRowSelected(i)) continue;
                        vec.addElement(i);
                    }
                    int[] retval = new int[vec.size()];
                    for (int i = 0; i < retval.length; ++i) {
                        retval[i] = (Integer)vec.elementAt(i);
                    }
                    return retval;
                }
                return new int[0];
            }

            @Override
            public int[] getSelectedAccessibleColumns() {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int nColumns = this.getAccessibleRowCount();
                    Vector<Integer> vec = new Vector<Integer>();
                    for (int i = 0; i < nColumns; ++i) {
                        if (!this.isAccessibleColumnSelected(i)) continue;
                        vec.addElement(i);
                    }
                    int[] retval = new int[vec.size()];
                    for (int i = 0; i < retval.length; ++i) {
                        retval[i] = (Integer)vec.elementAt(i);
                    }
                    return retval;
                }
                return new int[0];
            }

            public int getAccessibleRow(int index) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int numCells = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (index >= numCells) {
                        return -1;
                    }
                    return index / this.getAccessibleColumnCount();
                }
                return -1;
            }

            public int getAccessibleColumn(int index) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    int numCells = this.getAccessibleColumnCount() * this.getAccessibleRowCount();
                    if (index >= numCells) {
                        return -1;
                    }
                    return index % this.getAccessibleColumnCount();
                }
                return -1;
            }

            public int getAccessibleIndex(int r, int c) {
                if (TableElementInfo.this.validateIfNecessary()) {
                    if (r >= this.getAccessibleRowCount() || c >= this.getAccessibleColumnCount()) {
                        return -1;
                    }
                    return r * this.getAccessibleColumnCount() + c;
                }
                return -1;
            }

            public String getAccessibleRowHeader(int r) {
                View v;
                TableCellElementInfo cellInfo;
                if (TableElementInfo.this.validateIfNecessary() && (cellInfo = TableElementInfo.this.getCell(r, 0)).isHeaderCell() && (v = cellInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(v.getStartOffset(), v.getEndOffset() - v.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        return null;
                    }
                }
                return null;
            }

            public String getAccessibleColumnHeader(int c) {
                View v;
                TableCellElementInfo cellInfo;
                if (TableElementInfo.this.validateIfNecessary() && (cellInfo = TableElementInfo.this.getCell(0, c)).isHeaderCell() && (v = cellInfo.getView()) != null && AccessibleHTML.this.model != null) {
                    try {
                        return AccessibleHTML.this.model.getText(v.getStartOffset(), v.getEndOffset() - v.getStartOffset());
                    }
                    catch (BadLocationException e) {
                        return null;
                    }
                }
                return null;
            }

            public void addRowHeader(TableCellElementInfo cellInfo, int rowNumber) {
                if (this.rowHeadersTable == null) {
                    this.rowHeadersTable = new AccessibleHeadersTable();
                }
                this.rowHeadersTable.addHeader(cellInfo, rowNumber);
            }

            protected class AccessibleHeadersTable
            implements AccessibleTable {
                private Hashtable<Integer, ArrayList<TableCellElementInfo>> headers = new Hashtable();
                private int rowCount = 0;
                private int columnCount = 0;

                protected AccessibleHeadersTable() {
                }

                public void addHeader(TableCellElementInfo cellInfo, int rowNumber) {
                    Integer rowInteger = rowNumber;
                    ArrayList<TableCellElementInfo> list = this.headers.get(rowInteger);
                    if (list == null) {
                        list = new ArrayList();
                        this.headers.put(rowInteger, list);
                    }
                    list.add(cellInfo);
                }

                @Override
                public Accessible getAccessibleCaption() {
                    return null;
                }

                @Override
                public void setAccessibleCaption(Accessible a) {
                }

                @Override
                public Accessible getAccessibleSummary() {
                    return null;
                }

                @Override
                public void setAccessibleSummary(Accessible a) {
                }

                @Override
                public int getAccessibleRowCount() {
                    return this.rowCount;
                }

                @Override
                public int getAccessibleColumnCount() {
                    return this.columnCount;
                }

                private TableCellElementInfo getElementInfoAt(int r, int c) {
                    ArrayList<TableCellElementInfo> list = this.headers.get(r);
                    if (list != null) {
                        return list.get(c);
                    }
                    return null;
                }

                @Override
                public Accessible getAccessibleAt(int r, int c) {
                    TableCellElementInfo elementInfo = this.getElementInfoAt(r, c);
                    if (elementInfo instanceof Accessible) {
                        return (Accessible)((Object)elementInfo);
                    }
                    return null;
                }

                @Override
                public int getAccessibleRowExtentAt(int r, int c) {
                    TableCellElementInfo elementInfo = this.getElementInfoAt(r, c);
                    if (elementInfo != null) {
                        return elementInfo.getRowCount();
                    }
                    return 0;
                }

                @Override
                public int getAccessibleColumnExtentAt(int r, int c) {
                    TableCellElementInfo elementInfo = this.getElementInfoAt(r, c);
                    if (elementInfo != null) {
                        return elementInfo.getRowCount();
                    }
                    return 0;
                }

                @Override
                public AccessibleTable getAccessibleRowHeader() {
                    return null;
                }

                @Override
                public void setAccessibleRowHeader(AccessibleTable table) {
                }

                @Override
                public AccessibleTable getAccessibleColumnHeader() {
                    return null;
                }

                @Override
                public void setAccessibleColumnHeader(AccessibleTable table) {
                }

                @Override
                public Accessible getAccessibleRowDescription(int r) {
                    return null;
                }

                @Override
                public void setAccessibleRowDescription(int r, Accessible a) {
                }

                @Override
                public Accessible getAccessibleColumnDescription(int c) {
                    return null;
                }

                @Override
                public void setAccessibleColumnDescription(int c, Accessible a) {
                }

                @Override
                public boolean isAccessibleSelected(int r, int c) {
                    return false;
                }

                @Override
                public boolean isAccessibleRowSelected(int r) {
                    return false;
                }

                @Override
                public boolean isAccessibleColumnSelected(int c) {
                    return false;
                }

                @Override
                public int[] getSelectedAccessibleRows() {
                    return new int[0];
                }

                @Override
                public int[] getSelectedAccessibleColumns() {
                    return new int[0];
                }
            }
        }
    }

    private class IconElementInfo
    extends ElementInfo
    implements Accessible {
        private int width;
        private int height;
        private AccessibleContext accessibleContext;

        IconElementInfo(Element element, ElementInfo parent) {
            super(element, parent);
            this.width = -1;
            this.height = -1;
        }

        @Override
        protected void invalidate(boolean first) {
            super.invalidate(first);
            this.height = -1;
            this.width = -1;
        }

        private int getImageSize(Object key) {
            if (this.validateIfNecessary()) {
                int size = this.getIntAttr(this.getAttributes(), key, -1);
                if (size == -1) {
                    Image img;
                    View v = this.getView();
                    size = 0;
                    if (v instanceof ImageView && (img = ((ImageView)v).getImage()) != null) {
                        size = key == HTML.Attribute.WIDTH ? img.getWidth(null) : img.getHeight(null);
                    }
                }
                return size;
            }
            return 0;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new IconAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        protected class IconAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleIcon {
            public IconAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            @Override
            public String getAccessibleName() {
                return this.getAccessibleIconDescription();
            }

            @Override
            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.ICON;
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleIcon[] icons = new AccessibleIcon[]{this};
                return icons;
            }

            @Override
            public String getAccessibleIconDescription() {
                return ((ImageView)IconElementInfo.this.getView()).getAltText();
            }

            @Override
            public void setAccessibleIconDescription(String description) {
            }

            @Override
            public int getAccessibleIconWidth() {
                if (IconElementInfo.this.width == -1) {
                    IconElementInfo.this.width = IconElementInfo.this.getImageSize(HTML.Attribute.WIDTH);
                }
                return IconElementInfo.this.width;
            }

            @Override
            public int getAccessibleIconHeight() {
                if (IconElementInfo.this.height == -1) {
                    IconElementInfo.this.height = IconElementInfo.this.getImageSize(HTML.Attribute.HEIGHT);
                }
                return IconElementInfo.this.height;
            }
        }
    }

    class TextElementInfo
    extends ElementInfo
    implements Accessible {
        private AccessibleContext accessibleContext;

        TextElementInfo(Element element, ElementInfo parent) {
            super(element, parent);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new TextAccessibleContext((ElementInfo)this);
            }
            return this.accessibleContext;
        }

        public class TextAccessibleContext
        extends HTMLAccessibleContext
        implements AccessibleText {
            public TextAccessibleContext(ElementInfo elementInfo) {
                super(elementInfo);
            }

            @Override
            public AccessibleText getAccessibleText() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                if (AccessibleHTML.this.model != null) {
                    return (String)AccessibleHTML.this.model.getProperty("title");
                }
                return null;
            }

            @Override
            public String getAccessibleDescription() {
                return AccessibleHTML.this.editor.getContentType();
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.TEXT;
            }

            @Override
            public int getIndexAtPoint(Point p) {
                View v = TextElementInfo.this.getView();
                if (v != null) {
                    return v.viewToModel(p.x, p.y, this.getBounds());
                }
                return -1;
            }

            @Override
            public Rectangle getCharacterBounds(int i) {
                try {
                    return AccessibleHTML.this.editor.getUI().modelToView(AccessibleHTML.this.editor, i);
                }
                catch (BadLocationException e) {
                    return null;
                }
            }

            @Override
            public int getCharCount() {
                if (TextElementInfo.this.validateIfNecessary()) {
                    Element elem = this.elementInfo.getElement();
                    return elem.getEndOffset() - elem.getStartOffset();
                }
                return 0;
            }

            @Override
            public int getCaretPosition() {
                View v = TextElementInfo.this.getView();
                if (v == null) {
                    return -1;
                }
                Container c = v.getContainer();
                if (c == null) {
                    return -1;
                }
                if (c instanceof JTextComponent) {
                    return ((JTextComponent)c).getCaretPosition();
                }
                return -1;
            }

            @Override
            public String getAtIndex(int part, int index) {
                return this.getAtIndex(part, index, 0);
            }

            @Override
            public String getAfterIndex(int part, int index) {
                return this.getAtIndex(part, index, 1);
            }

            @Override
            public String getBeforeIndex(int part, int index) {
                return this.getAtIndex(part, index, -1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private String getAtIndex(int part, int index, int direction) {
                if (AccessibleHTML.this.model instanceof AbstractDocument) {
                    ((AbstractDocument)AccessibleHTML.this.model).readLock();
                }
                try {
                    if (index < 0 || index >= AccessibleHTML.this.model.getLength()) {
                        String string = null;
                        return string;
                    }
                    switch (part) {
                        case 1: {
                            if (index + direction >= AccessibleHTML.this.model.getLength()) return null;
                            if (index + direction < 0) return null;
                            String string = AccessibleHTML.this.model.getText(index + direction, 1);
                            return string;
                        }
                        case 2: 
                        case 3: {
                            IndexedSegment seg = this.getSegmentAt(part, index);
                            if (seg == null) return null;
                            if (direction != 0) {
                                int next = direction < 0 ? seg.modelOffset - 1 : seg.modelOffset + direction * seg.count;
                                seg = next >= 0 && next <= AccessibleHTML.this.model.getLength() ? this.getSegmentAt(part, next) : null;
                            }
                            if (seg == null) return null;
                            String string = new String(seg.array, seg.offset, seg.count);
                            return string;
                        }
                    }
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                finally {
                    if (AccessibleHTML.this.model instanceof AbstractDocument) {
                        ((AbstractDocument)AccessibleHTML.this.model).readUnlock();
                    }
                }
            }

            private Element getParagraphElement(int index) {
                if (AccessibleHTML.this.model instanceof PlainDocument) {
                    PlainDocument sdoc = (PlainDocument)AccessibleHTML.this.model;
                    return sdoc.getParagraphElement(index);
                }
                if (AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument sdoc = (StyledDocument)AccessibleHTML.this.model;
                    return sdoc.getParagraphElement(index);
                }
                Element para = AccessibleHTML.this.model.getDefaultRootElement();
                while (!para.isLeaf()) {
                    int pos = para.getElementIndex(index);
                    para = para.getElement(pos);
                }
                if (para == null) {
                    return null;
                }
                return para.getParentElement();
            }

            private IndexedSegment getParagraphElementText(int index) throws BadLocationException {
                Element para = this.getParagraphElement(index);
                if (para != null) {
                    IndexedSegment segment = new IndexedSegment();
                    try {
                        int length = para.getEndOffset() - para.getStartOffset();
                        AccessibleHTML.this.model.getText(para.getStartOffset(), length, segment);
                    }
                    catch (BadLocationException e) {
                        return null;
                    }
                    segment.modelOffset = para.getStartOffset();
                    return segment;
                }
                return null;
            }

            private IndexedSegment getSegmentAt(int part, int index) throws BadLocationException {
                BreakIterator iterator;
                IndexedSegment seg = this.getParagraphElementText(index);
                if (seg == null) {
                    return null;
                }
                switch (part) {
                    case 2: {
                        iterator = BreakIterator.getWordInstance(this.getLocale());
                        break;
                    }
                    case 3: {
                        iterator = BreakIterator.getSentenceInstance(this.getLocale());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                seg.first();
                iterator.setText(seg);
                int end = iterator.following(index - seg.modelOffset + seg.offset);
                if (end == -1) {
                    return null;
                }
                if (end > seg.offset + seg.count) {
                    return null;
                }
                int begin = iterator.previous();
                if (begin == -1 || begin >= seg.offset + seg.count) {
                    return null;
                }
                seg.modelOffset = seg.modelOffset + begin - seg.offset;
                seg.offset = begin;
                seg.count = end - begin;
                return seg;
            }

            @Override
            public AttributeSet getCharacterAttribute(int i) {
                StyledDocument doc;
                Element elem;
                if (AccessibleHTML.this.model instanceof StyledDocument && (elem = (doc = (StyledDocument)AccessibleHTML.this.model).getCharacterElement(i)) != null) {
                    return elem.getAttributes();
                }
                return null;
            }

            @Override
            public int getSelectionStart() {
                return AccessibleHTML.this.editor.getSelectionStart();
            }

            @Override
            public int getSelectionEnd() {
                return AccessibleHTML.this.editor.getSelectionEnd();
            }

            @Override
            public String getSelectedText() {
                return AccessibleHTML.this.editor.getSelectedText();
            }

            private String getText(int offset, int length) throws BadLocationException {
                if (AccessibleHTML.this.model != null && AccessibleHTML.this.model instanceof StyledDocument) {
                    StyledDocument doc = (StyledDocument)AccessibleHTML.this.model;
                    return AccessibleHTML.this.model.getText(offset, length);
                }
                return null;
            }

            private class IndexedSegment
            extends Segment {
                public int modelOffset;

                private IndexedSegment() {
                }
            }
        }
    }

    protected abstract class HTMLAccessibleContext
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent {
        protected ElementInfo elementInfo;

        public HTMLAccessibleContext(ElementInfo elementInfo) {
            this.elementInfo = elementInfo;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = new AccessibleStateSet();
            JEditorPane comp = AccessibleHTML.this.getTextComponent();
            if (comp.isEnabled()) {
                states.add(AccessibleState.ENABLED);
            }
            if (comp instanceof JTextComponent && ((JTextComponent)comp).isEditable()) {
                states.add(AccessibleState.EDITABLE);
                states.add(AccessibleState.FOCUSABLE);
            }
            if (comp.isVisible()) {
                states.add(AccessibleState.VISIBLE);
            }
            if (comp.isShowing()) {
                states.add(AccessibleState.SHOWING);
            }
            return states;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this.elementInfo.getIndexInParent();
        }

        @Override
        public int getAccessibleChildrenCount() {
            return this.elementInfo.getChildCount();
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            ElementInfo childInfo = this.elementInfo.getChild(i);
            if (childInfo != null && childInfo instanceof Accessible) {
                return (Accessible)((Object)childInfo);
            }
            return null;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return AccessibleHTML.this.editor.getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Color getBackground() {
            return AccessibleHTML.this.getTextComponent().getBackground();
        }

        @Override
        public void setBackground(Color c) {
            AccessibleHTML.this.getTextComponent().setBackground(c);
        }

        @Override
        public Color getForeground() {
            return AccessibleHTML.this.getTextComponent().getForeground();
        }

        @Override
        public void setForeground(Color c) {
            AccessibleHTML.this.getTextComponent().setForeground(c);
        }

        @Override
        public Cursor getCursor() {
            return AccessibleHTML.this.getTextComponent().getCursor();
        }

        @Override
        public void setCursor(Cursor cursor) {
            AccessibleHTML.this.getTextComponent().setCursor(cursor);
        }

        @Override
        public Font getFont() {
            return AccessibleHTML.this.getTextComponent().getFont();
        }

        @Override
        public void setFont(Font f) {
            AccessibleHTML.this.getTextComponent().setFont(f);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return AccessibleHTML.this.getTextComponent().getFontMetrics(f);
        }

        @Override
        public boolean isEnabled() {
            return AccessibleHTML.this.getTextComponent().isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            AccessibleHTML.this.getTextComponent().setEnabled(b);
        }

        @Override
        public boolean isVisible() {
            return AccessibleHTML.this.getTextComponent().isVisible();
        }

        @Override
        public void setVisible(boolean b) {
            AccessibleHTML.this.getTextComponent().setVisible(b);
        }

        @Override
        public boolean isShowing() {
            return AccessibleHTML.this.getTextComponent().isShowing();
        }

        @Override
        public boolean contains(Point p) {
            Rectangle r = this.getBounds();
            if (r != null) {
                return r.contains(p.x, p.y);
            }
            return false;
        }

        @Override
        public Point getLocationOnScreen() {
            Point editorLocation = AccessibleHTML.this.getTextComponent().getLocationOnScreen();
            Rectangle r = this.getBounds();
            if (r != null) {
                return new Point(editorLocation.x + r.x, editorLocation.y + r.y);
            }
            return null;
        }

        @Override
        public Point getLocation() {
            Rectangle r = this.getBounds();
            if (r != null) {
                return new Point(r.x, r.y);
            }
            return null;
        }

        @Override
        public void setLocation(Point p) {
        }

        @Override
        public Rectangle getBounds() {
            return this.elementInfo.getBounds();
        }

        @Override
        public void setBounds(Rectangle r) {
        }

        @Override
        public Dimension getSize() {
            Rectangle r = this.getBounds();
            if (r != null) {
                return new Dimension(r.width, r.height);
            }
            return null;
        }

        @Override
        public void setSize(Dimension d) {
            JEditorPane comp = AccessibleHTML.this.getTextComponent();
            comp.setSize(d);
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            ElementInfo innerMostElement = this.getElementInfoAt(AccessibleHTML.this.rootElementInfo, p);
            if (innerMostElement instanceof Accessible) {
                return (Accessible)((Object)innerMostElement);
            }
            return null;
        }

        private ElementInfo getElementInfoAt(ElementInfo elementInfo, Point p) {
            Rectangle bounds;
            ElementInfo captionInfo;
            if (elementInfo.getBounds() == null) {
                return null;
            }
            if (elementInfo.getChildCount() == 0 && elementInfo.getBounds().contains(p)) {
                return elementInfo;
            }
            if (elementInfo instanceof TableElementInfo && (captionInfo = ((TableElementInfo)elementInfo).getCaptionInfo()) != null && (bounds = captionInfo.getBounds()) != null && bounds.contains(p)) {
                return captionInfo;
            }
            for (int i = 0; i < elementInfo.getChildCount(); ++i) {
                ElementInfo childInfo = elementInfo.getChild(i);
                ElementInfo retValue = this.getElementInfoAt(childInfo, p);
                if (retValue == null) continue;
                return retValue;
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            JEditorPane comp = AccessibleHTML.this.getTextComponent();
            return comp instanceof JTextComponent && ((JTextComponent)comp).isEditable();
        }

        @Override
        public void requestFocus() {
            if (!this.isFocusTraversable()) {
                return;
            }
            JEditorPane comp = AccessibleHTML.this.getTextComponent();
            if (comp instanceof JTextComponent) {
                ((Component)comp).requestFocusInWindow();
                try {
                    if (this.elementInfo.validateIfNecessary()) {
                        Element elem = this.elementInfo.getElement();
                        ((JTextComponent)comp).setCaretPosition(elem.getStartOffset());
                        AccessibleContext ac = AccessibleHTML.this.editor.getAccessibleContext();
                        PropertyChangeEvent pce = new PropertyChangeEvent(this, "AccessibleState", null, AccessibleState.FOCUSED);
                        ac.firePropertyChange("AccessibleState", null, pce);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void addFocusListener(FocusListener l) {
            AccessibleHTML.this.getTextComponent().addFocusListener(l);
        }

        @Override
        public void removeFocusListener(FocusListener l) {
            AccessibleHTML.this.getTextComponent().removeFocusListener(l);
        }
    }

    private class RootHTMLAccessibleContext
    extends HTMLAccessibleContext {
        public RootHTMLAccessibleContext(ElementInfo elementInfo) {
            super(elementInfo);
        }

        @Override
        public String getAccessibleName() {
            if (AccessibleHTML.this.model != null) {
                return (String)AccessibleHTML.this.model.getProperty("title");
            }
            return null;
        }

        @Override
        public String getAccessibleDescription() {
            return AccessibleHTML.this.editor.getContentType();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }
    }
}

