/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    private boolean isDropCell;
    private boolean fillBackground;
    private boolean inited = true;

    @Override
    public void updateUI() {
        super.updateUI();
        if (!this.inited || this.getLeafIcon() instanceof UIResource) {
            this.setLeafIcon(DefaultLookup.getIcon(this, this.ui, "Tree.leafIcon"));
        }
        if (!this.inited || this.getClosedIcon() instanceof UIResource) {
            this.setClosedIcon(DefaultLookup.getIcon(this, this.ui, "Tree.closedIcon"));
        }
        if (!this.inited || this.getOpenIcon() instanceof UIResource) {
            this.setOpenIcon(DefaultLookup.getIcon(this, this.ui, "Tree.openIcon"));
        }
        if (!this.inited || this.getTextSelectionColor() instanceof UIResource) {
            this.setTextSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionForeground"));
        }
        if (!this.inited || this.getTextNonSelectionColor() instanceof UIResource) {
            this.setTextNonSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.textForeground"));
        }
        if (!this.inited || this.getBackgroundSelectionColor() instanceof UIResource) {
            this.setBackgroundSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionBackground"));
        }
        if (!this.inited || this.getBackgroundNonSelectionColor() instanceof UIResource) {
            this.setBackgroundNonSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.textBackground"));
        }
        if (!this.inited || this.getBorderSelectionColor() instanceof UIResource) {
            this.setBorderSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionBorderColor"));
        }
        this.drawsFocusBorderAroundIcon = DefaultLookup.getBoolean(this, this.ui, "Tree.drawsFocusBorderAroundIcon", false);
        this.drawDashedFocusIndicator = DefaultLookup.getBoolean(this, this.ui, "Tree.drawDashedFocusIndicator", false);
        this.fillBackground = DefaultLookup.getBoolean(this, this.ui, "Tree.rendererFillBackground", true);
        Insets margins = DefaultLookup.getInsets(this, this.ui, "Tree.rendererMargins");
        if (margins != null) {
            this.setBorder(new EmptyBorder(margins.top, margins.left, margins.bottom, margins.right));
        }
        this.setName("Tree.cellRenderer");
    }

    public Icon getDefaultOpenIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.leafIcon");
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        this.setText(stringValue);
        Color fg = null;
        this.isDropCell = false;
        JTree.DropLocation dropLocation = tree.getDropLocation();
        if (dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row) {
            Color col = DefaultLookup.getColor(this, this.ui, "Tree.dropCellForeground");
            fg = col != null ? col : this.getTextSelectionColor();
            this.isDropCell = true;
        } else {
            fg = sel ? this.getTextSelectionColor() : this.getTextNonSelectionColor();
        }
        this.setForeground(fg);
        Icon icon = null;
        icon = leaf ? this.getLeafIcon() : (expanded ? this.getOpenIcon() : this.getClosedIcon());
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            LookAndFeel laf = UIManager.getLookAndFeel();
            Icon disabledIcon = laf.getDisabledIcon(tree, icon);
            if (disabledIcon != null) {
                icon = disabledIcon;
            }
            this.setDisabledIcon(icon);
        } else {
            this.setEnabled(true);
            this.setIcon(icon);
        }
        this.setComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color bColor;
        if (this.isDropCell) {
            bColor = DefaultLookup.getColor(this, this.ui, "Tree.dropCellBackground");
            if (bColor == null) {
                bColor = this.getBackgroundSelectionColor();
            }
        } else if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if (bColor != null && this.fillBackground) {
            imageOffset = this.getLabelStart();
            g.setColor(bColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                g.fillRect(0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.paintFocus(g, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight(), bColor);
            } else {
                this.paintFocus(g, 0, 0, this.getWidth() - imageOffset, this.getHeight(), bColor);
            }
        }
        super.paint(g);
    }

    private void paintFocus(Graphics g, int x, int y, int w, int h, Color notColor) {
        Color bsColor = this.getBorderSelectionColor();
        if (bsColor != null && (this.selected || !this.drawDashedFocusIndicator)) {
            g.setColor(bsColor);
            g.drawRect(x, y, w - 1, h - 1);
        }
        if (this.drawDashedFocusIndicator && notColor != null) {
            if (this.treeBGColor != notColor) {
                this.treeBGColor = notColor;
                this.focusBGColor = new Color(~notColor.getRGB());
            }
            g.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(g, x, y, w, h);
        }
    }

    private int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || (SwingUtilities2.isScaleChanged(propertyName, oldValue, newValue) || propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

