/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt._AppDockIconHandler;
import com.apple.eawt._AppEventHandler;
import com.apple.eawt._AppMenuBarHandler;
import com.apple.eawt._AppMiscHandlers;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.OpenURIHandler;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.PrintFilesHandler;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitStrategy;
import java.awt.desktop.SystemEventListener;
import java.beans.Beans;
import javax.swing.JMenuBar;
import sun.awt.AWTAccessor;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.PlatformWindow;
import sun.lwawt.macosx.CPlatformWindow;

public class Application {
    static Application sApplication = null;
    final _AppEventHandler eventHandler = _AppEventHandler.getInstance();
    final _AppMenuBarHandler menuBarHandler = _AppMenuBarHandler.getInstance();
    final _AppDockIconHandler iconHandler = new _AppDockIconHandler();

    private static native void nativeInitializeApplicationDelegate();

    private static void checkSecurity() {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        security.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
    }

    public static Application getApplication() {
        Application.checkSecurity();
        return sApplication;
    }

    @Deprecated
    public Application() {
        Application.checkSecurity();
    }

    public void addAppEventListener(SystemEventListener listener) {
        this.eventHandler.addListener(listener);
    }

    public void removeAppEventListener(SystemEventListener listener) {
        this.eventHandler.removeListener(listener);
    }

    public void setAboutHandler(AboutHandler aboutHandler) {
        this.eventHandler.aboutDispatcher.setHandler(aboutHandler);
    }

    public void setPreferencesHandler(PreferencesHandler preferencesHandler) {
        this.eventHandler.preferencesDispatcher.setHandler(preferencesHandler);
    }

    public void setOpenFileHandler(OpenFilesHandler openFileHandler) {
        this.eventHandler.openFilesDispatcher.setHandler(openFileHandler);
    }

    public void setPrintFileHandler(PrintFilesHandler printFileHandler) {
        this.eventHandler.printFilesDispatcher.setHandler(printFileHandler);
    }

    public void setOpenURIHandler(OpenURIHandler openURIHandler) {
        this.eventHandler.openURIDispatcher.setHandler(openURIHandler);
    }

    public void setQuitHandler(QuitHandler quitHandler) {
        this.eventHandler.quitDispatcher.setHandler(quitHandler);
    }

    public void setQuitStrategy(QuitStrategy strategy) {
        this.eventHandler.setDefaultQuitStrategy(strategy);
    }

    public void enableSuddenTermination() {
        _AppMiscHandlers.enableSuddenTermination();
    }

    public void disableSuddenTermination() {
        _AppMiscHandlers.disableSuddenTermination();
    }

    public void requestForeground(boolean allWindows) {
        _AppMiscHandlers.requestActivation(allWindows);
    }

    public void requestUserAttention(boolean critical) {
        _AppMiscHandlers.requestUserAttention(critical);
    }

    public void openHelpViewer() {
        _AppMiscHandlers.openHelpViewer();
    }

    public void setDockMenu(PopupMenu menu) {
        this.iconHandler.setDockMenu(menu);
    }

    public PopupMenu getDockMenu() {
        return this.iconHandler.getDockMenu();
    }

    public void setDockIconImage(Image image) {
        this.iconHandler.setDockIconImage(image);
    }

    public Image getDockIconImage() {
        return this.iconHandler.getDockIconImage();
    }

    public void setDockIconBadge(String badge) {
        this.iconHandler.setDockIconBadge(badge);
    }

    public void setDockIconProgress(int value) {
        this.iconHandler.setDockIconProgress(value);
    }

    public void setDefaultMenuBar(JMenuBar menuBar) {
        this.menuBarHandler.setDefaultMenuBar(menuBar);
    }

    public void requestToggleFullScreen(Window window) {
        Object peer = AWTAccessor.getComponentAccessor().getPeer(window);
        if (!(peer instanceof LWWindowPeer)) {
            return;
        }
        PlatformWindow platformWindow = ((LWWindowPeer)peer).getPlatformWindow();
        if (!(platformWindow instanceof CPlatformWindow)) {
            return;
        }
        ((CPlatformWindow)platformWindow).toggleFullScreen();
    }

    static {
        Application.checkSecurity();
        Toolkit.getDefaultToolkit();
        if (!Beans.isDesignTime()) {
            Application.nativeInitializeApplicationDelegate();
        }
        sApplication = new Application();
    }
}

