/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaBorder;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonExtendedTypes;
import com.apple.laf.AquaComboBoxButton;
import com.apple.laf.AquaFocus;
import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaRootPaneUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaButtonUI
extends BasicButtonUI
implements AquaUtilControlSize.Sizeable {
    private static final String BUTTON_TYPE = "JButton.buttonType";
    private static final String SEGMENTED_BUTTON_POSITION = "JButton.segmentPosition";
    private static final AquaUtils.RecyclableSingleton<AquaButtonUI> buttonUI = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaButtonUI>(AquaButtonUI.class);
    private boolean defaults_initialized = false;
    private Color defaultDisabledTextColor = null;
    private static final AquaUtils.RecyclableSingleton<AquaHierarchyButtonListener> fHierListener = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaHierarchyButtonListener>(AquaHierarchyButtonListener.class);

    public static ComponentUI createUI(JComponent c) {
        return buttonUI.get();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        Object segmentProp;
        String pp = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultDisabledTextColor = UIManager.getColor(pp + "disabledText");
            this.defaults_initialized = true;
        }
        this.setButtonMarginIfNeeded(b, UIManager.getInsets(pp + "margin"));
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
        LookAndFeel.installProperty(b, "opaque", UIManager.getBoolean(pp + "opaque"));
        Object borderProp = b.getClientProperty(BUTTON_TYPE);
        boolean hasBorder = false;
        if (borderProp != null) {
            hasBorder = this.setButtonType(b, borderProp);
        }
        if (!hasBorder) {
            this.setThemeBorder(b);
        }
        if ((segmentProp = b.getClientProperty(SEGMENTED_BUTTON_POSITION)) != null) {
            Border border = b.getBorder();
            if (!(border instanceof AquaBorder)) {
                return;
            }
            b.setBorder(AquaButtonExtendedTypes.getBorderForPosition(b, b.getClientProperty(BUTTON_TYPE), segmentProp));
        }
    }

    @Override
    public void applySizeFor(JComponent c, JRSUIConstants.Size size) {
    }

    protected void setThemeBorder(AbstractButton b) {
        ButtonUI genericUI = b.getUI();
        if (!(genericUI instanceof AquaButtonUI)) {
            return;
        }
        AquaButtonUI ui = (AquaButtonUI)genericUI;
        Border border = b.getBorder();
        if (!ui.isBorderFromProperty(b) && (border == null || border instanceof UIResource || border instanceof AquaButtonBorder)) {
            boolean iconFont = true;
            if (AquaButtonUI.isOnToolbar(b)) {
                border = b instanceof JToggleButton ? AquaButtonBorder.getToolBarButtonBorder() : AquaButtonBorder.getBevelButtonBorder();
            } else if (b.getIcon() != null || b.getComponentCount() > 0) {
                border = AquaButtonBorder.getToggleButtonBorder();
            } else {
                border = UIManager.getBorder(this.getPropertyPrefix() + "border");
                iconFont = false;
            }
            b.setBorder(border);
            Font currentFont = b.getFont();
            if (iconFont && (currentFont == null || currentFont instanceof UIResource)) {
                b.setFont(UIManager.getFont("IconButton.font"));
            }
        }
    }

    protected static boolean isOnToolbar(AbstractButton b) {
        for (Container parent = b.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JToolBar)) continue;
            return true;
        }
        return false;
    }

    protected static void updateBorder(AbstractButton b) {
        Object prop = b.getClientProperty(BUTTON_TYPE);
        if (prop != null) {
            return;
        }
        ButtonUI ui = b.getUI();
        if (!(ui instanceof AquaButtonUI)) {
            return;
        }
        if (b.getBorder() != null) {
            ((AquaButtonUI)ui).setThemeBorder(b);
        }
    }

    protected void setButtonMarginIfNeeded(AbstractButton b, Insets insets) {
        Insets margin = b.getMargin();
        if (margin == null || margin instanceof UIResource) {
            b.setMargin(insets);
        }
    }

    public boolean isBorderFromProperty(AbstractButton button) {
        return button.getClientProperty(BUTTON_TYPE) != null;
    }

    protected boolean setButtonType(AbstractButton b, Object prop) {
        Font currentFont;
        if (!(prop instanceof String)) {
            b.putClientProperty(BUTTON_TYPE, null);
            return false;
        }
        String buttonType = (String)prop;
        boolean iconFont = true;
        AquaButtonExtendedTypes.TypeSpecifier specifier = AquaButtonExtendedTypes.getSpecifierByName(buttonType);
        if (specifier != null) {
            b.setBorder(specifier.getBorder());
            iconFont = specifier.setIconFont;
        }
        if ((currentFont = b.getFont()) == null || currentFont instanceof UIResource) {
            b.setFont(UIManager.getFont(iconFont ? "IconButton.font" : "Button.font"));
        }
        return true;
    }

    @Override
    protected void installListeners(AbstractButton b) {
        AquaButtonListener listener = this.createButtonListener(b);
        if (listener != null) {
            b.putClientProperty(this, listener);
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
            b.addAncestorListener(listener);
        }
        this.installHierListener(b);
        AquaUtilControlSize.addSizePropertyListener(b);
    }

    @Override
    protected void installKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.installKeyboardActions(b);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallKeyboardActions((AbstractButton)c);
        this.uninstallListeners((AbstractButton)c);
        this.uninstallDefaults((AbstractButton)c);
    }

    @Override
    protected void uninstallKeyboardActions(AbstractButton b) {
        BasicButtonListener listener = (BasicButtonListener)b.getClientProperty(this);
        if (listener != null) {
            listener.uninstallKeyboardActions(b);
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        AquaButtonListener listener = (AquaButtonListener)b.getClientProperty(this);
        b.putClientProperty(this, null);
        if (listener != null) {
            b.removeMouseListener(listener);
            b.removeMouseListener(listener);
            b.removeMouseMotionListener(listener);
            b.removeFocusListener(listener);
            b.removeChangeListener(listener);
            b.removePropertyChangeListener(listener);
            b.removeAncestorListener(listener);
        }
        this.uninstallHierListener(b);
        AquaUtilControlSize.addSizePropertyListener(b);
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        LookAndFeel.uninstallBorder(b);
        this.defaults_initialized = false;
    }

    @Override
    protected AquaButtonListener createButtonListener(AbstractButton b) {
        return new AquaButtonListener(b);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(b.getWidth(), b.getHeight());
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        if (b.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
        }
        AquaButtonBorder aquaBorder = null;
        if (((AbstractButton)c).isBorderPainted()) {
            Border border = c.getBorder();
            if (border instanceof AquaButtonBorder) {
                aquaBorder = (AquaButtonBorder)border;
                aquaBorder.paintButton(c, g, viewRect.x, viewRect.y, viewRect.width, viewRect.height);
            }
        } else {
            if (b.isOpaque()) {
                viewRect.x = i.left - 2;
                viewRect.y = i.top - 2;
                viewRect.width = b.getWidth() - (i.right + viewRect.x) + 4;
                viewRect.height = b.getHeight() - (i.bottom + viewRect.y) + 4;
                if (b.isContentAreaFilled() || model.isSelected()) {
                    if (model.isSelected()) {
                        g.setColor(c.getBackground().darker());
                    } else {
                        g.setColor(c.getBackground());
                    }
                    g.fillRect(viewRect.x, viewRect.y, viewRect.width, viewRect.height);
                }
            }
            if (b.isFocusPainted() && b.hasFocus()) {
                this.paintFocus(g, b, viewRect, textRect, iconRect);
            }
        }
        String text = this.layoutAndGetText(g, b, aquaBorder, i, viewRect, iconRect, textRect);
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (textRect.width == 0) {
            textRect.width = 50;
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
    }

    protected String layoutAndGetText(Graphics g, AbstractButton b, AquaButtonBorder aquaBorder, Insets i, Rectangle viewRect, Rectangle iconRect, Rectangle textRect) {
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        g.setFont(b.getFont());
        FontMetrics fm = g.getFontMetrics();
        String originalText = b.getText();
        String text = SwingUtilities.layoutCompoundLabel(b, fm, originalText, b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, originalText == null ? 0 : b.getIconTextGap());
        if (text == originalText || aquaBorder == null) {
            return text;
        }
        Insets alternateContentInsets = aquaBorder.getContentInsets(b, b.getWidth(), b.getHeight());
        if (alternateContentInsets != null) {
            return this.layoutAndGetText(g, b, null, alternateContentInsets, viewRect, iconRect, textRect);
        }
        return text;
    }

    protected void paintIcon(Graphics g, AbstractButton b, Rectangle localIconRect) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        Icon tmpIcon = null;
        if (icon == null) {
            return;
        }
        if (!model.isEnabled()) {
            tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            tmpIcon = b.getPressedIcon();
            if (tmpIcon == null && icon instanceof ImageIcon) {
                tmpIcon = new ImageIcon(AquaUtils.generateSelectedDarkImage(((ImageIcon)icon).getImage()));
            }
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            tmpIcon = model.isSelected() ? b.getRolloverSelectedIcon() : b.getRolloverIcon();
        } else if (model.isSelected()) {
            tmpIcon = b.getSelectedIcon();
        }
        if (model.isEnabled() && b.isFocusOwner() && b.getBorder() instanceof AquaButtonBorder.Toolbar) {
            if (tmpIcon == null) {
                tmpIcon = icon;
            }
            if (tmpIcon instanceof ImageIcon) {
                tmpIcon = AquaFocus.createFocusedIcon(tmpIcon, b, 3);
                tmpIcon.paintIcon(b, g, localIconRect.x - 3, localIconRect.y - 3);
                return;
            }
        }
        if (tmpIcon != null) {
            icon = tmpIcon;
        }
        icon.paintIcon(b, g, localIconRect.x, localIconRect.y);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle localTextRect, String text) {
        int mnemonicIndex;
        Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int n = mnemonicIndex = AquaMnemonicHandler.isMnemonicHidden() ? -1 : b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            g.setColor(this.defaultDisabledTextColor);
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, localTextRect.x, localTextRect.y + fm.getAscent());
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle localTextRect, String text) {
        this.paintText(g, (JComponent)b, localTextRect, text);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.paint(g, b);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractButton b = (AbstractButton)c;
        Dimension d = BasicGraphicsUtils.getPreferredButtonSize(b, b.getIconTextGap());
        if (d == null) {
            return null;
        }
        Border border = b.getBorder();
        if (border instanceof AquaButtonBorder) {
            ((AquaButtonBorder)border).alterPreferredSize(d);
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    static AquaHierarchyButtonListener getAquaHierarchyButtonListener() {
        return fHierListener.get();
    }

    private boolean shouldInstallHierListener(AbstractButton b) {
        return b instanceof JButton || b instanceof JToggleButton && !(b instanceof AquaComboBoxButton) && !(b instanceof JCheckBox) && !(b instanceof JRadioButton);
    }

    protected void installHierListener(AbstractButton b) {
        if (this.shouldInstallHierListener(b)) {
            b.addHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    protected void uninstallHierListener(AbstractButton b) {
        if (this.shouldInstallHierListener(b)) {
            b.removeHierarchyListener(AquaButtonUI.getAquaHierarchyButtonListener());
        }
    }

    class AquaButtonListener
    extends BasicButtonListener
    implements AncestorListener {
        protected final AbstractButton b;

        public AquaButtonListener(AbstractButton b) {
            super(b);
            this.b = b;
        }

        @Override
        public void focusGained(FocusEvent e) {
            ((Component)e.getSource()).repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ((Component)e.getSource()).repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Border border;
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if ("Frame.active".equals(propertyName)) {
                this.b.repaint();
                return;
            }
            if ("icon".equals(propertyName) || "text".equals(propertyName)) {
                AquaButtonUI.this.setThemeBorder(this.b);
                return;
            }
            if (AquaButtonUI.BUTTON_TYPE.equals(propertyName)) {
                String value = (String)e.getNewValue();
                Border border2 = AquaButtonExtendedTypes.getBorderForPosition(this.b, value, this.b.getClientProperty(AquaButtonUI.SEGMENTED_BUTTON_POSITION));
                if (border2 != null) {
                    this.b.setBorder(border2);
                }
                return;
            }
            if (AquaButtonUI.SEGMENTED_BUTTON_POSITION.equals(propertyName)) {
                border = this.b.getBorder();
                if (!(border instanceof AquaBorder)) {
                    return;
                }
                this.b.setBorder(AquaButtonExtendedTypes.getBorderForPosition(this.b, this.b.getClientProperty(AquaButtonUI.BUTTON_TYPE), e.getNewValue()));
            }
            if ("componentOrientation".equals(propertyName)) {
                border = this.b.getBorder();
                if (!(border instanceof AquaBorder)) {
                    return;
                }
                Object buttonType = this.b.getClientProperty(AquaButtonUI.BUTTON_TYPE);
                Object buttonPosition = this.b.getClientProperty(AquaButtonUI.SEGMENTED_BUTTON_POSITION);
                if (buttonType != null && buttonPosition != null) {
                    this.b.setBorder(AquaButtonExtendedTypes.getBorderForPosition(this.b, buttonType, buttonPosition));
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            this.updateDefaultButton();
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
            this.updateDefaultButton();
        }

        protected void updateDefaultButton() {
            if (!(this.b instanceof JButton)) {
                return;
            }
            if (!((JButton)this.b).isDefaultButton()) {
                return;
            }
            JRootPane rootPane = this.b.getRootPane();
            if (rootPane == null) {
                return;
            }
            RootPaneUI ui = rootPane.getUI();
            if (!(ui instanceof AquaRootPaneUI)) {
                return;
            }
            ((AquaRootPaneUI)ui).updateDefaultButton(rootPane);
        }
    }

    static class AquaHierarchyButtonListener
    implements HierarchyListener {
        AquaHierarchyButtonListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) == 0L) {
                return;
            }
            Object o = e.getSource();
            if (!(o instanceof AbstractButton)) {
                return;
            }
            AbstractButton b = (AbstractButton)o;
            ButtonUI ui = b.getUI();
            if (!(ui instanceof AquaButtonUI)) {
                return;
            }
            if (!(b.getBorder() instanceof UIResource)) {
                return;
            }
            ((AquaButtonUI)ui).setThemeBorder(b);
        }
    }
}

