/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import sun.swing.SwingUtilities2;

class AquaComboBoxRendererInternal<E>
extends JLabel
implements ListCellRenderer<E> {
    final JComboBox<?> fComboBox;
    boolean fSelected;
    boolean fChecked;
    boolean fInList;
    boolean fEditable;
    boolean fDrawCheckedItem = true;

    public AquaComboBoxRendererInternal(JComboBox<?> comboBox) {
        this.fComboBox = comboBox;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size;
        String text = this.getText();
        if (text == null || "".equals(text)) {
            this.setText(" ");
            size = super.getPreferredSize();
            this.setText("");
        } else {
            size = super.getPreferredSize();
        }
        return size;
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    @Override
    public int getBaseline(int width, int height) {
        return super.getBaseline(width, height) - 1;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
        this.fInList = index >= 0;
        this.fSelected = isSelected;
        if (index < 0) {
            index = this.fComboBox.getSelectedIndex();
        }
        if (index >= 0) {
            Object item = this.fComboBox.getItemAt(index);
            this.fChecked = this.fInList && item != null && item.equals(this.fComboBox.getSelectedItem());
        } else {
            this.fChecked = false;
        }
        this.fEditable = this.fComboBox.isEditable();
        if (isSelected) {
            if (this.fEditable) {
                this.setBackground(UIManager.getColor("List.selectionBackground"));
                this.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            }
        } else if (this.fEditable) {
            this.setBackground(UIManager.getColor("List.background"));
            this.setForeground(UIManager.getColor("List.foreground"));
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else {
            this.setText(value == null ? " " : value.toString());
        }
        return this;
    }

    @Override
    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.bottom = 1;
        insets.right = 5;
        insets.left = this.fInList && !this.fEditable ? 23 : 5;
        return insets;
    }

    protected void setDrawCheckedItem(boolean drawCheckedItem) {
        this.fDrawCheckedItem = drawCheckedItem;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.fInList) {
            if (this.fSelected && !this.fEditable) {
                AquaMenuPainter.instance().paintSelectedMenuItemBackground(g, this.getWidth(), this.getHeight());
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.fChecked && !this.fEditable && this.fDrawCheckedItem) {
                int y = this.getHeight() - 4;
                g.setColor(this.getForeground());
                SwingUtilities2.drawString(this.fComboBox, g, "\u2713", 6, y);
            }
        }
        super.paintComponent(g);
    }
}

