/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import sun.lwawt.macosx.CImage;

public class AquaIcon {
    static UIResource getIconFor(final JRSUIControlSpec spec, int width, int height) {
        return new ScalingJRSUIIcon(width, height){

            @Override
            public void initIconPainter(AquaPainter<JRSUIState> painter) {
                spec.initIconPainter(painter);
            }
        };
    }

    public static Image getImageForIcon(Icon i) {
        if (i instanceof ImageIcon) {
            return ((ImageIcon)i).getImage();
        }
        int w = i.getIconWidth();
        int h = i.getIconHeight();
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, 3);
        Graphics g = image.getGraphics();
        i.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    static class SystemIcon
    extends CachingScalingIcon {
        private static final SystemIconUIResourceSingleton folderIcon = new SystemIconUIResourceSingleton("fldr");
        private static final SystemIconUIResourceSingleton openFolderIcon = new SystemIconUIResourceSingleton("ofld");
        private static final SystemIconUIResourceSingleton desktopIcon = new SystemIconUIResourceSingleton("desk");
        private static final SystemIconUIResourceSingleton computerIcon = new SystemIconUIResourceSingleton("FNDR");
        private static final SystemIconUIResourceSingleton documentIcon = new SystemIconUIResourceSingleton("docu");
        private static final SystemIconUIResourceSingleton hardDriveIcon = new SystemIconUIResourceSingleton("hdsk");
        private static final SystemIconUIResourceSingleton floppyIcon = new SystemIconUIResourceSingleton("flpy");
        private static final SystemIconSingleton caut = new SystemIconSingleton("caut");
        private static final SystemIconSingleton stop = new SystemIconSingleton("stop");
        final String selector;

        static IconUIResource getFolderIconUIResource() {
            return (IconUIResource)folderIcon.get();
        }

        static IconUIResource getOpenFolderIconUIResource() {
            return (IconUIResource)openFolderIcon.get();
        }

        static IconUIResource getDesktopIconUIResource() {
            return (IconUIResource)desktopIcon.get();
        }

        static IconUIResource getComputerIconUIResource() {
            return (IconUIResource)computerIcon.get();
        }

        static IconUIResource getDocumentIconUIResource() {
            return (IconUIResource)documentIcon.get();
        }

        static IconUIResource getHardDriveIconUIResource() {
            return (IconUIResource)hardDriveIcon.get();
        }

        static IconUIResource getFloppyIconUIResource() {
            return (IconUIResource)floppyIcon.get();
        }

        static SystemIcon getCautionIcon() {
            return (SystemIcon)caut.get();
        }

        static SystemIcon getStopIcon() {
            return (SystemIcon)stop.get();
        }

        public SystemIcon(String iconSelector, int width, int height) {
            super(width, height);
            this.selector = iconSelector;
        }

        public SystemIcon(String iconSelector) {
            this(iconSelector, 16, 16);
        }

        @Override
        Image createImage() {
            return CImage.createSystemImageFromSelector((String)this.selector, (int)this.getIconWidth(), (int)this.getIconHeight());
        }
    }

    static class SystemIconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final String selector;

        public SystemIconUIResourceSingleton(String selector) {
            this.selector = selector;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new SystemIcon(this.selector));
        }
    }

    static class SystemIconSingleton
    extends AquaUtils.RecyclableSingleton<SystemIcon> {
        final String selector;

        public SystemIconSingleton(String selector) {
            this.selector = selector;
        }

        @Override
        protected SystemIcon getInstance() {
            return new SystemIcon(this.selector);
        }
    }

    static class FileIcon
    extends CachingScalingIcon {
        final File file;

        public FileIcon(File file, int width, int height) {
            super(width, height);
            this.file = file;
        }

        public FileIcon(File file) {
            this(file, 16, 16);
        }

        @Override
        Image createImage() {
            return CImage.createImageOfFile((String)this.file.getAbsolutePath(), (int)this.getIconWidth(), (int)this.getIconHeight());
        }
    }

    static abstract class ScalingJRSUIIcon
    implements Icon,
    UIResource {
        final int width;
        final int height;

        public ScalingJRSUIIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if ((g = g.create()) instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
            this.initIconPainter(painter);
            g.clipRect(x, y, this.width, this.height);
            painter.paint(g, c, x, y, this.width, this.height);
            g.dispose();
        }

        public abstract void initIconPainter(AquaPainter<JRSUIState> var1);

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    static abstract class CachingScalingIcon
    implements Icon,
    UIResource {
        int width;
        int height;
        Image image;

        public CachingScalingIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        void setSize(int width, int height) {
            this.width = width;
            this.height = height;
            this.image = null;
        }

        Image getImage() {
            if (this.image != null) {
                return this.image;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.image = this.createImage();
            }
            return this.image;
        }

        abstract Image createImage();

        public boolean hasIconRef() {
            return this.getImage() != null;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Image myImage;
            if ((g = g.create()) instanceof Graphics2D) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            if ((myImage = this.getImage()) != null) {
                g.drawImage(myImage, x, y, this.getIconWidth(), this.getIconHeight(), null);
            }
            g.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }

    static abstract class DynamicallySizingJRSUIIcon
    extends JRSUIIcon {
        protected final AquaUtilControlSize.SizeDescriptor sizeDescriptor;
        protected AquaUtilControlSize.SizeVariant sizeVariant;

        public DynamicallySizingJRSUIIcon(AquaUtilControlSize.SizeDescriptor sizeDescriptor) {
            this.sizeDescriptor = sizeDescriptor;
            this.sizeVariant = sizeDescriptor.regular;
            this.initJRSUIState();
        }

        public abstract void initJRSUIState();

        @Override
        public int getIconHeight() {
            return this.sizeVariant == null ? 0 : this.sizeVariant.h;
        }

        @Override
        public int getIconWidth() {
            return this.sizeVariant == null ? 0 : this.sizeVariant.w;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JRSUIConstants.Size size = c instanceof JComponent ? AquaUtilControlSize.getUserSizeFrom((JComponent)c) : JRSUIConstants.Size.REGULAR;
            this.sizeVariant = this.sizeDescriptor.get(size);
            ((JRSUIState)this.painter.state).set(size);
            super.paintIcon(c, g, x, y);
        }
    }

    static abstract class JRSUIIcon
    implements Icon,
    UIResource {
        protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());

        JRSUIIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.painter.paint(g, c, x, y, this.getIconWidth(), this.getIconHeight());
        }
    }

    public static interface JRSUIControlSpec {
        public void initIconPainter(AquaPainter<? extends JRSUIState> var1);
    }

    static interface InvertableIcon
    extends Icon {
        public Icon getInvertedIcon();
    }
}

