/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.eawt.Application;
import com.apple.eio.FileManager;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;
import sun.awt.image.MultiResolutionCachedImage;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.LWCToolkit;

public class AquaImageFactory {
    private static final int kAlertIconSize = 64;
    private static final NamedImageSingleton northArrow = new NamedImageSingleton("NSMenuScrollUp");
    private static final IconUIResourceSingleton northArrowIcon = new IconUIResourceSingleton(northArrow);
    private static final NamedImageSingleton southArrow = new NamedImageSingleton("NSMenuScrollDown");
    private static final IconUIResourceSingleton southArrowIcon = new IconUIResourceSingleton(southArrow);
    private static final NamedImageSingleton westArrow = new NamedImageSingleton("NSMenuSubmenuLeft");
    private static final IconUIResourceSingleton westArrowIcon = new IconUIResourceSingleton(westArrow);
    private static final NamedImageSingleton eastArrow = new NamedImageSingleton("NSMenuSubmenu");
    private static final IconUIResourceSingleton eastArrowIcon = new IconUIResourceSingleton(eastArrow);

    public static IconUIResource getConfirmImageIcon() {
        return new IconUIResource(new AquaIcon.CachingScalingIcon(64, 64){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        });
    }

    public static IconUIResource getCautionImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getCautionIcon());
    }

    public static IconUIResource getStopImageIcon() {
        return AquaImageFactory.getAppIconCompositedOn(AquaIcon.SystemIcon.getStopIcon());
    }

    public static IconUIResource getLockImageIcon() {
        if (JRSUIUtils.Images.shouldUseLegacySecurityUIPath()) {
            Image lockIcon = CImage.createImageFromFile((String)"/System/Library/CoreServices/SecurityAgent.app/Contents/Resources/Security.icns", (double)64.0, (double)64.0);
            return AquaImageFactory.getAppIconCompositedOn(lockIcon);
        }
        Image lockIcon = Toolkit.getDefaultToolkit().getImage("NSImage://NSSecurity");
        return AquaImageFactory.getAppIconCompositedOn(lockIcon);
    }

    static Image getGenericJavaIcon() {
        return AccessController.doPrivileged(new PrivilegedAction<Image>(){

            @Override
            public Image run() {
                return Application.getApplication().getDockIconImage();
            }
        });
    }

    static String getPathToThisApplication() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return FileManager.getPathToApplicationBundle();
            }
        });
    }

    static IconUIResource getAppIconCompositedOn(AquaIcon.SystemIcon systemIcon) {
        systemIcon.setSize(64, 64);
        return AquaImageFactory.getAppIconCompositedOn(systemIcon.createImage());
    }

    static IconUIResource getAppIconCompositedOn(Image background) {
        if (background instanceof MultiResolutionCachedImage) {
            int width = background.getWidth(null);
            MultiResolutionCachedImage mrIconImage = ((MultiResolutionCachedImage)background).map(rv -> AquaImageFactory.getAppIconImageCompositedOn(rv, rv.getWidth(null) / width));
            return new IconUIResource(new ImageIcon(mrIconImage));
        }
        BufferedImage iconImage = AquaImageFactory.getAppIconImageCompositedOn(background, 1);
        return new IconUIResource(new ImageIcon(iconImage));
    }

    static BufferedImage getAppIconImageCompositedOn(Image background, int scaleFactor) {
        int scaledAlertIconSize = 64 * scaleFactor;
        int kAlertSubIconSize = (int)((double)scaledAlertIconSize * 0.5);
        int kAlertSubIconInset = scaledAlertIconSize - kAlertSubIconSize;
        AquaIcon.CachingScalingIcon smallAppIconScaled = new AquaIcon.CachingScalingIcon(kAlertSubIconSize, kAlertSubIconSize){

            @Override
            Image createImage() {
                return AquaImageFactory.getGenericJavaIcon();
            }
        };
        BufferedImage image = new BufferedImage(scaledAlertIconSize, scaledAlertIconSize, 3);
        Graphics g = image.getGraphics();
        g.drawImage(background, 0, 0, scaledAlertIconSize, scaledAlertIconSize, null);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        smallAppIconScaled.paintIcon(null, g, kAlertSubIconInset, kAlertSubIconInset);
        g.dispose();
        return image;
    }

    public static IconUIResource getTreeFolderIcon() {
        return AquaIcon.SystemIcon.getFolderIconUIResource();
    }

    public static IconUIResource getTreeOpenFolderIcon() {
        return AquaIcon.SystemIcon.getOpenFolderIconUIResource();
    }

    public static IconUIResource getTreeDocumentIcon() {
        return AquaIcon.SystemIcon.getDocumentIconUIResource();
    }

    public static UIResource getTreeExpandedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> painter) {
                ((JRSUIState)painter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)painter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)painter.state).set(JRSUIConstants.Direction.DOWN);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> painter) {
                ((JRSUIState)painter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)painter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)painter.state).set(JRSUIConstants.Direction.RIGHT);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    public static UIResource getTreeRightToLeftCollapsedIcon() {
        return AquaIcon.getIconFor(new AquaIcon.JRSUIControlSpec(){

            @Override
            public void initIconPainter(AquaPainter<? extends JRSUIState> painter) {
                ((JRSUIState)painter.state).set(JRSUIConstants.Widget.DISCLOSURE_TRIANGLE);
                ((JRSUIState)painter.state).set(JRSUIConstants.State.ACTIVE);
                ((JRSUIState)painter.state).set(JRSUIConstants.Direction.LEFT);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentHorizontal.CENTER);
                ((JRSUIState)painter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
            }
        }, 20, 20);
    }

    static Image getArrowImageForDirection(int direction) {
        switch (direction) {
            case 1: {
                return (Image)northArrow.get();
            }
            case 5: {
                return (Image)southArrow.get();
            }
            case 3: {
                return (Image)eastArrow.get();
            }
            case 7: {
                return (Image)westArrow.get();
            }
        }
        return null;
    }

    static Icon getArrowIconForDirection(int direction) {
        switch (direction) {
            case 1: {
                return (Icon)northArrowIcon.get();
            }
            case 5: {
                return (Icon)southArrowIcon.get();
            }
            case 3: {
                return (Icon)eastArrowIcon.get();
            }
            case 7: {
                return (Icon)westArrowIcon.get();
            }
        }
        return null;
    }

    public static Icon getMenuArrowIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage((Image)eastArrow.get(), 25));
    }

    public static Icon getMenuItemCheckIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuItemSelection"), 25));
    }

    public static Icon getMenuItemDashIcon() {
        return new InvertableImageIcon(AquaUtils.generateLightenedImage(AquaImageFactory.getNSIcon("NSMenuMixedState"), 25));
    }

    private static Image getNSIcon(String imageName) {
        Image icon = Toolkit.getDefaultToolkit().getImage("NSImage://" + imageName);
        return icon;
    }

    public static Color getWindowBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.window);
    }

    public static Color getTextSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlight);
    }

    public static Color getTextSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.textHighlightText);
    }

    public static Color getSelectionBackgroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlHighlight);
    }

    public static Color getSelectionForegroundColorUIResource() {
        return new SystemColorProxy(SystemColor.controlLtHighlight);
    }

    public static Color getFocusRingColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor((int)0));
    }

    public static Color getSelectionInactiveBackgroundColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor((int)1));
    }

    public static Color getSelectionInactiveForegroundColorUIResource() {
        return new SystemColorProxy(LWCToolkit.getAppleColor((int)2));
    }

    private static class SystemColorProxy
    extends Color
    implements UIResource {
        final Color color;

        public SystemColorProxy(Color color) {
            super(color.getRGB());
            this.color = color;
        }

        @Override
        public int getRGB() {
            return this.color.getRGB();
        }
    }

    public static abstract class RecyclableSlicedImageControl
    extends AquaUtils.RecyclableObject<SlicedImageControl> {
        final NineSliceMetrics metrics;

        public RecyclableSlicedImageControl(NineSliceMetrics metrics) {
            this.metrics = metrics;
        }

        @Override
        protected SlicedImageControl create() {
            return new SlicedImageControl(this.createTemplateImage(this.metrics.minW, this.metrics.minH), this.metrics);
        }

        protected abstract Image createTemplateImage(int var1, int var2);
    }

    public static class SlicedImageControl {
        final BufferedImage NW;
        final BufferedImage N;
        final BufferedImage NE;
        final BufferedImage W;
        final BufferedImage C;
        final BufferedImage E;
        final BufferedImage SW;
        final BufferedImage S;
        final BufferedImage SE;
        final NineSliceMetrics metrics;
        final int totalWidth;
        final int totalHeight;
        final int centerColWidth;
        final int centerRowHeight;

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut) {
            this(img, westCut, eastCut, northCut, southCut, true);
        }

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut, boolean useMiddle) {
            this(img, westCut, eastCut, northCut, southCut, useMiddle, true, true);
        }

        public SlicedImageControl(Image img, int westCut, int eastCut, int northCut, int southCut, boolean useMiddle, boolean stretchHorizontally, boolean stretchVertically) {
            this(img, new NineSliceMetrics(img.getWidth(null), img.getHeight(null), westCut, eastCut, northCut, southCut, useMiddle, stretchHorizontally, stretchVertically));
        }

        public SlicedImageControl(Image img, NineSliceMetrics metrics) {
            this.metrics = metrics;
            if (img.getWidth(null) != metrics.minW || img.getHeight(null) != metrics.minH) {
                throw new IllegalArgumentException("SlicedImageControl: template image and NineSliceMetrics don't agree on minimum dimensions");
            }
            this.totalWidth = metrics.minW;
            this.totalHeight = metrics.minH;
            this.centerColWidth = this.totalWidth - metrics.wCut - metrics.eCut;
            this.centerRowHeight = this.totalHeight - metrics.nCut - metrics.sCut;
            this.NW = SlicedImageControl.createSlice(img, 0, 0, metrics.wCut, metrics.nCut);
            this.N = SlicedImageControl.createSlice(img, metrics.wCut, 0, this.centerColWidth, metrics.nCut);
            this.NE = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, 0, metrics.eCut, metrics.nCut);
            this.W = SlicedImageControl.createSlice(img, 0, metrics.nCut, metrics.wCut, this.centerRowHeight);
            this.C = metrics.showMiddle ? SlicedImageControl.createSlice(img, metrics.wCut, metrics.nCut, this.centerColWidth, this.centerRowHeight) : null;
            this.E = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, metrics.nCut, metrics.eCut, this.centerRowHeight);
            this.SW = SlicedImageControl.createSlice(img, 0, this.totalHeight - metrics.sCut, metrics.wCut, metrics.sCut);
            this.S = SlicedImageControl.createSlice(img, metrics.wCut, this.totalHeight - metrics.sCut, this.centerColWidth, metrics.sCut);
            this.SE = SlicedImageControl.createSlice(img, this.totalWidth - metrics.eCut, this.totalHeight - metrics.sCut, metrics.eCut, metrics.sCut);
        }

        static BufferedImage createSlice(Image img, int x, int y, int w, int h) {
            if (w == 0 || h == 0) {
                return null;
            }
            BufferedImage slice = new BufferedImage(w, h, 3);
            Graphics2D g2d = slice.createGraphics();
            g2d.drawImage(img, 0, 0, w, h, x, y, x + w, y + h, null);
            g2d.dispose();
            return slice;
        }

        public void paint(Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            if (w < this.totalWidth || h < this.totalHeight) {
                this.paintCompressed(g, w, h);
            } else {
                this.paintStretchedMiddles(g, w, h);
            }
            g.translate(-x, -y);
        }

        void paintStretchedMiddles(Graphics g, int w, int h) {
            int adjustedHeight;
            int baseX = this.metrics.stretchH ? 0 : w / 2 - this.totalWidth / 2;
            int baseY = this.metrics.stretchV ? 0 : h / 2 - this.totalHeight / 2;
            int adjustedWidth = this.metrics.stretchH ? w : this.totalWidth;
            int n = adjustedHeight = this.metrics.stretchV ? h : this.totalHeight;
            if (this.NW != null) {
                g.drawImage(this.NW, baseX, baseY, null);
            }
            if (this.N != null) {
                g.drawImage(this.N, baseX + this.metrics.wCut, baseY, adjustedWidth - this.metrics.eCut - this.metrics.wCut, this.metrics.nCut, null);
            }
            if (this.NE != null) {
                g.drawImage(this.NE, baseX + adjustedWidth - this.metrics.eCut, baseY, null);
            }
            if (this.W != null) {
                g.drawImage(this.W, baseX, baseY + this.metrics.nCut, this.metrics.wCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.C != null) {
                g.drawImage(this.C, baseX + this.metrics.wCut, baseY + this.metrics.nCut, adjustedWidth - this.metrics.eCut - this.metrics.wCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.E != null) {
                g.drawImage(this.E, baseX + adjustedWidth - this.metrics.eCut, baseY + this.metrics.nCut, this.metrics.eCut, adjustedHeight - this.metrics.nCut - this.metrics.sCut, null);
            }
            if (this.SW != null) {
                g.drawImage(this.SW, baseX, baseY + adjustedHeight - this.metrics.sCut, null);
            }
            if (this.S != null) {
                g.drawImage(this.S, baseX + this.metrics.wCut, baseY + adjustedHeight - this.metrics.sCut, adjustedWidth - this.metrics.eCut - this.metrics.wCut, this.metrics.sCut, null);
            }
            if (this.SE != null) {
                g.drawImage(this.SE, baseX + adjustedWidth - this.metrics.eCut, baseY + adjustedHeight - this.metrics.sCut, null);
            }
        }

        void paintCompressed(Graphics g, int w, int h) {
            double heightRatio = h > this.totalHeight ? 1.0 : (double)h / (double)this.totalHeight;
            double widthRatio = w > this.totalWidth ? 1.0 : (double)w / (double)this.totalWidth;
            int northHeight = (int)((double)this.metrics.nCut * heightRatio);
            int southHeight = (int)((double)this.metrics.sCut * heightRatio);
            int centerHeight = h - northHeight - southHeight;
            int westWidth = (int)((double)this.metrics.wCut * widthRatio);
            int eastWidth = (int)((double)this.metrics.eCut * widthRatio);
            int centerWidth = w - westWidth - eastWidth;
            if (this.NW != null) {
                g.drawImage(this.NW, 0, 0, westWidth, northHeight, null);
            }
            if (this.N != null) {
                g.drawImage(this.N, westWidth, 0, centerWidth, northHeight, null);
            }
            if (this.NE != null) {
                g.drawImage(this.NE, w - eastWidth, 0, eastWidth, northHeight, null);
            }
            if (this.W != null) {
                g.drawImage(this.W, 0, northHeight, westWidth, centerHeight, null);
            }
            if (this.C != null) {
                g.drawImage(this.C, westWidth, northHeight, centerWidth, centerHeight, null);
            }
            if (this.E != null) {
                g.drawImage(this.E, w - eastWidth, northHeight, eastWidth, centerHeight, null);
            }
            if (this.SW != null) {
                g.drawImage(this.SW, 0, h - southHeight, westWidth, southHeight, null);
            }
            if (this.S != null) {
                g.drawImage(this.S, westWidth, h - southHeight, centerWidth, southHeight, null);
            }
            if (this.SE != null) {
                g.drawImage(this.SE, w - eastWidth, h - southHeight, eastWidth, southHeight, null);
            }
        }
    }

    public static class NineSliceMetrics {
        public final int wCut;
        public final int eCut;
        public final int nCut;
        public final int sCut;
        public final int minW;
        public final int minH;
        public final boolean showMiddle;
        public final boolean stretchH;
        public final boolean stretchV;

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut) {
            this(minWidth, minHeight, westCut, eastCut, northCut, southCut, true);
        }

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut, boolean showMiddle) {
            this(minWidth, minHeight, westCut, eastCut, northCut, southCut, showMiddle, true, true);
        }

        public NineSliceMetrics(int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut, boolean showMiddle, boolean stretchHorizontally, boolean stretchVertically) {
            this.wCut = westCut;
            this.eCut = eastCut;
            this.nCut = northCut;
            this.sCut = southCut;
            this.minW = minWidth;
            this.minH = minHeight;
            this.showMiddle = showMiddle;
            this.stretchH = stretchHorizontally;
            this.stretchV = stretchVertically;
        }
    }

    static class InvertableImageIcon
    extends ImageIcon
    implements AquaIcon.InvertableIcon,
    UIResource {
        Icon invertedImage;

        public InvertableImageIcon(Image image) {
            super(image);
        }

        @Override
        public Icon getInvertedIcon() {
            if (this.invertedImage != null) {
                return this.invertedImage;
            }
            this.invertedImage = new IconUIResource(new ImageIcon(AquaUtils.generateLightenedImage(this.getImage(), 100)));
            return this.invertedImage;
        }
    }

    static class IconUIResourceSingleton
    extends AquaUtils.RecyclableSingleton<IconUIResource> {
        final NamedImageSingleton holder;

        public IconUIResourceSingleton(NamedImageSingleton holder) {
            this.holder = holder;
        }

        @Override
        protected IconUIResource getInstance() {
            return new IconUIResource(new ImageIcon((Image)this.holder.get()));
        }
    }

    static class NamedImageSingleton
    extends AquaUtils.RecyclableSingleton<Image> {
        final String namedImage;

        NamedImageSingleton(String namedImage) {
            this.namedImage = namedImage;
        }

        @Override
        protected Image getInstance() {
            return AquaImageFactory.getNSIcon(this.namedImage);
        }
    }
}

