/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaInternalFrameBorderMetrics;
import com.apple.laf.AquaInternalFrameUI;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class AquaInternalFrameBorder
implements Border,
UIResource {
    private static final int kCloseButton = 0;
    private static final int kIconButton = 1;
    private static final int kGrowButton = 2;
    private static final int sMaxIconWidth = 15;
    private static final int sMaxIconHeight = 15;
    private static final int sAfterButtonPad = 11;
    private static final int sAfterIconPad = 5;
    private static final int sRightSideTitleClip = 0;
    private static final int kContentTester = 100;
    private static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> documentWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.DOCUMENT);
        }
    };
    private static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> utilityWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.UTILITY);
        }
    };
    private static final AquaUtils.RecyclableSingleton<AquaInternalFrameBorder> dialogWindowFrame = new AquaUtils.RecyclableSingleton<AquaInternalFrameBorder>(){

        @Override
        protected AquaInternalFrameBorder getInstance() {
            return new AquaInternalFrameBorder(JRSUIConstants.WindowType.DOCUMENT);
        }
    };
    private final AquaInternalFrameBorderMetrics metrics;
    private final int fThisButtonSpan;
    private final int fThisLeftSideTotal;
    private final boolean fIsUtility;
    private final JRSUIConstants.WindowType fWindowKind;
    private Insets fBorderInsets;
    private Color selectedTextColor;
    private Color notSelectedTextColor;
    private Rectangle fInBounds;
    protected final AquaPainter<JRSUIState.TitleBarHeightState> titleBarPainter = AquaPainter.create(JRSUIStateFactory.getTitleBar());
    protected final AquaPainter<JRSUIState> widgetPainter = AquaPainter.create(JRSUIState.getInstance());

    protected static AquaInternalFrameBorder window() {
        return documentWindowFrame.get();
    }

    protected static AquaInternalFrameBorder utility() {
        return utilityWindowFrame.get();
    }

    protected static AquaInternalFrameBorder dialog() {
        return dialogWindowFrame.get();
    }

    protected AquaInternalFrameBorder(JRSUIConstants.WindowType kind) {
        this.fWindowKind = kind;
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowClipCorners.YES);
        if (this.fWindowKind == JRSUIConstants.WindowType.UTILITY) {
            this.fIsUtility = true;
            this.metrics = AquaInternalFrameBorderMetrics.getMetrics(true);
            ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.WindowType.UTILITY);
            ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowType.UTILITY);
        } else {
            this.fIsUtility = false;
            this.metrics = AquaInternalFrameBorderMetrics.getMetrics(false);
            ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.WindowType.DOCUMENT);
            ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowType.DOCUMENT);
        }
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).setValue(this.metrics.titleBarHeight);
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(JRSUIConstants.WindowTitleBarSeparator.YES);
        ((JRSUIState)this.widgetPainter.state).set(JRSUIConstants.AlignmentVertical.CENTER);
        this.fThisButtonSpan = this.metrics.buttonWidth * 3 + this.metrics.buttonPadding * 2;
        this.fThisLeftSideTotal = this.metrics.leftSidePadding + this.fThisButtonSpan + 11;
    }

    public void setColors(Color inSelectedTextColor, Color inNotSelectedTextColor) {
        this.selectedTextColor = inSelectedTextColor;
        this.notSelectedTextColor = inNotSelectedTextColor;
    }

    protected void setInBounds(int x, int y, int w, int h) {
        if (this.fInBounds == null) {
            this.fInBounds = new Rectangle();
        }
        this.fInBounds.x = x;
        this.fInBounds.y = y;
        this.fInBounds.width = w;
        this.fInBounds.height = h;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.paintBorder((JInternalFrame)c, c, g, x, y, w, h);
    }

    protected void paintTitleContents(Graphics g, JInternalFrame frame, int x, int y, int w, int h) {
        boolean isSelected = frame.isSelected();
        Font f = g.getFont();
        g.setFont(this.metrics.font);
        FontMetrics fm = g.getFontMetrics();
        int baseline = (this.metrics.titleBarHeight + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
        int usedWidth = this.fThisLeftSideTotal + 0;
        int iconWidth = this.getIconWidth(frame);
        if (iconWidth > 0) {
            iconWidth += 5;
        }
        int totalWidth = w;
        int availTextWidth = totalWidth - usedWidth - iconWidth - 11;
        String title = frame.getTitle();
        Object text = title;
        int totalTextWidth = 0;
        int startXPosition = this.fThisLeftSideTotal;
        boolean wasTextShortened = false;
        if (text != null && !((String)text).equals("")) {
            totalTextWidth = SwingUtilities.computeStringWidth(fm, (String)text);
            String clipString = "\u2026";
            if (totalTextWidth > availTextWidth) {
                int nextCharWidth;
                int nChars;
                wasTextShortened = true;
                totalTextWidth = SwingUtilities.computeStringWidth(fm, "\u2026");
                for (nChars = 0; nChars < ((String)text).length() && totalTextWidth + (nextCharWidth = fm.charWidth(((String)text).charAt(nChars))) <= availTextWidth; ++nChars) {
                    totalTextWidth += nextCharWidth;
                }
                text = ((String)text).substring(0, nChars) + "\u2026";
            }
            if (!wasTextShortened && (startXPosition = (totalWidth - (totalTextWidth + iconWidth)) / 2) < this.fThisLeftSideTotal) {
                startXPosition = this.fThisLeftSideTotal;
            }
            if (isSelected || this.fIsUtility) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(Color.white);
            }
            SwingUtilities2.drawString((JComponent)frame, g, (String)text, x + startXPosition + iconWidth, y + baseline + 1);
            if (isSelected || this.fIsUtility) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            SwingUtilities2.drawString((JComponent)frame, g, (String)text, x + startXPosition + iconWidth, y + baseline);
            g.setFont(f);
        }
        int iconYPostion = (this.metrics.titleBarHeight - this.getIconHeight(frame)) / 2;
        this.paintTitleIcon(g, frame, x + startXPosition, y + iconYPostion);
    }

    public int getWhichButtonHit(JInternalFrame frame, int x, int y) {
        int buttonHit = -1;
        Insets i = frame.getInsets();
        int startX = i.left + this.metrics.leftSidePadding - 1;
        if (this.isInsideYButtonArea(i, y) && x >= startX) {
            if (x <= startX + this.metrics.buttonWidth) {
                if (frame.isClosable()) {
                    buttonHit = 0;
                }
            } else if (x >= (startX += this.metrics.buttonWidth + this.metrics.buttonPadding) && x <= startX + this.metrics.buttonWidth) {
                if (frame.isIconifiable()) {
                    buttonHit = 1;
                }
            } else if (x >= (startX += this.metrics.buttonWidth + this.metrics.buttonPadding) && x <= startX + this.metrics.buttonWidth && frame.isMaximizable()) {
                buttonHit = 2;
            }
        }
        return buttonHit;
    }

    public void doButtonAction(JInternalFrame frame, int whichButton) {
        switch (whichButton) {
            case 0: {
                frame.doDefaultCloseAction();
                break;
            }
            case 1: {
                if (!frame.isIconifiable()) break;
                if (!frame.isIcon()) {
                    try {
                        frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                try {
                    frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            case 2: {
                if (!frame.isMaximizable()) break;
                if (!frame.isMaximum()) {
                    try {
                        frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                try {
                    frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
                break;
            }
            default: {
                System.err.println("AquaInternalFrameBorder should never get here!!!!");
                Thread.dumpStack();
            }
        }
    }

    public boolean isInsideYButtonArea(Insets i, int y) {
        int startY = i.top - this.metrics.titleBarHeight / 2 - this.metrics.buttonHeight / 2 - 1;
        int endY = startY + this.metrics.buttonHeight;
        return y >= startY && y <= endY;
    }

    public boolean getWithinRolloverArea(Insets i, int x, int y) {
        int startX = i.left + this.metrics.leftSidePadding;
        int endX = startX + this.fThisButtonSpan;
        return this.isInsideYButtonArea(i, y) && x >= startX && x <= endX;
    }

    protected void paintTitleIcon(Graphics g, JInternalFrame frame, int x, int y) {
        Icon icon = frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon == null) {
            return;
        }
        if (icon.getIconWidth() > 15 || icon.getIconHeight() > 15) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform savedAT = g2.getTransform();
            double xScaleFactor = 15.0 / (double)icon.getIconWidth();
            double yScaleFactor = 15.0 / (double)icon.getIconHeight();
            g2.translate(x, y);
            double scaleMaintainAspectRatio = Math.min(xScaleFactor, yScaleFactor);
            g2.scale(scaleMaintainAspectRatio, scaleMaintainAspectRatio);
            icon.paintIcon(frame, g2, 0, 0);
            g2.setTransform(savedAT);
        } else {
            icon.paintIcon(frame, g, x, y);
        }
    }

    protected int getIconWidth(JInternalFrame frame) {
        int width = 0;
        Icon icon = frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            width = Math.min(icon.getIconWidth(), 15);
        }
        return width;
    }

    protected int getIconHeight(JInternalFrame frame) {
        int height = 0;
        Icon icon = frame.getFrameIcon();
        if (icon == null) {
            icon = UIManager.getIcon("InternalFrame.icon");
        }
        if (icon != null) {
            height = Math.min(icon.getIconHeight(), 15);
        }
        return height;
    }

    public void drawWindowTitle(Graphics g, JInternalFrame frame, int inX, int inY, int inW, int inH) {
        int x = inX;
        int y = inY;
        int w = inW;
        int h = inH;
        h = this.metrics.titleBarHeight + inH;
        ((JRSUIState.TitleBarHeightState)this.titleBarPainter.state).set(frame.isSelected() ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.INACTIVE);
        this.titleBarPainter.paint(g, frame, x, y, w, h);
        this.paintTitleContents(g, frame, x, y, w, h);
        this.drawAllWidgets(g, frame);
    }

    void paintBorder(JInternalFrame frame, Component c, Graphics g, int x, int y, int w, int h) {
        if (this.fBorderInsets == null) {
            this.getBorderInsets(c);
        }
        this.setInBounds(x + this.fBorderInsets.left, y + this.fBorderInsets.top, w - (this.fBorderInsets.right + this.fBorderInsets.left), h - (this.fBorderInsets.top + this.fBorderInsets.bottom));
        this.setMetrics(frame, c);
        this.drawWindowTitle(g, frame, x, y, w, h);
    }

    boolean isDirty(JInternalFrame frame) {
        Object dirty = frame.getClientProperty("windowModified");
        return dirty != null && dirty != Boolean.FALSE;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.fBorderInsets == null) {
            this.fBorderInsets = new Insets(0, 0, 0, 0);
        }
        if (!(c instanceof JInternalFrame)) {
            return this.fBorderInsets;
        }
        JInternalFrame frame = (JInternalFrame)c;
        this.setInBounds(0, 0, 100, 100);
        this.setMetrics(frame, c);
        this.fBorderInsets.left = 0;
        this.fBorderInsets.top = this.metrics.titleBarHeight;
        this.fBorderInsets.right = 0;
        this.fBorderInsets.bottom = 0;
        return this.fBorderInsets;
    }

    public void repaintButtonArea(JInternalFrame frame) {
        Insets i = frame.getInsets();
        int x = i.left + this.metrics.leftSidePadding;
        int y = i.top - this.metrics.titleBarHeight + 1;
        frame.repaint(x, y, this.fThisButtonSpan, this.metrics.titleBarHeight - 2);
    }

    void drawAllWidgets(Graphics g, JInternalFrame frame) {
        int x = this.metrics.leftSidePadding;
        int y = (this.metrics.titleBarHeight - this.metrics.buttonHeight) / 2 - this.metrics.titleBarHeight;
        Insets insets = frame.getInsets();
        x += insets.left;
        y += insets.top + this.metrics.downShift;
        AquaInternalFrameUI ui = (AquaInternalFrameUI)frame.getUI();
        int buttonPressedIndex = ui.getWhichButtonPressed();
        boolean overButton = ui.getMouseOverPressedButton();
        boolean rollover = ui.getRollover();
        boolean frameSelected = frame.isSelected() || this.fIsUtility;
        boolean generalActive = rollover || frameSelected;
        boolean dirty = this.isDirty(frame);
        this.paintButton(g, frame, x, y, 0, buttonPressedIndex, overButton, frame.isClosable(), generalActive, rollover, dirty);
        this.paintButton(g, frame, x += this.metrics.buttonPadding + this.metrics.buttonWidth, y, 1, buttonPressedIndex, overButton, frame.isIconifiable(), generalActive, rollover, false);
        this.paintButton(g, frame, x += this.metrics.buttonPadding + this.metrics.buttonWidth, y, 2, buttonPressedIndex, overButton, frame.isMaximizable(), generalActive, rollover, false);
    }

    public void paintButton(Graphics g, JInternalFrame frame, int x, int y, int buttonType, int buttonPressedIndex, boolean overButton, boolean enabled, boolean active, boolean anyRollover, boolean dirty) {
        ((JRSUIState)this.widgetPainter.state).set(AquaInternalFrameBorder.getWidget(frame, buttonType));
        ((JRSUIState)this.widgetPainter.state).set(AquaInternalFrameBorder.getState(buttonPressedIndex == buttonType && overButton, anyRollover, active, enabled));
        ((JRSUIState)this.widgetPainter.state).set(dirty ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        this.widgetPainter.paint(g, frame, x, y, this.metrics.buttonWidth, this.metrics.buttonHeight);
    }

    static JRSUIConstants.Widget getWidget(JInternalFrame frame, int buttonType) {
        switch (buttonType) {
            case 1: {
                return JRSUIConstants.Widget.TITLE_BAR_COLLAPSE_BOX;
            }
            case 2: {
                return JRSUIConstants.Widget.TITLE_BAR_ZOOM_BOX;
            }
        }
        return JRSUIConstants.Widget.TITLE_BAR_CLOSE_BOX;
    }

    static JRSUIConstants.State getState(boolean pressed, boolean rollover, boolean active, boolean enabled) {
        if (!enabled) {
            return JRSUIConstants.State.DISABLED;
        }
        if (!active) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (pressed) {
            return JRSUIConstants.State.PRESSED;
        }
        if (rollover) {
            return JRSUIConstants.State.ROLLOVER;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected void setMetrics(JInternalFrame frame, Component window) {
        Icon icon;
        String title = frame.getTitle();
        FontMetrics fm = frame.getFontMetrics(UIManager.getFont("InternalFrame.titleFont"));
        int titleWidth = 0;
        int titleHeight = fm.getAscent();
        if (title != null) {
            titleWidth = SwingUtilities.computeStringWidth(fm, title);
        }
        if ((icon = frame.getFrameIcon()) != null) {
            titleWidth += icon.getIconWidth();
            titleHeight = Math.max(titleHeight, icon.getIconHeight());
        }
    }

    protected int getTitleHeight() {
        return this.metrics.titleBarHeight;
    }
}

