/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaMenuPainter;
import com.apple.laf.ScreenMenuBar;
import com.apple.laf.ScreenMenuBarProvider;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MenuBar;
import java.security.AccessController;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import sun.lwawt.macosx.LWCToolkit;
import sun.security.action.GetBooleanAction;

public class AquaMenuBarUI
extends BasicMenuBarUI
implements ScreenMenuBarProvider {
    ScreenMenuBar fScreenMenuBar;
    boolean useScreenMenuBar = AquaMenuBarUI.getScreenMenuBarProperty();

    @Override
    public void uninstallUI(JComponent c) {
        if (this.fScreenMenuBar != null) {
            JFrame frame = (JFrame)c.getTopLevelAncestor();
            if (frame != null && frame.getMenuBar() == this.fScreenMenuBar) {
                frame.setMenuBar(null);
            }
            this.fScreenMenuBar = null;
        }
        super.uninstallUI(c);
    }

    public static ComponentUI createUI(JComponent c) {
        return new AquaMenuBarUI();
    }

    @Override
    protected void installKeyboardActions() {
        if (!this.useScreenMenuBar) {
            super.installKeyboardActions();
        }
    }

    @Override
    protected void uninstallKeyboardActions() {
        if (!this.useScreenMenuBar) {
            super.uninstallKeyboardActions();
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AquaMenuPainter.instance().paintMenuBarBackground(g, c.getWidth(), c.getHeight(), c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (AquaMenuBarUI.isScreenMenuBar((JMenuBar)c) && this.setScreenMenuBar((JFrame)c.getTopLevelAncestor())) {
            return new Dimension(0, 0);
        }
        return null;
    }

    void clearScreenMenuBar(JFrame frame) {
        if (this.useScreenMenuBar) {
            frame.setMenuBar(null);
        }
    }

    boolean setScreenMenuBar(JFrame frame) {
        if (this.useScreenMenuBar) {
            try {
                this.getScreenMenuBar();
            }
            catch (Throwable t) {
                return false;
            }
            frame.setMenuBar(this.fScreenMenuBar);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScreenMenuBar getScreenMenuBar() {
        AquaMenuBarUI aquaMenuBarUI = this;
        synchronized (aquaMenuBarUI) {
            if (this.fScreenMenuBar == null) {
                this.fScreenMenuBar = new ScreenMenuBar(this.menuBar);
            }
        }
        return this.fScreenMenuBar;
    }

    public static final boolean isScreenMenuBar(JMenuBar c) {
        MenuBarUI ui = c.getUI();
        if (ui instanceof AquaMenuBarUI) {
            if (!((AquaMenuBarUI)ui).useScreenMenuBar) {
                return false;
            }
            Container parent = c.getTopLevelAncestor();
            if (parent instanceof JFrame) {
                boolean thisIsTheJMenuBar;
                MenuBar mb = ((JFrame)parent).getMenuBar();
                boolean bl = thisIsTheJMenuBar = ((JFrame)parent).getJMenuBar() == c;
                if (mb == null) {
                    return thisIsTheJMenuBar;
                }
                return mb instanceof ScreenMenuBar && thisIsTheJMenuBar;
            }
        }
        return false;
    }

    public static boolean getScreenMenuBarProperty() {
        if (LWCToolkit.isEmbedded()) {
            return false;
        }
        if (AccessController.doPrivileged(new GetBooleanAction("apple.laf.useScreenMenuBar")).booleanValue()) {
            return true;
        }
        if (AccessController.doPrivileged(new GetBooleanAction("com.apple.macos.useScreenMenuBar")).booleanValue()) {
            System.err.println("com.apple.macos.useScreenMenuBar has been deprecated. Please switch to apple.laf.useScreenMenuBar");
            return true;
        }
        return false;
    }

    static {
        AccessController.doPrivileged(() -> {
            System.loadLibrary("osxui");
            return null;
        });
    }
}

