/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaImageFactory;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import sun.awt.image.ImageCache;
import sun.awt.image.MultiResolutionCachedImage;
import sun.awt.image.SunWritableRaster;
import sun.java2d.SunGraphics2D;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;

abstract class AquaPainter<T extends JRSUIState> {
    final Rectangle boundsRect = new Rectangle();
    final JRSUIControl control;
    T state;

    static <T extends JRSUIState> AquaPainter<T> create(T state) {
        return new AquaSingleImagePainter<T>(state);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T state, int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut) {
        return AquaPainter.create(state, minWidth, minHeight, westCut, eastCut, northCut, southCut, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T state, int minWidth, int minHeight, int westCut, int eastCut, int northCut, int southCut, boolean useMiddle) {
        return AquaPainter.create(state, minWidth, minHeight, westCut, eastCut, northCut, southCut, useMiddle, true, true);
    }

    static <T extends JRSUIState> AquaPainter<T> create(T state, final int minWidth, final int minHeight, final int westCut, final int eastCut, final int northCut, final int southCut, final boolean useMiddle, final boolean stretchHorizontally, final boolean stretchVertically) {
        return AquaPainter.create(state, new JRSUIUtils.NineSliceMetricsProvider(){

            @Override
            public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState state) {
                return new AquaImageFactory.NineSliceMetrics(minWidth, minHeight, westCut, eastCut, northCut, southCut, useMiddle, stretchHorizontally, stretchVertically);
            }
        });
    }

    static <T extends JRSUIState> AquaPainter<T> create(T state, JRSUIUtils.NineSliceMetricsProvider metricsProvider) {
        return new AquaNineSlicingImagePainter<T>(state, metricsProvider);
    }

    abstract void paint(Graphics2D var1, T var2);

    AquaPainter(JRSUIControl control, T state) {
        this.control = control;
        this.state = state;
    }

    final JRSUIControl getControl() {
        this.state = ((JRSUIState)this.state).derive();
        this.control.set((JRSUIState)this.state);
        return this.control;
    }

    final void paint(Graphics g, Component c, int x, int y, int w, int h) {
        this.boundsRect.setBounds(x, y, w, h);
        Object nextState = ((JRSUIState)this.state).derive();
        Graphics2D g2d = this.getGraphics2D(g);
        if (g2d != null) {
            this.paint(g2d, nextState);
        }
        this.state = nextState;
    }

    private Graphics2D getGraphics2D(Graphics g) {
        try {
            return (SunGraphics2D)g;
        }
        catch (Exception ignored) {
            if (g instanceof PeekGraphics) {
                g.fillRect(this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
            } else if (g instanceof ProxyGraphics2D) {
                ProxyGraphics2D pg = (ProxyGraphics2D)g;
                Graphics2D g2d = pg.getDelegate();
                if (g2d instanceof SunGraphics2D) {
                    return g2d;
                }
            } else if (g instanceof Graphics2D) {
                return (Graphics2D)g;
            }
            return null;
        }
    }

    private static class RecyclableJRSUISlicedImageControl
    extends AquaImageFactory.RecyclableSlicedImageControl {
        private final JRSUIControl control;
        private final JRSUIState state;

        RecyclableJRSUISlicedImageControl(JRSUIControl control, JRSUIState state, AquaImageFactory.NineSliceMetrics metrics) {
            super(metrics);
            this.control = control;
            this.state = state;
        }

        @Override
        protected Image createTemplateImage(int width, int height) {
            BufferedImage image = new BufferedImage(this.metrics.minW, this.metrics.minH, 3);
            WritableRaster raster = image.getRaster();
            DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
            this.control.set(this.state);
            this.control.paint(SunWritableRaster.stealData(buffer, 0), this.metrics.minW, this.metrics.minH, 0.0, 0.0, this.metrics.minW, this.metrics.minH);
            SunWritableRaster.markDirty(buffer);
            return image;
        }
    }

    private static class AquaPixelsKey
    implements ImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Rectangle bounds;
        private final JRSUIState state;

        AquaPixelsKey(GraphicsConfiguration config, int w, int h, Rectangle bounds, JRSUIState state) {
            this.pixelCount = w * h;
            this.config = config;
            this.w = w;
            this.h = h;
            this.bounds = bounds;
            this.state = state;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int hash = this.config != null ? this.config.hashCode() : 0;
            hash = 31 * hash + this.w;
            hash = 31 * hash + this.h;
            hash = 31 * hash + this.bounds.hashCode();
            hash = 31 * hash + this.state.hashCode();
            return hash;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AquaPixelsKey) {
                AquaPixelsKey key = (AquaPixelsKey)obj;
                return this.config == key.config && this.w == key.w && this.h == key.h && this.bounds.equals(key.bounds) && this.state.equals(key.state);
            }
            return false;
        }
    }

    private static final class AquaSingleImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        AquaSingleImagePainter(T state) {
            super(new JRSUIControl(false), state);
        }

        @Override
        void paint(Graphics2D g, T stateToPaint) {
            AquaSingleImagePainter.paintFromSingleCachedImage(g, this.control, stateToPaint, this.boundsRect);
        }

        static void paintFromSingleCachedImage(Graphics2D g, JRSUIControl control, JRSUIState controlState, Rectangle bounds) {
            AquaPixelsKey key;
            if (bounds.width <= 0 || bounds.height <= 0) {
                return;
            }
            int focus = 0;
            if (controlState.is(JRSUIConstants.Focused.YES)) {
                focus = 4;
            }
            int imgX = bounds.x - focus;
            int imgY = bounds.y - focus;
            int imgW = bounds.width + (focus << 1);
            int imgH = bounds.height + (focus << 1);
            GraphicsConfiguration config = g.getDeviceConfiguration();
            ImageCache cache = ImageCache.getInstance();
            Image img = cache.getImage(key = new AquaPixelsKey(config, imgW, imgH, bounds, controlState));
            if (img == null) {
                img = new MultiResolutionCachedImage(imgW, imgH, (rvWidth, rvHeight) -> AquaSingleImagePainter.createImage(imgX, imgY, rvWidth, rvHeight, bounds, control, controlState));
                if (!controlState.is(JRSUIConstants.Animating.YES)) {
                    cache.setImage(key, img);
                }
            }
            g.drawImage(img, imgX, imgY, imgW, imgH, null);
        }

        private static Image createImage(int imgX, int imgY, int imgW, int imgH, Rectangle bounds, JRSUIControl control, JRSUIState controlState) {
            BufferedImage img = new BufferedImage(imgW, imgH, 3);
            WritableRaster raster = img.getRaster();
            DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
            control.set(controlState);
            control.paint(SunWritableRaster.stealData(buffer, 0), imgW, imgH, bounds.x - imgX, bounds.y - imgY, bounds.width, bounds.height);
            SunWritableRaster.markDirty(buffer);
            return img;
        }
    }

    private static class AquaNineSlicingImagePainter<T extends JRSUIState>
    extends AquaPainter<T> {
        private final HashMap<T, RecyclableJRSUISlicedImageControl> slicedControlImages;
        private final JRSUIUtils.NineSliceMetricsProvider metricsProvider;

        AquaNineSlicingImagePainter(T state) {
            this(state, null);
        }

        AquaNineSlicingImagePainter(T state, JRSUIUtils.NineSliceMetricsProvider metricsProvider) {
            super(new JRSUIControl(false), state);
            this.metricsProvider = metricsProvider;
            this.slicedControlImages = new HashMap();
        }

        @Override
        void paint(Graphics2D g, T stateToPaint) {
            if (this.metricsProvider == null) {
                AquaSingleImagePainter.paintFromSingleCachedImage(g, this.control, stateToPaint, this.boundsRect);
                return;
            }
            RecyclableJRSUISlicedImageControl slicesRef = this.slicedControlImages.get(stateToPaint);
            if (slicesRef == null) {
                AquaImageFactory.NineSliceMetrics metrics = this.metricsProvider.getNineSliceMetricsForState((JRSUIState)stateToPaint);
                if (metrics == null) {
                    AquaSingleImagePainter.paintFromSingleCachedImage(g, this.control, stateToPaint, this.boundsRect);
                    return;
                }
                slicesRef = new RecyclableJRSUISlicedImageControl(this.control, (JRSUIState)stateToPaint, metrics);
                this.slicedControlImages.put(stateToPaint, slicesRef);
            }
            AquaImageFactory.SlicedImageControl slices = (AquaImageFactory.SlicedImageControl)slicesRef.get();
            slices.paint(g, this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
        }
    }
}

