/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

public class AquaScrollBarUI
extends ScrollBarUI {
    private static final int kInitialDelay = 300;
    private static final int kNormalDelay = 100;
    static final int MIN_ARROW_COLLAPSE_SIZE = 64;
    protected boolean fIsDragging;
    protected Timer fScrollTimer;
    protected ScrollListener fScrollListener;
    protected TrackListener fTrackListener;
    protected JRSUIConstants.Hit fTrackHighlight = JRSUIConstants.Hit.NONE;
    protected JRSUIConstants.Hit fMousePart = JRSUIConstants.Hit.NONE;
    protected JScrollBar fScrollBar;
    protected ModelListener fModelListener;
    protected PropertyChangeListener fPropertyChangeListener;
    protected final AquaPainter<JRSUIState.ScrollBarState> painter = AquaPainter.create(JRSUIStateFactory.getScrollBar());
    private static final AquaUtils.RecyclableSingleton<Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>> hitToPressedPartMap = new AquaUtils.RecyclableSingleton<Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>>(){

        @Override
        protected Map<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart> getInstance() {
            HashMap<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart> map = new HashMap<JRSUIConstants.Hit, JRSUIConstants.ScrollBarPart>(7);
            map.put(JRSUIConstants.ScrollBarHit.ARROW_MAX, JRSUIConstants.ScrollBarPart.ARROW_MAX);
            map.put(JRSUIConstants.ScrollBarHit.ARROW_MIN, JRSUIConstants.ScrollBarPart.ARROW_MIN);
            map.put(JRSUIConstants.ScrollBarHit.ARROW_MAX_INSIDE, JRSUIConstants.ScrollBarPart.ARROW_MAX_INSIDE);
            map.put(JRSUIConstants.ScrollBarHit.ARROW_MIN_INSIDE, JRSUIConstants.ScrollBarPart.ARROW_MIN_INSIDE);
            map.put(JRSUIConstants.ScrollBarHit.TRACK_MAX, JRSUIConstants.ScrollBarPart.TRACK_MAX);
            map.put(JRSUIConstants.ScrollBarHit.TRACK_MIN, JRSUIConstants.ScrollBarPart.TRACK_MIN);
            map.put(JRSUIConstants.ScrollBarHit.THUMB, JRSUIConstants.ScrollBarPart.THUMB);
            return map;
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new AquaScrollBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.fScrollBar = (JScrollBar)c;
        this.installListeners();
        this.configureScrollBarColors();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.fScrollBar = null;
    }

    protected void configureScrollBarColors() {
        LookAndFeel.installColors(this.fScrollBar, "ScrollBar.background", "ScrollBar.foreground");
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected void installListeners() {
        this.fTrackListener = this.createTrackListener();
        this.fModelListener = this.createModelListener();
        this.fPropertyChangeListener = this.createPropertyChangeListener();
        this.fScrollBar.addMouseListener(this.fTrackListener);
        this.fScrollBar.addMouseMotionListener(this.fTrackListener);
        this.fScrollBar.getModel().addChangeListener(this.fModelListener);
        this.fScrollBar.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fScrollListener = this.createScrollListener();
        this.fScrollTimer = new Timer(100, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(300);
    }

    protected void uninstallListeners() {
        this.fScrollTimer.stop();
        this.fScrollTimer = null;
        this.fScrollBar.getModel().removeChangeListener(this.fModelListener);
        this.fScrollBar.removeMouseListener(this.fTrackListener);
        this.fScrollBar.removeMouseMotionListener(this.fTrackListener);
        this.fScrollBar.removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected void syncState(JComponent c) {
        JRSUIState.ScrollBarState scrollBarState = (JRSUIState.ScrollBarState)this.painter.state;
        scrollBarState.set(this.isHorizontal() ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL);
        float trackExtent = this.fScrollBar.getMaximum() - this.fScrollBar.getMinimum() - this.fScrollBar.getModel().getExtent();
        if (trackExtent <= 0.0f) {
            scrollBarState.set(JRSUIConstants.NothingToScroll.YES);
            return;
        }
        JRSUIConstants.ScrollBarPart pressedPart = this.getPressedPart();
        scrollBarState.set(pressedPart);
        scrollBarState.set(this.getState(c, pressedPart));
        scrollBarState.set(JRSUIConstants.NothingToScroll.NO);
        scrollBarState.setValue((float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / trackExtent);
        scrollBarState.setThumbStart(this.getThumbStart());
        scrollBarState.setThumbPercent(this.getThumbPercent());
        scrollBarState.set(this.shouldShowArrows() ? JRSUIConstants.ShowArrows.YES : JRSUIConstants.ShowArrows.NO);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.syncState(c);
        this.painter.paint(g, c, 0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected JRSUIConstants.State getState(JComponent c, JRSUIConstants.ScrollBarPart pressedPart) {
        if (!AquaFocusHandler.isActive(c)) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!c.isEnabled()) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (pressedPart != JRSUIConstants.ScrollBarPart.NONE) {
            return JRSUIConstants.State.PRESSED;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected JRSUIConstants.ScrollBarPart getPressedPart() {
        if (!this.fTrackListener.fInArrows || !this.fTrackListener.fStillInArrow) {
            return JRSUIConstants.ScrollBarPart.NONE;
        }
        JRSUIConstants.ScrollBarPart pressedPart = hitToPressedPartMap.get().get(this.fMousePart);
        if (pressedPart == null) {
            return JRSUIConstants.ScrollBarPart.NONE;
        }
        return pressedPart;
    }

    protected boolean shouldShowArrows() {
        return 64 < (this.isHorizontal() ? this.fScrollBar.getWidth() : this.fScrollBar.getHeight());
    }

    public void layoutContainer(Container fScrollBarContainer) {
        this.fScrollBar.repaint();
        this.fScrollBar.revalidate();
    }

    protected Rectangle getTrackBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected Rectangle getDragBounds() {
        return new Rectangle(0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight());
    }

    protected void startTimer(boolean initial) {
        this.fScrollTimer.setInitialDelay(initial ? 300 : 100);
        this.fScrollTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByBlock(int direction) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int oldValue = this.fScrollBar.getValue();
            int blockIncrement = this.fScrollBar.getBlockIncrement(direction);
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.fScrollBar.setValue(oldValue + delta);
            this.fTrackHighlight = direction > 0 ? JRSUIConstants.ScrollBarHit.TRACK_MAX : JRSUIConstants.ScrollBarHit.TRACK_MIN;
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(direction);
            this.fScrollListener.setScrollByBlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollByUnit(int direction) {
        JScrollBar jScrollBar = this.fScrollBar;
        synchronized (jScrollBar) {
            int delta = this.fScrollBar.getUnitIncrement(direction);
            if (direction <= 0) {
                delta = -delta;
            }
            this.fScrollBar.setValue(delta + this.fScrollBar.getValue());
            this.fScrollBar.repaint();
            this.fScrollListener.setDirection(direction);
            this.fScrollListener.setScrollByBlock(false);
        }
    }

    protected JRSUIConstants.Hit getPartHit(int x, int y) {
        this.syncState(this.fScrollBar);
        return JRSUIUtils.HitDetection.getHitForPoint(this.painter.getControl(), 0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight(), x, y);
    }

    float getThumbStart() {
        int min;
        int max = this.fScrollBar.getMaximum();
        int extent = max - (min = this.fScrollBar.getMinimum());
        if (extent <= 0) {
            return 0.0f;
        }
        return (float)(this.fScrollBar.getValue() - this.fScrollBar.getMinimum()) / (float)extent;
    }

    float getThumbPercent() {
        int min;
        int visible = this.fScrollBar.getVisibleAmount();
        int max = this.fScrollBar.getMaximum();
        int extent = max - (min = this.fScrollBar.getMinimum());
        if (extent <= 0) {
            return 0.0f;
        }
        return (float)visible / (float)extent;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.isHorizontal() ? new Dimension(96, 15) : new Dimension(15, 96);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.isHorizontal() ? new Dimension(54, 15) : new Dimension(15, 54);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    boolean isHorizontal() {
        return this.fScrollBar.getOrientation() == 0;
    }

    Point getScrollToHereStartPoint(int clickPosX, int clickPosY) {
        Rectangle limitRect = this.getDragBounds();
        this.syncState(this.fScrollBar);
        double[] rect = new double[4];
        JRSUIUtils.ScrollBar.getPartBounds(rect, this.painter.getControl(), 0, 0, this.fScrollBar.getWidth(), this.fScrollBar.getHeight(), JRSUIConstants.ScrollBarPart.THUMB);
        Rectangle r = new Rectangle((int)rect[0], (int)rect[1], (int)rect[2], (int)rect[3]);
        Point startPoint = new Point(clickPosX, clickPosY);
        if (this.isHorizontal()) {
            int halfWidth = r.width / 2;
            int limitRectRight = limitRect.x + limitRect.width;
            startPoint.x = clickPosX + halfWidth > limitRectRight ? r.x + r.width - limitRectRight - clickPosX - 1 : (clickPosX - halfWidth < limitRect.x ? r.x + clickPosX - limitRect.x : r.x + halfWidth);
            startPoint.y = (r.y + r.height) / 2;
            return startPoint;
        }
        int halfHeight = r.height / 2;
        int limitRectBottom = limitRect.y + limitRect.height;
        startPoint.y = clickPosY + halfHeight > limitRectBottom ? r.y + r.height - limitRectBottom - clickPosY - 1 : (clickPosY - halfHeight < limitRect.y ? r.y + clickPosY - limitRect.y : r.y + halfHeight);
        startPoint.x = (r.x + r.width) / 2;
        return startPoint;
    }

    static class HitUtil {
        HitUtil() {
        }

        static boolean isIncrement(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.ARROW_MAX || hit == JRSUIConstants.ScrollBarHit.ARROW_MAX_INSIDE;
        }

        static boolean isDecrement(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.ARROW_MIN || hit == JRSUIConstants.ScrollBarHit.ARROW_MIN_INSIDE;
        }

        static boolean isArrow(JRSUIConstants.Hit hit) {
            return HitUtil.isIncrement(hit) || HitUtil.isDecrement(hit);
        }

        static boolean isTrack(JRSUIConstants.Hit hit) {
            return hit == JRSUIConstants.ScrollBarHit.TRACK_MAX || hit == JRSUIConstants.ScrollBarHit.TRACK_MIN;
        }
    }

    protected class ScrollListener
    implements ActionListener {
        boolean fUseBlockIncrement;
        int fDirection = 1;

        protected ScrollListener() {
        }

        void setDirection(int direction) {
            this.fDirection = direction;
        }

        void setScrollByBlock(boolean block) {
            this.fUseBlockIncrement = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fUseBlockIncrement) {
                JRSUIConstants.Hit newPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (newPart == JRSUIConstants.ScrollBarHit.TRACK_MIN || newPart == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                    int newDirection;
                    int n = newDirection = newPart == JRSUIConstants.ScrollBarHit.TRACK_MAX ? 1 : -1;
                    if (this.fDirection != newDirection) {
                        this.fDirection = newDirection;
                    }
                }
                AquaScrollBarUI.this.scrollByBlock(this.fDirection);
                newPart = AquaScrollBarUI.this.getPartHit(AquaScrollBarUI.this.fTrackListener.fCurrentMouseX, AquaScrollBarUI.this.fTrackListener.fCurrentMouseY);
                if (newPart == JRSUIConstants.ScrollBarHit.THUMB) {
                    ((Timer)e.getSource()).stop();
                }
            } else {
                AquaScrollBarUI.this.scrollByUnit(this.fDirection);
            }
            if (this.fDirection > 0 && AquaScrollBarUI.this.fScrollBar.getValue() + AquaScrollBarUI.this.fScrollBar.getVisibleAmount() >= AquaScrollBarUI.this.fScrollBar.getMaximum()) {
                ((Timer)e.getSource()).stop();
            } else if (this.fDirection < 0 && AquaScrollBarUI.this.fScrollBar.getValue() <= AquaScrollBarUI.this.fScrollBar.getMinimum()) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int fCurrentMouseX;
        protected transient int fCurrentMouseY;
        protected transient boolean fInArrows;
        protected transient boolean fStillInArrow = false;
        protected transient boolean fStillInTrack = false;
        protected transient int fFirstMouseX;
        protected transient int fFirstMouseY;
        protected transient int fFirstValue;

        protected TrackListener() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseReleasedInArrows(e);
            } else {
                this.mouseReleasedInTrack(e);
            }
            this.fInArrows = false;
            this.fStillInArrow = false;
            this.fStillInTrack = false;
            AquaScrollBarUI.this.fScrollBar.repaint();
            AquaScrollBarUI.this.fScrollBar.revalidate();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            JRSUIConstants.Hit part = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
            this.fInArrows = HitUtil.isArrow(part);
            if (this.fInArrows) {
                this.mousePressedInArrows(e, part);
            } else if (part == JRSUIConstants.Hit.NONE) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.Hit.NONE;
            } else {
                this.mousePressedInTrack(e, part);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!AquaScrollBarUI.this.fScrollBar.isEnabled()) {
                return;
            }
            if (this.fInArrows) {
                this.mouseDraggedInArrows(e);
            } else if (AquaScrollBarUI.this.fIsDragging) {
                this.mouseDraggedInTrack(e);
            } else {
                JRSUIConstants.Hit previousPart = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
                if (!HitUtil.isTrack(previousPart)) {
                    this.fStillInTrack = false;
                }
                this.fCurrentMouseX = e.getX();
                this.fCurrentMouseY = e.getY();
                JRSUIConstants.Hit part = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
                boolean temp = HitUtil.isTrack(part);
                if (temp == this.fStillInTrack) {
                    return;
                }
                this.fStillInTrack = temp;
                if (!this.fStillInTrack) {
                    AquaScrollBarUI.this.fScrollTimer.stop();
                } else {
                    AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                    AquaScrollBarUI.this.startTimer(false);
                }
            }
        }

        int getValueFromOffset(int xOffset, int yOffset, int firstValue) {
            boolean isHoriz = AquaScrollBarUI.this.isHorizontal();
            int offsetWeCareAbout = isHoriz ? xOffset : yOffset;
            int visibleAmt = AquaScrollBarUI.this.fScrollBar.getVisibleAmount();
            int max = AquaScrollBarUI.this.fScrollBar.getMaximum();
            int min = AquaScrollBarUI.this.fScrollBar.getMinimum();
            int extent = max - min;
            AquaScrollBarUI.this.syncState(AquaScrollBarUI.this.fScrollBar);
            double offsetChange = JRSUIUtils.ScrollBar.getNativeOffsetChange(AquaScrollBarUI.this.painter.getControl(), 0, 0, AquaScrollBarUI.this.fScrollBar.getWidth(), AquaScrollBarUI.this.fScrollBar.getHeight(), offsetWeCareAbout, visibleAmt, extent);
            int scrollableArea = extent - visibleAmt;
            int changeByValue = (int)(offsetChange * (double)scrollableArea);
            int newValue = firstValue + changeByValue;
            newValue = Math.max(min, newValue);
            newValue = Math.min(max - visibleAmt, newValue);
            return newValue;
        }

        void mousePressedInArrows(MouseEvent e, JRSUIConstants.Hit part) {
            int direction = HitUtil.isIncrement(part) ? 1 : -1;
            this.fStillInArrow = true;
            AquaScrollBarUI.this.scrollByUnit(direction);
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollListener.setDirection(direction);
            AquaScrollBarUI.this.fScrollListener.setScrollByBlock(false);
            AquaScrollBarUI.this.fMousePart = part;
            AquaScrollBarUI.this.startTimer(true);
        }

        void mouseReleasedInArrows(MouseEvent e) {
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fMousePart = JRSUIConstants.Hit.NONE;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mouseDraggedInArrows(MouseEvent e) {
            JRSUIConstants.Hit whichPart = AquaScrollBarUI.this.getPartHit(e.getX(), e.getY());
            if (AquaScrollBarUI.this.fMousePart == whichPart && this.fStillInArrow) {
                return;
            }
            if (AquaScrollBarUI.this.fMousePart != whichPart && !HitUtil.isArrow(whichPart)) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                this.fStillInArrow = false;
                AquaScrollBarUI.this.fScrollBar.repaint();
            } else {
                AquaScrollBarUI.this.fMousePart = whichPart;
                AquaScrollBarUI.this.fScrollListener.setDirection(HitUtil.isIncrement(whichPart) ? 1 : -1);
                this.fStillInArrow = true;
                AquaScrollBarUI.this.fScrollListener.actionPerformed(new ActionEvent(AquaScrollBarUI.this.fScrollTimer, 0, ""));
                AquaScrollBarUI.this.startTimer(false);
            }
            AquaScrollBarUI.this.fScrollBar.repaint();
        }

        void mouseReleasedInTrack(MouseEvent e) {
            if (AquaScrollBarUI.this.fTrackHighlight != JRSUIConstants.Hit.NONE) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
            AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.Hit.NONE;
            AquaScrollBarUI.this.fIsDragging = false;
            AquaScrollBarUI.this.fScrollTimer.stop();
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(false);
        }

        void mousePressedInTrack(MouseEvent e, JRSUIConstants.Hit part) {
            boolean shouldScrollToHere;
            AquaScrollBarUI.this.fScrollBar.setValueIsAdjusting(true);
            boolean bl = shouldScrollToHere = part != JRSUIConstants.ScrollBarHit.THUMB && JRSUIUtils.ScrollBar.useScrollToClick();
            if (e.isAltDown()) {
                boolean bl2 = shouldScrollToHere = !shouldScrollToHere;
            }
            if (shouldScrollToHere) {
                Point p = AquaScrollBarUI.this.getScrollToHereStartPoint(e.getX(), e.getY());
                this.fFirstMouseX = p.x;
                this.fFirstMouseY = p.y;
                this.fFirstValue = AquaScrollBarUI.this.fScrollBar.getValue();
                this.moveToMouse(e);
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            this.fCurrentMouseX = e.getX();
            this.fCurrentMouseY = e.getY();
            int direction = 0;
            if (part == JRSUIConstants.ScrollBarHit.TRACK_MIN) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.TRACK_MIN;
                direction = -1;
            } else if (part == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.TRACK_MAX;
                direction = 1;
            } else {
                this.fFirstValue = AquaScrollBarUI.this.fScrollBar.getValue();
                this.fFirstMouseX = this.fCurrentMouseX;
                this.fFirstMouseY = this.fCurrentMouseY;
                AquaScrollBarUI.this.fTrackHighlight = JRSUIConstants.ScrollBarHit.THUMB;
                AquaScrollBarUI.this.fIsDragging = true;
                return;
            }
            AquaScrollBarUI.this.fIsDragging = false;
            this.fStillInTrack = true;
            AquaScrollBarUI.this.scrollByBlock(direction);
            JRSUIConstants.Hit newPart = AquaScrollBarUI.this.getPartHit(this.fCurrentMouseX, this.fCurrentMouseY);
            if (newPart == JRSUIConstants.ScrollBarHit.TRACK_MIN || newPart == JRSUIConstants.ScrollBarHit.TRACK_MAX) {
                AquaScrollBarUI.this.fScrollTimer.stop();
                AquaScrollBarUI.this.fScrollListener.setDirection(newPart == JRSUIConstants.ScrollBarHit.TRACK_MAX ? 1 : -1);
                AquaScrollBarUI.this.fScrollListener.setScrollByBlock(true);
                AquaScrollBarUI.this.startTimer(true);
            }
        }

        void mouseDraggedInTrack(MouseEvent e) {
            this.moveToMouse(e);
        }

        void moveToMouse(MouseEvent e) {
            this.fCurrentMouseX = e.getX();
            this.fCurrentMouseY = e.getY();
            int oldValue = AquaScrollBarUI.this.fScrollBar.getValue();
            int newValue = this.getValueFromOffset(this.fCurrentMouseX - this.fFirstMouseX, this.fCurrentMouseY - this.fFirstMouseY, this.fFirstValue);
            if (newValue == oldValue) {
                return;
            }
            AquaScrollBarUI.this.fScrollBar.setValue(newValue);
            Rectangle dirtyRect = AquaScrollBarUI.this.getTrackBounds();
            AquaScrollBarUI.this.fScrollBar.repaint(dirtyRect.x, dirtyRect.y, dirtyRect.width, dirtyRect.height);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AquaScrollBarUI.this.layoutContainer(AquaScrollBarUI.this.fScrollBar);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("model".equals(propertyName)) {
                BoundedRangeModel oldModel = (BoundedRangeModel)e.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)e.getNewValue();
                oldModel.removeChangeListener(AquaScrollBarUI.this.fModelListener);
                newModel.addChangeListener(AquaScrollBarUI.this.fModelListener);
                AquaScrollBarUI.this.fScrollBar.repaint();
                AquaScrollBarUI.this.fScrollBar.revalidate();
            } else if ("Frame.active".equals(propertyName)) {
                AquaScrollBarUI.this.fScrollBar.repaint();
            }
        }
    }
}

