/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaTableHeaderBorder;
import com.apple.laf.AquaUtils;
import com.apple.laf.ClientPropertyApplicator;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class AquaTableHeaderUI
extends BasicTableHeaderUI {
    private int originalHeaderAlignment;
    protected int sortColumn;
    protected int sortOrder;
    private static final AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JTableHeader, JTableHeader>> TABLE_HEADER_APPLICATORS = new AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JTableHeader, JTableHeader>>(){

        @Override
        protected ClientPropertyApplicator<JTableHeader, JTableHeader> getInstance() {
            return new ClientPropertyApplicator<JTableHeader, JTableHeader>(new ClientPropertyApplicator.Property<JTableHeader>("JTableHeader.selectedColumn"){

                @Override
                public void applyProperty(JTableHeader target, Object value) {
                    AquaTableHeaderUI.tickle(target, value, target.getClientProperty("JTableHeader.sortDirection"));
                }
            }, new ClientPropertyApplicator.Property<JTableHeader>("JTableHeader.sortDirection"){

                @Override
                public void applyProperty(JTableHeader target, Object value) {
                    AquaTableHeaderUI.tickle(target, target.getClientProperty("JTableHeader.selectedColumn"), value);
                }
            });
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new AquaTableHeaderUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        TableCellRenderer renderer = this.header.getDefaultRenderer();
        if (renderer instanceof UIResource && renderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultRenderer = (DefaultTableCellRenderer)renderer;
            this.originalHeaderAlignment = defaultRenderer.getHorizontalAlignment();
            defaultRenderer.setHorizontalAlignment(10);
        }
    }

    @Override
    public void uninstallDefaults() {
        TableCellRenderer renderer = this.header.getDefaultRenderer();
        if (renderer instanceof UIResource && renderer instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer defaultRenderer = (DefaultTableCellRenderer)renderer;
            defaultRenderer.setHorizontalAlignment(this.originalHeaderAlignment);
        }
        super.uninstallDefaults();
    }

    static ClientPropertyApplicator<JTableHeader, JTableHeader> getTableHeaderApplicators() {
        return TABLE_HEADER_APPLICATORS.get();
    }

    static void tickle(JTableHeader target, Object selectedColumn, Object direction) {
        TableColumn tableColumn = AquaTableHeaderUI.getTableColumn(target, selectedColumn);
        if (tableColumn == null) {
            return;
        }
        int sortDirection = 0;
        if ("ascending".equalsIgnoreCase("" + direction)) {
            sortDirection = 1;
        } else if ("descending".equalsIgnoreCase("" + direction)) {
            sortDirection = -1;
        } else if ("decending".equalsIgnoreCase("" + direction)) {
            sortDirection = -1;
        }
        TableHeaderUI headerUI = target.getUI();
        if (headerUI == null || !(headerUI instanceof AquaTableHeaderUI)) {
            return;
        }
        AquaTableHeaderUI aquaHeaderUI = (AquaTableHeaderUI)headerUI;
        aquaHeaderUI.sortColumn = tableColumn.getModelIndex();
        aquaHeaderUI.sortOrder = sortDirection;
        AquaTableCellRenderer renderer = aquaHeaderUI.new AquaTableCellRenderer();
        tableColumn.setHeaderRenderer(renderer);
    }

    protected static TableColumn getTableColumn(JTableHeader target, Object value) {
        if (value == null || !(value instanceof Integer)) {
            return null;
        }
        int columnIndex = (Integer)value;
        TableColumnModel columnModel = target.getColumnModel();
        if (columnIndex < 0 || columnIndex >= columnModel.getColumnCount()) {
            return null;
        }
        return columnModel.getColumn(columnIndex);
    }

    protected static AquaTableHeaderBorder getAquaBorderFrom(JTableHeader header, TableColumn column) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            return null;
        }
        Component c = renderer.getTableCellRendererComponent(header.getTable(), column.getHeaderValue(), false, false, -1, column.getModelIndex());
        if (!(c instanceof JComponent)) {
            return null;
        }
        Border border = ((JComponent)c).getBorder();
        if (!(border instanceof AquaTableHeaderBorder)) {
            return null;
        }
        return (AquaTableHeaderBorder)border;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaTableHeaderUI.getTableHeaderApplicators().attachAndApplyClientProperties(this.header);
    }

    @Override
    protected void uninstallListeners() {
        AquaTableHeaderUI.getTableHeaderApplicators().removeFrom(this.header);
        super.uninstallListeners();
    }

    private int getHeaderHeightAqua() {
        int height = 0;
        boolean accomodatedDefault = false;
        TableColumnModel columnModel = this.header.getColumnModel();
        for (int column = 0; column < columnModel.getColumnCount(); ++column) {
            TableColumn aColumn = columnModel.getColumn(column);
            if (aColumn.getHeaderRenderer() == null && accomodatedDefault) continue;
            Component comp = this.getHeaderRendererAqua(column);
            int rendererHeight = comp.getPreferredSize().height;
            height = Math.max(height, rendererHeight);
            if (rendererHeight <= 4) continue;
            accomodatedDefault = true;
        }
        return height;
    }

    private Component getHeaderRendererAqua(int columnIndex) {
        TableColumn aColumn = this.header.getColumnModel().getColumn(columnIndex);
        TableCellRenderer renderer = aColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.header.getDefaultRenderer();
        }
        return renderer.getTableCellRendererComponent(this.header.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
    }

    private Dimension createHeaderSizeAqua(long width) {
        if (width > Integer.MAX_VALUE) {
            width = Integer.MAX_VALUE;
        }
        return new Dimension((int)width, this.getHeaderHeightAqua());
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createHeaderSizeAqua(width);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.header.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createHeaderSizeAqua(width);
    }

    class AquaTableCellRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        AquaTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable localTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (localTable != null && AquaTableHeaderUI.this.header != null) {
                this.setForeground(AquaTableHeaderUI.this.header.getForeground());
                this.setBackground(AquaTableHeaderUI.this.header.getBackground());
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            this.setText(value == null ? "" : value.toString());
            AquaTableHeaderBorder cellBorder = AquaTableHeaderBorder.getListHeaderBorder();
            cellBorder.setSortOrder(0);
            if (localTable != null) {
                boolean thisColumnSelected = localTable.getColumnModel().getColumn(column).getModelIndex() == AquaTableHeaderUI.this.sortColumn;
                cellBorder.setSelected(thisColumnSelected);
                if (thisColumnSelected) {
                    cellBorder.setSortOrder(AquaTableHeaderUI.this.sortOrder);
                }
            }
            this.setBorder(cellBorder);
            return this;
        }
    }
}

