/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Window;
import java.awt.peer.ComponentPeer;

public class DefaultFocusTraversalPolicy
extends ContainerOrderFocusTraversalPolicy {
    private static final long serialVersionUID = 8876966522510157497L;

    @Override
    protected boolean accept(Component aComponent) {
        if (!(aComponent.isVisible() && aComponent.isDisplayable() && aComponent.isEnabled())) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            for (Container enableTest = aComponent.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        boolean focusable = aComponent.isFocusable();
        if (aComponent.isFocusTraversableOverridden()) {
            return focusable;
        }
        ComponentPeer peer = aComponent.peer;
        return peer != null && peer.isFocusable();
    }
}

