/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;

public final class DisplayMode {
    private Dimension size;
    private int bitDepth;
    private int refreshRate;
    public static final int BIT_DEPTH_MULTI = -1;
    public static final int REFRESH_RATE_UNKNOWN = 0;

    public DisplayMode(int width, int height, int bitDepth, int refreshRate) {
        this.size = new Dimension(width, height);
        this.bitDepth = bitDepth;
        this.refreshRate = refreshRate;
    }

    public int getHeight() {
        return this.size.height;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public boolean equals(DisplayMode dm) {
        if (dm == null) {
            return false;
        }
        return this.getHeight() == dm.getHeight() && this.getWidth() == dm.getWidth() && this.getBitDepth() == dm.getBitDepth() && this.getRefreshRate() == dm.getRefreshRate();
    }

    public boolean equals(Object dm) {
        if (dm instanceof DisplayMode) {
            return this.equals((DisplayMode)dm);
        }
        return false;
    }

    public int hashCode() {
        return this.getWidth() + this.getHeight() + this.getBitDepth() * 7 + this.getRefreshRate() * 13;
    }

    public String toString() {
        return this.getWidth() + "x" + this.getHeight() + "x" + (String)(this.getBitDepth() > 0 ? this.getBitDepth() + "bpp" : "[Multi depth]") + "@" + (String)(this.getRefreshRate() > 0 ? this.getRefreshRate() + "Hz" : "[Unknown refresh rate]");
    }
}

