/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.peer.PopupMenuPeer;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import sun.awt.AWTAccessor;

public class PopupMenu
extends Menu {
    private static final String base = "popup";
    static int nameCounter = 0;
    volatile transient boolean isTrayIconPopup;
    private static final long serialVersionUID = -4620452533522760060L;

    public PopupMenu() throws HeadlessException {
        this("");
    }

    public PopupMenu(String label) throws HeadlessException {
        super(label);
    }

    @Override
    public MenuContainer getParent() {
        if (this.isTrayIconPopup) {
            return null;
        }
        return super.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<PopupMenu> clazz = PopupMenu.class;
        synchronized (PopupMenu.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && !(this.parent instanceof Component)) {
                super.addNotify();
            } else {
                if (this.peer == null) {
                    this.peer = this.getComponentFactory().createPopupMenu(this);
                }
                int nitems = this.getItemCount();
                for (int i = 0; i < nitems; ++i) {
                    MenuItem mi = this.getItem(i);
                    mi.parent = this;
                    mi.addNotify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Component origin, int x, int y) {
        MenuContainer localParent = this.parent;
        if (localParent == null) {
            throw new NullPointerException("parent is null");
        }
        if (!(localParent instanceof Component)) {
            throw new IllegalArgumentException("PopupMenus with non-Component parents cannot be shown");
        }
        Component compParent = (Component)localParent;
        if (compParent != origin) {
            if (compParent instanceof Container) {
                if (!((Container)compParent).isAncestorOf(origin)) {
                    throw new IllegalArgumentException("origin not in parent's hierarchy");
                }
            } else {
                throw new IllegalArgumentException("origin not in parent's hierarchy");
            }
        }
        if (compParent.peer == null || !compParent.isShowing()) {
            throw new RuntimeException("parent not showing on screen");
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer != null) {
                ((PopupMenuPeer)this.peer).show(new Event(origin, 0L, 501, x, y, 0, 0));
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTPopupMenu();
        }
        return this.accessibleContext;
    }

    static {
        AWTAccessor.setPopupMenuAccessor(new AWTAccessor.PopupMenuAccessor(){

            @Override
            public boolean isTrayIconPopup(PopupMenu popupMenu) {
                return popupMenu.isTrayIconPopup;
            }
        });
    }

    protected class AccessibleAWTPopupMenu
    extends Menu.AccessibleAWTMenu {
        private static final long serialVersionUID = -4282044795947239955L;

        protected AccessibleAWTPopupMenu() {
            super(PopupMenu.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }
}

