/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDEventMulticaster;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.SerializationTester;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.EventListener;
import sun.awt.AWTAccessor;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetIntegerAction;

public class DragSource
implements Serializable {
    private static final long serialVersionUID = 6236096958971414066L;
    public static final Cursor DefaultCopyDrop = DragSource.load("DnD.Cursor.CopyDrop");
    public static final Cursor DefaultMoveDrop = DragSource.load("DnD.Cursor.MoveDrop");
    public static final Cursor DefaultLinkDrop = DragSource.load("DnD.Cursor.LinkDrop");
    public static final Cursor DefaultCopyNoDrop = DragSource.load("DnD.Cursor.CopyNoDrop");
    public static final Cursor DefaultMoveNoDrop = DragSource.load("DnD.Cursor.MoveNoDrop");
    public static final Cursor DefaultLinkNoDrop = DragSource.load("DnD.Cursor.LinkNoDrop");
    private static final DragSource dflt = GraphicsEnvironment.isHeadless() ? null : new DragSource();
    static final String dragSourceListenerK = "dragSourceL";
    static final String dragSourceMotionListenerK = "dragSourceMotionL";
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();
    private transient DragSourceListener listener;
    private transient DragSourceMotionListener motionListener;

    private static Cursor load(String name) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        try {
            return (Cursor)Toolkit.getDefaultToolkit().getDesktopProperty(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("failed to load system cursor: " + name + " : " + e.getMessage());
        }
    }

    public static DragSource getDefaultDragSource() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return dflt;
    }

    public static boolean isDragImageSupported() {
        Toolkit t = Toolkit.getDefaultToolkit();
        try {
            Boolean supported = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.isDragImageSupported");
            return supported;
        }
        catch (Exception e) {
            return false;
        }
    }

    public DragSource() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        SunDragSourceContextPeer.setDragDropInProgress(true);
        try {
            DragSourceContext dsc;
            if (flavorMap != null) {
                this.flavorMap = flavorMap;
            }
            if ((dsc = this.createDragSourceContext(trigger, dragCursor, dragImage, imageOffset, transferable, dsl)) == null) {
                throw new InvalidDnDOperationException();
            }
            AWTAccessor.DragSourceContextAccessor acc = AWTAccessor.getDragSourceContextAccessor();
            acc.getPeer(dsc).startDrag(dsc, dsc.getCursor(), dragImage, imageOffset);
        }
        catch (RuntimeException e) {
            SunDragSourceContextPeer.setDragDropInProgress(false);
            throw e;
        }
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl, FlavorMap flavorMap) throws InvalidDnDOperationException {
        this.startDrag(trigger, dragCursor, null, null, transferable, dsl, flavorMap);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point dragOffset, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this.startDrag(trigger, dragCursor, dragImage, dragOffset, transferable, dsl, null);
    }

    public void startDrag(DragGestureEvent trigger, Cursor dragCursor, Transferable transferable, DragSourceListener dsl) throws InvalidDnDOperationException {
        this.startDrag(trigger, dragCursor, null, null, transferable, dsl, null);
    }

    protected DragSourceContext createDragSourceContext(DragGestureEvent dgl, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable t, DragSourceListener dsl) {
        return new DragSourceContext(dgl, dragCursor, dragImage, imageOffset, t, dsl);
    }

    public FlavorMap getFlavorMap() {
        return this.flavorMap;
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> recognizerAbstractClass, Component c, int actions, DragGestureListener dgl) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(recognizerAbstractClass, this, c, actions, dgl);
    }

    public DragGestureRecognizer createDefaultDragGestureRecognizer(Component c, int actions, DragGestureListener dgl) {
        return Toolkit.getDefaultToolkit().createDragGestureRecognizer(MouseDragGestureRecognizer.class, this, c, actions, dgl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDragSourceListener(DragSourceListener dsl) {
        if (dsl != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.listener = DnDEventMulticaster.add(this.listener, dsl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDragSourceListener(DragSourceListener dsl) {
        if (dsl != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.listener = DnDEventMulticaster.remove(this.listener, dsl);
            }
        }
    }

    public DragSourceListener[] getDragSourceListeners() {
        return (DragSourceListener[])this.getListeners(DragSourceListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDragSourceMotionListener(DragSourceMotionListener dsml) {
        if (dsml != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.motionListener = DnDEventMulticaster.add(this.motionListener, dsml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDragSourceMotionListener(DragSourceMotionListener dsml) {
        if (dsml != null) {
            DragSource dragSource = this;
            synchronized (dragSource) {
                this.motionListener = DnDEventMulticaster.remove(this.motionListener, dsml);
            }
        }
    }

    public DragSourceMotionListener[] getDragSourceMotionListeners() {
        return (DragSourceMotionListener[])this.getListeners(DragSourceMotionListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener l = null;
        if (listenerType == DragSourceListener.class) {
            l = this.listener;
        } else if (listenerType == DragSourceMotionListener.class) {
            l = this.motionListener;
        }
        return DnDEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    void processDragEnter(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragEnter(dsde);
        }
    }

    void processDragOver(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragOver(dsde);
        }
    }

    void processDropActionChanged(DragSourceDragEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dropActionChanged(dsde);
        }
    }

    void processDragExit(DragSourceEvent dse) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragExit(dse);
        }
    }

    void processDragDropEnd(DragSourceDropEvent dsde) {
        DragSourceListener dsl = this.listener;
        if (dsl != null) {
            dsl.dragDropEnd(dsde);
        }
    }

    void processDragMouseMoved(DragSourceDragEvent dsde) {
        DragSourceMotionListener dsml = this.motionListener;
        if (dsml != null) {
            dsml.dragMouseMoved(dsde);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(SerializationTester.test(this.flavorMap) ? this.flavorMap : null);
        DnDEventMulticaster.save(s, dragSourceListenerK, this.listener);
        DnDEventMulticaster.save(s, dragSourceMotionListenerK, this.motionListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object keyOrNull;
        s.defaultReadObject();
        this.flavorMap = (FlavorMap)s.readObject();
        if (this.flavorMap == null) {
            this.flavorMap = SystemFlavorMap.getDefaultFlavorMap();
        }
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if (dragSourceListenerK == key) {
                this.addDragSourceListener((DragSourceListener)s.readObject());
                continue;
            }
            if (dragSourceMotionListenerK == key) {
                this.addDragSourceMotionListener((DragSourceMotionListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    public static int getDragThreshold() {
        int ts = AccessController.doPrivileged(new GetIntegerAction("awt.dnd.drag.threshold", 0));
        if (ts > 0) {
            return ts;
        }
        Integer td = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        if (td != null) {
            return td;
        }
        return 5;
    }
}

