/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LayoutPath;
import java.awt.font.LineMetrics;
import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLine;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.CodePointIterator;
import sun.font.CoreMetrics;
import sun.font.FontResolver;
import sun.font.GraphicComponent;
import sun.font.LayoutPathImpl;

public final class TextLayout
implements Cloneable {
    private int characterCount;
    private boolean isVerticalLine = false;
    private byte baseline;
    private float[] baselineOffsets;
    private TextLine textLine;
    private TextLine.TextLineMetrics lineMetrics = null;
    private float visibleAdvance;
    private boolean cacheIsValid = false;
    private float justifyRatio;
    private static final float ALREADY_JUSTIFIED = -53.9f;
    private static float dx;
    private static float dy;
    private Rectangle2D naturalBounds = null;
    private Rectangle2D boundsRect = null;
    private boolean caretsInLigaturesAreAllowed = false;
    public static final CaretPolicy DEFAULT_CARET_POLICY;

    public TextLayout(String string, Font font, FontRenderContext frc) {
        char[] text;
        if (font == null) {
            throw new IllegalArgumentException("Null font passed to TextLayout constructor.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        Map<TextAttribute, ?> attributes = null;
        if (font.hasLayoutAttributes()) {
            attributes = font.getAttributes();
        }
        if (TextLayout.sameBaselineUpTo(font, text = string.toCharArray(), 0, text.length) == text.length) {
            this.fastInit(text, font, attributes, frc);
        } else {
            AttributedString as = attributes == null ? new AttributedString(string) : new AttributedString(string, attributes);
            as.addAttribute(TextAttribute.FONT, font);
            this.standardInit(as.getIterator(), text, frc);
        }
    }

    public TextLayout(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes, FontRenderContext frc) {
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Null map passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] text = string.toCharArray();
        Font font = TextLayout.singleFont(text, 0, text.length, attributes);
        if (font != null) {
            this.fastInit(text, font, attributes, frc);
        } else {
            AttributedString as = new AttributedString(string, attributes);
            this.standardInit(as.getIterator(), text, frc);
        }
    }

    private static Font singleFont(char[] text, int start, int limit, Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        if (attributes.get(TextAttribute.CHAR_REPLACEMENT) != null) {
            return null;
        }
        Font font = null;
        try {
            font = (Font)attributes.get(TextAttribute.FONT);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (font == null) {
            if (attributes.get(TextAttribute.FAMILY) != null) {
                font = Font.getFont(attributes);
                if (font.canDisplayUpTo(text, start, limit) != -1) {
                    return null;
                }
            } else {
                FontResolver resolver = FontResolver.getInstance();
                CodePointIterator iter = CodePointIterator.create(text, start, limit);
                int fontIndex = resolver.nextFontRunIndex(iter);
                if (iter.charIndex() == limit) {
                    font = resolver.getFont(fontIndex, attributes);
                }
            }
        }
        if (TextLayout.sameBaselineUpTo(font, text, start, limit) != limit) {
            return null;
        }
        return font;
    }

    public TextLayout(AttributedCharacterIterator text, FontRenderContext frc) {
        Map<AttributedCharacterIterator.Attribute, Object> attributes;
        Font font;
        int limit;
        if (text == null) {
            throw new IllegalArgumentException("Null iterator passed to TextLayout constructor.");
        }
        int start = text.getBeginIndex();
        if (start == (limit = text.getEndIndex())) {
            throw new IllegalArgumentException("Zero length iterator passed to TextLayout constructor.");
        }
        int len = limit - start;
        text.first();
        char[] chars = new char[len];
        int n = 0;
        char c = text.first();
        while (c != '\uffff') {
            chars[n++] = c;
            c = text.next();
        }
        text.first();
        if (text.getRunLimit() == limit && (font = TextLayout.singleFont(chars, 0, len, attributes = text.getAttributes())) != null) {
            this.fastInit(chars, font, attributes, frc);
            return;
        }
        this.standardInit(text, chars, frc);
    }

    TextLayout(TextLine textLine, byte baseline, float[] baselineOffsets, float justifyRatio) {
        this.characterCount = textLine.characterCount();
        this.baseline = baseline;
        this.baselineOffsets = baselineOffsets;
        this.textLine = textLine;
        this.justifyRatio = justifyRatio;
    }

    private void paragraphInit(byte aBaseline, CoreMetrics lm, Map<? extends AttributedCharacterIterator.Attribute, ?> paragraphAttrs, char[] text) {
        this.baseline = aBaseline;
        this.baselineOffsets = TextLine.getNormalizedOffsets(lm.baselineOffsets, this.baseline);
        this.justifyRatio = AttributeValues.getJustification(paragraphAttrs);
        NumericShaper shaper = AttributeValues.getNumericShaping(paragraphAttrs);
        if (shaper != null) {
            shaper.shape(text, 0, text.length);
        }
    }

    private void fastInit(char[] chars, Font font, Map<? extends AttributedCharacterIterator.Attribute, ?> attrs, FontRenderContext frc) {
        this.isVerticalLine = false;
        LineMetrics lm = font.getLineMetrics(chars, 0, chars.length, frc);
        CoreMetrics cm = CoreMetrics.get(lm);
        byte glyphBaseline = (byte)cm.baselineIndex;
        if (attrs == null) {
            this.baseline = glyphBaseline;
            this.baselineOffsets = cm.baselineOffsets;
            this.justifyRatio = 1.0f;
        } else {
            this.paragraphInit(glyphBaseline, cm, attrs, chars);
        }
        this.characterCount = chars.length;
        this.textLine = TextLine.fastCreateTextLine(frc, chars, font, cm, attrs);
    }

    private void standardInit(AttributedCharacterIterator text, char[] chars, FontRenderContext frc) {
        this.characterCount = chars.length;
        Map<AttributedCharacterIterator.Attribute, Object> paragraphAttrs = text.getAttributes();
        boolean haveFont = TextLine.advanceToFirstFont(text);
        if (haveFont) {
            Font defaultFont = TextLine.getFontAtCurrentPos(text);
            int charsStart = text.getIndex() - text.getBeginIndex();
            LineMetrics lm = defaultFont.getLineMetrics(chars, charsStart, charsStart + 1, frc);
            CoreMetrics cm = CoreMetrics.get(lm);
            this.paragraphInit((byte)cm.baselineIndex, cm, paragraphAttrs, chars);
        } else {
            GraphicAttribute graphic = (GraphicAttribute)paragraphAttrs.get(TextAttribute.CHAR_REPLACEMENT);
            byte defaultBaseline = TextLayout.getBaselineFromGraphic(graphic);
            CoreMetrics cm = GraphicComponent.createCoreMetrics(graphic);
            this.paragraphInit(defaultBaseline, cm, paragraphAttrs, chars);
        }
        this.textLine = TextLine.standardCreateTextLine(frc, text, chars, this.baselineOffsets);
    }

    private void ensureCache() {
        if (!this.cacheIsValid) {
            this.buildCache();
        }
    }

    private void buildCache() {
        this.lineMetrics = this.textLine.getMetrics();
        if (this.textLine.isDirectionLTR()) {
            int logIndex;
            int lastNonSpace;
            for (lastNonSpace = this.characterCount - 1; lastNonSpace != -1 && this.textLine.isCharSpace(logIndex = this.textLine.visualToLogical(lastNonSpace)); --lastNonSpace) {
            }
            if (lastNonSpace == this.characterCount - 1) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else if (lastNonSpace == -1) {
                this.visibleAdvance = 0.0f;
            } else {
                logIndex = this.textLine.visualToLogical(lastNonSpace);
                this.visibleAdvance = this.textLine.getCharLinePosition(logIndex) + this.textLine.getCharAdvance(logIndex);
            }
        } else {
            int logIndex;
            int leftmostNonSpace;
            for (leftmostNonSpace = 0; leftmostNonSpace != this.characterCount && this.textLine.isCharSpace(logIndex = this.textLine.visualToLogical(leftmostNonSpace)); ++leftmostNonSpace) {
            }
            if (leftmostNonSpace == this.characterCount) {
                this.visibleAdvance = 0.0f;
            } else if (leftmostNonSpace == 0) {
                this.visibleAdvance = this.lineMetrics.advance;
            } else {
                logIndex = this.textLine.visualToLogical(leftmostNonSpace);
                float pos = this.textLine.getCharLinePosition(logIndex);
                this.visibleAdvance = this.lineMetrics.advance - pos;
            }
        }
        this.naturalBounds = null;
        this.boundsRect = null;
        this.cacheIsValid = true;
    }

    private Rectangle2D getNaturalBounds() {
        this.ensureCache();
        if (this.naturalBounds == null) {
            this.naturalBounds = this.textLine.getItalicBounds();
        }
        return this.naturalBounds;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private void checkTextHit(TextHitInfo hit) {
        if (hit == null) {
            throw new IllegalArgumentException("TextHitInfo is null.");
        }
        if (hit.getInsertionIndex() < 0 || hit.getInsertionIndex() > this.characterCount) {
            throw new IllegalArgumentException("TextHitInfo is out of range");
        }
    }

    public TextLayout getJustifiedLayout(float justificationWidth) {
        int limit;
        if (justificationWidth <= 0.0f) {
            throw new IllegalArgumentException("justificationWidth <= 0 passed to TextLayout.getJustifiedLayout()");
        }
        if (this.justifyRatio == -53.9f) {
            throw new Error("Can't justify again.");
        }
        this.ensureCache();
        for (limit = this.characterCount; limit > 0 && this.textLine.isCharWhitespace(limit - 1); --limit) {
        }
        TextLine newLine = this.textLine.getJustifiedLine(justificationWidth, this.justifyRatio, 0, limit);
        if (newLine != null) {
            return new TextLayout(newLine, this.baseline, this.baselineOffsets, -53.9f);
        }
        return this;
    }

    protected void handleJustify(float justificationWidth) {
    }

    public byte getBaseline() {
        return this.baseline;
    }

    public float[] getBaselineOffsets() {
        float[] offsets = new float[this.baselineOffsets.length];
        System.arraycopy(this.baselineOffsets, 0, offsets, 0, offsets.length);
        return offsets;
    }

    public float getAdvance() {
        this.ensureCache();
        return this.lineMetrics.advance;
    }

    public float getVisibleAdvance() {
        this.ensureCache();
        return this.visibleAdvance;
    }

    public float getAscent() {
        this.ensureCache();
        return this.lineMetrics.ascent;
    }

    public float getDescent() {
        this.ensureCache();
        return this.lineMetrics.descent;
    }

    public float getLeading() {
        this.ensureCache();
        return this.lineMetrics.leading;
    }

    public Rectangle2D getBounds() {
        this.ensureCache();
        if (this.boundsRect == null) {
            Rectangle2D vb = this.textLine.getVisualBounds();
            if (dx != 0.0f || dy != 0.0f) {
                vb.setRect(vb.getX() - (double)dx, vb.getY() - (double)dy, vb.getWidth(), vb.getHeight());
            }
            this.boundsRect = vb;
        }
        Rectangle2D.Float bounds = new Rectangle2D.Float();
        ((Rectangle2D)bounds).setRect(this.boundsRect);
        return bounds;
    }

    public Rectangle getPixelBounds(FontRenderContext frc, float x, float y) {
        return this.textLine.getPixelBounds(frc, x, y);
    }

    public boolean isLeftToRight() {
        return this.textLine.isDirectionLTR();
    }

    public boolean isVertical() {
        return this.isVerticalLine;
    }

    public int getCharacterCount() {
        return this.characterCount;
    }

    private float[] getCaretInfo(int caret, Rectangle2D bounds, float[] info) {
        float bottom1X;
        float bottom2X;
        float top1X;
        float top2X;
        if (caret == 0 || caret == this.characterCount) {
            float pos;
            int logIndex;
            if (caret == this.characterCount) {
                logIndex = this.textLine.visualToLogical(this.characterCount - 1);
                pos = this.textLine.getCharLinePosition(logIndex) + this.textLine.getCharAdvance(logIndex);
            } else {
                logIndex = this.textLine.visualToLogical(caret);
                pos = this.textLine.getCharLinePosition(logIndex);
            }
            float angle = this.textLine.getCharAngle(logIndex);
            float shift = this.textLine.getCharShift(logIndex);
            top1X = top2X = (pos += angle * shift) + angle * this.textLine.getCharAscent(logIndex);
            bottom1X = bottom2X = pos - angle * this.textLine.getCharDescent(logIndex);
        } else {
            int logIndex = this.textLine.visualToLogical(caret - 1);
            float angle1 = this.textLine.getCharAngle(logIndex);
            float pos1 = this.textLine.getCharLinePosition(logIndex) + this.textLine.getCharAdvance(logIndex);
            if (angle1 != 0.0f) {
                top1X = (pos1 += angle1 * this.textLine.getCharShift(logIndex)) + angle1 * this.textLine.getCharAscent(logIndex);
                bottom1X = pos1 - angle1 * this.textLine.getCharDescent(logIndex);
            } else {
                top1X = bottom1X = pos1;
            }
            logIndex = this.textLine.visualToLogical(caret);
            float angle2 = this.textLine.getCharAngle(logIndex);
            float pos2 = this.textLine.getCharLinePosition(logIndex);
            if (angle2 != 0.0f) {
                top2X = (pos2 += angle2 * this.textLine.getCharShift(logIndex)) + angle2 * this.textLine.getCharAscent(logIndex);
                bottom2X = pos2 - angle2 * this.textLine.getCharDescent(logIndex);
            } else {
                top2X = bottom2X = pos2;
            }
        }
        float topX = (top1X + top2X) / 2.0f;
        float bottomX = (bottom1X + bottom2X) / 2.0f;
        if (info == null) {
            info = new float[2];
        }
        if (this.isVerticalLine) {
            info[1] = (float)((double)(topX - bottomX) / bounds.getWidth());
            info[0] = (float)((double)topX + (double)info[1] * bounds.getX());
        } else {
            info[1] = (float)((double)(topX - bottomX) / bounds.getHeight());
            info[0] = (float)((double)bottomX + (double)info[1] * bounds.getMaxY());
        }
        return info;
    }

    public float[] getCaretInfo(TextHitInfo hit, Rectangle2D bounds) {
        this.ensureCache();
        this.checkTextHit(hit);
        return this.getCaretInfoTestInternal(hit, bounds);
    }

    private float[] getCaretInfoTestInternal(TextHitInfo hit, Rectangle2D bounds) {
        double p2y;
        double p1y;
        double p1x;
        double p2x;
        boolean horiz;
        this.ensureCache();
        this.checkTextHit(hit);
        float[] info = new float[6];
        this.getCaretInfo(this.hitToCaret(hit), bounds, info);
        int charix = hit.getCharIndex();
        boolean lead = hit.isLeadingEdge();
        boolean ltr = this.textLine.isDirectionLTR();
        boolean bl = horiz = !this.isVertical();
        if (charix == -1 || charix == this.characterCount) {
            TextLine.TextLineMetrics m = this.textLine.getMetrics();
            boolean low = ltr == (charix == -1);
            double iangle = 0.0;
            if (horiz) {
                p2x = low ? 0.0 : (double)m.advance;
                p1x = p2x;
                p1y = -m.ascent;
                p2y = m.descent;
            } else {
                p2y = low ? 0.0 : (double)m.advance;
                p1y = p2y;
                p1x = m.descent;
                p2x = m.ascent;
            }
        } else {
            CoreMetrics thiscm = this.textLine.getCoreMetricsAt(charix);
            double iangle = thiscm.italicAngle;
            double ixbase = this.textLine.getCharLinePosition(charix, lead);
            if (thiscm.baselineIndex < 0) {
                TextLine.TextLineMetrics m = this.textLine.getMetrics();
                if (horiz) {
                    p1x = p2x = ixbase;
                    if (thiscm.baselineIndex == -1) {
                        p1y = -m.ascent;
                        p2y = p1y + (double)thiscm.height;
                    } else {
                        p2y = m.descent;
                        p1y = p2y - (double)thiscm.height;
                    }
                } else {
                    p1y = p2y = ixbase;
                    p1x = m.descent;
                    p2x = m.ascent;
                }
            } else {
                float bo = this.baselineOffsets[thiscm.baselineIndex];
                if (horiz) {
                    p1x = (ixbase += iangle * (double)thiscm.ssOffset) + iangle * (double)thiscm.ascent;
                    p2x = ixbase - iangle * (double)thiscm.descent;
                    p1y = bo - thiscm.ascent;
                    p2y = bo + thiscm.descent;
                } else {
                    p1y = (ixbase -= iangle * (double)thiscm.ssOffset) + iangle * (double)thiscm.ascent;
                    p2y = ixbase - iangle * (double)thiscm.descent;
                    p1x = bo + thiscm.ascent;
                    p2x = bo + thiscm.descent;
                }
            }
        }
        info[2] = (float)p1x;
        info[3] = (float)p1y;
        info[4] = (float)p2x;
        info[5] = (float)p2y;
        return info;
    }

    public float[] getCaretInfo(TextHitInfo hit) {
        return this.getCaretInfo(hit, this.getNaturalBounds());
    }

    private int hitToCaret(TextHitInfo hit) {
        int hitIndex = hit.getCharIndex();
        if (hitIndex < 0) {
            return this.textLine.isDirectionLTR() ? 0 : this.characterCount;
        }
        if (hitIndex >= this.characterCount) {
            return this.textLine.isDirectionLTR() ? this.characterCount : 0;
        }
        int visIndex = this.textLine.logicalToVisual(hitIndex);
        if (hit.isLeadingEdge() != this.textLine.isCharLTR(hitIndex)) {
            ++visIndex;
        }
        return visIndex;
    }

    private TextHitInfo caretToHit(int caret) {
        if (caret == 0 || caret == this.characterCount) {
            if (caret == this.characterCount == this.textLine.isDirectionLTR()) {
                return TextHitInfo.leading(this.characterCount);
            }
            return TextHitInfo.trailing(-1);
        }
        int charIndex = this.textLine.visualToLogical(caret);
        boolean leading = this.textLine.isCharLTR(charIndex);
        return leading ? TextHitInfo.leading(charIndex) : TextHitInfo.trailing(charIndex);
    }

    private boolean caretIsValid(int caret) {
        if (caret == this.characterCount || caret == 0) {
            return true;
        }
        int offset = this.textLine.visualToLogical(caret);
        if (!this.textLine.isCharLTR(offset) && this.textLine.isCharLTR(offset = this.textLine.visualToLogical(caret - 1))) {
            return true;
        }
        return this.textLine.caretAtOffsetIsValid(offset);
    }

    public TextHitInfo getNextRightHit(TextHitInfo hit) {
        this.ensureCache();
        this.checkTextHit(hit);
        int caret = this.hitToCaret(hit);
        if (caret == this.characterCount) {
            return null;
        }
        while (!this.caretIsValid(++caret)) {
        }
        return this.caretToHit(caret);
    }

    public TextHitInfo getNextRightHit(int offset, CaretPolicy policy) {
        TextHitInfo hit2;
        if (offset < 0 || offset > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextRightHit()");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextRightHit()");
        }
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        TextHitInfo nextHit = this.getNextRightHit(policy.getStrongCaret(hit1, hit2 = hit1.getOtherHit(), this));
        if (nextHit != null) {
            TextHitInfo otherHit = this.getVisualOtherHit(nextHit);
            return policy.getStrongCaret(otherHit, nextHit, this);
        }
        return null;
    }

    public TextHitInfo getNextRightHit(int offset) {
        return this.getNextRightHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getNextLeftHit(TextHitInfo hit) {
        this.ensureCache();
        this.checkTextHit(hit);
        int caret = this.hitToCaret(hit);
        if (caret == 0) {
            return null;
        }
        while (!this.caretIsValid(--caret)) {
        }
        return this.caretToHit(caret);
    }

    public TextHitInfo getNextLeftHit(int offset, CaretPolicy policy) {
        TextHitInfo hit2;
        if (policy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getNextLeftHit()");
        }
        if (offset < 0 || offset > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getNextLeftHit()");
        }
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        TextHitInfo nextHit = this.getNextLeftHit(policy.getStrongCaret(hit1, hit2 = hit1.getOtherHit(), this));
        if (nextHit != null) {
            TextHitInfo otherHit = this.getVisualOtherHit(nextHit);
            return policy.getStrongCaret(otherHit, nextHit, this);
        }
        return null;
    }

    public TextHitInfo getNextLeftHit(int offset) {
        return this.getNextLeftHit(offset, DEFAULT_CARET_POLICY);
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hit) {
        boolean leading;
        int charIndex;
        this.ensureCache();
        this.checkTextHit(hit);
        int hitCharIndex = hit.getCharIndex();
        if (hitCharIndex == -1 || hitCharIndex == this.characterCount) {
            int visIndex = this.textLine.isDirectionLTR() == (hitCharIndex == -1) ? 0 : this.characterCount - 1;
            charIndex = this.textLine.visualToLogical(visIndex);
            leading = this.textLine.isDirectionLTR() == (hitCharIndex == -1) ? this.textLine.isCharLTR(charIndex) : !this.textLine.isCharLTR(charIndex);
        } else {
            boolean movedToRight;
            int visIndex = this.textLine.logicalToVisual(hitCharIndex);
            if (this.textLine.isCharLTR(hitCharIndex) == hit.isLeadingEdge()) {
                --visIndex;
                movedToRight = false;
            } else {
                ++visIndex;
                movedToRight = true;
            }
            if (visIndex > -1 && visIndex < this.characterCount) {
                charIndex = this.textLine.visualToLogical(visIndex);
                leading = movedToRight == this.textLine.isCharLTR(charIndex);
            } else {
                charIndex = movedToRight == this.textLine.isDirectionLTR() ? this.characterCount : -1;
                leading = charIndex == this.characterCount;
            }
        }
        return leading ? TextHitInfo.leading(charIndex) : TextHitInfo.trailing(charIndex);
    }

    private double[] getCaretPath(TextHitInfo hit, Rectangle2D bounds) {
        float[] info = this.getCaretInfo(hit, bounds);
        return new double[]{info[2], info[3], info[4], info[5]};
    }

    private double[] getCaretPath(int caret, Rectangle2D bounds, boolean clipToBounds) {
        double[] dArray;
        double y1;
        double y0;
        double x1;
        double x0;
        float[] info = this.getCaretInfo(caret, bounds, null);
        double pos = info[0];
        double slope = info[1];
        double x2 = -3141.59;
        double y2 = -2.7;
        double left = bounds.getX();
        double right = left + bounds.getWidth();
        double top = bounds.getY();
        double bottom = top + bounds.getHeight();
        boolean threePoints = false;
        if (this.isVerticalLine) {
            if (slope >= 0.0) {
                x0 = left;
                x1 = right;
            } else {
                x1 = left;
                x0 = right;
            }
            y0 = pos + x0 * slope;
            y1 = pos + x1 * slope;
            if (clipToBounds) {
                if (y0 < top) {
                    if (slope <= 0.0 || y1 <= top) {
                        y0 = y1 = top;
                    } else {
                        threePoints = true;
                        y0 = top;
                        y2 = top;
                        x2 = x1 + (top - y1) / slope;
                        if (y1 > bottom) {
                            y1 = bottom;
                        }
                    }
                } else if (y1 > bottom) {
                    if (slope >= 0.0 || y0 >= bottom) {
                        y0 = y1 = bottom;
                    } else {
                        threePoints = true;
                        y1 = bottom;
                        y2 = bottom;
                        x2 = x0 + (bottom - x1) / slope;
                    }
                }
            }
        } else {
            if (slope >= 0.0) {
                y0 = bottom;
                y1 = top;
            } else {
                y1 = bottom;
                y0 = top;
            }
            x0 = pos - y0 * slope;
            x1 = pos - y1 * slope;
            if (clipToBounds) {
                if (x0 < left) {
                    if (slope <= 0.0 || x1 <= left) {
                        x0 = x1 = left;
                    } else {
                        threePoints = true;
                        x0 = left;
                        x2 = left;
                        y2 = y1 - (left - x1) / slope;
                        if (x1 > right) {
                            x1 = right;
                        }
                    }
                } else if (x1 > right) {
                    if (slope >= 0.0 || x0 >= right) {
                        x0 = x1 = right;
                    } else {
                        threePoints = true;
                        x1 = right;
                        x2 = right;
                        y2 = y0 - (right - x0) / slope;
                    }
                }
            }
        }
        if (threePoints) {
            double[] dArray2 = new double[6];
            dArray2[0] = x0;
            dArray2[1] = y0;
            dArray2[2] = x2;
            dArray2[3] = y2;
            dArray2[4] = x1;
            dArray = dArray2;
            dArray2[5] = y1;
        } else {
            double[] dArray3 = new double[4];
            dArray3[0] = x0;
            dArray3[1] = y0;
            dArray3[2] = x1;
            dArray = dArray3;
            dArray3[3] = y1;
        }
        return dArray;
    }

    private static GeneralPath pathToShape(double[] path, boolean close, LayoutPathImpl lp) {
        GeneralPath result = new GeneralPath(0, path.length);
        result.moveTo((float)path[0], (float)path[1]);
        for (int i = 2; i < path.length; i += 2) {
            result.lineTo((float)path[i], (float)path[i + 1]);
        }
        if (close) {
            result.closePath();
        }
        if (lp != null) {
            result = (GeneralPath)lp.mapShape(result);
        }
        return result;
    }

    public Shape getCaretShape(TextHitInfo hit, Rectangle2D bounds) {
        this.ensureCache();
        this.checkTextHit(hit);
        if (bounds == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaret()");
        }
        return TextLayout.pathToShape(this.getCaretPath(hit, bounds), false, this.textLine.getLayoutPath());
    }

    public Shape getCaretShape(TextHitInfo hit) {
        return this.getCaretShape(hit, this.getNaturalBounds());
    }

    private TextHitInfo getStrongHit(TextHitInfo hit1, TextHitInfo hit2) {
        byte hit2Level;
        byte hit1Level = this.getCharacterLevel(hit1.getCharIndex());
        if (hit1Level == (hit2Level = this.getCharacterLevel(hit2.getCharIndex()))) {
            if (hit2.isLeadingEdge() && !hit1.isLeadingEdge()) {
                return hit2;
            }
            return hit1;
        }
        return hit1Level < hit2Level ? hit1 : hit2;
    }

    public byte getCharacterLevel(int index) {
        if (index < -1 || index > this.characterCount) {
            throw new IllegalArgumentException("Index is out of range in getCharacterLevel.");
        }
        this.ensureCache();
        if (index == -1 || index == this.characterCount) {
            return (byte)(!this.textLine.isDirectionLTR() ? 1 : 0);
        }
        return this.textLine.getCharLevel(index);
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, CaretPolicy policy) {
        this.ensureCache();
        if (offset < 0 || offset > this.characterCount) {
            throw new IllegalArgumentException("Offset out of bounds in TextLayout.getCaretShapes()");
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getCaretShapes()");
        }
        if (policy == null) {
            throw new IllegalArgumentException("Null CaretPolicy passed to TextLayout.getCaretShapes()");
        }
        Shape[] result = new Shape[2];
        TextHitInfo hit = TextHitInfo.afterOffset(offset);
        int hitCaret = this.hitToCaret(hit);
        LayoutPathImpl lp = this.textLine.getLayoutPath();
        GeneralPath hitShape = TextLayout.pathToShape(this.getCaretPath(hit, bounds), false, lp);
        TextHitInfo otherHit = hit.getOtherHit();
        int otherCaret = this.hitToCaret(otherHit);
        if (hitCaret == otherCaret) {
            result[0] = hitShape;
        } else {
            GeneralPath otherShape = TextLayout.pathToShape(this.getCaretPath(otherHit, bounds), false, lp);
            TextHitInfo strongHit = policy.getStrongCaret(hit, otherHit, this);
            boolean hitIsStrong = strongHit.equals(hit);
            if (hitIsStrong) {
                result[0] = hitShape;
                result[1] = otherShape;
            } else {
                result[0] = otherShape;
                result[1] = hitShape;
            }
        }
        return result;
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds) {
        return this.getCaretShapes(offset, bounds, DEFAULT_CARET_POLICY);
    }

    public Shape[] getCaretShapes(int offset) {
        return this.getCaretShapes(offset, this.getNaturalBounds(), DEFAULT_CARET_POLICY);
    }

    private GeneralPath boundingShape(double[] path0, double[] path1) {
        int increment;
        int limit;
        int start;
        boolean sameDirection;
        GeneralPath result = TextLayout.pathToShape(path0, false, null);
        if (this.isVerticalLine) {
            sameDirection = path0[1] > path0[path0.length - 1] == path1[1] > path1[path1.length - 1];
        } else {
            boolean bl = sameDirection = path0[0] > path0[path0.length - 2] == path1[0] > path1[path1.length - 2];
        }
        if (sameDirection) {
            start = path1.length - 2;
            limit = -2;
            increment = -2;
        } else {
            start = 0;
            limit = path1.length;
            increment = 2;
        }
        for (int i = start; i != limit; i += increment) {
            result.lineTo((float)path1[i], (float)path1[i + 1]);
        }
        result.closePath();
        return result;
    }

    private GeneralPath caretBoundingShape(int caret0, int caret1, Rectangle2D bounds) {
        if (caret0 > caret1) {
            int temp = caret0;
            caret0 = caret1;
            caret1 = temp;
        }
        return this.boundingShape(this.getCaretPath(caret0, bounds, true), this.getCaretPath(caret1, bounds, true));
    }

    private GeneralPath leftShape(Rectangle2D bounds) {
        double[] path0 = this.isVerticalLine ? new double[]{bounds.getX(), bounds.getY(), bounds.getX() + bounds.getWidth(), bounds.getY()} : new double[]{bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX(), bounds.getY()};
        double[] path1 = this.getCaretPath(0, bounds, true);
        return this.boundingShape(path0, path1);
    }

    private GeneralPath rightShape(Rectangle2D bounds) {
        double[] path1 = this.isVerticalLine ? new double[]{bounds.getX(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight()} : new double[]{bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight(), bounds.getX() + bounds.getWidth(), bounds.getY()};
        double[] path0 = this.getCaretPath(this.characterCount, bounds, true);
        return this.boundingShape(path0, path1);
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        this.ensureCache();
        this.checkTextHit(firstEndpoint);
        this.checkTextHit(secondEndpoint);
        boolean[] included = new boolean[this.characterCount];
        int startIndex = this.hitToCaret(firstEndpoint);
        int limitIndex = this.hitToCaret(secondEndpoint);
        if (startIndex > limitIndex) {
            int t = startIndex;
            startIndex = limitIndex;
            limitIndex = t;
        }
        if (startIndex < limitIndex) {
            for (int visIndex = startIndex; visIndex < limitIndex; ++visIndex) {
                included[this.textLine.visualToLogical((int)visIndex)] = true;
            }
        }
        int count = 0;
        boolean inrun = false;
        for (int i = 0; i < this.characterCount; ++i) {
            if (included[i] == inrun) continue;
            boolean bl = inrun = !inrun;
            if (!inrun) continue;
            ++count;
        }
        int[] ranges = new int[count * 2];
        count = 0;
        inrun = false;
        for (int i = 0; i < this.characterCount; ++i) {
            if (included[i] == inrun) continue;
            ranges[count++] = i;
            inrun = !inrun;
        }
        if (inrun) {
            ranges[count++] = this.characterCount;
        }
        return ranges;
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint, Rectangle2D bounds) {
        LayoutPathImpl lp;
        GeneralPath rs;
        GeneralPath ls;
        this.ensureCache();
        this.checkTextHit(firstEndpoint);
        this.checkTextHit(secondEndpoint);
        if (bounds == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getVisualHighlightShape()");
        }
        GeneralPath result = new GeneralPath(0);
        int firstCaret = this.hitToCaret(firstEndpoint);
        int secondCaret = this.hitToCaret(secondEndpoint);
        result.append(this.caretBoundingShape(firstCaret, secondCaret, bounds), false);
        if (!(firstCaret != 0 && secondCaret != 0 || (ls = this.leftShape(bounds)).getBounds().isEmpty())) {
            result.append(ls, false);
        }
        if (!(firstCaret != this.characterCount && secondCaret != this.characterCount || (rs = this.rightShape(bounds)).getBounds().isEmpty())) {
            result.append(rs, false);
        }
        if ((lp = this.textLine.getLayoutPath()) != null) {
            result = (GeneralPath)lp.mapShape(result);
        }
        return result;
    }

    public Shape getVisualHighlightShape(TextHitInfo firstEndpoint, TextHitInfo secondEndpoint) {
        return this.getVisualHighlightShape(firstEndpoint, secondEndpoint, this.getNaturalBounds());
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds) {
        LayoutPathImpl lp;
        if (bounds == null) {
            throw new IllegalArgumentException("Null Rectangle2D passed to TextLayout.getLogicalHighlightShape()");
        }
        this.ensureCache();
        if (firstEndpoint > secondEndpoint) {
            int t = firstEndpoint;
            firstEndpoint = secondEndpoint;
            secondEndpoint = t;
        }
        if (firstEndpoint < 0 || secondEndpoint > this.characterCount) {
            throw new IllegalArgumentException("Range is invalid in TextLayout.getLogicalHighlightShape()");
        }
        GeneralPath result = new GeneralPath(0);
        int[] carets = new int[10];
        int count = 0;
        if (firstEndpoint < secondEndpoint) {
            int logIndex = firstEndpoint;
            do {
                carets[count++] = this.hitToCaret(TextHitInfo.leading(logIndex));
                boolean ltr = this.textLine.isCharLTR(logIndex);
                while (++logIndex < secondEndpoint && this.textLine.isCharLTR(logIndex) == ltr) {
                }
                int hitCh = logIndex;
                carets[count++] = this.hitToCaret(TextHitInfo.trailing(hitCh - 1));
                if (count != carets.length) continue;
                int[] temp = new int[carets.length + 10];
                System.arraycopy(carets, 0, temp, 0, count);
                carets = temp;
            } while (logIndex < secondEndpoint);
        } else {
            count = 2;
            carets[0] = carets[1] = this.hitToCaret(TextHitInfo.leading(firstEndpoint));
        }
        for (int i = 0; i < count; i += 2) {
            result.append(this.caretBoundingShape(carets[i], carets[i + 1], bounds), false);
        }
        if (firstEndpoint != secondEndpoint) {
            GeneralPath rs;
            GeneralPath ls;
            if ((this.textLine.isDirectionLTR() && firstEndpoint == 0 || !this.textLine.isDirectionLTR() && secondEndpoint == this.characterCount) && !(ls = this.leftShape(bounds)).getBounds().isEmpty()) {
                result.append(ls, false);
            }
            if ((this.textLine.isDirectionLTR() && secondEndpoint == this.characterCount || !this.textLine.isDirectionLTR() && firstEndpoint == 0) && !(rs = this.rightShape(bounds)).getBounds().isEmpty()) {
                result.append(rs, false);
            }
        }
        if ((lp = this.textLine.getLayoutPath()) != null) {
            result = (GeneralPath)lp.mapShape(result);
        }
        return result;
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint) {
        return this.getLogicalHighlightShape(firstEndpoint, secondEndpoint, this.getNaturalBounds());
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        LayoutPathImpl lp;
        this.ensureCache();
        if (firstEndpoint > secondEndpoint) {
            int t = firstEndpoint;
            firstEndpoint = secondEndpoint;
            secondEndpoint = t;
        }
        if (firstEndpoint < 0 || secondEndpoint > this.characterCount) {
            throw new IllegalArgumentException("Invalid range passed to TextLayout.getBlackBoxBounds()");
        }
        GeneralPath result = new GeneralPath(1);
        if (firstEndpoint < this.characterCount) {
            for (int logIndex = firstEndpoint; logIndex < secondEndpoint; ++logIndex) {
                Rectangle2D r = this.textLine.getCharBounds(logIndex);
                if (r.isEmpty()) continue;
                result.append(r, false);
            }
        }
        if (dx != 0.0f || dy != 0.0f) {
            AffineTransform tx = AffineTransform.getTranslateInstance(dx, dy);
            result = (GeneralPath)tx.createTransformedShape(result);
        }
        if ((lp = this.textLine.getLayoutPath()) != null) {
            result = (GeneralPath)lp.mapShape(result);
        }
        return result;
    }

    private float caretToPointDistance(float[] caretInfo, float x, float y) {
        float lineDistance = this.isVerticalLine ? y : x;
        float distanceOffBaseline = this.isVerticalLine ? -x : y;
        return lineDistance - caretInfo[0] + distanceOffBaseline * caretInfo[1];
    }

    public TextHitInfo hitTestChar(float x, float y, Rectangle2D bounds) {
        boolean leading;
        LayoutPathImpl lp = this.textLine.getLayoutPath();
        boolean prev = false;
        if (lp != null) {
            Point2D.Float pt = new Point2D.Float(x, y);
            prev = lp.pointToPath(pt, pt);
            x = pt.x;
            y = pt.y;
        }
        if (this.isVertical()) {
            if ((double)y < bounds.getMinY()) {
                return TextHitInfo.leading(0);
            }
            if ((double)y >= bounds.getMaxY()) {
                return TextHitInfo.trailing(this.characterCount - 1);
            }
        } else {
            if ((double)x < bounds.getMinX()) {
                return this.isLeftToRight() ? TextHitInfo.leading(0) : TextHitInfo.trailing(this.characterCount - 1);
            }
            if ((double)x >= bounds.getMaxX()) {
                return this.isLeftToRight() ? TextHitInfo.trailing(this.characterCount - 1) : TextHitInfo.leading(0);
            }
        }
        double distance = Double.MAX_VALUE;
        int index = 0;
        int trail = -1;
        CoreMetrics lcm = null;
        float icx = 0.0f;
        float icy = 0.0f;
        float ia = 0.0f;
        float cy = 0.0f;
        float dya = 0.0f;
        float ydsq = 0.0f;
        for (int i = 0; i < this.characterCount; ++i) {
            double nd;
            CoreMetrics cm;
            if (!this.textLine.caretAtOffsetIsValid(i)) continue;
            if (trail == -1) {
                trail = i;
            }
            if ((cm = this.textLine.getCoreMetricsAt(i)) != lcm) {
                lcm = cm;
                cy = cm.baselineIndex == -1 ? -(this.textLine.getMetrics().ascent - cm.ascent) + cm.ssOffset : (cm.baselineIndex == -2 ? this.textLine.getMetrics().descent - cm.descent + cm.ssOffset : cm.effectiveBaselineOffset(this.baselineOffsets) + cm.ssOffset);
                float dy = (cm.descent - cm.ascent) / 2.0f - cy;
                dya = dy * cm.italicAngle;
                ydsq = ((cy += dy) - y) * (cy - y);
            }
            float cx = this.textLine.getCharXPosition(i);
            float ca = this.textLine.getCharAdvance(i);
            float dx = ca / 2.0f;
            if (!((nd = Math.sqrt(4.0f * ((cx += dx - dya) - x) * (cx - x) + ydsq)) < distance)) continue;
            distance = nd;
            index = i;
            trail = -1;
            icx = cx;
            icy = cy;
            ia = cm.italicAngle;
        }
        boolean left = x < icx - (y - icy) * ia;
        boolean bl = leading = this.textLine.isCharLTR(index) == left;
        if (trail == -1) {
            trail = this.characterCount;
        }
        TextHitInfo result = leading ? TextHitInfo.leading(index) : TextHitInfo.trailing(trail - 1);
        return result;
    }

    public TextHitInfo hitTestChar(float x, float y) {
        return this.hitTestChar(x, y, this.getNaturalBounds());
    }

    public boolean equals(TextLayout rhs) {
        return this.equals((Object)rhs);
    }

    public String toString() {
        this.ensureCache();
        return this.textLine.toString();
    }

    public void draw(Graphics2D g2, float x, float y) {
        if (g2 == null) {
            throw new IllegalArgumentException("Null Graphics2D passed to TextLayout.draw()");
        }
        this.textLine.draw(g2, x - dx, y - dy);
    }

    TextLine getTextLineForTesting() {
        return this.textLine;
    }

    private static int sameBaselineUpTo(Font font, char[] text, int start, int limit) {
        return limit;
    }

    static byte getBaselineFromGraphic(GraphicAttribute graphic) {
        byte alignment = (byte)graphic.getAlignment();
        if (alignment == -2 || alignment == -1) {
            return 0;
        }
        return alignment;
    }

    public Shape getOutline(AffineTransform tx) {
        this.ensureCache();
        Shape result = this.textLine.getOutline(tx);
        LayoutPathImpl lp = this.textLine.getLayoutPath();
        if (lp != null) {
            result = lp.mapShape(result);
        }
        return result;
    }

    public LayoutPath getLayoutPath() {
        return this.textLine.getLayoutPath();
    }

    public void hitToPoint(TextHitInfo hit, Point2D point) {
        boolean ltr;
        if (hit == null || point == null) {
            throw new NullPointerException((hit == null ? "hit" : "point") + " can't be null");
        }
        this.ensureCache();
        this.checkTextHit(hit);
        float adv = 0.0f;
        float off = 0.0f;
        int ix = hit.getCharIndex();
        boolean leading = hit.isLeadingEdge();
        if (ix == -1 || ix == this.textLine.characterCount()) {
            ltr = this.textLine.isDirectionLTR();
            adv = ltr == (ix == -1) ? 0.0f : this.lineMetrics.advance;
        } else {
            ltr = this.textLine.isCharLTR(ix);
            adv = this.textLine.getCharLinePosition(ix, leading);
            off = this.textLine.getCharYPosition(ix);
        }
        point.setLocation(adv, off);
        LayoutPathImpl lp = this.textLine.getLayoutPath();
        if (lp != null) {
            lp.pathToPoint(point, ltr != leading, point);
        }
    }

    static {
        DEFAULT_CARET_POLICY = new CaretPolicy();
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo hit1, TextHitInfo hit2, TextLayout layout) {
            return layout.getStrongHit(hit1, hit2);
        }
    }
}

