/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BufferedImageFilter
extends ImageFilter
implements Cloneable {
    BufferedImageOp bufferedImageOp;
    ColorModel model;
    int width;
    int height;
    byte[] bytePixels;
    int[] intPixels;

    public BufferedImageFilter(BufferedImageOp op) {
        if (op == null) {
            throw new NullPointerException("Operation cannot be null");
        }
        this.bufferedImageOp = op;
    }

    public BufferedImageOp getBufferedImageOp() {
        return this.bufferedImageOp;
    }

    @Override
    public void setDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            this.imageComplete(3);
            return;
        }
        this.width = width;
        this.height = height;
    }

    @Override
    public void setColorModel(ColorModel model) {
        this.model = model;
    }

    private void convertToRGB() {
        int size = this.width * this.height;
        int[] newpixels = new int[size];
        if (this.bytePixels != null) {
            for (int i = 0; i < size; ++i) {
                newpixels[i] = this.model.getRGB(this.bytePixels[i] & 0xFF);
            }
        } else if (this.intPixels != null) {
            for (int i = 0; i < size; ++i) {
                newpixels[i] = this.model.getRGB(this.intPixels[i]);
            }
        }
        this.bytePixels = null;
        this.intPixels = newpixels;
        this.model = ColorModel.getRGBdefault();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int diff;
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException("Width (" + w + ") and height (" + h + ") must be > 0");
        }
        if (w == 0 || h == 0) {
            return;
        }
        if (y < 0) {
            diff = -y;
            if (diff >= h) {
                return;
            }
            off += scansize * diff;
            y += diff;
            h -= diff;
        }
        if (y + h > this.height && (h = this.height - y) <= 0) {
            return;
        }
        if (x < 0) {
            diff = -x;
            if (diff >= w) {
                return;
            }
            off += diff;
            x += diff;
            w -= diff;
        }
        if (x + w > this.width && (w = this.width - x) <= 0) {
            return;
        }
        int dstPtr = y * this.width + x;
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.width * this.height];
                this.model = model;
            } else if (this.model != model) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                for (int sh = h; sh > 0; --sh) {
                    System.arraycopy(pixels, off, this.bytePixels, dstPtr, w);
                    off += scansize;
                    dstPtr += this.width;
                }
            }
        }
        if (this.intPixels != null) {
            int dstRem = this.width - w;
            int srcRem = scansize - w;
            for (int sh = h; sh > 0; --sh) {
                for (int sw = w; sw > 0; --sw) {
                    this.intPixels[dstPtr++] = model.getRGB(pixels[off++] & 0xFF);
                }
                off += srcRem;
                dstPtr += dstRem;
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int diff;
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException("Width (" + w + ") and height (" + h + ") must be > 0");
        }
        if (w == 0 || h == 0) {
            return;
        }
        if (y < 0) {
            diff = -y;
            if (diff >= h) {
                return;
            }
            off += scansize * diff;
            y += diff;
            h -= diff;
        }
        if (y + h > this.height && (h = this.height - y) <= 0) {
            return;
        }
        if (x < 0) {
            diff = -x;
            if (diff >= w) {
                return;
            }
            off += diff;
            x += diff;
            w -= diff;
        }
        if (x + w > this.width && (w = this.width - x) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.width * this.height];
                this.model = model;
            } else {
                this.convertToRGB();
            }
        }
        int dstPtr = y * this.width + x;
        if (this.model == model) {
            for (int sh = h; sh > 0; --sh) {
                System.arraycopy(pixels, off, this.intPixels, dstPtr, w);
                off += scansize;
                dstPtr += this.width;
            }
        } else {
            if (this.model != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int dstRem = this.width - w;
            int srcRem = scansize - w;
            for (int sh = h; sh > 0; --sh) {
                for (int sw = w; sw > 0; --sw) {
                    this.intPixels[dstPtr++] = model.getRGB(pixels[off++]);
                }
                off += srcRem;
                dstPtr += dstRem;
            }
        }
    }

    @Override
    public void imageComplete(int status) {
        switch (status) {
            case 1: 
            case 4: {
                this.model = null;
                this.width = -1;
                this.height = -1;
                this.intPixels = null;
                this.bytePixels = null;
                break;
            }
            case 2: 
            case 3: {
                WritableRaster wr;
                if (this.width <= 0 || this.height <= 0) break;
                if (this.model instanceof DirectColorModel) {
                    if (this.intPixels == null) break;
                    wr = this.createDCMraster();
                } else if (this.model instanceof IndexColorModel) {
                    int[] bandOffsets = new int[]{0};
                    if (this.bytePixels == null) break;
                    DataBufferByte db = new DataBufferByte(this.bytePixels, this.width * this.height);
                    wr = Raster.createInterleavedRaster(db, this.width, this.height, this.width, 1, bandOffsets, null);
                } else {
                    this.convertToRGB();
                    if (this.intPixels == null) break;
                    wr = this.createDCMraster();
                }
                BufferedImage bi = new BufferedImage(this.model, wr, this.model.isAlphaPremultiplied(), null);
                bi = this.bufferedImageOp.filter(bi, null);
                WritableRaster r = bi.getRaster();
                ColorModel cm = bi.getColorModel();
                int w = r.getWidth();
                int h = r.getHeight();
                this.consumer.setDimensions(w, h);
                this.consumer.setColorModel(cm);
                if (cm instanceof DirectColorModel) {
                    DataBufferInt db = (DataBufferInt)r.getDataBuffer();
                    this.consumer.setPixels(0, 0, w, h, cm, db.getData(), 0, w);
                    break;
                }
                if (cm instanceof IndexColorModel) {
                    DataBufferByte db = (DataBufferByte)r.getDataBuffer();
                    this.consumer.setPixels(0, 0, w, h, cm, db.getData(), 0, w);
                    break;
                }
                throw new InternalError("Unknown color model " + cm);
            }
        }
        this.consumer.imageComplete(status);
    }

    private WritableRaster createDCMraster() {
        DirectColorModel dcm = (DirectColorModel)this.model;
        boolean hasAlpha = this.model.hasAlpha();
        int[] bandMasks = new int[3 + (hasAlpha ? 1 : 0)];
        bandMasks[0] = dcm.getRedMask();
        bandMasks[1] = dcm.getGreenMask();
        bandMasks[2] = dcm.getBlueMask();
        if (hasAlpha) {
            bandMasks[3] = dcm.getAlphaMask();
        }
        DataBufferInt db = new DataBufferInt(this.intPixels, this.width * this.height);
        WritableRaster wr = Raster.createPackedRaster(db, this.width, this.height, this.width, bandMasks, null);
        return wr;
    }
}

