/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MemoryImageSource
implements ImageProducer {
    int width;
    int height;
    ColorModel model;
    Object pixels;
    int pixeloffset;
    int pixelscan;
    Hashtable<?, ?> properties;
    Vector<ImageConsumer> theConsumers = new Vector();
    boolean animating;
    boolean fullbuffers;

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        this.initialize(w, h, cm, pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        this.initialize(w, h, cm, pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    private void initialize(int w, int h, ColorModel cm, Object pix, int off, int scan, Hashtable<?, ?> props) {
        this.width = w;
        this.height = h;
        this.model = cm;
        this.pixels = pix;
        this.pixeloffset = off;
        this.pixelscan = scan;
        if (props == null) {
            props = new Hashtable();
        }
        this.properties = props;
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan) {
        this.initialize(w, h, ColorModel.getRGBdefault(), pix, off, scan, null);
    }

    public MemoryImageSource(int w, int h, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        this.initialize(w, h, ColorModel.getRGBdefault(), pix, off, scan, props);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        block5: {
            if (this.theConsumers.contains(ic)) {
                return;
            }
            this.theConsumers.addElement(ic);
            try {
                this.initConsumer(ic);
                this.sendPixels(ic, 0, 0, this.width, this.height);
                if (this.isConsumer(ic)) {
                    ic.imageComplete(this.animating ? 2 : 3);
                    if (!this.animating && this.isConsumer(ic)) {
                        ic.imageComplete(1);
                        this.removeConsumer(ic);
                    }
                }
            }
            catch (Exception e) {
                if (!this.isConsumer(ic)) break block5;
                ic.imageComplete(1);
            }
        }
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.theConsumers.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.theConsumers.removeElement(ic);
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public synchronized void setAnimated(boolean animated) {
        this.animating = animated;
        if (!this.animating) {
            Enumeration<ImageConsumer> enum_ = this.theConsumers.elements();
            while (enum_.hasMoreElements()) {
                ImageConsumer ic = enum_.nextElement();
                ic.imageComplete(3);
                if (!this.isConsumer(ic)) continue;
                ic.imageComplete(1);
            }
            this.theConsumers.removeAllElements();
        }
    }

    public synchronized void setFullBufferUpdates(boolean fullbuffers) {
        if (this.fullbuffers == fullbuffers) {
            return;
        }
        this.fullbuffers = fullbuffers;
        if (this.animating) {
            Enumeration<ImageConsumer> enum_ = this.theConsumers.elements();
            while (enum_.hasMoreElements()) {
                ImageConsumer ic = enum_.nextElement();
                ic.setHints(fullbuffers ? 6 : 1);
            }
        }
    }

    public void newPixels() {
        this.newPixels(0, 0, this.width, this.height, true);
    }

    public synchronized void newPixels(int x, int y, int w, int h) {
        this.newPixels(x, y, w, h, true);
    }

    public synchronized void newPixels(int x, int y, int w, int h, boolean framenotify) {
        if (this.animating) {
            if (this.fullbuffers) {
                y = 0;
                x = 0;
                w = this.width;
                h = this.height;
            } else {
                if (x < 0) {
                    w += x;
                    x = 0;
                }
                if (x + w > this.width) {
                    w = this.width - x;
                }
                if (y < 0) {
                    h += y;
                    y = 0;
                }
                if (y + h > this.height) {
                    h = this.height - y;
                }
            }
            if (!(w > 0 && h > 0 || framenotify)) {
                return;
            }
            Enumeration<ImageConsumer> enum_ = this.theConsumers.elements();
            while (enum_.hasMoreElements()) {
                ImageConsumer ic = enum_.nextElement();
                if (w > 0 && h > 0) {
                    this.sendPixels(ic, x, y, w, h);
                }
                if (!framenotify || !this.isConsumer(ic)) continue;
                ic.imageComplete(2);
            }
        }
    }

    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        this.newPixels();
    }

    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        this.newPixels();
    }

    private void initConsumer(ImageConsumer ic) {
        if (this.isConsumer(ic)) {
            ic.setDimensions(this.width, this.height);
        }
        if (this.isConsumer(ic)) {
            ic.setProperties(this.properties);
        }
        if (this.isConsumer(ic)) {
            ic.setColorModel(this.model);
        }
        if (this.isConsumer(ic)) {
            ic.setHints(this.animating ? (this.fullbuffers ? 6 : 1) : 30);
        }
    }

    private void sendPixels(ImageConsumer ic, int x, int y, int w, int h) {
        int off = this.pixeloffset + this.pixelscan * y + x;
        if (this.isConsumer(ic)) {
            if (this.pixels instanceof byte[]) {
                ic.setPixels(x, y, w, h, this.model, (byte[])this.pixels, off, this.pixelscan);
            } else {
                ic.setPixels(x, y, w, h, this.model, (int[])this.pixels, off, this.pixelscan);
            }
        }
    }
}

