/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DialogOwner;
import javax.print.attribute.standard.Fidelity;
import sun.print.ServiceDialog;
import sun.print.SunAlternateMedia;

public class ServiceUI {
    public static PrintService printDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        Rectangle dlgBounds;
        DialogOwner dlgOwner;
        int defaultIndex = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals(defaultService)) continue;
                defaultIndex = i;
                break;
            }
            if (defaultIndex < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            defaultIndex = 0;
        }
        Window owner = (dlgOwner = (DialogOwner)attributes.get(DialogOwner.class)) != null ? dlgOwner.getOwner() : null;
        boolean setOnTop = dlgOwner != null && owner == null;
        Rectangle gcBounds = gc == null ? GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds() : gc.getBounds();
        ServiceDialog dialog = new ServiceDialog(gc, x += gcBounds.x, y += gcBounds.y, services, defaultIndex, flavor, attributes, owner);
        if (setOnTop) {
            try {
                dialog.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (!gcBounds.contains(dlgBounds = dialog.getBounds())) {
            if (dlgBounds.x + dlgBounds.width > gcBounds.x + gcBounds.width) {
                x = gcBounds.x + gcBounds.width - dlgBounds.width > gcBounds.x ? gcBounds.x + gcBounds.width - dlgBounds.width : gcBounds.x;
            }
            if (dlgBounds.y + dlgBounds.height > gcBounds.y + gcBounds.height) {
                y = gcBounds.y + gcBounds.height - dlgBounds.height > gcBounds.y ? gcBounds.y + gcBounds.height - dlgBounds.height : gcBounds.y;
            }
            dialog.setBounds(x, y, dlgBounds.width, dlgBounds.height);
        }
        dialog.show();
        if (dialog.getStatus() == 1) {
            PrintRequestAttributeSet newas = dialog.getAttributes();
            Class<Destination> dstCategory = Destination.class;
            Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
            Class<Fidelity> fdCategory = Fidelity.class;
            if (attributes.containsKey(dstCategory) && !newas.containsKey(dstCategory)) {
                attributes.remove(dstCategory);
            }
            if (attributes.containsKey(amCategory) && !newas.containsKey(amCategory)) {
                attributes.remove(amCategory);
            }
            attributes.addAll(newas);
            Fidelity fd = (Fidelity)attributes.get(fdCategory);
            if (fd != null && fd == Fidelity.FIDELITY_TRUE) {
                ServiceUI.removeUnsupportedAttributes(dialog.getPrintService(), flavor, attributes);
            }
        }
        return dialog.getPrintService();
    }

    private static void removeUnsupportedAttributes(PrintService ps, DocFlavor flavor, AttributeSet aset) {
        AttributeSet asUnsupported = ps.getUnsupportedAttributes(flavor, aset);
        if (asUnsupported != null) {
            Attribute[] usAttrs = asUnsupported.toArray();
            for (int i = 0; i < usAttrs.length; ++i) {
                Class<? extends Attribute> category = usAttrs[i].getCategory();
                if (ps.isAttributeCategorySupported(category)) {
                    Attribute attr = (Attribute)ps.getDefaultAttributeValue(category);
                    if (attr != null) {
                        aset.add(attr);
                        continue;
                    }
                    aset.remove(category);
                    continue;
                }
                aset.remove(category);
            }
        }
    }
}

