/*
 * Decompiled with CFR 0.152.
 */
package javax.print;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import sun.awt.AppContext;

public abstract class StreamPrintServiceFactory {
    private static Services getServices() {
        Services services = (Services)AppContext.getAppContext().get(Services.class);
        if (services == null) {
            services = new Services();
            AppContext.getAppContext().put(Services.class, services);
        }
        return services;
    }

    private static ArrayList<StreamPrintServiceFactory> getListOfFactories() {
        return StreamPrintServiceFactory.getServices().listOfFactories;
    }

    private static ArrayList<StreamPrintServiceFactory> initListOfFactories() {
        ArrayList<StreamPrintServiceFactory> listOfFactories = new ArrayList<StreamPrintServiceFactory>();
        StreamPrintServiceFactory.getServices().listOfFactories = listOfFactories;
        return listOfFactories;
    }

    public static StreamPrintServiceFactory[] lookupStreamPrintServiceFactories(DocFlavor flavor, String outputMimeType) {
        ArrayList<StreamPrintServiceFactory> list = StreamPrintServiceFactory.getFactories(flavor, outputMimeType);
        return list.toArray(new StreamPrintServiceFactory[list.size()]);
    }

    public abstract String getOutputFormat();

    public abstract DocFlavor[] getSupportedDocFlavors();

    public abstract StreamPrintService getPrintService(OutputStream var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<StreamPrintServiceFactory> getAllFactories() {
        Class<StreamPrintServiceFactory> clazz = StreamPrintServiceFactory.class;
        synchronized (StreamPrintServiceFactory.class) {
            ArrayList<StreamPrintServiceFactory> listOfFactories = StreamPrintServiceFactory.getListOfFactories();
            if (listOfFactories != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return listOfFactories;
            }
            listOfFactories = StreamPrintServiceFactory.initListOfFactories();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        Iterator<StreamPrintServiceFactory> iterator = ServiceLoader.load(StreamPrintServiceFactory.class).iterator();
                        ArrayList<StreamPrintServiceFactory> lof = StreamPrintServiceFactory.getListOfFactories();
                        while (iterator.hasNext()) {
                            try {
                                lof.add(iterator.next());
                            }
                            catch (ServiceConfigurationError err) {
                                if (System.getSecurityManager() != null) {
                                    err.printStackTrace();
                                    continue;
                                }
                                throw err;
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            return listOfFactories;
        }
    }

    private static boolean isMember(DocFlavor flavor, DocFlavor[] flavors) {
        for (int f = 0; f < flavors.length; ++f) {
            if (!flavor.equals(flavors[f])) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<StreamPrintServiceFactory> getFactories(DocFlavor flavor, String outType) {
        if (flavor == null && outType == null) {
            return StreamPrintServiceFactory.getAllFactories();
        }
        ArrayList<StreamPrintServiceFactory> list = new ArrayList<StreamPrintServiceFactory>();
        for (StreamPrintServiceFactory factory : StreamPrintServiceFactory.getAllFactories()) {
            if (outType != null && !outType.equalsIgnoreCase(factory.getOutputFormat()) || flavor != null && !StreamPrintServiceFactory.isMember(flavor, factory.getSupportedDocFlavors())) continue;
            list.add(factory);
        }
        return list;
    }

    static class Services {
        private ArrayList<StreamPrintServiceFactory> listOfFactories = null;

        Services() {
        }
    }
}

