/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;

public class AudioFileFormat {
    private final Type type;
    private final int byteLength;
    private final AudioFormat format;
    private final int frameLength;
    private HashMap<String, Object> properties;

    protected AudioFileFormat(Type type, int byteLength, AudioFormat format, int frameLength) {
        this.type = type;
        this.byteLength = byteLength;
        this.format = format;
        this.frameLength = frameLength;
        this.properties = null;
    }

    public AudioFileFormat(Type type, AudioFormat format, int frameLength) {
        this(type, -1, format, frameLength);
    }

    public AudioFileFormat(Type type, AudioFormat format, int frameLength, Map<String, Object> properties) {
        this(type, -1, format, frameLength);
        this.properties = new HashMap<String, Object>(properties);
    }

    public Type getType() {
        return this.type;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public Map<String, Object> properties() {
        Map ret = this.properties == null ? new HashMap(0) : (Map)this.properties.clone();
        return Collections.unmodifiableMap(ret);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.type != null) {
            buf.append(this.type.toString() + " (." + this.type.getExtension() + ") file");
        } else {
            buf.append("unknown file format");
        }
        if (this.byteLength != -1) {
            buf.append(", byte length: " + this.byteLength);
        }
        buf.append(", data format: " + this.format);
        if (this.frameLength != -1) {
            buf.append(", frame length: " + this.frameLength);
        }
        return new String(buf);
    }

    public static class Type {
        public static final Type WAVE = new Type("WAVE", "wav");
        public static final Type AU = new Type("AU", "au");
        public static final Type AIFF = new Type("AIFF", "aif");
        public static final Type AIFC = new Type("AIFF-C", "aifc");
        public static final Type SND = new Type("SND", "snd");
        private final String name;
        private final String extension;

        public Type(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Type)) {
                return false;
            }
            return Objects.equals(this.name, ((Type)obj).name);
        }

        public final int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public final String toString() {
            return this.name;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

