/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;

public class GroupLayout
implements LayoutManager2 {
    private static final int MIN_SIZE = 0;
    private static final int PREF_SIZE = 1;
    private static final int MAX_SIZE = 2;
    private static final int SPECIFIC_SIZE = 3;
    private static final int UNSET = Integer.MIN_VALUE;
    private static final int INFINITE = 0x3FFFFFFF;
    public static final int DEFAULT_SIZE = -1;
    public static final int PREFERRED_SIZE = -2;
    private boolean autocreatePadding;
    private boolean autocreateContainerPadding;
    private Group horizontalGroup;
    private Group verticalGroup;
    private Map<Component, ComponentInfo> componentInfos;
    private Container host;
    private Set<Spring> tmpParallelSet;
    private boolean springsChanged;
    private boolean isValid;
    private boolean hasPreferredPaddingSprings;
    private LayoutStyle layoutStyle;
    private boolean honorsVisibility;

    private static void checkSize(int min, int pref, int max, boolean isComponentSpring) {
        GroupLayout.checkResizeType(min, isComponentSpring);
        if (!isComponentSpring && pref < 0) {
            throw new IllegalArgumentException("Pref must be >= 0");
        }
        if (isComponentSpring) {
            GroupLayout.checkResizeType(pref, true);
        }
        GroupLayout.checkResizeType(max, isComponentSpring);
        GroupLayout.checkLessThan(min, pref);
        GroupLayout.checkLessThan(pref, max);
    }

    private static void checkResizeType(int type, boolean isComponentSpring) {
        if (type < 0 && (isComponentSpring && type != -1 && type != -2 || !isComponentSpring && type != -2)) {
            throw new IllegalArgumentException("Invalid size");
        }
    }

    private static void checkLessThan(int min, int max) {
        if (min >= 0 && max >= 0 && min > max) {
            throw new IllegalArgumentException("Following is not met: min<=pref<=max");
        }
    }

    public GroupLayout(Container host) {
        if (host == null) {
            throw new IllegalArgumentException("Container must be non-null");
        }
        this.honorsVisibility = true;
        this.host = host;
        this.setHorizontalGroup(this.createParallelGroup(Alignment.LEADING, true));
        this.setVerticalGroup(this.createParallelGroup(Alignment.LEADING, true));
        this.componentInfos = new HashMap<Component, ComponentInfo>();
        this.tmpParallelSet = new HashSet<Spring>();
    }

    public void setHonorsVisibility(boolean honorsVisibility) {
        if (this.honorsVisibility != honorsVisibility) {
            this.honorsVisibility = honorsVisibility;
            this.springsChanged = true;
            this.isValid = false;
            this.invalidateHost();
        }
    }

    public boolean getHonorsVisibility() {
        return this.honorsVisibility;
    }

    public void setHonorsVisibility(Component component, Boolean honorsVisibility) {
        if (component == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        this.getComponentInfo(component).setHonorsVisibility(honorsVisibility);
        this.springsChanged = true;
        this.isValid = false;
        this.invalidateHost();
    }

    public void setAutoCreateGaps(boolean autoCreatePadding) {
        if (this.autocreatePadding != autoCreatePadding) {
            this.autocreatePadding = autoCreatePadding;
            this.invalidateHost();
        }
    }

    public boolean getAutoCreateGaps() {
        return this.autocreatePadding;
    }

    public void setAutoCreateContainerGaps(boolean autoCreateContainerPadding) {
        if (this.autocreateContainerPadding != autoCreateContainerPadding) {
            this.autocreateContainerPadding = autoCreateContainerPadding;
            this.horizontalGroup = this.createTopLevelGroup(this.getHorizontalGroup());
            this.verticalGroup = this.createTopLevelGroup(this.getVerticalGroup());
            this.invalidateHost();
        }
    }

    public boolean getAutoCreateContainerGaps() {
        return this.autocreateContainerPadding;
    }

    public void setHorizontalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.horizontalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    private Group getHorizontalGroup() {
        int index = 0;
        if (this.horizontalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.horizontalGroup.springs.get(index);
    }

    public void setVerticalGroup(Group group) {
        if (group == null) {
            throw new IllegalArgumentException("Group must be non-null");
        }
        this.verticalGroup = this.createTopLevelGroup(group);
        this.invalidateHost();
    }

    private Group getVerticalGroup() {
        int index = 0;
        if (this.verticalGroup.springs.size() > 1) {
            index = 1;
        }
        return (Group)this.verticalGroup.springs.get(index);
    }

    private Group createTopLevelGroup(Group specifiedGroup) {
        SequentialGroup group = this.createSequentialGroup();
        if (this.getAutoCreateContainerGaps()) {
            group.addSpring(new ContainerAutoPreferredGapSpring());
            group.addGroup(specifiedGroup);
            group.addSpring(new ContainerAutoPreferredGapSpring());
        } else {
            group.addGroup(specifiedGroup);
        }
        return group;
    }

    public SequentialGroup createSequentialGroup() {
        return new SequentialGroup();
    }

    public ParallelGroup createParallelGroup() {
        return this.createParallelGroup(Alignment.LEADING);
    }

    public ParallelGroup createParallelGroup(Alignment alignment) {
        return this.createParallelGroup(alignment, true);
    }

    public ParallelGroup createParallelGroup(Alignment alignment, boolean resizable) {
        if (alignment == null) {
            throw new IllegalArgumentException("alignment must be non null");
        }
        if (alignment == Alignment.BASELINE) {
            return new BaselineGroup(resizable);
        }
        return new ParallelGroup(alignment, resizable);
    }

    public ParallelGroup createBaselineGroup(boolean resizable, boolean anchorBaselineToTop) {
        return new BaselineGroup(resizable, anchorBaselineToTop);
    }

    public void linkSize(Component ... components) {
        this.linkSize(0, components);
        this.linkSize(1, components);
    }

    public void linkSize(int axis, Component ... components) {
        int glAxis;
        if (components == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        for (int counter = components.length - 1; counter >= 0; --counter) {
            Component c = components[counter];
            if (components[counter] == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.getComponentInfo(c);
        }
        if (axis == 0) {
            glAxis = 0;
        } else if (axis == 1) {
            glAxis = 1;
        } else {
            throw new IllegalArgumentException("Axis must be one of SwingConstants.HORIZONTAL or SwingConstants.VERTICAL");
        }
        LinkInfo master = this.getComponentInfo(components[components.length - 1]).getLinkInfo(glAxis);
        for (int counter = components.length - 2; counter >= 0; --counter) {
            master.add(this.getComponentInfo(components[counter]));
        }
        this.invalidateHost();
    }

    public void replace(Component existingComponent, Component newComponent) {
        ComponentInfo info;
        if (existingComponent == null || newComponent == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        if ((info = this.componentInfos.remove(existingComponent)) == null) {
            throw new IllegalArgumentException("Component must already exist");
        }
        this.host.remove(existingComponent);
        if (newComponent.getParent() != this.host) {
            this.host.add(newComponent);
        }
        info.setComponent(newComponent);
        this.componentInfos.put(newComponent, info);
        this.invalidateHost();
    }

    public void setLayoutStyle(LayoutStyle layoutStyle) {
        this.layoutStyle = layoutStyle;
        this.invalidateHost();
    }

    public LayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    private LayoutStyle getLayoutStyle0() {
        LayoutStyle layoutStyle = this.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getInstance();
        }
        return layoutStyle;
    }

    private void invalidateHost() {
        if (this.host instanceof JComponent) {
            ((JComponent)this.host).revalidate();
        } else {
            this.host.invalidate();
        }
        this.host.repaint();
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
        ComponentInfo info = this.componentInfos.remove(component);
        if (info != null) {
            info.dispose();
            this.springsChanged = true;
            this.isValid = false;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(1);
        return this.adjustSize(this.horizontalGroup.getPreferredSize(0), this.verticalGroup.getPreferredSize(1));
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(0);
        return this.adjustSize(this.horizontalGroup.getMinimumSize(0), this.verticalGroup.getMinimumSize(1));
    }

    @Override
    public void layoutContainer(Container parent) {
        this.prepare(3);
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int height = parent.getHeight() - insets.top - insets.bottom;
        boolean ltr = this.isLeftToRight();
        if (this.getAutoCreateGaps() || this.getAutoCreateContainerGaps() || this.hasPreferredPaddingSprings) {
            this.calculateAutopadding(this.horizontalGroup, 0, 3, 0, width);
            this.calculateAutopadding(this.verticalGroup, 1, 3, 0, height);
        }
        this.horizontalGroup.setSize(0, 0, width);
        this.verticalGroup.setSize(1, 0, height);
        for (ComponentInfo info : this.componentInfos.values()) {
            info.setBounds(insets, width, ltr);
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object constraints) {
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        this.checkParent(parent);
        this.prepare(2);
        return this.adjustSize(this.horizontalGroup.getMaximumSize(0), this.verticalGroup.getMaximumSize(1));
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        this.checkParent(parent);
        return 0.5f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLayout(Container parent) {
        this.checkParent(parent);
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.isValid = false;
        }
    }

    private void prepare(int sizeType) {
        boolean visChanged = false;
        if (!this.isValid) {
            this.isValid = true;
            this.horizontalGroup.setSize(0, Integer.MIN_VALUE, Integer.MIN_VALUE);
            this.verticalGroup.setSize(1, Integer.MIN_VALUE, Integer.MIN_VALUE);
            for (ComponentInfo ci : this.componentInfos.values()) {
                if (ci.updateVisibility()) {
                    visChanged = true;
                }
                ci.clearCachedSize();
            }
        }
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        if (this.springsChanged || visChanged) {
            this.checkComponents();
            this.horizontalGroup.removeAutopadding();
            this.verticalGroup.removeAutopadding();
            if (this.getAutoCreateGaps()) {
                this.insertAutopadding(true);
            } else if (this.hasPreferredPaddingSprings || this.getAutoCreateContainerGaps()) {
                this.insertAutopadding(false);
            }
            this.springsChanged = false;
        }
        if (sizeType != 3 && (this.getAutoCreateGaps() || this.getAutoCreateContainerGaps() || this.hasPreferredPaddingSprings)) {
            this.calculateAutopadding(this.horizontalGroup, 0, sizeType, 0, 0);
            this.calculateAutopadding(this.verticalGroup, 1, sizeType, 0, 0);
        }
    }

    private void calculateAutopadding(Group group, int axis, int sizeType, int origin, int size) {
        group.unsetAutopadding();
        switch (sizeType) {
            case 0: {
                size = group.getMinimumSize(axis);
                break;
            }
            case 1: {
                size = group.getPreferredSize(axis);
                break;
            }
            case 2: {
                size = group.getMaximumSize(axis);
                break;
            }
        }
        group.setSize(axis, origin, size);
        group.calculateAutopadding(axis);
    }

    private void checkComponents() {
        for (ComponentInfo info : this.componentInfos.values()) {
            if (info.horizontalSpring == null) {
                throw new IllegalStateException(info.component + " is not attached to a horizontal group");
            }
            if (info.verticalSpring != null) continue;
            throw new IllegalStateException(info.component + " is not attached to a vertical group");
        }
    }

    private void registerComponents(Group group, int axis) {
        List<Spring> springs = group.springs;
        for (int counter = springs.size() - 1; counter >= 0; --counter) {
            Spring spring = springs.get(counter);
            if (spring instanceof ComponentSpring) {
                ((ComponentSpring)spring).installIfNecessary(axis);
                continue;
            }
            if (!(spring instanceof Group)) continue;
            this.registerComponents((Group)spring, axis);
        }
    }

    private Dimension adjustSize(int width, int height) {
        Insets insets = this.host.getInsets();
        return new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    private void checkParent(Container parent) {
        if (parent != this.host) {
            throw new IllegalArgumentException("GroupLayout can only be used with one Container at a time");
        }
    }

    private ComponentInfo getComponentInfo(Component component) {
        ComponentInfo info = this.componentInfos.get(component);
        if (info == null) {
            info = new ComponentInfo(component);
            this.componentInfos.put(component, info);
            if (component.getParent() != this.host) {
                this.host.add(component);
            }
        }
        return info;
    }

    private void insertAutopadding(boolean insert) {
        this.horizontalGroup.insertAutopadding(0, new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<ComponentSpring>(1), new ArrayList<ComponentSpring>(1), insert);
        this.verticalGroup.insertAutopadding(1, new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<AutoPreferredGapSpring>(1), new ArrayList<ComponentSpring>(1), new ArrayList<ComponentSpring>(1), insert);
    }

    private boolean areParallelSiblings(Component source, Component target, int axis) {
        Spring spring;
        ComponentSpring targetSpring;
        ComponentSpring sourceSpring;
        ComponentInfo sourceInfo = this.getComponentInfo(source);
        ComponentInfo targetInfo = this.getComponentInfo(target);
        if (axis == 0) {
            sourceSpring = sourceInfo.horizontalSpring;
            targetSpring = targetInfo.horizontalSpring;
        } else {
            sourceSpring = sourceInfo.verticalSpring;
            targetSpring = targetInfo.verticalSpring;
        }
        Set<Spring> sourcePath = this.tmpParallelSet;
        sourcePath.clear();
        for (spring = sourceSpring.getParent(); spring != null; spring = spring.getParent()) {
            sourcePath.add(spring);
        }
        for (spring = targetSpring.getParent(); spring != null; spring = spring.getParent()) {
            if (!sourcePath.contains(spring)) continue;
            sourcePath.clear();
            while (spring != null) {
                if (spring instanceof ParallelGroup) {
                    return true;
                }
                spring = spring.getParent();
            }
            return false;
        }
        sourcePath.clear();
        return false;
    }

    private boolean isLeftToRight() {
        return this.host.getComponentOrientation().isLeftToRight();
    }

    public String toString() {
        if (this.springsChanged) {
            this.registerComponents(this.horizontalGroup, 0);
            this.registerComponents(this.verticalGroup, 1);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("HORIZONTAL\n");
        this.createSpringDescription(sb, this.horizontalGroup, "  ", 0);
        sb.append("\nVERTICAL\n");
        this.createSpringDescription(sb, this.verticalGroup, "  ", 1);
        return sb.toString();
    }

    private void createSpringDescription(StringBuilder sb, Spring spring, String indent, int axis) {
        Object origin = "";
        Object padding = "";
        if (spring instanceof ComponentSpring) {
            ComponentSpring cSpring = (ComponentSpring)spring;
            origin = Integer.toString(cSpring.getOrigin()) + " ";
            String name = cSpring.getComponent().getName();
            if (name != null) {
                origin = "name=" + name + ", ";
            }
        }
        if (spring instanceof AutoPreferredGapSpring) {
            AutoPreferredGapSpring paddingSpring = (AutoPreferredGapSpring)spring;
            padding = ", userCreated=" + paddingSpring.getUserCreated() + ", matches=" + paddingSpring.getMatchDescription();
        }
        sb.append((String)indent).append(spring.getClass().getName()).append(' ').append(Integer.toHexString(spring.hashCode())).append(' ').append((String)origin).append(", size=").append(spring.getSize()).append(", alignment=").append((Object)spring.getAlignment()).append(" prefs=[").append(spring.getMinimumSize(axis)).append(' ').append(spring.getPreferredSize(axis)).append(' ').append(spring.getMaximumSize(axis)).append((String)padding).append("]\n");
        if (spring instanceof Group) {
            List<Spring> springs = ((Group)spring).springs;
            indent = (String)indent + "  ";
            for (int counter = 0; counter < springs.size(); ++counter) {
                this.createSpringDescription(sb, springs.get(counter), (String)indent, axis);
            }
        }
    }

    private class ComponentInfo {
        private Component component;
        ComponentSpring horizontalSpring;
        ComponentSpring verticalSpring;
        private LinkInfo horizontalMaster;
        private LinkInfo verticalMaster;
        private boolean visible;
        private Boolean honorsVisibility;

        ComponentInfo(Component component) {
            this.component = component;
            this.updateVisibility();
        }

        public void dispose() {
            this.removeSpring(this.horizontalSpring);
            this.horizontalSpring = null;
            this.removeSpring(this.verticalSpring);
            this.verticalSpring = null;
            if (this.horizontalMaster != null) {
                this.horizontalMaster.remove(this);
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.remove(this);
            }
        }

        void setHonorsVisibility(Boolean honorsVisibility) {
            this.honorsVisibility = honorsVisibility;
        }

        private void removeSpring(Spring spring) {
            if (spring != null) {
                ((Group)spring.getParent()).springs.remove(spring);
            }
        }

        public boolean isVisible() {
            return this.visible;
        }

        boolean updateVisibility() {
            boolean newVisible;
            boolean honorsVisibility = this.honorsVisibility == null ? GroupLayout.this.getHonorsVisibility() : this.honorsVisibility.booleanValue();
            boolean bl = newVisible = honorsVisibility ? this.component.isVisible() : true;
            if (this.visible != newVisible) {
                this.visible = newVisible;
                return true;
            }
            return false;
        }

        public void setBounds(Insets insets, int parentWidth, boolean ltr) {
            int x = this.horizontalSpring.getOrigin();
            int w = this.horizontalSpring.getSize();
            int y = this.verticalSpring.getOrigin();
            int h = this.verticalSpring.getSize();
            if (!ltr) {
                x = parentWidth - x - w;
            }
            this.component.setBounds(x + insets.left, y + insets.top, w, h);
        }

        public void setComponent(Component component) {
            this.component = component;
            if (this.horizontalSpring != null) {
                this.horizontalSpring.setComponent(component);
            }
            if (this.verticalSpring != null) {
                this.verticalSpring.setComponent(component);
            }
        }

        public Component getComponent() {
            return this.component;
        }

        public boolean isLinked(int axis) {
            if (axis == 0) {
                return this.horizontalMaster != null;
            }
            assert (axis == 1);
            return this.verticalMaster != null;
        }

        private void setLinkInfo(int axis, LinkInfo linkInfo) {
            if (axis == 0) {
                this.horizontalMaster = linkInfo;
            } else {
                assert (axis == 1);
                this.verticalMaster = linkInfo;
            }
        }

        public LinkInfo getLinkInfo(int axis) {
            return this.getLinkInfo(axis, true);
        }

        private LinkInfo getLinkInfo(int axis, boolean create) {
            if (axis == 0) {
                if (this.horizontalMaster == null && create) {
                    new LinkInfo(0).add(this);
                }
                return this.horizontalMaster;
            }
            assert (axis == 1);
            if (this.verticalMaster == null && create) {
                new LinkInfo(1).add(this);
            }
            return this.verticalMaster;
        }

        public void clearCachedSize() {
            if (this.horizontalMaster != null) {
                this.horizontalMaster.clearCachedSize();
            }
            if (this.verticalMaster != null) {
                this.verticalMaster.clearCachedSize();
            }
        }

        int getLinkSize(int axis, int type) {
            if (axis == 0) {
                return this.horizontalMaster.getSize(axis);
            }
            assert (axis == 1);
            return this.verticalMaster.getSize(axis);
        }
    }

    private static class LinkInfo {
        private final int axis;
        private final List<ComponentInfo> linked = new ArrayList<ComponentInfo>();
        private int size = Integer.MIN_VALUE;

        LinkInfo(int axis) {
            this.axis = axis;
        }

        public void add(ComponentInfo child) {
            LinkInfo childMaster = child.getLinkInfo(this.axis, false);
            if (childMaster == null) {
                this.linked.add(child);
                child.setLinkInfo(this.axis, this);
            } else if (childMaster != this) {
                this.linked.addAll(childMaster.linked);
                for (ComponentInfo childInfo : childMaster.linked) {
                    childInfo.setLinkInfo(this.axis, this);
                }
            }
            this.clearCachedSize();
        }

        public void remove(ComponentInfo info) {
            this.linked.remove(info);
            info.setLinkInfo(this.axis, null);
            if (this.linked.size() == 1) {
                this.linked.get(0).setLinkInfo(this.axis, null);
            }
            this.clearCachedSize();
        }

        public void clearCachedSize() {
            this.size = Integer.MIN_VALUE;
        }

        public int getSize(int axis) {
            if (this.size == Integer.MIN_VALUE) {
                this.size = this.calculateLinkedSize(axis);
            }
            return this.size;
        }

        private int calculateLinkedSize(int axis) {
            int size = 0;
            for (ComponentInfo info : this.linked) {
                ComponentSpring spring;
                if (axis == 0) {
                    spring = info.horizontalSpring;
                } else {
                    assert (axis == 1);
                    spring = info.verticalSpring;
                }
                size = Math.max(size, spring.calculateNonlinkedPreferredSize(axis));
            }
            return size;
        }
    }

    private class ContainerAutoPreferredGapSpring
    extends AutoPreferredGapSpring {
        private List<ComponentSpring> targets;

        ContainerAutoPreferredGapSpring() {
            this.setUserCreated(true);
        }

        ContainerAutoPreferredGapSpring(int pref, int max) {
            super(pref, max);
            this.setUserCreated(true);
        }

        @Override
        public void addTarget(ComponentSpring spring, int axis) {
            if (this.targets == null) {
                this.targets = new ArrayList<ComponentSpring>(1);
            }
            this.targets.add(spring);
        }

        @Override
        public void calculatePadding(int axis) {
            LayoutStyle p = GroupLayout.this.getLayoutStyle0();
            int maxPadding = 0;
            this.size = 0;
            if (this.targets != null) {
                int position = axis == 0 ? (GroupLayout.this.isLeftToRight() ? 7 : 3) : 5;
                for (int i = this.targets.size() - 1; i >= 0; --i) {
                    ComponentSpring targetSpring = this.targets.get(i);
                    int padding = 10;
                    if (targetSpring.getComponent() instanceof JComponent) {
                        padding = p.getContainerGap((JComponent)targetSpring.getComponent(), position, GroupLayout.this.host);
                        maxPadding = Math.max(padding, maxPadding);
                        padding -= targetSpring.getOrigin();
                    } else {
                        maxPadding = Math.max(padding, maxPadding);
                    }
                    this.size = Math.max(this.size, padding);
                }
            } else {
                int position = axis == 0 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                if (this.sources != null) {
                    for (int i = this.sources.size() - 1; i >= 0; --i) {
                        ComponentSpring sourceSpring = (ComponentSpring)this.sources.get(i);
                        maxPadding = Math.max(maxPadding, this.updateSize(p, sourceSpring, position));
                    }
                } else if (this.source != null) {
                    maxPadding = this.updateSize(p, this.source, position);
                }
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int updateSize(LayoutStyle p, ComponentSpring sourceSpring, int position) {
            int padding = 10;
            if (sourceSpring.getComponent() instanceof JComponent) {
                padding = p.getContainerGap((JComponent)sourceSpring.getComponent(), position, GroupLayout.this.host);
            }
            int delta = Math.max(0, this.getParent().getSize() - sourceSpring.getSize() - sourceSpring.getOrigin());
            this.size = Math.max(this.size, padding - delta);
            return padding;
        }

        @Override
        String getMatchDescription() {
            if (this.targets != null) {
                return "leading: " + this.targets.toString();
            }
            if (this.sources != null) {
                return "trailing: " + this.sources.toString();
            }
            return "--";
        }
    }

    private static final class AutoPreferredGapMatch {
        public final ComponentSpring source;
        public final ComponentSpring target;

        AutoPreferredGapMatch(ComponentSpring source, ComponentSpring target) {
            this.source = source;
            this.target = target;
        }

        private String toString(ComponentSpring spring) {
            return spring.getComponent().getName();
        }

        public String toString() {
            return "[" + this.toString(this.source) + "-" + this.toString(this.target) + "]";
        }
    }

    private class AutoPreferredGapSpring
    extends Spring {
        List<ComponentSpring> sources;
        ComponentSpring source;
        private List<AutoPreferredGapMatch> matches;
        int size;
        int lastSize;
        private final int pref;
        private final int max;
        private LayoutStyle.ComponentPlacement type;
        private boolean userCreated;

        private AutoPreferredGapSpring() {
            this.pref = -2;
            this.max = -2;
            this.type = LayoutStyle.ComponentPlacement.RELATED;
        }

        AutoPreferredGapSpring(int pref, int max) {
            this.pref = pref;
            this.max = max;
        }

        AutoPreferredGapSpring(LayoutStyle.ComponentPlacement type, int pref, int max) {
            this.type = type;
            this.pref = pref;
            this.max = max;
            this.userCreated = true;
        }

        public void setSource(ComponentSpring source) {
            this.source = source;
        }

        public void setSources(List<ComponentSpring> sources) {
            this.sources = new ArrayList<ComponentSpring>(sources);
        }

        public void setUserCreated(boolean userCreated) {
            this.userCreated = userCreated;
        }

        public boolean getUserCreated() {
            return this.userCreated;
        }

        @Override
        void unset() {
            this.lastSize = this.getSize();
            super.unset();
            this.size = 0;
        }

        public void reset() {
            this.size = 0;
            this.sources = null;
            this.source = null;
            this.matches = null;
        }

        public void calculatePadding(int axis) {
            this.size = Integer.MIN_VALUE;
            int maxPadding = Integer.MIN_VALUE;
            if (this.matches != null) {
                LayoutStyle p = GroupLayout.this.getLayoutStyle0();
                int position = axis == 0 ? (GroupLayout.this.isLeftToRight() ? 3 : 7) : 5;
                for (int i = this.matches.size() - 1; i >= 0; --i) {
                    AutoPreferredGapMatch match = this.matches.get(i);
                    maxPadding = Math.max(maxPadding, this.calculatePadding(p, position, match.source, match.target));
                }
            }
            if (this.size == Integer.MIN_VALUE) {
                this.size = 0;
            }
            if (maxPadding == Integer.MIN_VALUE) {
                maxPadding = 0;
            }
            if (this.lastSize != Integer.MIN_VALUE) {
                this.size += Math.min(maxPadding, this.lastSize);
            }
        }

        private int calculatePadding(LayoutStyle p, int position, ComponentSpring source, ComponentSpring target) {
            int delta = target.getOrigin() - (source.getOrigin() + source.getSize());
            if (delta >= 0) {
                int padding = source.getComponent() instanceof JComponent && target.getComponent() instanceof JComponent ? p.getPreferredGap((JComponent)source.getComponent(), (JComponent)target.getComponent(), this.type, position, GroupLayout.this.host) : 10;
                if (padding > delta) {
                    this.size = Math.max(this.size, padding - delta);
                }
                return padding;
            }
            return 0;
        }

        public void addTarget(ComponentSpring spring, int axis) {
            int oAxis;
            int n = oAxis = axis == 0 ? 1 : 0;
            if (this.source != null) {
                if (GroupLayout.this.areParallelSiblings(this.source.getComponent(), spring.getComponent(), oAxis)) {
                    this.addValidTarget(this.source, spring);
                }
            } else {
                Component component = spring.getComponent();
                for (int counter = this.sources.size() - 1; counter >= 0; --counter) {
                    ComponentSpring source = this.sources.get(counter);
                    if (!GroupLayout.this.areParallelSiblings(source.getComponent(), component, oAxis)) continue;
                    this.addValidTarget(source, spring);
                }
            }
        }

        private void addValidTarget(ComponentSpring source, ComponentSpring target) {
            if (this.matches == null) {
                this.matches = new ArrayList<AutoPreferredGapMatch>(1);
            }
            this.matches.add(new AutoPreferredGapMatch(source, target));
        }

        @Override
        int calculateMinimumSize(int axis) {
            return this.size;
        }

        @Override
        int calculatePreferredSize(int axis) {
            if (this.pref == -2 || this.pref == -1) {
                return this.size;
            }
            return Math.max(this.size, this.pref);
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.max >= 0) {
                return Math.max(this.getPreferredSize(axis), this.max);
            }
            return this.size;
        }

        String getMatchDescription() {
            return this.matches == null ? "" : this.matches.toString();
        }

        public String toString() {
            return super.toString() + this.getMatchDescription();
        }

        @Override
        boolean willHaveZeroSize(boolean treatAutopaddingAsZeroSized) {
            return treatAutopaddingAsZeroSized;
        }
    }

    private class GapSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;

        GapSpring(int min, int pref, int max) {
            GroupLayout.checkSize(min, pref, max, false);
            this.min = min;
            this.pref = pref;
            this.max = max;
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (this.min == -2) {
                return this.getPreferredSize(axis);
            }
            return this.min;
        }

        @Override
        int calculatePreferredSize(int axis) {
            return this.pref;
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.max == -2) {
                return this.getPreferredSize(axis);
            }
            return this.max;
        }

        @Override
        boolean willHaveZeroSize(boolean treatAutopaddingAsZeroSized) {
            return false;
        }
    }

    private class PreferredGapSpring
    extends Spring {
        private final JComponent source;
        private final JComponent target;
        private final LayoutStyle.ComponentPlacement type;
        private final int pref;
        private final int max;

        PreferredGapSpring(JComponent source, JComponent target, LayoutStyle.ComponentPlacement type, int pref, int max) {
            this.source = source;
            this.target = target;
            this.type = type;
            this.pref = pref;
            this.max = max;
        }

        @Override
        int calculateMinimumSize(int axis) {
            return this.getPadding(axis);
        }

        @Override
        int calculatePreferredSize(int axis) {
            if (this.pref == -1 || this.pref == -2) {
                return this.getMinimumSize(axis);
            }
            int min = this.getMinimumSize(axis);
            int max = this.getMaximumSize(axis);
            return Math.min(max, Math.max(min, this.pref));
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.max == -2 || this.max == -1) {
                return this.getPadding(axis);
            }
            return Math.max(this.getMinimumSize(axis), this.max);
        }

        private int getPadding(int axis) {
            int position = axis == 0 ? 3 : 5;
            return GroupLayout.this.getLayoutStyle0().getPreferredGap(this.source, this.target, this.type, position, GroupLayout.this.host);
        }

        @Override
        boolean willHaveZeroSize(boolean treatAutopaddingAsZeroSized) {
            return false;
        }
    }

    private final class ComponentSpring
    extends Spring {
        private Component component;
        private int origin;
        private final int min;
        private final int pref;
        private final int max;
        private int baseline;
        private boolean installed;

        private ComponentSpring(Component component, int min, int pref, int max) {
            this.baseline = -1;
            this.component = component;
            if (component == null) {
                throw new IllegalArgumentException("Component must be non-null");
            }
            GroupLayout.checkSize(min, pref, max, true);
            this.min = min;
            this.max = max;
            this.pref = pref;
            GroupLayout.this.getComponentInfo(component);
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 0);
            }
            return this.calculateNonlinkedMinimumSize(axis);
        }

        @Override
        int calculatePreferredSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 1);
            }
            int min = this.getMinimumSize(axis);
            int pref = this.calculateNonlinkedPreferredSize(axis);
            int max = this.getMaximumSize(axis);
            return Math.min(max, Math.max(min, pref));
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (this.isLinked(axis)) {
                return this.getLinkSize(axis, 2);
            }
            return Math.max(this.getMinimumSize(axis), this.calculateNonlinkedMaximumSize(axis));
        }

        boolean isVisible() {
            return GroupLayout.this.getComponentInfo(this.getComponent()).isVisible();
        }

        int calculateNonlinkedMinimumSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.min >= 0) {
                return this.min;
            }
            if (this.min == -2) {
                return this.calculateNonlinkedPreferredSize(axis);
            }
            assert (this.min == -1);
            return this.getSizeAlongAxis(axis, this.component.getMinimumSize());
        }

        int calculateNonlinkedPreferredSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.pref >= 0) {
                return this.pref;
            }
            assert (this.pref == -1 || this.pref == -2);
            return this.getSizeAlongAxis(axis, this.component.getPreferredSize());
        }

        int calculateNonlinkedMaximumSize(int axis) {
            if (!this.isVisible()) {
                return 0;
            }
            if (this.max >= 0) {
                return this.max;
            }
            if (this.max == -2) {
                return this.calculateNonlinkedPreferredSize(axis);
            }
            assert (this.max == -1);
            return this.getSizeAlongAxis(axis, this.component.getMaximumSize());
        }

        private int getSizeAlongAxis(int axis, Dimension size) {
            return axis == 0 ? size.width : size.height;
        }

        private int getLinkSize(int axis, int type) {
            if (!this.isVisible()) {
                return 0;
            }
            ComponentInfo ci = GroupLayout.this.getComponentInfo(this.component);
            return ci.getLinkSize(axis, type);
        }

        @Override
        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            this.origin = origin;
            if (size == Integer.MIN_VALUE) {
                this.baseline = -1;
            }
        }

        int getOrigin() {
            return this.origin;
        }

        void setComponent(Component component) {
            this.component = component;
        }

        Component getComponent() {
            return this.component;
        }

        @Override
        int getBaseline() {
            if (this.baseline == -1) {
                ComponentSpring horizontalSpring = GroupLayout.this.getComponentInfo((Component)this.component).horizontalSpring;
                int width = horizontalSpring.getPreferredSize(0);
                int height = this.getPreferredSize(1);
                if (width > 0 && height > 0) {
                    this.baseline = this.component.getBaseline(width, height);
                }
            }
            return this.baseline;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return this.getComponent().getBaselineResizeBehavior();
        }

        private boolean isLinked(int axis) {
            return GroupLayout.this.getComponentInfo(this.component).isLinked(axis);
        }

        void installIfNecessary(int axis) {
            if (!this.installed) {
                this.installed = true;
                if (axis == 0) {
                    GroupLayout.this.getComponentInfo((Component)this.component).horizontalSpring = this;
                } else {
                    GroupLayout.this.getComponentInfo((Component)this.component).verticalSpring = this;
                }
            }
        }

        @Override
        boolean willHaveZeroSize(boolean treatAutopaddingAsZeroSized) {
            return !this.isVisible();
        }
    }

    private class BaselineGroup
    extends ParallelGroup {
        private boolean allSpringsHaveBaseline;
        private int prefAscent;
        private int prefDescent;
        private boolean baselineAnchorSet;
        private boolean baselineAnchoredToTop;
        private boolean calcedBaseline;

        BaselineGroup(boolean resizable) {
            super(Alignment.LEADING, resizable);
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        BaselineGroup(boolean resizable, boolean baselineAnchoredToTop) {
            this(resizable);
            this.baselineAnchoredToTop = baselineAnchoredToTop;
            this.baselineAnchorSet = true;
        }

        @Override
        void unset() {
            super.unset();
            this.prefDescent = -1;
            this.prefAscent = -1;
            this.calcedBaseline = false;
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            this.checkAxis(axis);
            if (this.prefAscent == -1) {
                super.setValidSize(axis, origin, size);
            } else {
                this.baselineLayout(origin, size);
            }
        }

        @Override
        int calculateSize(int axis, int type) {
            this.checkAxis(axis);
            if (!this.calcedBaseline) {
                this.calculateBaselineAndResizeBehavior();
            }
            if (type == 0) {
                return this.calculateMinSize();
            }
            if (type == 2) {
                return this.calculateMaxSize();
            }
            if (this.allSpringsHaveBaseline) {
                return this.prefAscent + this.prefDescent;
            }
            return Math.max(this.prefAscent + this.prefDescent, super.calculateSize(axis, type));
        }

        private void calculateBaselineAndResizeBehavior() {
            this.prefAscent = 0;
            this.prefDescent = 0;
            int baselineSpringCount = 0;
            Component.BaselineResizeBehavior resizeBehavior = null;
            for (Spring spring : this.springs) {
                int baseline;
                if (spring.getAlignment() != null && spring.getAlignment() != Alignment.BASELINE || (baseline = spring.getBaseline()) < 0) continue;
                if (spring.isResizable(1)) {
                    Component.BaselineResizeBehavior brb = spring.getBaselineResizeBehavior();
                    if (resizeBehavior == null) {
                        resizeBehavior = brb;
                    } else if (brb != resizeBehavior) {
                        resizeBehavior = Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                }
                this.prefAscent = Math.max(this.prefAscent, baseline);
                this.prefDescent = Math.max(this.prefDescent, spring.getPreferredSize(1) - baseline);
                ++baselineSpringCount;
            }
            if (!this.baselineAnchorSet) {
                this.baselineAnchoredToTop = resizeBehavior != Component.BaselineResizeBehavior.CONSTANT_DESCENT;
            }
            this.allSpringsHaveBaseline = baselineSpringCount == this.springs.size();
            this.calcedBaseline = true;
        }

        private int calculateMaxSize() {
            int maxAscent = this.prefAscent;
            int maxDescent = this.prefDescent;
            int nonBaselineMax = 0;
            for (Spring spring : this.springs) {
                int baseline;
                int springMax = spring.getMaximumSize(1);
                if ((spring.getAlignment() == null || spring.getAlignment() == Alignment.BASELINE) && (baseline = spring.getBaseline()) >= 0) {
                    int springPref = spring.getPreferredSize(1);
                    if (springPref == springMax) continue;
                    switch (spring.getBaselineResizeBehavior()) {
                        case CONSTANT_ASCENT: {
                            if (!this.baselineAnchoredToTop) break;
                            maxDescent = Math.max(maxDescent, springMax - baseline);
                            break;
                        }
                        case CONSTANT_DESCENT: {
                            if (this.baselineAnchoredToTop) break;
                            maxAscent = Math.max(maxAscent, springMax - springPref + baseline);
                            break;
                        }
                    }
                    continue;
                }
                nonBaselineMax = Math.max(nonBaselineMax, springMax);
            }
            return Math.max(nonBaselineMax, maxAscent + maxDescent);
        }

        private int calculateMinSize() {
            int minAscent = 0;
            int minDescent = 0;
            int nonBaselineMin = 0;
            if (this.baselineAnchoredToTop) {
                minAscent = this.prefAscent;
            } else {
                minDescent = this.prefDescent;
            }
            for (Spring spring : this.springs) {
                int baseline;
                int springMin = spring.getMinimumSize(1);
                if ((spring.getAlignment() == null || spring.getAlignment() == Alignment.BASELINE) && (baseline = spring.getBaseline()) >= 0) {
                    int springPref = spring.getPreferredSize(1);
                    Component.BaselineResizeBehavior brb = spring.getBaselineResizeBehavior();
                    switch (brb) {
                        case CONSTANT_ASCENT: {
                            if (this.baselineAnchoredToTop) {
                                minDescent = Math.max(springMin - baseline, minDescent);
                                break;
                            }
                            minAscent = Math.max(baseline, minAscent);
                            break;
                        }
                        case CONSTANT_DESCENT: {
                            if (!this.baselineAnchoredToTop) {
                                minAscent = Math.max(baseline - (springPref - springMin), minAscent);
                                break;
                            }
                            minDescent = Math.max(springPref - baseline, minDescent);
                            break;
                        }
                        default: {
                            minAscent = Math.max(baseline, minAscent);
                            minDescent = Math.max(springPref - baseline, minDescent);
                            break;
                        }
                    }
                    continue;
                }
                nonBaselineMin = Math.max(nonBaselineMin, springMin);
            }
            return Math.max(nonBaselineMin, minAscent + minDescent);
        }

        private void baselineLayout(int origin, int size) {
            int descent;
            int ascent;
            if (this.baselineAnchoredToTop) {
                ascent = this.prefAscent;
                descent = size - ascent;
            } else {
                ascent = size - this.prefDescent;
                descent = this.prefDescent;
            }
            for (Spring spring : this.springs) {
                Alignment alignment = spring.getAlignment();
                if (alignment == null || alignment == Alignment.BASELINE) {
                    int baseline = spring.getBaseline();
                    if (baseline >= 0) {
                        int y;
                        int springPref;
                        int springMax = spring.getMaximumSize(1);
                        int height = springPref = spring.getPreferredSize(1);
                        switch (spring.getBaselineResizeBehavior()) {
                            case CONSTANT_ASCENT: {
                                y = origin + ascent - baseline;
                                height = Math.min(descent, springMax - baseline) + baseline;
                                break;
                            }
                            case CONSTANT_DESCENT: {
                                height = Math.min(ascent, springMax - springPref + baseline) + (springPref - baseline);
                                y = origin + ascent + (springPref - baseline) - height;
                                break;
                            }
                            default: {
                                y = origin + ascent - baseline;
                            }
                        }
                        spring.setSize(1, y, height);
                        continue;
                    }
                    this.setChildSize(spring, 1, origin, size);
                    continue;
                }
                this.setChildSize(spring, 1, origin, size);
            }
        }

        @Override
        int getBaseline() {
            if (this.springs.size() > 1) {
                this.getPreferredSize(1);
                return this.prefAscent;
            }
            if (this.springs.size() == 1) {
                return ((Spring)this.springs.get(0)).getBaseline();
            }
            return -1;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            if (this.springs.size() == 1) {
                return ((Spring)this.springs.get(0)).getBaselineResizeBehavior();
            }
            if (this.baselineAnchoredToTop) {
                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
            }
            return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
        }

        private void checkAxis(int axis) {
            if (axis == 0) {
                throw new IllegalStateException("Baseline must be used along vertical axis");
            }
        }
    }

    public class ParallelGroup
    extends Group {
        private final Alignment childAlignment;
        private final boolean resizable;

        ParallelGroup(Alignment childAlignment, boolean resizable) {
            this.childAlignment = childAlignment;
            this.resizable = resizable;
        }

        @Override
        public ParallelGroup addGroup(Group group) {
            return (ParallelGroup)super.addGroup(group);
        }

        @Override
        public ParallelGroup addComponent(Component component) {
            return (ParallelGroup)super.addComponent(component);
        }

        @Override
        public ParallelGroup addComponent(Component component, int min, int pref, int max) {
            return (ParallelGroup)super.addComponent(component, min, pref, max);
        }

        @Override
        public ParallelGroup addGap(int pref) {
            return (ParallelGroup)super.addGap(pref);
        }

        @Override
        public ParallelGroup addGap(int min, int pref, int max) {
            return (ParallelGroup)super.addGap(min, pref, max);
        }

        public ParallelGroup addGroup(Alignment alignment, Group group) {
            this.checkChildAlignment(alignment);
            group.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(group);
        }

        public ParallelGroup addComponent(Component component, Alignment alignment) {
            return this.addComponent(component, alignment, -1, -1, -1);
        }

        public ParallelGroup addComponent(Component component, Alignment alignment, int min, int pref, int max) {
            this.checkChildAlignment(alignment);
            ComponentSpring spring = new ComponentSpring(component, min, pref, max);
            spring.setAlignment(alignment);
            return (ParallelGroup)this.addSpring(spring);
        }

        boolean isResizable() {
            return this.resizable;
        }

        @Override
        int operator(int a, int b) {
            return Math.max(a, b);
        }

        @Override
        int calculateMinimumSize(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.calculateMinimumSize(axis);
        }

        @Override
        int calculateMaximumSize(int axis) {
            if (!this.isResizable()) {
                return this.getPreferredSize(axis);
            }
            return super.calculateMaximumSize(axis);
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            for (Spring spring : this.springs) {
                this.setChildSize(spring, axis, origin, size);
            }
        }

        void setChildSize(Spring spring, int axis, int origin, int size) {
            Alignment alignment = spring.getAlignment();
            int springSize = Math.min(Math.max(spring.getMinimumSize(axis), size), spring.getMaximumSize(axis));
            if (alignment == null) {
                alignment = this.childAlignment;
            }
            switch (alignment) {
                case TRAILING: {
                    spring.setSize(axis, origin + size - springSize, springSize);
                    break;
                }
                case CENTER: {
                    spring.setSize(axis, origin + (size - springSize) / 2, springSize);
                    break;
                }
                default: {
                    spring.setSize(axis, origin, springSize);
                }
            }
        }

        @Override
        void insertAutopadding(int axis, List<AutoPreferredGapSpring> leadingPadding, List<AutoPreferredGapSpring> trailingPadding, List<ComponentSpring> leading, List<ComponentSpring> trailing, boolean insert) {
            for (Spring spring : this.springs) {
                if (spring instanceof ComponentSpring) {
                    if (!((ComponentSpring)spring).isVisible()) continue;
                    for (AutoPreferredGapSpring gapSpring : leadingPadding) {
                        gapSpring.addTarget((ComponentSpring)spring, axis);
                    }
                    trailing.add((ComponentSpring)spring);
                    continue;
                }
                if (spring instanceof Group) {
                    ((Group)spring).insertAutopadding(axis, leadingPadding, trailingPadding, leading, trailing, insert);
                    continue;
                }
                if (!(spring instanceof AutoPreferredGapSpring)) continue;
                ((AutoPreferredGapSpring)spring).setSources(leading);
                trailingPadding.add((AutoPreferredGapSpring)spring);
            }
        }

        private void checkChildAlignment(Alignment alignment) {
            this.checkChildAlignment(alignment, this instanceof BaselineGroup);
        }

        private void checkChildAlignment(Alignment alignment, boolean allowsBaseline) {
            if (alignment == null) {
                throw new IllegalArgumentException("Alignment must be non-null");
            }
            if (!allowsBaseline && alignment == Alignment.BASELINE) {
                throw new IllegalArgumentException("Alignment must be one of:LEADING, TRAILING or CENTER");
            }
        }
    }

    private static final class SpringDelta
    implements Comparable<SpringDelta> {
        public final int index;
        public int delta;

        public SpringDelta(int index, int delta) {
            this.index = index;
            this.delta = delta;
        }

        @Override
        public int compareTo(SpringDelta o) {
            return this.delta - o.delta;
        }

        public String toString() {
            return super.toString() + "[index=" + this.index + ", delta=" + this.delta + "]";
        }
    }

    public class SequentialGroup
    extends Group {
        private Spring baselineSpring;

        SequentialGroup() {
        }

        @Override
        public SequentialGroup addGroup(Group group) {
            return (SequentialGroup)super.addGroup(group);
        }

        public SequentialGroup addGroup(boolean useAsBaseline, Group group) {
            super.addGroup(group);
            if (useAsBaseline) {
                this.baselineSpring = group;
            }
            return this;
        }

        @Override
        public SequentialGroup addComponent(Component component) {
            return (SequentialGroup)super.addComponent(component);
        }

        public SequentialGroup addComponent(boolean useAsBaseline, Component component) {
            super.addComponent(component);
            if (useAsBaseline) {
                this.baselineSpring = (Spring)this.springs.get(this.springs.size() - 1);
            }
            return this;
        }

        @Override
        public SequentialGroup addComponent(Component component, int min, int pref, int max) {
            return (SequentialGroup)super.addComponent(component, min, pref, max);
        }

        public SequentialGroup addComponent(boolean useAsBaseline, Component component, int min, int pref, int max) {
            super.addComponent(component, min, pref, max);
            if (useAsBaseline) {
                this.baselineSpring = (Spring)this.springs.get(this.springs.size() - 1);
            }
            return this;
        }

        @Override
        public SequentialGroup addGap(int size) {
            return (SequentialGroup)super.addGap(size);
        }

        @Override
        public SequentialGroup addGap(int min, int pref, int max) {
            return (SequentialGroup)super.addGap(min, pref, max);
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, LayoutStyle.ComponentPlacement type) {
            return this.addPreferredGap(comp1, comp2, type, -1, -2);
        }

        public SequentialGroup addPreferredGap(JComponent comp1, JComponent comp2, LayoutStyle.ComponentPlacement type, int pref, int max) {
            if (type == null) {
                throw new IllegalArgumentException("Type must be non-null");
            }
            if (comp1 == null || comp2 == null) {
                throw new IllegalArgumentException("Components must be non-null");
            }
            this.checkPreferredGapValues(pref, max);
            return (SequentialGroup)this.addSpring(new PreferredGapSpring(comp1, comp2, type, pref, max));
        }

        public SequentialGroup addPreferredGap(LayoutStyle.ComponentPlacement type) {
            return this.addPreferredGap(type, -1, -1);
        }

        public SequentialGroup addPreferredGap(LayoutStyle.ComponentPlacement type, int pref, int max) {
            if (type != LayoutStyle.ComponentPlacement.RELATED && type != LayoutStyle.ComponentPlacement.UNRELATED) {
                throw new IllegalArgumentException("Type must be one of LayoutStyle.ComponentPlacement.RELATED or LayoutStyle.ComponentPlacement.UNRELATED");
            }
            this.checkPreferredGapValues(pref, max);
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new AutoPreferredGapSpring(type, pref, max));
        }

        public SequentialGroup addContainerGap() {
            return this.addContainerGap(-1, -1);
        }

        public SequentialGroup addContainerGap(int pref, int max) {
            if (pref < 0 && pref != -1 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_VALUE or >= 0 and pref <= max");
            }
            GroupLayout.this.hasPreferredPaddingSprings = true;
            return (SequentialGroup)this.addSpring(new ContainerAutoPreferredGapSpring(pref, max));
        }

        @Override
        int operator(int a, int b) {
            return this.constrain(a) + this.constrain(b);
        }

        @Override
        void setValidSize(int axis, int origin, int size) {
            int pref = this.getPreferredSize(axis);
            if (size == pref) {
                for (Spring spring : this.springs) {
                    int springPref = spring.getPreferredSize(axis);
                    spring.setSize(axis, origin, springPref);
                    origin += springPref;
                }
            } else if (this.springs.size() == 1) {
                Spring spring = this.getSpring(0);
                spring.setSize(axis, origin, Math.min(Math.max(size, spring.getMinimumSize(axis)), spring.getMaximumSize(axis)));
            } else if (this.springs.size() > 1) {
                this.setValidSizeNotPreferred(axis, origin, size);
            }
        }

        private void setValidSizeNotPreferred(int axis, int origin, int size) {
            List<SpringDelta> resizable;
            int resizableCount;
            int delta = size - this.getPreferredSize(axis);
            assert (delta != 0);
            boolean useMin = delta < 0;
            int springCount = this.springs.size();
            if (useMin) {
                delta *= -1;
            }
            if ((resizableCount = (resizable = this.buildResizableList(axis, useMin)).size()) > 0) {
                int counter;
                int sDelta = delta / resizableCount;
                int slop = delta - sDelta * resizableCount;
                int[] sizes = new int[springCount];
                int sign = useMin ? -1 : 1;
                for (counter = 0; counter < resizableCount; ++counter) {
                    SpringDelta springDelta = resizable.get(counter);
                    if (counter + 1 == resizableCount) {
                        sDelta += slop;
                    }
                    springDelta.delta = Math.min(sDelta, springDelta.delta);
                    delta -= springDelta.delta;
                    if (springDelta.delta != sDelta && counter + 1 < resizableCount) {
                        sDelta = delta / (resizableCount - counter - 1);
                        slop = delta - sDelta * (resizableCount - counter - 1);
                    }
                    sizes[springDelta.index] = sign * springDelta.delta;
                }
                for (counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = spring.getPreferredSize(axis) + sizes[counter];
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            } else {
                for (int counter = 0; counter < springCount; ++counter) {
                    Spring spring = this.getSpring(counter);
                    int sSize = useMin ? spring.getMinimumSize(axis) : spring.getMaximumSize(axis);
                    spring.setSize(axis, origin, sSize);
                    origin += sSize;
                }
            }
        }

        private List<SpringDelta> buildResizableList(int axis, boolean useMin) {
            int size = this.springs.size();
            ArrayList<SpringDelta> sorted = new ArrayList<SpringDelta>(size);
            for (int counter = 0; counter < size; ++counter) {
                Spring spring = this.getSpring(counter);
                int sDelta = useMin ? spring.getPreferredSize(axis) - spring.getMinimumSize(axis) : spring.getMaximumSize(axis) - spring.getPreferredSize(axis);
                if (sDelta <= 0) continue;
                sorted.add(new SpringDelta(counter, sDelta));
            }
            Collections.sort(sorted);
            return sorted;
        }

        private int indexOfNextNonZeroSpring(int index, boolean treatAutopaddingAsZeroSized) {
            while (index < this.springs.size()) {
                Spring spring = (Spring)this.springs.get(index);
                if (!spring.willHaveZeroSize(treatAutopaddingAsZeroSized)) {
                    return index;
                }
                ++index;
            }
            return index;
        }

        @Override
        void insertAutopadding(int axis, List<AutoPreferredGapSpring> leadingPadding, List<AutoPreferredGapSpring> trailingPadding, List<ComponentSpring> leading, List<ComponentSpring> trailing, boolean insert) {
            ArrayList<AutoPreferredGapSpring> newLeadingPadding = new ArrayList<AutoPreferredGapSpring>(leadingPadding);
            ArrayList<AutoPreferredGapSpring> newTrailingPadding = new ArrayList<AutoPreferredGapSpring>(1);
            ArrayList<ComponentSpring> newLeading = new ArrayList<ComponentSpring>(leading);
            ArrayList<ComponentSpring> newTrailing = null;
            int counter = 0;
            while (counter < this.springs.size()) {
                AutoPreferredGapSpring padding;
                Spring spring = this.getSpring(counter);
                if (spring instanceof AutoPreferredGapSpring) {
                    if (newLeadingPadding.size() == 0) {
                        padding = (AutoPreferredGapSpring)spring;
                        padding.setSources(newLeading);
                        newLeading.clear();
                        counter = this.indexOfNextNonZeroSpring(counter + 1, true);
                        if (counter == this.springs.size()) {
                            if (padding instanceof ContainerAutoPreferredGapSpring) continue;
                            trailingPadding.add(padding);
                            continue;
                        }
                        newLeadingPadding.clear();
                        newLeadingPadding.add(padding);
                        continue;
                    }
                    counter = this.indexOfNextNonZeroSpring(counter + 1, true);
                    continue;
                }
                if (newLeading.size() > 0 && newLeadingPadding.isEmpty() && insert) {
                    padding = new AutoPreferredGapSpring();
                    this.springs.add(counter, padding);
                    continue;
                }
                if (spring instanceof ComponentSpring) {
                    ComponentSpring cSpring = (ComponentSpring)spring;
                    if (!cSpring.isVisible()) {
                        ++counter;
                        continue;
                    }
                    for (AutoPreferredGapSpring gapSpring : newLeadingPadding) {
                        gapSpring.addTarget(cSpring, axis);
                    }
                    newLeading.clear();
                    newLeadingPadding.clear();
                    counter = this.indexOfNextNonZeroSpring(counter + 1, false);
                    if (counter == this.springs.size()) {
                        trailing.add(cSpring);
                        continue;
                    }
                    newLeading.add(cSpring);
                    continue;
                }
                if (spring instanceof Group) {
                    if (newTrailing == null) {
                        newTrailing = new ArrayList<ComponentSpring>(1);
                    } else {
                        newTrailing.clear();
                    }
                    newTrailingPadding.clear();
                    ((Group)spring).insertAutopadding(axis, newLeadingPadding, newTrailingPadding, newLeading, newTrailing, insert);
                    newLeading.clear();
                    newLeadingPadding.clear();
                    counter = this.indexOfNextNonZeroSpring(counter + 1, newTrailing.size() == 0);
                    if (counter == this.springs.size()) {
                        trailing.addAll(newTrailing);
                        trailingPadding.addAll(newTrailingPadding);
                        continue;
                    }
                    newLeading.addAll(newTrailing);
                    newLeadingPadding.addAll(newTrailingPadding);
                    continue;
                }
                newLeadingPadding.clear();
                newLeading.clear();
                ++counter;
            }
        }

        @Override
        int getBaseline() {
            int baseline;
            if (this.baselineSpring != null && (baseline = this.baselineSpring.getBaseline()) >= 0) {
                int size = 0;
                for (Spring spring : this.springs) {
                    if (spring == this.baselineSpring) {
                        return size + baseline;
                    }
                    size += spring.getPreferredSize(1);
                }
            }
            return -1;
        }

        @Override
        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            if (this.isResizable(1)) {
                if (!this.baselineSpring.isResizable(1)) {
                    Spring spring;
                    Spring spring2;
                    boolean leadingResizable = false;
                    Iterator iterator = this.springs.iterator();
                    while (iterator.hasNext() && (spring2 = (Spring)iterator.next()) != this.baselineSpring) {
                        if (!spring2.isResizable(1)) continue;
                        leadingResizable = true;
                        break;
                    }
                    boolean trailingResizable = false;
                    for (int i = this.springs.size() - 1; i >= 0 && (spring = (Spring)this.springs.get(i)) != this.baselineSpring; --i) {
                        if (!spring.isResizable(1)) continue;
                        trailingResizable = true;
                        break;
                    }
                    if (leadingResizable && !trailingResizable) {
                        return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                    }
                    if (!leadingResizable && trailingResizable) {
                        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                    }
                } else {
                    Component.BaselineResizeBehavior brb = this.baselineSpring.getBaselineResizeBehavior();
                    if (brb == Component.BaselineResizeBehavior.CONSTANT_ASCENT) {
                        for (Spring spring : this.springs) {
                            if (spring == this.baselineSpring) {
                                return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                            }
                            if (!spring.isResizable(1)) continue;
                            return Component.BaselineResizeBehavior.OTHER;
                        }
                    } else if (brb == Component.BaselineResizeBehavior.CONSTANT_DESCENT) {
                        for (int i = this.springs.size() - 1; i >= 0; --i) {
                            Spring spring = (Spring)this.springs.get(i);
                            if (spring == this.baselineSpring) {
                                return Component.BaselineResizeBehavior.CONSTANT_DESCENT;
                            }
                            if (!spring.isResizable(1)) continue;
                            return Component.BaselineResizeBehavior.OTHER;
                        }
                    }
                }
                return Component.BaselineResizeBehavior.OTHER;
            }
            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
        }

        private void checkPreferredGapValues(int pref, int max) {
            if (pref < 0 && pref != -1 && pref != -2 || max < 0 && max != -1 && max != -2 || pref >= 0 && max >= 0 && pref > max) {
                throw new IllegalArgumentException("Pref and max must be either DEFAULT_SIZE, PREFERRED_SIZE, or >= 0 and pref <= max");
            }
        }
    }

    public abstract class Group
    extends Spring {
        List<Spring> springs;

        Group() {
            this.springs = new ArrayList<Spring>();
        }

        public Group addGroup(Group group) {
            return this.addSpring(group);
        }

        public Group addComponent(Component component) {
            return this.addComponent(component, -1, -1, -1);
        }

        public Group addComponent(Component component, int min, int pref, int max) {
            return this.addSpring(new ComponentSpring(component, min, pref, max));
        }

        public Group addGap(int size) {
            return this.addGap(size, size, size);
        }

        public Group addGap(int min, int pref, int max) {
            return this.addSpring(new GapSpring(min, pref, max));
        }

        Spring getSpring(int index) {
            return this.springs.get(index);
        }

        int indexOf(Spring spring) {
            return this.springs.indexOf(spring);
        }

        Group addSpring(Spring spring) {
            this.springs.add(spring);
            spring.setParent(this);
            if (!(spring instanceof AutoPreferredGapSpring) || !((AutoPreferredGapSpring)spring).getUserCreated()) {
                GroupLayout.this.springsChanged = true;
            }
            return this;
        }

        @Override
        void setSize(int axis, int origin, int size) {
            super.setSize(axis, origin, size);
            if (size == Integer.MIN_VALUE) {
                for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                    this.getSpring(counter).setSize(axis, origin, size);
                }
            } else {
                this.setValidSize(axis, origin, size);
            }
        }

        abstract void setValidSize(int var1, int var2, int var3);

        @Override
        int calculateMinimumSize(int axis) {
            return this.calculateSize(axis, 0);
        }

        @Override
        int calculatePreferredSize(int axis) {
            return this.calculateSize(axis, 1);
        }

        @Override
        int calculateMaximumSize(int axis) {
            return this.calculateSize(axis, 2);
        }

        int calculateSize(int axis, int type) {
            int count = this.springs.size();
            if (count == 0) {
                return 0;
            }
            if (count == 1) {
                return this.getSpringSize(this.getSpring(0), axis, type);
            }
            int size = this.constrain(this.operator(this.getSpringSize(this.getSpring(0), axis, type), this.getSpringSize(this.getSpring(1), axis, type)));
            for (int counter = 2; counter < count; ++counter) {
                size = this.constrain(this.operator(size, this.getSpringSize(this.getSpring(counter), axis, type)));
            }
            return size;
        }

        int getSpringSize(Spring spring, int axis, int type) {
            switch (type) {
                case 0: {
                    return spring.getMinimumSize(axis);
                }
                case 1: {
                    return spring.getPreferredSize(axis);
                }
                case 2: {
                    return spring.getMaximumSize(axis);
                }
            }
            assert (false);
            return 0;
        }

        abstract int operator(int var1, int var2);

        abstract void insertAutopadding(int var1, List<AutoPreferredGapSpring> var2, List<AutoPreferredGapSpring> var3, List<ComponentSpring> var4, List<ComponentSpring> var5, boolean var6);

        void removeAutopadding() {
            this.unset();
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = this.springs.get(counter);
                if (spring instanceof AutoPreferredGapSpring) {
                    if (((AutoPreferredGapSpring)spring).getUserCreated()) {
                        ((AutoPreferredGapSpring)spring).reset();
                        continue;
                    }
                    this.springs.remove(counter);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).removeAutopadding();
            }
        }

        void unsetAutopadding() {
            this.unset();
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = this.springs.get(counter);
                if (spring instanceof AutoPreferredGapSpring) {
                    spring.unset();
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).unsetAutopadding();
            }
        }

        void calculateAutopadding(int axis) {
            for (int counter = this.springs.size() - 1; counter >= 0; --counter) {
                Spring spring = this.springs.get(counter);
                if (spring instanceof AutoPreferredGapSpring) {
                    spring.unset();
                    ((AutoPreferredGapSpring)spring).calculatePadding(axis);
                    continue;
                }
                if (!(spring instanceof Group)) continue;
                ((Group)spring).calculateAutopadding(axis);
            }
            this.unset();
        }

        @Override
        boolean willHaveZeroSize(boolean treatAutopaddingAsZeroSized) {
            for (int i = this.springs.size() - 1; i >= 0; --i) {
                Spring spring = this.springs.get(i);
                if (spring.willHaveZeroSize(treatAutopaddingAsZeroSized)) continue;
                return false;
            }
            return true;
        }
    }

    private abstract class Spring {
        private int size;
        private int min;
        private int max = Integer.MIN_VALUE;
        private int pref = Integer.MIN_VALUE;
        private Spring parent;
        private Alignment alignment;

        Spring() {
            this.min = Integer.MIN_VALUE;
        }

        abstract int calculateMinimumSize(int var1);

        abstract int calculatePreferredSize(int var1);

        abstract int calculateMaximumSize(int var1);

        void setParent(Spring parent) {
            this.parent = parent;
        }

        Spring getParent() {
            return this.parent;
        }

        void setAlignment(Alignment alignment) {
            this.alignment = alignment;
        }

        Alignment getAlignment() {
            return this.alignment;
        }

        final int getMinimumSize(int axis) {
            if (this.min == Integer.MIN_VALUE) {
                this.min = this.constrain(this.calculateMinimumSize(axis));
            }
            return this.min;
        }

        final int getPreferredSize(int axis) {
            if (this.pref == Integer.MIN_VALUE) {
                this.pref = this.constrain(this.calculatePreferredSize(axis));
            }
            return this.pref;
        }

        final int getMaximumSize(int axis) {
            if (this.max == Integer.MIN_VALUE) {
                this.max = this.constrain(this.calculateMaximumSize(axis));
            }
            return this.max;
        }

        void setSize(int axis, int origin, int size) {
            this.size = size;
            if (size == Integer.MIN_VALUE) {
                this.unset();
            }
        }

        void unset() {
            this.max = Integer.MIN_VALUE;
            this.pref = Integer.MIN_VALUE;
            this.min = Integer.MIN_VALUE;
            this.size = Integer.MIN_VALUE;
        }

        int getSize() {
            return this.size;
        }

        int constrain(int value) {
            return Math.min(value, 0x3FFFFFFF);
        }

        int getBaseline() {
            return -1;
        }

        Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return Component.BaselineResizeBehavior.OTHER;
        }

        final boolean isResizable(int axis) {
            int pref;
            int min = this.getMinimumSize(axis);
            return min != (pref = this.getPreferredSize(axis)) || pref != this.getMaximumSize(axis);
        }

        abstract boolean willHaveZeroSize(boolean var1);
    }

    public static enum Alignment {
        LEADING,
        TRAILING,
        CENTER,
        BASELINE;

    }
}

