/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ColorChooserDialog;
import javax.swing.ColorTracker;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingContainer;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.plaf.ColorChooserUI;

@JavaBean(defaultProperty="UI", description="A component that supports selecting a Color.")
@SwingContainer(value=false)
public class JColorChooser
extends JComponent
implements Accessible {
    private static final String uiClassID = "ColorChooserUI";
    private ColorSelectionModel selectionModel;
    private JComponent previewPanel = ColorChooserComponentFactory.getPreviewPanel();
    private AbstractColorChooserPanel[] chooserPanels = new AbstractColorChooserPanel[0];
    private boolean dragEnabled;
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String PREVIEW_PANEL_PROPERTY = "previewPanel";
    public static final String CHOOSER_PANELS_PROPERTY = "chooserPanels";
    protected AccessibleContext accessibleContext = null;

    public static Color showDialog(Component component, String title, Color initialColor) throws HeadlessException {
        return JColorChooser.showDialog(component, title, initialColor, true);
    }

    public static Color showDialog(Component component, String title, Color initialColor, boolean colorTransparencySelectionEnabled) throws HeadlessException {
        JColorChooser pane = new JColorChooser(initialColor != null ? initialColor : Color.white);
        for (AbstractColorChooserPanel ccPanel : pane.getChooserPanels()) {
            ccPanel.setColorTransparencySelectionEnabled(colorTransparencySelectionEnabled);
        }
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addComponentListener(new ColorChooserDialog.DisposeOnClose());
        dialog.show();
        return ok.getColor();
    }

    public static JDialog createDialog(Component c, String title, boolean modal, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        Window window = JOptionPane.getWindowForComponent(c);
        ColorChooserDialog dialog = window instanceof Frame ? new ColorChooserDialog((Frame)window, title, modal, c, chooserPane, okListener, cancelListener) : new ColorChooserDialog((Dialog)window, title, modal, c, chooserPane, okListener, cancelListener);
        dialog.getAccessibleContext().setAccessibleDescription(title);
        return dialog;
    }

    public JColorChooser() {
        this(Color.white);
    }

    public JColorChooser(Color initialColor) {
        this(new DefaultColorSelectionModel(initialColor));
    }

    public JColorChooser(ColorSelectionModel model) {
        this.selectionModel = model;
        this.updateUI();
        this.dragEnabled = false;
    }

    @Override
    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.ui;
    }

    @BeanProperty(hidden=true, description="The UI object that implements the color chooser's LookAndFeel.")
    public void setUI(ColorChooserUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((ColorChooserUI)UIManager.getUI(this));
    }

    @Override
    @BeanProperty(bound=false)
    public String getUIClassID() {
        return uiClassID;
    }

    public Color getColor() {
        return this.selectionModel.getSelectedColor();
    }

    @BeanProperty(bound=false, description="The current color the chooser is to display.")
    public void setColor(Color color) {
        this.selectionModel.setSelectedColor(color);
    }

    public void setColor(int r, int g, int b) {
        this.setColor(new Color(r, g, b));
    }

    public void setColor(int c) {
        this.setColor(c >> 16 & 0xFF, c >> 8 & 0xFF, c & 0xFF);
    }

    @BeanProperty(bound=false, description="Determines whether automatic drag handling is enabled.")
    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    @BeanProperty(hidden=true, description="The UI component which displays the current color.")
    public void setPreviewPanel(JComponent preview) {
        if (this.previewPanel != preview) {
            JComponent oldPreview = this.previewPanel;
            this.previewPanel = preview;
            this.firePropertyChange(PREVIEW_PANEL_PROPERTY, oldPreview, preview);
        }
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    public void addChooserPanel(AbstractColorChooserPanel panel) {
        AbstractColorChooserPanel[] oldPanels = this.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[oldPanels.length + 1];
        System.arraycopy(oldPanels, 0, newPanels, 0, oldPanels.length);
        newPanels[newPanels.length - 1] = panel;
        this.setChooserPanels(newPanels);
    }

    public AbstractColorChooserPanel removeChooserPanel(AbstractColorChooserPanel panel) {
        int containedAt = -1;
        for (int i = 0; i < this.chooserPanels.length; ++i) {
            if (this.chooserPanels[i] != panel) continue;
            containedAt = i;
            break;
        }
        if (containedAt == -1) {
            throw new IllegalArgumentException("chooser panel not in this chooser");
        }
        AbstractColorChooserPanel[] newArray = new AbstractColorChooserPanel[this.chooserPanels.length - 1];
        if (containedAt == this.chooserPanels.length - 1) {
            System.arraycopy(this.chooserPanels, 0, newArray, 0, newArray.length);
        } else if (containedAt == 0) {
            System.arraycopy(this.chooserPanels, 1, newArray, 0, newArray.length);
        } else {
            System.arraycopy(this.chooserPanels, 0, newArray, 0, containedAt);
            System.arraycopy(this.chooserPanels, containedAt + 1, newArray, containedAt, this.chooserPanels.length - containedAt - 1);
        }
        this.setChooserPanels(newArray);
        return panel;
    }

    @BeanProperty(hidden=true, description="An array of different chooser types.")
    public void setChooserPanels(AbstractColorChooserPanel[] panels) {
        AbstractColorChooserPanel[] oldValue = this.chooserPanels;
        this.chooserPanels = Arrays.copyOf(panels, panels.length);
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, oldValue, panels);
    }

    public AbstractColorChooserPanel[] getChooserPanels() {
        return Arrays.copyOf(this.chooserPanels, this.chooserPanels.length);
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @BeanProperty(hidden=true, description="The model which contains the currently selected color.")
    public void setSelectionModel(ColorSelectionModel newModel) {
        ColorSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldModel, newModel);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        StringBuilder chooserPanelsString = new StringBuilder();
        for (AbstractColorChooserPanel panel : this.chooserPanels) {
            chooserPanelsString.append('[').append(panel).append(']');
        }
        String previewPanelString = this.previewPanel != null ? this.previewPanel.toString() : "";
        return super.paramString() + ",chooserPanels=" + chooserPanelsString.toString() + ",previewPanel=" + previewPanelString;
    }

    @Override
    @BeanProperty(bound=false)
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJColorChooser();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJColorChooser
    extends JComponent.AccessibleJComponent {
        protected AccessibleJColorChooser() {
            super(JColorChooser.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }
}

