/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingContainer;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

@JavaBean(description="A text component that can be marked up with attributes that are graphically represented.")
@SwingContainer
public class JTextPane
extends JEditorPane {
    private static final String uiClassID = "TextPaneUI";

    public JTextPane() {
        EditorKit editorKit = this.createDefaultEditorKit();
        String contentType = editorKit.getContentType();
        if (contentType != null && JTextPane.getEditorKitClassNameForContentType(contentType) == defaultEditorKitMap.get(contentType)) {
            this.setEditorKitForContentType(contentType, editorKit);
        }
        this.setEditorKit(editorKit);
    }

    public JTextPane(StyledDocument doc) {
        this();
        this.setStyledDocument(doc);
    }

    @Override
    @BeanProperty(bound=false)
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setDocument(Document doc) {
        if (!(doc instanceof StyledDocument)) {
            throw new IllegalArgumentException("Model must be StyledDocument");
        }
        super.setDocument(doc);
    }

    public void setStyledDocument(StyledDocument doc) {
        super.setDocument(doc);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    @Override
    public void replaceSelection(String content) {
        this.replaceSelection(content, true);
    }

    private void replaceSelection(String content, boolean checkEditable) {
        if (checkEditable && !this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        StyledDocument doc = this.getStyledDocument();
        if (doc != null) {
            try {
                Caret caret = this.getCaret();
                boolean composedTextSaved = this.saveComposedText(caret.getDot());
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                AttributeSet attr = this.getInputAttributes().copyAttributes();
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)((Object)doc)).replace(p0, p1 - p0, content, attr);
                } else {
                    if (p0 != p1) {
                        doc.remove(p0, p1 - p0);
                    }
                    if (content != null && content.length() > 0) {
                        doc.insertString(p0, content, attr);
                    }
                }
                if (composedTextSaved) {
                    this.restoreComposedText();
                }
            }
            catch (BadLocationException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public void insertComponent(Component c) {
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        StyleConstants.setComponent(inputAttributes, c);
        this.replaceSelection(" ", false);
        inputAttributes.removeAttributes(inputAttributes);
    }

    public void insertIcon(Icon g) {
        MutableAttributeSet inputAttributes = this.getInputAttributes();
        inputAttributes.removeAttributes(inputAttributes);
        StyleConstants.setIcon(inputAttributes, g);
        this.replaceSelection(" ", false);
        inputAttributes.removeAttributes(inputAttributes);
    }

    public Style addStyle(String nm, Style parent) {
        StyledDocument doc = this.getStyledDocument();
        return doc.addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        doc.removeStyle(nm);
    }

    public Style getStyle(String nm) {
        StyledDocument doc = this.getStyledDocument();
        return doc.getStyle(nm);
    }

    public void setLogicalStyle(Style s) {
        StyledDocument doc = this.getStyledDocument();
        doc.setLogicalStyle(this.getCaretPosition(), s);
    }

    public Style getLogicalStyle() {
        StyledDocument doc = this.getStyledDocument();
        return doc.getLogicalStyle(this.getCaretPosition());
    }

    @BeanProperty(bound=false)
    public AttributeSet getCharacterAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element run = doc.getCharacterElement(this.getCaretPosition());
        if (run != null) {
            return run.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attr, boolean replace) {
        int p1;
        int p0 = this.getSelectionStart();
        if (p0 != (p1 = this.getSelectionEnd())) {
            StyledDocument doc = this.getStyledDocument();
            doc.setCharacterAttributes(p0, p1 - p0, attr, replace);
        } else {
            MutableAttributeSet inputAttributes = this.getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attr);
        }
    }

    @BeanProperty(bound=false)
    public AttributeSet getParagraphAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element paragraph = doc.getParagraphElement(this.getCaretPosition());
        if (paragraph != null) {
            return paragraph.getAttributes();
        }
        return null;
    }

    public void setParagraphAttributes(AttributeSet attr, boolean replace) {
        int p0 = this.getSelectionStart();
        int p1 = this.getSelectionEnd();
        StyledDocument doc = this.getStyledDocument();
        doc.setParagraphAttributes(p0, p1 - p0, attr, replace);
    }

    @BeanProperty(bound=false)
    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    @Override
    public final void setEditorKit(EditorKit kit) {
        if (!(kit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("Must be StyledEditorKit");
        }
        super.setEditorKit(kit);
    }

    @Override
    protected String paramString() {
        return super.paramString();
    }
}

