/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.filechooser;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

class UnixFileSystemView
extends FileSystemView {
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.other.newFolder.subsequent");

    UnixFileSystemView() {
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 1; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, i));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        if (!newFolder.mkdirs()) {
            throw new IOException(newFolder.getAbsolutePath());
        }
        return newFolder;
    }

    @Override
    public boolean isFileSystemRoot(File dir) {
        return dir != null && dir.getAbsolutePath().equals("/");
    }

    @Override
    public boolean isDrive(File dir) {
        return this.isFloppyDrive(dir);
    }

    @Override
    public boolean isFloppyDrive(File dir) {
        return false;
    }

    @Override
    public boolean isComputerNode(File dir) {
        String parent;
        return dir != null && (parent = dir.getParent()) != null && parent.equals("/net");
    }
}

