/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    private static String newline = System.lineSeparator();
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("close"));
        BasicLookAndFeel.installAudioActionMap(map);
    }

    public static ComponentUI createUI(JComponent x) {
        return new BasicOptionPaneUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.optionPane = (JOptionPane)c;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        LookAndFeel.installProperty(this.optionPane, "opaque", Boolean.TRUE);
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container separator = this.createSeparator();
        if (separator != null) {
            this.optionPane.add(separator);
        }
        this.optionPane.add(this.createButtonArea());
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installKeyboardActions() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, map);
        LazyActionMap.installLazyActionMap(this.optionPane, BasicOptionPaneUI.class, "OptionPane.actionMap");
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.optionPane, 2, null);
        SwingUtilities.replaceUIActionMap(this.optionPane, null);
    }

    InputMap getInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])DefaultLookup.get(this.optionPane, this, "OptionPane.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.optionPane, bindings);
        }
        return null;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c == this.optionPane) {
            Dimension ourMin = this.getMinimumOptionPaneSize();
            LayoutManager lm = c.getLayout();
            if (lm != null) {
                Dimension lmSize = lm.preferredLayoutSize(c);
                if (ourMin != null) {
                    return new Dimension(Math.max(lmSize.width, ourMin.width), Math.max(lmSize.height, ourMin.height));
                }
                return lmSize;
            }
            return ourMin;
        }
        return null;
    }

    protected Container createMessageArea() {
        JPanel top = new JPanel();
        Border topBorder = (Border)DefaultLookup.get(this.optionPane, this, "OptionPane.messageAreaBorder");
        if (topBorder != null) {
            top.setBorder(topBorder);
        }
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel(new GridBagLayout());
        JPanel realBody = new JPanel(new BorderLayout());
        body.setName("OptionPane.body");
        realBody.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            JPanel sep = new JPanel();
            sep.setName("OptionPane.separator");
            sep.setPreferredSize(new Dimension(15, 1));
            realBody.add((Component)sep, "Before");
        }
        realBody.add((Component)body, "Center");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = DefaultLookup.getInt(this.optionPane, this, "OptionPane.messageAnchor", 10);
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        this.addIcon(top);
        return top;
    }

    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            if (msg instanceof JScrollPane || msg instanceof JPanel) {
                cons.fill = 1;
                cons.weighty = 1.0;
            } else {
                cons.fill = 2;
            }
            cons.weightx = 1.0;
            container.add((Component)msg, cons);
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            ++cons.gridy;
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            Object[] msgs;
            for (Object o : msgs = (Object[])msg) {
                this.addMessageComponents(container, cons, o, maxll, false);
            }
        } else if (msg instanceof Icon) {
            JLabel label = new JLabel((Icon)msg, 0);
            this.configureMessageLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        } else {
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            int nll = 0;
            int nl = s.indexOf(newline);
            if (nl >= 0) {
                nll = newline.length();
            } else {
                nl = s.indexOf("\r\n");
                if (nl >= 0) {
                    nll = 2;
                } else {
                    nl = s.indexOf(10);
                    if (nl >= 0) {
                        nll = 1;
                    }
                }
            }
            if (nl >= 0) {
                if (nl == 0) {
                    JPanel breakPanel = new JPanel(){

                        @Override
                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            if (f != null) {
                                return new Dimension(1, f.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    };
                    breakPanel.setName("OptionPane.break");
                    this.addMessageComponents(container, cons, breakPanel, maxll, true);
                } else {
                    this.addMessageComponents(container, cons, s.substring(0, nl), maxll, false);
                }
                this.addMessageComponents(container, cons, s.substring(nl + nll), maxll, false);
            } else if (len > maxll) {
                Box c = Box.createVerticalBox();
                c.setName("OptionPane.verticalBox");
                this.burstStringInto(c, s, maxll);
                this.addMessageComponents(container, cons, c, maxll, true);
            } else {
                JLabel label = new JLabel(s, 10);
                label.setName("OptionPane.label");
                this.configureMessageLabel(label);
                this.addMessageComponents(container, cons, label, maxll, true);
            }
        }
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent toAdd;
                Object message = this.optionPane.getMessage();
                Object[] sValues = this.optionPane.getSelectionValues();
                Object inputValue = this.optionPane.getInitialSelectionValue();
                if (sValues != null) {
                    if (sValues.length < 20) {
                        JComboBox<Object> cBox = new JComboBox<Object>();
                        cBox.setName("OptionPane.comboBox");
                        int maxCounter = sValues.length;
                        for (int counter = 0; counter < maxCounter; ++counter) {
                            cBox.addItem(sValues[counter]);
                        }
                        if (inputValue != null) {
                            cBox.setSelectedItem(inputValue);
                        }
                        this.inputComponent = cBox;
                        toAdd = cBox;
                    } else {
                        JList<Object> list = new JList<Object>(sValues);
                        JScrollPane sp = new JScrollPane(list);
                        sp.setName("OptionPane.scrollPane");
                        list.setName("OptionPane.list");
                        list.setVisibleRowCount(10);
                        list.setSelectionMode(0);
                        if (inputValue != null) {
                            list.setSelectedValue(inputValue, true);
                        }
                        list.addMouseListener(this.getHandler());
                        toAdd = sp;
                        this.inputComponent = list;
                    }
                } else {
                    MultiplexingTextField tf = new MultiplexingTextField(20);
                    tf.setName("OptionPane.textField");
                    tf.setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (inputValue != null) {
                        String inputString = inputValue.toString();
                        tf.setText(inputString);
                        tf.setSelectionStart(0);
                        tf.setSelectionEnd(inputString.length());
                    }
                    tf.addActionListener(this.getHandler());
                    this.inputComponent = tf;
                    toAdd = this.inputComponent;
                }
                Object[] newMessage = message == null ? new Object[]{toAdd} : new Object[]{message, toAdd};
                return newMessage;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setName("OptionPane.iconLabel");
            iconLabel.setVerticalAlignment(1);
            top.add((Component)iconLabel, "Before");
        }
    }

    protected Icon getIcon() {
        Icon mIcon;
        Icon icon = mIcon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (mIcon == null && this.optionPane != null) {
            mIcon = this.getIconForType(this.optionPane.getMessageType());
        }
        return mIcon;
    }

    protected Icon getIconForType(int messageType) {
        if (messageType < 0 || messageType > 3) {
            return null;
        }
        String propertyName = null;
        switch (messageType) {
            case 0: {
                propertyName = "OptionPane.errorIcon";
                break;
            }
            case 1: {
                propertyName = "OptionPane.informationIcon";
                break;
            }
            case 2: {
                propertyName = "OptionPane.warningIcon";
                break;
            }
            case 3: {
                propertyName = "OptionPane.questionIcon";
            }
        }
        if (propertyName != null) {
            return (Icon)DefaultLookup.get(this.optionPane, this, propertyName);
        }
        return null;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    protected void burstStringInto(Container c, String d, int maxll) {
        int len = d.length();
        if (len <= 0) {
            return;
        }
        if (len > maxll) {
            int p = d.lastIndexOf(32, maxll);
            if (p <= 0) {
                p = d.indexOf(32, maxll);
            }
            if (p > 0 && p < len) {
                this.burstStringInto(c, d.substring(0, p), maxll);
                this.burstStringInto(c, d.substring(p + 1), maxll);
                return;
            }
        }
        JLabel label = new JLabel(d, 2);
        label.setName("OptionPane.label");
        this.configureMessageLabel(label);
        c.add(label);
    }

    protected Container createSeparator() {
        return null;
    }

    protected Container createButtonArea() {
        JPanel bottom = new JPanel();
        Border border = (Border)DefaultLookup.get(this.optionPane, this, "OptionPane.buttonAreaBorder");
        bottom.setName("OptionPane.buttonArea");
        if (border != null) {
            bottom.setBorder(border);
        }
        bottom.setLayout(new ButtonAreaLayout(DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", true), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonPadding", 6), DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonOrientation", 0), DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.isYesLast", false)));
        this.addButtonComponents(bottom, this.getButtons(), this.getInitialValueIndex());
        return bottom;
    }

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = this.getSizeButtonsToSameWidth();
            boolean createdAll = true;
            int numButtons = buttons.length;
            JButton[] createdButtons = null;
            int maxWidth = 0;
            if (sizeButtonsToSame) {
                createdButtons = new JButton[numButtons];
            }
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    JButton aButton = button instanceof ButtonFactory ? ((ButtonFactory)button).createButton() : (button instanceof Icon ? new JButton((Icon)button) : new JButton(button.toString()));
                    aButton.setName("OptionPane.button");
                    aButton.setMultiClickThreshhold(DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonClickThreshhold", 0));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                }
                if (sizeButtonsToSame && createdAll && newComponent instanceof JButton) {
                    createdButtons[counter] = (JButton)newComponent;
                    maxWidth = Math.max(maxWidth, newComponent.getMinimumSize().width);
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        JButton defaultButton;
                        JRootPane root;
                        if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }
                });
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(sizeButtonsToSame && createdAll);
            if (DefaultLookup.getBoolean(this.optionPane, this, "OptionPane.setButtonMargin", true) && sizeButtonsToSame && createdAll) {
                int padSize = numButtons <= 2 ? 8 : 4;
                for (int counter = 0; counter < numButtons; ++counter) {
                    JButton aButton = createdButtons[counter];
                    aButton.setMargin(new Insets(2, padSize, 2, padSize));
                }
            }
        }
    }

    protected ActionListener createButtonActionListener(int buttonIndex) {
        return new ButtonActionListener(buttonIndex);
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                int type = this.optionPane.getOptionType();
                Locale l = this.optionPane.getLocale();
                int minimumWidth = DefaultLookup.getInt(this.optionPane, this, "OptionPane.buttonMinimumWidth", -1);
                Object[] defaultOptions = type == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), minimumWidth), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), minimumWidth)} : (type == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.yesButtonText", l), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.yesIcon"), minimumWidth), new ButtonFactory(UIManager.getString((Object)"OptionPane.noButtonText", l), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.noIcon"), minimumWidth), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), minimumWidth)} : (type == 2 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), minimumWidth), new ButtonFactory(UIManager.getString((Object)"OptionPane.cancelButtonText", l), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.cancelIcon"), minimumWidth)} : new ButtonFactory[]{new ButtonFactory(UIManager.getString((Object)"OptionPane.okButtonText", l), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)DefaultLookup.get(this.optionPane, this, "OptionPane.okIcon"), minimumWidth)}));
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key, l);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object iv = this.optionPane.getInitialValue();
            Object[] options = this.optionPane.getOptions();
            if (options == null) {
                return 0;
            }
            if (iv != null) {
                for (int counter = options.length - 1; counter >= 0; --counter) {
                    if (!options[counter].equals(iv)) continue;
                    return counter;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    @Override
    public void selectInitialValue(JOptionPane op) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane root;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (root = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                root.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    @Override
    public boolean containsCustomComponents(JOptionPane op) {
        return this.hasCustomComponents;
    }

    private void configureMessageLabel(JLabel label) {
        Font messageFont;
        Color color = (Color)DefaultLookup.get(this.optionPane, this, "OptionPane.messageForeground");
        if (color != null) {
            label.setForeground(color);
        }
        if ((messageFont = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.messageFont")) != null) {
            label.setFont(messageFont);
        }
    }

    private void configureButton(JButton button) {
        Font buttonFont = (Font)DefaultLookup.get(this.optionPane, this, "OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    static {
        if (newline == null) {
            newline = "\n";
        }
    }

    private static class ButtonFactory {
        private String text;
        private int mnemonic;
        private Icon icon;
        private int minimumWidth = -1;

        ButtonFactory(String text, int mnemonic, Icon icon, int minimumWidth) {
            this.text = text;
            this.mnemonic = mnemonic;
            this.icon = icon;
            this.minimumWidth = minimumWidth;
        }

        JButton createButton() {
            JButton button = this.minimumWidth > 0 ? new ConstrainedButton(this.text, this.minimumWidth) : new JButton(this.text);
            if (this.icon != null) {
                button.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                button.setMnemonic(this.mnemonic);
            }
            return button;
        }

        private static class ConstrainedButton
        extends JButton {
            int minimumWidth;

            ConstrainedButton(String text, int minimumWidth) {
                super(text);
                this.minimumWidth = minimumWidth;
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension min = super.getMinimumSize();
                min.width = Math.max(min.width, this.minimumWidth);
                return min;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                pref.width = Math.max(pref.width, this.minimumWidth);
                return pref;
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CLOSE = "close";

        Actions(String key) {
            super(key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.getName() == CLOSE) {
                JOptionPane optionPane = (JOptionPane)e.getSource();
                optionPane.setValue(-1);
            }
        }
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        MultiplexingTextField(int cols) {
            super(cols);
        }

        void setKeyStrokes(KeyStroke[] strokes) {
            this.strokes = strokes;
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean processed = super.processKeyBinding(ks, e, condition, pressed);
            if (processed && condition != 2) {
                for (int counter = this.strokes.length - 1; counter >= 0; --counter) {
                    if (!this.strokes[counter].equals(ks)) continue;
                    return false;
                }
            }
            return processed;
        }
    }

    private class Handler
    implements ActionListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicOptionPaneUI.this.optionPane.setInputValue(((JTextField)e.getSource()).getText());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                BasicOptionPaneUI.this.optionPane.setInputValue(list.getModel().getElementAt(index));
                BasicOptionPaneUI.this.optionPane.setValue(0);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicOptionPaneUI.this.optionPane) {
                String changeName;
                if ("ancestor" == e.getPropertyName()) {
                    JOptionPane op = (JOptionPane)e.getSource();
                    boolean isComingUp = e.getOldValue() == null;
                    switch (op.getMessageType()) {
                        case -1: {
                            if (!isComingUp) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 3: {
                            if (!isComingUp) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.questionSound");
                            break;
                        }
                        case 1: {
                            if (!isComingUp) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.informationSound");
                            break;
                        }
                        case 2: {
                            if (!isComingUp) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.warningSound");
                            break;
                        }
                        case 0: {
                            if (!isComingUp) break;
                            BasicLookAndFeel.playSound(BasicOptionPaneUI.this.optionPane, "OptionPane.errorSound");
                            break;
                        }
                        default: {
                            System.err.println("Undefined JOptionPane type: " + op.getMessageType());
                        }
                    }
                }
                if ((changeName = e.getPropertyName()) == "options" || changeName == "initialValue" || changeName == "icon" || changeName == "messageType" || changeName == "optionType" || changeName == "message" || changeName == "selectionValues" || changeName == "initialSelectionValue" || changeName == "wantsInput") {
                    BasicOptionPaneUI.this.uninstallComponents();
                    BasicOptionPaneUI.this.installComponents();
                    BasicOptionPaneUI.this.optionPane.validate();
                } else if (changeName == "componentOrientation") {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JOptionPane op = (JOptionPane)e.getSource();
                    if (o != e.getOldValue()) {
                        op.applyComponentOrientation(o);
                    }
                }
            }
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicOptionPaneUI.this.optionPane != null) {
                int optionType = BasicOptionPaneUI.this.optionPane.getOptionType();
                Object[] options = BasicOptionPaneUI.this.optionPane.getOptions();
                if (BasicOptionPaneUI.this.inputComponent != null && (options != null || optionType == -1 || (optionType == 0 || optionType == 1 || optionType == 2) && this.buttonIndex == 0)) {
                    BasicOptionPaneUI.this.resetInputValue();
                }
                if (options == null) {
                    if (optionType == 2 && this.buttonIndex == 1) {
                        BasicOptionPaneUI.this.optionPane.setValue(2);
                    } else {
                        BasicOptionPaneUI.this.optionPane.setValue(this.buttonIndex);
                    }
                } else {
                    BasicOptionPaneUI.this.optionPane.setValue(options[this.buttonIndex]);
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            BasicOptionPaneUI.this.getHandler().propertyChange(e);
        }
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;
        private int orientation;
        private boolean reverseButtons;
        private boolean useOrientation;

        public ButtonAreaLayout(boolean syncAllWidths, int padding) {
            this.syncAllWidths = syncAllWidths;
            this.padding = padding;
            this.centersChildren = true;
            this.useOrientation = false;
        }

        ButtonAreaLayout(boolean syncAllSizes, int padding, int orientation, boolean reverseButtons) {
            this(syncAllSizes, padding);
            this.useOrientation = true;
            this.orientation = orientation;
            this.reverseButtons = reverseButtons;
        }

        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int newPadding) {
            this.padding = newPadding;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
            this.useOrientation = false;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        private int getOrientation(Container container) {
            if (!this.useOrientation) {
                return 0;
            }
            if (container.getComponentOrientation().isLeftToRight()) {
                return this.orientation;
            }
            switch (this.orientation) {
                case 2: {
                    return 4;
                }
                case 4: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            return 2;
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int counter;
                int numChildren = children.length;
                Insets insets = container.getInsets();
                int maxWidth = 0;
                int maxHeight = 0;
                int totalButtonWidth = 0;
                int x = 0;
                int xOffset = 0;
                boolean ltr = container.getComponentOrientation().isLeftToRight();
                boolean reverse = ltr ? this.reverseButtons : !this.reverseButtons;
                for (counter = 0; counter < numChildren; ++counter) {
                    Dimension pref = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, pref.width);
                    maxHeight = Math.max(maxHeight, pref.height);
                    totalButtonWidth += pref.width;
                }
                if (this.getSyncAllWidths()) {
                    totalButtonWidth = maxWidth * numChildren;
                }
                totalButtonWidth += (numChildren - 1) * this.padding;
                switch (this.getOrientation(container)) {
                    case 2: {
                        x = insets.left;
                        break;
                    }
                    case 4: {
                        x = container.getWidth() - insets.right - totalButtonWidth;
                        break;
                    }
                    case 0: {
                        if (this.getCentersChildren() || numChildren < 2) {
                            x = (container.getWidth() - totalButtonWidth) / 2;
                            break;
                        }
                        x = insets.left;
                        xOffset = this.getSyncAllWidths() ? (container.getWidth() - insets.left - insets.right - totalButtonWidth) / (numChildren - 1) + maxWidth : (container.getWidth() - insets.left - insets.right - totalButtonWidth) / (numChildren - 1);
                    }
                }
                for (counter = 0; counter < numChildren; ++counter) {
                    int index = reverse ? numChildren - counter - 1 : counter;
                    Dimension pref = children[index].getPreferredSize();
                    if (this.getSyncAllWidths()) {
                        children[index].setBounds(x, insets.top, maxWidth, maxHeight);
                    } else {
                        children[index].setBounds(x, insets.top, pref.width, pref.height);
                    }
                    if (xOffset != 0) {
                        x += xOffset;
                        continue;
                    }
                    x += children[index].getWidth() + this.padding;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                if (this.syncAllWidths) {
                    int maxWidth = 0;
                    for (int counter = 0; counter < numChildren; ++counter) {
                        Dimension aSize = children[counter].getPreferredSize();
                        height = Math.max(height, aSize.height);
                        maxWidth = Math.max(maxWidth, aSize.width);
                    }
                    return new Dimension(extraWidth + maxWidth * numChildren + (numChildren - 1) * this.padding, extraHeight + height);
                }
                int totalWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    totalWidth += aSize.width;
                }
                return new Dimension(extraWidth + (totalWidth += (numChildren - 1) * this.padding), extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }
}

