/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.SeparatorUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthSeparatorUI
extends SeparatorUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent c) {
        return new SynthSeparatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults((JSeparator)c);
        this.installListeners((JSeparator)c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners((JSeparator)c);
        this.uninstallDefaults((JSeparator)c);
    }

    public void installDefaults(JSeparator c) {
        this.updateStyle(c);
    }

    private void updateStyle(JSeparator sep) {
        Dimension size;
        SynthContext context = this.getContext(sep, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && sep instanceof JToolBar.Separator && ((size = ((JToolBar.Separator)sep).getSeparatorSize()) == null || size instanceof UIResource)) {
            size = (DimensionUIResource)this.style.get(context, "ToolBar.separatorSize");
            if (size == null) {
                size = new DimensionUIResource(10, 10);
            }
            ((JToolBar.Separator)sep).setSeparatorSize(size);
        }
    }

    public void uninstallDefaults(JSeparator c) {
        SynthContext context = this.getContext(c, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
    }

    public void installListeners(JSeparator c) {
        c.addPropertyChangeListener(this);
    }

    public void uninstallListeners(JSeparator c) {
        c.removePropertyChangeListener(this);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        JSeparator separator = (JSeparator)context.getComponent();
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintSeparatorBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), separator.getOrientation());
        this.paint(context, g);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        JSeparator separator = (JSeparator)context.getComponent();
        context.getPainter().paintSeparatorForeground(context, g, 0, 0, separator.getWidth(), separator.getHeight(), separator.getOrientation());
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        JSeparator separator = (JSeparator)context.getComponent();
        context.getPainter().paintSeparatorBorder(context, g, x, y, w, h, separator.getOrientation());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SynthContext context = this.getContext(c);
        int thickness = this.style.getInt(context, "Separator.thickness", 2);
        Insets insets = c.getInsets();
        Dimension size = ((JSeparator)c).getOrientation() == 1 ? new Dimension(insets.left + insets.right + thickness, insets.top + insets.bottom) : new Dimension(insets.left + insets.right, insets.top + insets.bottom + thickness);
        return size;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
            this.updateStyle((JSeparator)evt.getSource());
        }
    }
}

