/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class SynthTabbedPaneUI
extends BasicTabbedPaneUI
implements PropertyChangeListener,
SynthUI {
    private int tabOverlap = 0;
    private boolean extendTabsToBase = false;
    private SynthContext tabAreaContext;
    private SynthContext tabContext;
    private SynthContext tabContentContext;
    private SynthStyle style;
    private SynthStyle tabStyle;
    private SynthStyle tabAreaStyle;
    private SynthStyle tabContentStyle;
    private Rectangle textRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle tabAreaBounds = new Rectangle();
    private boolean tabAreaStatesMatchSelectedTab = false;
    private boolean nudgeSelectedLabel = true;
    private boolean selectedTabIsPressed = false;

    public static ComponentUI createUI(JComponent c) {
        return new SynthTabbedPaneUI();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.tabPane);
    }

    private void updateStyle(JTabbedPane c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.tabRunOverlay = this.style.getInt(context, "TabbedPane.tabRunOverlay", 0);
            this.tabOverlap = this.style.getInt(context, "TabbedPane.tabOverlap", 0);
            this.extendTabsToBase = this.style.getBoolean(context, "TabbedPane.extendTabsToBase", false);
            this.textIconGap = this.style.getInt(context, "TabbedPane.textIconGap", 0);
            this.selectedTabPadInsets = (Insets)this.style.get(context, "TabbedPane.selectedTabPadInsets");
            if (this.selectedTabPadInsets == null) {
                this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
            }
            this.tabAreaStatesMatchSelectedTab = this.style.getBoolean(context, "TabbedPane.tabAreaStatesMatchSelectedTab", false);
            this.nudgeSelectedLabel = this.style.getBoolean(context, "TabbedPane.nudgeSelectedLabel", true);
            if (oldStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        this.tabContext = this.getContext(c, Region.TABBED_PANE_TAB, 1);
        this.tabStyle = SynthLookAndFeel.updateStyle(this.tabContext, this);
        this.tabInsets = this.tabStyle.getInsets(this.tabContext, null);
        this.tabAreaContext = this.getContext(c, Region.TABBED_PANE_TAB_AREA, 1);
        this.tabAreaStyle = SynthLookAndFeel.updateStyle(this.tabAreaContext, this);
        this.tabAreaInsets = this.tabAreaStyle.getInsets(this.tabAreaContext, null);
        this.tabContentContext = this.getContext(c, Region.TABBED_PANE_CONTENT, 1);
        this.tabContentStyle = SynthLookAndFeel.updateStyle(this.tabContentContext, this);
        this.contentBorderInsets = this.tabContentStyle.getInsets(this.tabContentContext, null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.tabPane.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removePropertyChangeListener(this);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.tabPane, 1);
        this.style.uninstallDefaults(context);
        this.style = null;
        this.tabStyle.uninstallDefaults(this.tabContext);
        this.tabContext = null;
        this.tabStyle = null;
        this.tabAreaStyle.uninstallDefaults(this.tabAreaContext);
        this.tabAreaContext = null;
        this.tabAreaStyle = null;
        this.tabContentStyle.uninstallDefaults(this.tabContentContext);
        this.tabContentContext = null;
        this.tabContentStyle = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, SynthLookAndFeel.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private SynthContext getContext(JComponent c, Region subregion, int state) {
        SynthStyle style = null;
        if (subregion == Region.TABBED_PANE_TAB) {
            style = this.tabStyle;
        } else if (subregion == Region.TABBED_PANE_TAB_AREA) {
            style = this.tabAreaStyle;
        } else if (subregion == Region.TABBED_PANE_CONTENT) {
            style = this.tabContentStyle;
        }
        return SynthContext.getContext(c, subregion, style, state);
    }

    @Override
    protected JButton createScrollButton(int direction) {
        if (UIManager.getBoolean("TabbedPane.useBasicArrows")) {
            JButton btn = super.createScrollButton(direction);
            btn.setBorder(BorderFactory.createEmptyBorder());
            return btn;
        }
        return new SynthScrollableTabButton(direction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.tabPane);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        final MouseListener delegate = super.createMouseListener();
        final MouseMotionListener delegate2 = (MouseMotionListener)((Object)delegate);
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                delegate.mouseClicked(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                delegate.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                delegate.mouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!SynthTabbedPaneUI.this.tabPane.isEnabled()) {
                    return;
                }
                int tabIndex = SynthTabbedPaneUI.this.tabForCoordinate(SynthTabbedPaneUI.this.tabPane, e.getX(), e.getY());
                if (tabIndex >= 0 && SynthTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex) && tabIndex == SynthTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    SynthTabbedPaneUI.this.selectedTabIsPressed = true;
                    SynthTabbedPaneUI.this.tabPane.repaint();
                }
                delegate.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SynthTabbedPaneUI.this.selectedTabIsPressed) {
                    SynthTabbedPaneUI.this.selectedTabIsPressed = false;
                    SynthTabbedPaneUI.this.tabPane.repaint();
                }
                delegate.mouseReleased(e);
                delegate2.mouseMoved(e);
            }
        };
    }

    @Override
    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.nudgeSelectedLabel) {
            return super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        if (this.nudgeSelectedLabel) {
            return super.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        }
        return 0;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintTabbedPaneBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
    }

    @Override
    protected int getBaseline(int tab) {
        if (this.tabPane.getTabComponentAt(tab) != null || this.getTextViewForTab(tab) != null) {
            return super.getBaseline(tab);
        }
        String title = this.tabPane.getTitleAt(tab);
        Font font = this.tabContext.getStyle().getFont(this.tabContext);
        FontMetrics metrics = this.getFontMetrics(font);
        Icon icon = this.getIconForTab(tab);
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.calcRect.setBounds(0, 0, Short.MAX_VALUE, this.maxTabHeight);
        this.tabContext.getStyle().getGraphicsUtils(this.tabContext).layoutText(this.tabContext, metrics, title, icon, 0, 0, 10, 0, this.calcRect, this.iconRect, this.textRect, this.textIconGap);
        return this.textRect.y + metrics.getAscent() + this.getBaselineOffset();
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintTabbedPaneBorder(context, g, x, y, w, h);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
    }

    protected void paint(SynthContext context, Graphics g) {
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (!this.scrollableTabLayoutEnabled()) {
            Insets insets = this.tabPane.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = this.tabPane.getWidth() - insets.left - insets.right;
            int height = this.tabPane.getHeight() - insets.top - insets.bottom;
            switch (tabPlacement) {
                case 2: {
                    width = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    break;
                }
                case 4: {
                    int size = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    x = x + width - size;
                    width = size;
                    break;
                }
                case 3: {
                    int size = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    y = y + height - size;
                    height = size;
                    break;
                }
                default: {
                    height = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                }
            }
            this.tabAreaBounds.setBounds(x, y, width, height);
            if (g.getClipBounds().intersects(this.tabAreaBounds)) {
                this.paintTabArea(this.tabAreaContext, g, tabPlacement, selectedIndex, this.tabAreaBounds);
            }
        }
        this.paintContentBorder(this.tabContentContext, g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.tabPane.getWidth() - insets.left - insets.right;
        int height = this.tabPane.getHeight() - insets.top - insets.bottom;
        this.paintTabArea(this.tabAreaContext, g, tabPlacement, selectedIndex, new Rectangle(x, y, width, height));
    }

    private void paintTabArea(SynthContext ss, Graphics g, int tabPlacement, int selectedIndex, Rectangle tabAreaBounds) {
        Rectangle clipRect = g.getClipBounds();
        if (this.tabAreaStatesMatchSelectedTab && selectedIndex >= 0) {
            this.updateTabContext(selectedIndex, true, this.selectedTabIsPressed, this.getRolloverTab() == selectedIndex, this.getFocusIndex() == selectedIndex);
            ss.setComponentState(this.tabContext.getComponentState());
        } else {
            ss.setComponentState(1);
        }
        SynthLookAndFeel.updateSubregion(ss, g, tabAreaBounds);
        ss.getPainter().paintTabbedPaneTabAreaBackground(ss, g, tabAreaBounds.x, tabAreaBounds.y, tabAreaBounds.width, tabAreaBounds.height, tabPlacement);
        ss.getPainter().paintTabbedPaneTabAreaBorder(ss, g, tabAreaBounds.x, tabAreaBounds.y, tabAreaBounds.width, tabAreaBounds.height, tabPlacement);
        int tabCount = this.tabPane.getTabCount();
        this.iconRect.setBounds(0, 0, 0, 0);
        this.textRect.setBounds(0, 0, 0, 0);
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                if (!this.rects[j].intersects(clipRect) || selectedIndex == j) continue;
                this.paintTab(this.tabContext, g, tabPlacement, this.rects, j, this.iconRect, this.textRect);
            }
        }
        if (selectedIndex >= 0 && this.rects[selectedIndex].intersects(clipRect)) {
            this.paintTab(this.tabContext, g, tabPlacement, this.rects, selectedIndex, this.iconRect, this.textRect);
        }
    }

    @Override
    protected void setRolloverTab(int index) {
        int oldRolloverTab = this.getRolloverTab();
        super.setRolloverTab(index);
        Rectangle r = null;
        if (oldRolloverTab != index && this.tabAreaStatesMatchSelectedTab) {
            this.tabPane.repaint();
        } else {
            if (oldRolloverTab >= 0 && oldRolloverTab < this.tabPane.getTabCount() && (r = this.getTabBounds(this.tabPane, oldRolloverTab)) != null) {
                this.tabPane.repaint(r);
            }
            if (index >= 0 && (r = this.getTabBounds(this.tabPane, index)) != null) {
                this.tabPane.repaint(r);
            }
        }
    }

    private void paintTab(SynthContext ss, Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.updateTabContext(tabIndex, isSelected, isSelected && this.selectedTabIsPressed, this.getRolloverTab() == tabIndex, this.getFocusIndex() == tabIndex);
        SynthLookAndFeel.updateSubregion(ss, g, tabRect);
        int x = tabRect.x;
        int y = tabRect.y;
        int height = tabRect.height;
        int width = tabRect.width;
        int placement = this.tabPane.getTabPlacement();
        if (this.extendTabsToBase && this.runCount > 1 && selectedIndex >= 0) {
            Rectangle r = rects[selectedIndex];
            switch (placement) {
                case 1: {
                    int bottomY = r.y + r.height;
                    height = bottomY - tabRect.y;
                    break;
                }
                case 2: {
                    int rightX = r.x + r.width;
                    width = rightX - tabRect.x;
                    break;
                }
                case 3: {
                    int topY = r.y;
                    height = tabRect.y + tabRect.height - topY;
                    y = topY;
                    break;
                }
                case 4: {
                    int leftX = r.x;
                    width = tabRect.x + tabRect.width - leftX;
                    x = leftX;
                }
            }
        }
        this.tabContext.getPainter().paintTabbedPaneTabBackground(this.tabContext, g, x, y, width, height, tabIndex, placement);
        this.tabContext.getPainter().paintTabbedPaneTabBorder(this.tabContext, g, x, y, width, height, tabIndex, placement);
        if (this.tabPane.getTabComponentAt(tabIndex) == null) {
            String title;
            String clippedTitle = title = this.tabPane.getTitleAt(tabIndex);
            Font font = ss.getStyle().getFont(ss);
            FontMetrics metrics = SwingUtilities2.getFontMetrics(this.tabPane, g, font);
            Icon icon = this.getIconForTab(tabIndex);
            this.layoutLabel(ss, tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
            clippedTitle = SwingUtilities2.clipStringIfNecessary(null, metrics, title, textRect.width);
            this.paintText(ss, g, tabPlacement, font, metrics, tabIndex, clippedTitle, textRect, isSelected);
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
    }

    private void layoutLabel(SynthContext ss, int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        ss.getStyle().getGraphicsUtils(ss).layoutText(ss, metrics, title, icon, 0, 0, 10, 0, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += xNudge;
        iconRect.y += yNudge;
        textRect.x += xNudge;
        textRect.y += yNudge;
    }

    private void paintText(SynthContext ss, Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            g.setColor(ss.getStyle().getColor(ss, ColorType.TEXT_FOREGROUND));
            ss.getStyle().getGraphicsUtils(ss).paintText(ss, g, title, textRect, mnemIndex);
        }
    }

    private void paintContentBorder(SynthContext ss, Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        SynthLookAndFeel.updateSubregion(ss, g, new Rectangle(x, y, w, h));
        ss.getPainter().paintTabbedPaneContentBackground(ss, g, x, y, w, h);
        ss.getPainter().paintTabbedPaneContentBorder(ss, g, x, y, w, h);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    @Override
    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        int fontHeight = metrics.getHeight();
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), result);
        }
        return result;
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets tabInsets = this.getTabInsets(tabPlacement, tabIndex);
        int width = tabInsets.left + tabInsets.right;
        Component tabComponent = this.tabPane.getTabComponentAt(tabIndex);
        if (tabComponent != null) {
            width += tabComponent.getPreferredSize().width;
        } else {
            View v;
            if (icon != null) {
                width += icon.getIconWidth() + this.textIconGap;
            }
            if ((v = this.getTextViewForTab(tabIndex)) != null) {
                width += (int)v.getPreferredSpan(0);
            } else {
                String title = this.tabPane.getTitleAt(tabIndex);
                width += this.tabContext.getStyle().getGraphicsUtils(this.tabContext).computeStringWidth(this.tabContext, metrics.getFont(), metrics, title);
            }
        }
        return width;
    }

    @Override
    protected int calculateMaxTabWidth(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
        int tabCount = this.tabPane.getTabCount();
        int result = 0;
        for (int i = 0; i < tabCount; ++i) {
            result = Math.max(this.calculateTabWidth(tabPlacement, i, metrics), result);
        }
        return result;
    }

    @Override
    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        this.updateTabContext(tabIndex, false, false, false, this.getFocusIndex() == tabIndex);
        return this.tabInsets;
    }

    @Override
    protected FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.tabContext.getStyle().getFont(this.tabContext));
    }

    private FontMetrics getFontMetrics(Font font) {
        return this.tabPane.getFontMetrics(font);
    }

    private void updateTabContext(int index, boolean selected, boolean isMouseDown, boolean isMouseOver, boolean hasFocus) {
        int state = 0;
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(index)) {
            state |= 8;
            if (selected) {
                state |= 0x200;
            }
        } else if (selected) {
            state |= 0x201;
            if (isMouseOver && UIManager.getBoolean("TabbedPane.isTabRollover")) {
                state |= 2;
            }
        } else if (isMouseOver) {
            state |= 3;
        } else {
            state = SynthLookAndFeel.getComponentState(this.tabPane);
            state &= 0xFFFFFEFF;
        }
        if (hasFocus && this.tabPane.hasFocus()) {
            state |= 0x100;
        }
        if (isMouseDown) {
            state |= 4;
        }
        this.tabContext.setComponentState(state);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new BasicTabbedPaneUI.TabbedPaneLayout(){

            @Override
            public void calculateLayoutInfo() {
                super.calculateLayoutInfo();
                if (SynthTabbedPaneUI.this.tabOverlap != 0) {
                    int tabCount = SynthTabbedPaneUI.this.tabPane.getTabCount();
                    boolean ltr = SynthTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
                    for (int i = SynthTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                        int start = SynthTabbedPaneUI.this.tabRuns[i];
                        int next = SynthTabbedPaneUI.this.tabRuns[i == SynthTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                        int end = next != 0 ? next - 1 : tabCount - 1;
                        for (int j = start + 1; j <= end; ++j) {
                            int xshift = 0;
                            int yshift = 0;
                            switch (SynthTabbedPaneUI.this.tabPane.getTabPlacement()) {
                                case 1: 
                                case 3: {
                                    xshift = ltr ? SynthTabbedPaneUI.this.tabOverlap : -SynthTabbedPaneUI.this.tabOverlap;
                                    break;
                                }
                                case 2: 
                                case 4: {
                                    yshift = SynthTabbedPaneUI.this.tabOverlap;
                                    break;
                                }
                            }
                            ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).rects[j].x += xshift;
                            ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).rects[j].y += yshift;
                            ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).rects[j].width += Math.abs(xshift);
                            ((SynthTabbedPaneUI)SynthTabbedPaneUI.this).rects[j].height += Math.abs(yshift);
                        }
                    }
                }
            }
        };
    }

    private class SynthScrollableTabButton
    extends SynthArrowButton
    implements UIResource {
        public SynthScrollableTabButton(int direction) {
            super(direction);
            this.setName("TabbedPane.button");
        }
    }
}

