/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.beans.BeanProperty;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    @Deprecated
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    public TableColumn() {
        this(0);
    }

    public TableColumn(int modelIndex) {
        this(modelIndex, 75, null, null);
    }

    public TableColumn(int modelIndex, int width) {
        this(modelIndex, width, null, null);
    }

    public TableColumn(int modelIndex, int width, TableCellRenderer cellRenderer, TableCellEditor cellEditor) {
        this.modelIndex = modelIndex;
        this.preferredWidth = this.width = Math.max(width, 0);
        this.cellRenderer = cellRenderer;
        this.cellEditor = cellEditor;
        this.minWidth = Math.min(15, this.width);
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.headerValue = null;
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    private void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    @BeanProperty(description="The model index.")
    public void setModelIndex(int modelIndex) {
        int old = this.modelIndex;
        this.modelIndex = modelIndex;
        this.firePropertyChange("modelIndex", old, modelIndex);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    @BeanProperty(description="A unique identifier for this column.")
    public void setIdentifier(Object identifier) {
        Object old = this.identifier;
        this.identifier = identifier;
        this.firePropertyChange("identifier", old, identifier);
    }

    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.getHeaderValue();
    }

    @BeanProperty(description="The text to be used by the header renderer.")
    public void setHeaderValue(Object headerValue) {
        Object old = this.headerValue;
        this.headerValue = headerValue;
        this.firePropertyChange(HEADER_VALUE_PROPERTY, old, headerValue);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    @BeanProperty(description="The header renderer.")
    public void setHeaderRenderer(TableCellRenderer headerRenderer) {
        TableCellRenderer old = this.headerRenderer;
        this.headerRenderer = headerRenderer;
        this.firePropertyChange(HEADER_RENDERER_PROPERTY, old, headerRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    @BeanProperty(description="The renderer to use for cell values.")
    public void setCellRenderer(TableCellRenderer cellRenderer) {
        TableCellRenderer old = this.cellRenderer;
        this.cellRenderer = cellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, old, cellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    @BeanProperty(description="The editor to use for cell values.")
    public void setCellEditor(TableCellEditor cellEditor) {
        TableCellEditor old = this.cellEditor;
        this.cellEditor = cellEditor;
        this.firePropertyChange("cellEditor", old, cellEditor);
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    @BeanProperty(description="The width of the column.")
    public void setWidth(int width) {
        int old = this.width;
        this.width = Math.min(Math.max(width, this.minWidth), this.maxWidth);
        this.firePropertyChange("width", old, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    @BeanProperty(description="The preferred width of the column.")
    public void setPreferredWidth(int preferredWidth) {
        int old = this.preferredWidth;
        this.preferredWidth = Math.min(Math.max(preferredWidth, this.minWidth), this.maxWidth);
        this.firePropertyChange("preferredWidth", old, this.preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @BeanProperty(description="The minimum width of the column.")
    public void setMinWidth(int minWidth) {
        int old = this.minWidth;
        this.minWidth = Math.max(Math.min(minWidth, this.maxWidth), 0);
        if (this.width < this.minWidth) {
            this.setWidth(this.minWidth);
        }
        if (this.preferredWidth < this.minWidth) {
            this.setPreferredWidth(this.minWidth);
        }
        this.firePropertyChange("minWidth", old, this.minWidth);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    @BeanProperty(description="The maximum width of the column.")
    public void setMaxWidth(int maxWidth) {
        int old = this.maxWidth;
        this.maxWidth = Math.max(this.minWidth, maxWidth);
        if (this.width > this.maxWidth) {
            this.setWidth(this.maxWidth);
        }
        if (this.preferredWidth > this.maxWidth) {
            this.setPreferredWidth(this.maxWidth);
        }
        this.firePropertyChange("maxWidth", old, this.maxWidth);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    @BeanProperty(description="Whether or not this column can be resized.")
    public void setResizable(boolean isResizable) {
        boolean old = this.isResizable;
        this.isResizable = isResizable;
        this.firePropertyChange("isResizable", old, this.isResizable);
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component c = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        this.setMinWidth(c.getMinimumSize().width);
        this.setMaxWidth(c.getMaximumSize().width);
        this.setPreferredWidth(c.getPreferredSize().width);
        this.setWidth(this.getPreferredWidth());
    }

    @Deprecated
    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    @Deprecated
    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer label = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JTableHeader header;
                if (table != null && (header = table.getTableHeader()) != null) {
                    this.setForeground(header.getForeground());
                    this.setBackground(header.getBackground());
                    this.setFont(header.getFont());
                }
                this.setText(value == null ? "" : value.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        label.setHorizontalAlignment(0);
        return label;
    }
}

