/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableStringConverter;

public class TableRowSorter<M extends TableModel>
extends DefaultRowSorter<M, Integer> {
    private static final Comparator<?> COMPARABLE_COMPARATOR = new ComparableComparator();
    private M tableModel;
    private TableStringConverter stringConverter;

    public TableRowSorter() {
        this(null);
    }

    public TableRowSorter(M model) {
        this.setModel(model);
    }

    public void setModel(M model) {
        this.tableModel = model;
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    public void setStringConverter(TableStringConverter stringConverter) {
        this.stringConverter = stringConverter;
    }

    public TableStringConverter getStringConverter() {
        return this.stringConverter;
    }

    @Override
    public Comparator<?> getComparator(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return comparator;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(columnClass)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    @Override
    protected boolean useToString(int column) {
        Comparator<?> comparator = super.getComparator(column);
        if (comparator != null) {
            return false;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column);
        if (columnClass == String.class) {
            return false;
        }
        return !Comparable.class.isAssignableFrom(columnClass);
    }

    private static class ComparableComparator
    implements Comparator<Object> {
        private ComparableComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }

    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return TableRowSorter.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return TableRowSorter.this.tableModel == null ? 0 : TableRowSorter.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return TableRowSorter.this.tableModel == null ? 0 : TableRowSorter.this.tableModel.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return TableRowSorter.this.tableModel.getValueAt(row, column);
        }

        @Override
        public String getStringValueAt(int row, int column) {
            TableStringConverter converter = TableRowSorter.this.getStringConverter();
            if (converter != null) {
                String value = converter.toString((TableModel)TableRowSorter.this.tableModel, row, column);
                if (value != null) {
                    return value;
                }
                return "";
            }
            Object o = this.getValueAt(row, column);
            if (o == null) {
                return "";
            }
            String string = o.toString();
            if (string == null) {
                return "";
            }
            return string;
        }

        @Override
        public Integer getIdentifier(int index) {
            return index;
        }
    }
}

