/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.TabExpander;

class GlyphPainter2
extends GlyphView.GlyphPainter {
    TextLayout layout;

    public GlyphPainter2(TextLayout layout) {
        this.layout = layout;
    }

    @Override
    public GlyphView.GlyphPainter getPainter(GlyphView v, int p0, int p1) {
        return null;
    }

    @Override
    public float getSpan(GlyphView v, int p0, int p1, TabExpander e, float x) {
        if (p0 == v.getStartOffset() && p1 == v.getEndOffset()) {
            return this.layout.getAdvance();
        }
        int p = v.getStartOffset();
        int index0 = p0 - p;
        int index1 = p1 - p;
        TextHitInfo hit0 = TextHitInfo.afterOffset(index0);
        TextHitInfo hit1 = TextHitInfo.beforeOffset(index1);
        float[] locs = this.layout.getCaretInfo(hit0);
        float x0 = locs[0];
        locs = this.layout.getCaretInfo(hit1);
        float x1 = locs[0];
        return x1 > x0 ? x1 - x0 : x0 - x1;
    }

    @Override
    public float getHeight(GlyphView v) {
        return this.layout.getAscent() + this.layout.getDescent() + this.layout.getLeading();
    }

    @Override
    public float getAscent(GlyphView v) {
        return this.layout.getAscent();
    }

    @Override
    public float getDescent(GlyphView v) {
        return this.layout.getDescent();
    }

    @Override
    public void paint(GlyphView v, Graphics g, Shape a, int p0, int p1) {
        if (g instanceof Graphics2D) {
            Rectangle2D alloc = a.getBounds2D();
            Graphics2D g2d = (Graphics2D)g;
            float y = (float)alloc.getY() + this.layout.getAscent() + this.layout.getLeading();
            float x = (float)alloc.getX();
            if (p0 > v.getStartOffset() || p1 < v.getEndOffset()) {
                try {
                    Shape s = v.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, a);
                    Shape savedClip = g.getClip();
                    g2d.clip(s);
                    this.layout.draw(g2d, x, y);
                    g.setClip(savedClip);
                }
                catch (BadLocationException badLocationException) {}
            } else {
                this.layout.draw(g2d, x, y);
            }
        }
    }

    @Override
    public Shape modelToView(GlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        int offs = pos - v.getStartOffset();
        Rectangle2D alloc = a.getBounds2D();
        TextHitInfo hit = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(offs) : TextHitInfo.beforeOffset(offs);
        float[] locs = this.layout.getCaretInfo(hit);
        Rectangle2D.Float rect = new Rectangle2D.Float();
        ((Rectangle2D)rect).setRect(alloc.getX() + (double)locs[0], alloc.getY(), 1.0, alloc.getHeight());
        return rect;
    }

    @Override
    public int viewToModel(GlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle2D alloc = a instanceof Rectangle2D ? (Rectangle2D)a : a.getBounds2D();
        TextHitInfo hit = this.layout.hitTestChar(x - (float)alloc.getX(), 0.0f);
        int pos = hit.getInsertionIndex();
        if (pos == v.getEndOffset()) {
            --pos;
        }
        biasReturn[0] = hit.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        return pos + v.getStartOffset();
    }

    @Override
    public int getBoundedPosition(GlyphView v, int p0, float x, float len) {
        if (len < 0.0f) {
            throw new IllegalArgumentException("Length must be >= 0.");
        }
        TextHitInfo hit = this.layout.isLeftToRight() ? this.layout.hitTestChar(len, 0.0f) : this.layout.hitTestChar(this.layout.getAdvance() - len, 0.0f);
        return v.getStartOffset() + hit.getCharIndex();
    }

    @Override
    public int getNextVisualPositionFrom(GlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        Document doc = v.getDocument();
        int startOffset = v.getStartOffset();
        int endOffset = v.getEndOffset();
        switch (direction) {
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                boolean viewIsLeftToRight = AbstractDocument.isLeftToRight(doc, startOffset, endOffset);
                if (startOffset == doc.getLength()) {
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    return -1;
                }
                if (pos == -1) {
                    if (viewIsLeftToRight) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    Segment text = v.getText(endOffset - 1, endOffset);
                    char c = text.array[text.offset];
                    SegmentCache.releaseSharedSegment(text);
                    if (c == '\n') {
                        biasRet[0] = Position.Bias.Forward;
                        return endOffset - 1;
                    }
                    biasRet[0] = Position.Bias.Backward;
                    return endOffset;
                }
                TextHitInfo currentHit = b == Position.Bias.Forward ? TextHitInfo.afterOffset(pos - startOffset) : TextHitInfo.beforeOffset(pos - startOffset);
                TextHitInfo nextHit = this.layout.getNextRightHit(currentHit);
                if (nextHit == null) {
                    return -1;
                }
                if (viewIsLeftToRight != this.layout.isLeftToRight()) {
                    nextHit = this.layout.getVisualOtherHit(nextHit);
                }
                if ((pos = nextHit.getInsertionIndex() + startOffset) == endOffset) {
                    Segment text = v.getText(endOffset - 1, endOffset);
                    char c = text.array[text.offset];
                    SegmentCache.releaseSharedSegment(text);
                    if (c == '\n') {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Backward;
                } else {
                    biasRet[0] = Position.Bias.Forward;
                }
                return pos;
            }
            case 7: {
                boolean viewIsLeftToRight = AbstractDocument.isLeftToRight(doc, startOffset, endOffset);
                if (startOffset == doc.getLength()) {
                    if (pos == -1) {
                        biasRet[0] = Position.Bias.Forward;
                        return startOffset;
                    }
                    return -1;
                }
                if (pos == -1) {
                    if (viewIsLeftToRight) {
                        Segment text = v.getText(endOffset - 1, endOffset);
                        char c = text.array[text.offset];
                        SegmentCache.releaseSharedSegment(text);
                        if (c == '\n' || Character.isSpaceChar(c)) {
                            biasRet[0] = Position.Bias.Forward;
                            return endOffset - 1;
                        }
                        biasRet[0] = Position.Bias.Backward;
                        return endOffset;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return startOffset;
                }
                TextHitInfo currentHit = b == Position.Bias.Forward ? TextHitInfo.afterOffset(pos - startOffset) : TextHitInfo.beforeOffset(pos - startOffset);
                TextHitInfo nextHit = this.layout.getNextLeftHit(currentHit);
                if (nextHit == null) {
                    return -1;
                }
                if (viewIsLeftToRight != this.layout.isLeftToRight()) {
                    nextHit = this.layout.getVisualOtherHit(nextHit);
                }
                if ((pos = nextHit.getInsertionIndex() + startOffset) == endOffset) {
                    Segment text = v.getText(endOffset - 1, endOffset);
                    char c = text.array[text.offset];
                    SegmentCache.releaseSharedSegment(text);
                    if (c == '\n') {
                        return -1;
                    }
                    biasRet[0] = Position.Bias.Backward;
                } else {
                    biasRet[0] = Position.Bias.Forward;
                }
                return pos;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }
}

