/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.ConstructorProperties;
import java.io.Serializable;

public class TreePath
implements Serializable {
    private TreePath parentPath;
    private Object lastPathComponent;

    @ConstructorProperties(value={"path"})
    public TreePath(Object[] path) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("path in TreePath must be non null and not empty.");
        }
        this.lastPathComponent = path[path.length - 1];
        if (this.lastPathComponent == null) {
            throw new IllegalArgumentException("Last path component must be non-null");
        }
        if (path.length > 1) {
            this.parentPath = new TreePath(path, path.length - 1);
        }
    }

    public TreePath(Object lastPathComponent) {
        if (lastPathComponent == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.lastPathComponent = lastPathComponent;
        this.parentPath = null;
    }

    protected TreePath(TreePath parent, Object lastPathComponent) {
        if (lastPathComponent == null) {
            throw new IllegalArgumentException("path in TreePath must be non null.");
        }
        this.parentPath = parent;
        this.lastPathComponent = lastPathComponent;
    }

    protected TreePath(Object[] path, int length) {
        this.lastPathComponent = path[length - 1];
        if (this.lastPathComponent == null) {
            throw new IllegalArgumentException("Path elements must be non-null");
        }
        if (length > 1) {
            this.parentPath = new TreePath(path, length - 1);
        }
    }

    protected TreePath() {
    }

    public Object[] getPath() {
        int i = this.getPathCount();
        Object[] result = new Object[i--];
        for (TreePath path = this; path != null; path = path.getParentPath()) {
            result[i--] = path.getLastPathComponent();
        }
        return result;
    }

    public Object getLastPathComponent() {
        return this.lastPathComponent;
    }

    public int getPathCount() {
        int result = 0;
        for (TreePath path = this; path != null; path = path.getParentPath()) {
            ++result;
        }
        return result;
    }

    public Object getPathComponent(int index) {
        int pathLength = this.getPathCount();
        if (index < 0 || index >= pathLength) {
            throw new IllegalArgumentException("Index " + index + " is out of the specified range");
        }
        TreePath path = this;
        for (int i = pathLength - 1; i != index; --i) {
            path = path.getParentPath();
        }
        return path.getLastPathComponent();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TreePath) {
            TreePath oTreePath = (TreePath)o;
            if (this.getPathCount() != oTreePath.getPathCount()) {
                return false;
            }
            for (TreePath path = this; path != null; path = path.getParentPath()) {
                if (!path.getLastPathComponent().equals(oTreePath.getLastPathComponent())) {
                    return false;
                }
                oTreePath = oTreePath.getParentPath();
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.getLastPathComponent().hashCode();
    }

    public boolean isDescendant(TreePath aTreePath) {
        if (aTreePath == this) {
            return true;
        }
        if (aTreePath != null) {
            int pathLength = this.getPathCount();
            int oPathLength = aTreePath.getPathCount();
            if (oPathLength < pathLength) {
                return false;
            }
            while (oPathLength-- > pathLength) {
                aTreePath = aTreePath.getParentPath();
            }
            return this.equals(aTreePath);
        }
        return false;
    }

    public TreePath pathByAddingChild(Object child) {
        if (child == null) {
            throw new NullPointerException("Null child not allowed");
        }
        return new TreePath(this, child);
    }

    public TreePath getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuilder tempSpot = new StringBuilder("[");
        int maxCounter = this.getPathCount();
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (counter > 0) {
                tempSpot.append(", ");
            }
            tempSpot.append(this.getPathComponent(counter));
        }
        tempSpot.append("]");
        return tempSpot.toString();
    }
}

