/*
 * Decompiled with CFR 0.152.
 */
package com.dgunia.signpackage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.zip.ZipUtil;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lcom/dgunia/signpackage/SignPackage;", "", "args", "", "", "([Ljava/lang/String;)V", "OPTION_DIR", "OPTION_ENTITLEMENTS", "OPTION_EXCLUDE", "OPTION_RUNTIME", "OPTION_SIGN_KEY", "OPTION_TIMESTAMP", "getArgs", "()[Ljava/lang/String;", "[Ljava/lang/String;", "excludedFiles", "tmpDir", "Ljava/io/File;", "getTmpDir", "()Ljava/io/File;", "run", "", "scanRecursive", "dir", "cmd", "Lorg/apache/commons/cli/CommandLine;", "signFile", "dylibFile", "SignPackage"})
public final class SignPackage {
    @NotNull
    private final String[] args;
    @NotNull
    private final File tmpDir;
    @NotNull
    private final String OPTION_DIR;
    @NotNull
    private final String OPTION_SIGN_KEY;
    @NotNull
    private final String OPTION_ENTITLEMENTS;
    @NotNull
    private final String OPTION_RUNTIME;
    @NotNull
    private final String OPTION_TIMESTAMP;
    @NotNull
    private final String OPTION_EXCLUDE;
    @NotNull
    private String[] excludedFiles;

    public SignPackage(@NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(args2, "args");
        this.args = args2;
        this.tmpDir = new File(Intrinsics.stringPlus("tmpdir", System.currentTimeMillis()));
        this.OPTION_DIR = "d";
        this.OPTION_SIGN_KEY = "k";
        this.OPTION_ENTITLEMENTS = "e";
        this.OPTION_RUNTIME = "r";
        this.OPTION_TIMESTAMP = "t";
        this.OPTION_EXCLUDE = "x";
        boolean $i$f$emptyArray = false;
        this.excludedFiles = new String[0];
    }

    @NotNull
    public final String[] getArgs() {
        return this.args;
    }

    @NotNull
    public final File getTmpDir() {
        return this.tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Options options = new Options();
        options.addOption(Option.builder(this.OPTION_DIR).longOpt("dir").desc("Directory to scan recursively").hasArg().required().build());
        options.addOption(Option.builder(this.OPTION_SIGN_KEY).longOpt("signing-key").desc("Key name (e.g. Developer ID Application: John Public (xxxxxxxxxxx))").hasArg().required().build());
        options.addOption(Option.builder(this.OPTION_ENTITLEMENTS).longOpt("entitlements").desc("Entitlements file").hasArg().build());
        options.addOption(Option.builder(this.OPTION_RUNTIME).longOpt("runtime").desc("Harden using runtime parameter").build());
        options.addOption(Option.builder(this.OPTION_TIMESTAMP).longOpt("timestamp").desc("Set secure timestamp using timestamp parameter").build());
        options.addOption(Option.builder(this.OPTION_EXCLUDE).longOpt("exclude").hasArgs().desc("Excludes files from being signed. Can be used multiple times to specify multiple files. You have to specify the path including directories.").build());
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, this.args);
            if (!this.tmpDir.mkdirs()) {
                System.err.println("Could not create directory " + this.tmpDir.getName() + '.');
                return;
            }
            this.tmpDir.deleteOnExit();
            if (cmd.hasOption(this.OPTION_EXCLUDE)) {
                String[] stringArray = cmd.getOptionValues(this.OPTION_EXCLUDE);
                Intrinsics.checkNotNullExpressionValue(stringArray, "cmd.getOptionValues(OPTION_EXCLUDE)");
                this.excludedFiles = stringArray;
            }
            File file = new File(cmd.getOptionValue(this.OPTION_DIR));
            Intrinsics.checkNotNullExpressionValue(cmd, "cmd");
            this.scanRecursive(file, cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            new HelpFormatter().printHelp("java -jar SignPackage.jar", options);
        }
        finally {
            FilesKt.deleteRecursively(this.tmpDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void scanRecursive(File dir, CommandLine cmd) {
        File[] fileArray = dir.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = 0;
            int n2 = fileArray2.length;
            while (n < n2) {
                File element$iv = fileArray2[n];
                ++n;
                File file = element$iv;
                boolean bl = false;
                if (ArraysKt.contains(this.excludedFiles, file.getPath())) continue;
                if (file.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue(file, "file");
                    this.scanRecursive(file, cmd);
                    continue;
                }
                Object object = file.getName();
                Intrinsics.checkNotNullExpressionValue(object, "file.name");
                if (StringsKt.endsWith$default((String)object, ".jar", false, 2, null)) {
                    void $this$forEach$iv2;
                    object = new ZipFile(file).entries();
                    Intrinsics.checkNotNullExpressionValue(object, "ZipFile(file).entries()");
                    object = SequencesKt.asSequence(CollectionsKt.iterator(object));
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        ZipEntry zipEntry = (ZipEntry)element$iv2;
                        boolean bl2 = false;
                        String string = zipEntry.getName();
                        Intrinsics.checkNotNullExpressionValue(string, "zipEntry.name");
                        if (!StringsKt.endsWith$default(string, ".dylib", false, 2, null)) {
                            string = zipEntry.getName();
                            Intrinsics.checkNotNullExpressionValue(string, "zipEntry.name");
                            if (!StringsKt.endsWith$default(string, ".jnilib", false, 2, null)) {
                                string = zipEntry.getName();
                                Intrinsics.checkNotNullExpressionValue(string, "zipEntry.name");
                                if (!StringsKt.contains$default((CharSequence)string, "pty4j-unix-spawn-helper", false, 2, null)) continue;
                            }
                        }
                        System.out.println((Object)(file.getAbsolutePath() + ": " + zipEntry.getName()));
                        File dylibFile = new File(this.getTmpDir(), new File(zipEntry.getName()).getName());
                        ZipUtil.unpackEntry(file, zipEntry.getName(), dylibFile);
                        this.signFile(dylibFile, cmd);
                        ZipUtil.replaceEntry(file, zipEntry.getName(), dylibFile);
                    }
                    System.out.println((Object)file.getAbsolutePath());
                    Intrinsics.checkNotNullExpressionValue(file, "file");
                    this.signFile(file, cmd);
                    continue;
                }
                object = file.getName();
                Intrinsics.checkNotNullExpressionValue(object, "file.name");
                if (!StringsKt.endsWith$default((String)object, ".dylib", false, 2, null)) {
                    object = file.getName();
                    Intrinsics.checkNotNullExpressionValue(object, "file.name");
                    if (!StringsKt.endsWith$default((String)object, ".jnilib", false, 2, null) && !file.canExecute()) continue;
                }
                System.out.println((Object)file.getAbsolutePath());
                Intrinsics.checkNotNullExpressionValue(file, "file");
                this.signFile(file, cmd);
            }
        }
    }

    private final void signFile(File dylibFile, CommandLine cmd) {
        String[] stringArray;
        ArrayList<String> command = new ArrayList<String>();
        command.add("codesign");
        if (cmd.hasOption(this.OPTION_TIMESTAMP)) {
            command.add("--timestamp");
        }
        if (cmd.hasOption(this.OPTION_RUNTIME)) {
            stringArray = new String[]{"--options", "runtime"};
            command.addAll((Collection)CollectionsKt.listOf(stringArray));
        }
        if (cmd.hasOption(this.OPTION_ENTITLEMENTS)) {
            stringArray = new String[]{"--entitlements", new File(cmd.getOptionValue(this.OPTION_ENTITLEMENTS)).getAbsolutePath()};
            command.addAll((Collection)CollectionsKt.listOf(stringArray));
        }
        stringArray = new String[]{"--deep", "-vvv", "-f"};
        command.addAll((Collection)CollectionsKt.listOf(stringArray));
        command.add("--sign");
        command.add(cmd.getOptionValue(this.OPTION_SIGN_KEY));
        command.add(dylibFile.getAbsolutePath());
        System.out.println((Object)CollectionsKt.joinToString$default(command, " ", null, null, 0, null, null, 62, null));
        new ProcessBuilder(new String[0]).directory(dylibFile.getParentFile()).inheritIO().command((List<String>)command).start().waitFor();
    }
}

