/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.zip.ByteSource;
import org.zeroturnaround.zip.CloseShieldInputStream;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.IdentityNameMapper;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZTFilePermissions;
import org.zeroturnaround.zip.ZTFilePermissionsUtil;
import org.zeroturnaround.zip.ZipBreakException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipEntryUtil;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipExceptionUtil;
import org.zeroturnaround.zip.ZipFileUtil;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.commons.FileUtils;
import org.zeroturnaround.zip.commons.FilenameUtils;
import org.zeroturnaround.zip.commons.IOUtils;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformerEntry;

public final class ZipUtil {
    private static final String PATH_SEPARATOR = "/";
    public static final int DEFAULT_COMPRESSION_LEVEL = -1;
    private static final Logger log = LoggerFactory.getLogger("org/zeroturnaround/zip/ZipUtil".replace('/', '.'));

    private ZipUtil() {
    }

    public static boolean containsEntry(File zip2, String name) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip2);
            bl = zf.getEntry(name) != null;
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    @Deprecated
    public static int getCompressionLevelOfEntry(File zip2, String name) {
        return ZipUtil.getCompressionMethodOfEntry(zip2, name);
    }

    public static int getCompressionMethodOfEntry(File zip2, String name) {
        int n;
        ZipEntry zipEntry;
        ZipFile zf;
        block5: {
            zf = null;
            zf = new ZipFile(zip2);
            zipEntry = zf.getEntry(name);
            if (zipEntry != null) break block5;
            int n2 = -1;
            ZipUtil.closeQuietly(zf);
            return n2;
        }
        try {
            n = zipEntry.getMethod();
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containsAnyEntry(File zip2, String[] names) {
        boolean bl;
        ZipFile zf;
        block6: {
            int i;
            zf = null;
            try {
                zf = new ZipFile(zip2);
                for (i = 0; i < names.length; ++i) {
                    if (zf.getEntry(names[i]) == null) continue;
                    bl = true;
                    break block6;
                }
                i = 0;
            }
            catch (IOException e) {
                try {
                    throw ZipExceptionUtil.rethrow(e);
                }
                catch (Throwable throwable) {
                    ZipUtil.closeQuietly(zf);
                    throw throwable;
                }
            }
            ZipUtil.closeQuietly(zf);
            return i != 0;
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static byte[] unpackEntry(File zip2, String name) {
        byte[] byArray;
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip2);
            byArray = ZipUtil.doUnpackEntry(zf, name);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return byArray;
    }

    public static byte[] unpackEntry(File zip2, String name, Charset charset) {
        byte[] byArray;
        ZipFile zf = null;
        try {
            zf = charset != null ? new ZipFile(zip2, charset) : new ZipFile(zip2);
            byArray = ZipUtil.doUnpackEntry(zf, name);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return byArray;
    }

    public static byte[] unpackEntry(ZipFile zf, String name) {
        try {
            return ZipUtil.doUnpackEntry(zf, name);
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doUnpackEntry(ZipFile zf, String name) throws IOException {
        ZipEntry ze = zf.getEntry(name);
        if (ze == null) {
            return null;
        }
        InputStream is = zf.getInputStream(ze);
        try {
            byte[] byArray = IOUtils.toByteArray(is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static byte[] unpackEntry(InputStream is, String name) {
        ByteArrayUnpacker action = new ByteArrayUnpacker();
        if (!ZipUtil.handle(is, name, (ZipEntryCallback)action)) {
            return null;
        }
        return action.getBytes();
    }

    public static boolean unpackEntry(File zip2, String name, File file) {
        return ZipUtil.unpackEntry(zip2, name, file, null);
    }

    public static boolean unpackEntry(File zip2, String name, File file, Charset charset) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = charset != null ? new ZipFile(zip2, charset) : new ZipFile(zip2);
            bl = ZipUtil.doUnpackEntry(zf, name, file);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static boolean unpackEntry(ZipFile zf, String name, File file) {
        try {
            return ZipUtil.doUnpackEntry(zf, name, file);
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doUnpackEntry(ZipFile zf, String name, File file) throws IOException {
        ZipEntry ze;
        if (log.isTraceEnabled()) {
            log.trace("Extracting '" + zf.getName() + "' entry '" + name + "' into '" + file + "'.");
        }
        if ((ze = zf.getEntry(name)) == null) {
            return false;
        }
        if (ze.isDirectory() || zf.getInputStream(ze) == null) {
            if (file.isDirectory()) {
                return true;
            }
            if (file.exists()) {
                FileUtils.forceDelete(file);
            }
            return file.mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
        try {
            FileUtils.copy(in, file);
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        return true;
    }

    public static boolean unpackEntry(InputStream is, String name, File file) throws IOException {
        return ZipUtil.handle(is, name, (ZipEntryCallback)new FileUnpacker(file));
    }

    public static void iterate(File zip2, ZipEntryCallback action) {
        ZipUtil.iterate(zip2, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(File zip2, ZipEntryCallback action, Charset charset) {
        ZipFile zf = null;
        try {
            zf = charset == null ? new ZipFile(zip2) : new ZipFile(zip2, charset);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                InputStream is = zf.getInputStream(e);
                try {
                    action.process(is, e);
                }
                catch (IOException ze) {
                    throw new ZipException("Failed to process zip entry '" + e.getName() + "' with action " + action, ze);
                }
                catch (ZipBreakException ex) {
                    break;
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(File zip2, String[] entryNames, ZipEntryCallback action) {
        ZipUtil.iterate(zip2, entryNames, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(File zip2, String[] entryNames, ZipEntryCallback action, Charset charset) {
        ZipFile zf = null;
        try {
            zf = charset == null ? new ZipFile(zip2) : new ZipFile(zip2, charset);
            for (int i = 0; i < entryNames.length; ++i) {
                ZipEntry e = zf.getEntry(entryNames[i]);
                if (e == null) continue;
                InputStream is = zf.getInputStream(e);
                try {
                    action.process(is, e);
                    continue;
                }
                catch (IOException ze) {
                    throw new ZipException("Failed to process zip entry '" + e.getName() + " with action " + action, ze);
                }
                catch (ZipBreakException ex) {
                    break;
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(File zip2, ZipInfoCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip2);
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                try {
                    action.process(e);
                }
                catch (IOException ze) {
                    throw new ZipException("Failed to process zip entry '" + e.getName() + " with action " + action, ze);
                }
                catch (ZipBreakException ex) {
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    public static void iterate(File zip2, String[] entryNames, ZipInfoCallback action) {
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip2);
            for (int i = 0; i < entryNames.length; ++i) {
                ZipEntry e = zf.getEntry(entryNames[i]);
                if (e == null) continue;
                try {
                    action.process(e);
                    continue;
                }
                catch (IOException ze) {
                    throw new ZipException("Failed to process zip entry '" + e.getName() + " with action " + action, ze);
                }
                catch (ZipBreakException ex) {
                    break;
                }
            }
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(InputStream is, ZipEntryCallback action, Charset charset) {
        try {
            ZipInputStream in = null;
            try {
                ZipEntry entry;
                in = ZipUtil.newCloseShieldZipInputStream(is, charset);
                while ((entry = in.getNextEntry()) != null) {
                    try {
                        action.process(in, entry);
                    }
                    catch (IOException ze) {
                        throw new ZipException("Failed to process zip entry '" + entry.getName() + " with action " + action, ze);
                    }
                    catch (ZipBreakException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    public static void iterate(InputStream is, ZipEntryCallback action) {
        ZipUtil.iterate(is, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void iterate(InputStream is, String[] entryNames, ZipEntryCallback action, Charset charset) {
        HashSet<String> namesSet = new HashSet<String>();
        for (int i = 0; i < entryNames.length; ++i) {
            namesSet.add(entryNames[i]);
        }
        try {
            ZipInputStream in = null;
            try {
                ZipEntry entry;
                in = ZipUtil.newCloseShieldZipInputStream(is, charset);
                while ((entry = in.getNextEntry()) != null) {
                    if (!namesSet.contains(entry.getName())) continue;
                    try {
                        action.process(in, entry);
                    }
                    catch (IOException ze) {
                        throw new ZipException("Failed to process zip entry '" + entry.getName() + " with action " + action, ze);
                    }
                    catch (ZipBreakException ex) {
                        // empty catch block
                        break;
                    }
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    public static void iterate(InputStream is, String[] entryNames, ZipEntryCallback action) {
        ZipUtil.iterate(is, entryNames, action, null);
    }

    private static ZipInputStream newCloseShieldZipInputStream(InputStream is, Charset charset) {
        BufferedInputStream in = new BufferedInputStream(new CloseShieldInputStream(is));
        if (charset == null) {
            return new ZipInputStream(in);
        }
        return ZipFileUtil.createZipInputStream(in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handle(File zip2, String name, ZipEntryCallback action) {
        boolean bl;
        ZipEntry ze;
        ZipFile zf;
        block8: {
            zf = null;
            zf = new ZipFile(zip2);
            ze = zf.getEntry(name);
            if (ze != null) break block8;
            boolean bl2 = false;
            ZipUtil.closeQuietly(zf);
            return bl2;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
            try {
                action.process(in, ze);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf);
        return bl;
    }

    public static boolean handle(InputStream is, String name, ZipEntryCallback action) {
        SingleZipEntryCallback helper = new SingleZipEntryCallback(name, action);
        ZipUtil.iterate(is, (ZipEntryCallback)helper);
        return helper.found();
    }

    public static void unpack(File zip2, File outputDir) {
        ZipUtil.unpack(zip2, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unpack(File zip2, File outputDir, Charset charset) {
        ZipUtil.unpack(zip2, outputDir, IdentityNameMapper.INSTANCE, charset);
    }

    public static void unpack(File zip2, File outputDir, NameMapper mapper, Charset charset) {
        log.debug("Extracting '{}' into '{}'.", zip2, (Object)outputDir);
        ZipUtil.iterate(zip2, (ZipEntryCallback)new Unpacker(outputDir, mapper), charset);
    }

    public static void unpack(File zip2, File outputDir, NameMapper mapper) {
        log.debug("Extracting '{}' into '{}'.", zip2, (Object)outputDir);
        ZipUtil.iterate(zip2, (ZipEntryCallback)new Unpacker(outputDir, mapper));
    }

    public static void unwrap(File zip2, File outputDir) {
        ZipUtil.unwrap(zip2, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unwrap(File zip2, File outputDir, NameMapper mapper) {
        log.debug("Unwrapping '{}' into '{}'.", zip2, (Object)outputDir);
        ZipUtil.iterate(zip2, (ZipEntryCallback)new Unwrapper(outputDir, mapper));
    }

    public static void unpack(InputStream is, File outputDir) {
        ZipUtil.unpack(is, outputDir, IdentityNameMapper.INSTANCE, null);
    }

    public static void unpack(InputStream is, File outputDir, Charset charset) {
        ZipUtil.unpack(is, outputDir, IdentityNameMapper.INSTANCE, charset);
    }

    public static void unpack(InputStream is, File outputDir, NameMapper mapper) {
        ZipUtil.unpack(is, outputDir, mapper, null);
    }

    public static void unpack(InputStream is, File outputDir, NameMapper mapper, Charset charset) {
        log.debug("Extracting {} into '{}'.", is, (Object)outputDir);
        ZipUtil.iterate(is, (ZipEntryCallback)new Unpacker(outputDir, mapper), charset);
    }

    public static void unwrap(InputStream is, File outputDir) {
        ZipUtil.unwrap(is, outputDir, IdentityNameMapper.INSTANCE);
    }

    public static void unwrap(InputStream is, File outputDir, NameMapper mapper) {
        log.debug("Unwrapping {} into '{}'.", is, (Object)outputDir);
        ZipUtil.iterate(is, (ZipEntryCallback)new Unwrapper(outputDir, mapper));
    }

    public static void explode(File zip2) {
        try {
            File tempFile = FileUtils.getTempFileFor(zip2);
            FileUtils.moveFile(zip2, tempFile);
            ZipUtil.unpack(tempFile, zip2);
            if (!tempFile.delete()) {
                throw new IOException("Unable to delete file: " + tempFile);
            }
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] packEntry(File file) {
        log.trace("Compressing '{}' into a ZIP file with single entry.", file);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            ZipOutputStream out = new ZipOutputStream(result);
            ZipEntry entry = ZipEntryUtil.fromFile(file.getName(), file);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                ZipEntryUtil.addEntry(entry, in, out);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
            out.close();
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
        return result.toByteArray();
    }

    public static void pack(File rootDir, File zip2) {
        ZipUtil.pack(rootDir, zip2, -1);
    }

    public static void pack(File rootDir, File zip2, int compressionLevel) {
        ZipUtil.pack(rootDir, zip2, IdentityNameMapper.INSTANCE, compressionLevel);
    }

    public static void pack(File sourceDir, File targetZipFile, boolean preserveRoot) {
        if (preserveRoot) {
            final String parentName = sourceDir.getName();
            ZipUtil.pack(sourceDir, targetZipFile, new NameMapper(){

                @Override
                public String map(String name) {
                    return parentName + ZipUtil.PATH_SEPARATOR + name;
                }
            });
        } else {
            ZipUtil.pack(sourceDir, targetZipFile);
        }
    }

    public static void packEntry(File fileToPack, File destZipFile) {
        ZipUtil.packEntry(fileToPack, destZipFile, IdentityNameMapper.INSTANCE);
    }

    public static void packEntry(File fileToPack, File destZipFile, final String fileName) {
        ZipUtil.packEntry(fileToPack, destZipFile, new NameMapper(){

            @Override
            public String map(String name) {
                return fileName;
            }
        });
    }

    public static void packEntry(File fileToPack, File destZipFile, NameMapper mapper) {
        ZipUtil.packEntries(new File[]{fileToPack}, destZipFile, mapper);
    }

    public static void packEntries(File[] filesToPack, File destZipFile) {
        ZipUtil.packEntries(filesToPack, destZipFile, IdentityNameMapper.INSTANCE);
    }

    public static void packEntries(File[] filesToPack, File destZipFile, NameMapper mapper) {
        ZipUtil.packEntries(filesToPack, destZipFile, mapper, -1);
    }

    public static void packEntries(File[] filesToPack, File destZipFile, int compressionLevel) {
        ZipUtil.packEntries(filesToPack, destZipFile, IdentityNameMapper.INSTANCE, compressionLevel);
    }

    public static void packEntries(File[] filesToPack, File destZipFile, NameMapper mapper, int compressionLevel) {
        log.debug("Compressing '{}' into '{}'.", filesToPack, (Object)destZipFile);
        ZipOutputStream out = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destZipFile);
            out = new ZipOutputStream(new BufferedOutputStream(fos));
            out.setLevel(compressionLevel);
            for (int i = 0; i < filesToPack.length; ++i) {
                File fileToPack = filesToPack[i];
                ZipEntry zipEntry = ZipEntryUtil.fromFile(mapper.map(fileToPack.getName()), fileToPack);
                out.putNextEntry(zipEntry);
                FileUtils.copy(fileToPack, out);
                out.closeEntry();
            }
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(fos);
    }

    public static void pack(File sourceDir, File targetZip, NameMapper mapper) {
        ZipUtil.pack(sourceDir, targetZip, mapper, -1);
    }

    public static void pack(File sourceDir, File targetZip, NameMapper mapper, int compressionLevel) {
        log.debug("Compressing '{}' into '{}'.", sourceDir, (Object)targetZip);
        if (!sourceDir.exists()) {
            throw new ZipException("Given file '" + sourceDir + "' doesn't exist!");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetZip)));
            out.setLevel(compressionLevel);
            ZipUtil.pack(sourceDir, out, mapper, "", true);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static void pack(File sourceDir, OutputStream os) {
        ZipUtil.pack(sourceDir, os, IdentityNameMapper.INSTANCE, -1);
    }

    public static void pack(File sourceDir, OutputStream os, int compressionLevel) {
        ZipUtil.pack(sourceDir, os, IdentityNameMapper.INSTANCE, compressionLevel);
    }

    public static void pack(File sourceDir, OutputStream os, NameMapper mapper) {
        ZipUtil.pack(sourceDir, os, mapper, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(File sourceDir, OutputStream os, NameMapper mapper, int compressionLevel) {
        log.debug("Compressing '{}' into a stream.", sourceDir);
        if (!sourceDir.exists()) {
            throw new ZipException("Given file '" + sourceDir + "' doesn't exist!");
        }
        ZipOutputStream out = null;
        IOException error = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(os));
            out.setLevel(compressionLevel);
            ZipUtil.pack(sourceDir, out, mapper, "", true);
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            if (out != null && error == null) {
                try {
                    out.finish();
                    out.flush();
                }
                catch (IOException e) {
                    error = e;
                }
            }
        }
        if (error != null) {
            throw ZipExceptionUtil.rethrow(error);
        }
    }

    private static void pack(File dir, ZipOutputStream out, NameMapper mapper, String pathPrefix, boolean mustHaveChildren) throws IOException {
        String[] filenames = dir.list();
        if (filenames == null) {
            if (!dir.exists()) {
                throw new ZipException("Given file '" + dir + "' doesn't exist!");
            }
            throw new IOException("Given file is not a directory '" + dir + "'");
        }
        if (mustHaveChildren && filenames.length == 0) {
            throw new ZipException("Given directory '" + dir + "' doesn't contain any files!");
        }
        for (int i = 0; i < filenames.length; ++i) {
            String name;
            String filename = filenames[i];
            File file = new File(dir, filename);
            boolean isDir = file.isDirectory();
            String path = pathPrefix + file.getName();
            if (isDir) {
                path = path + PATH_SEPARATOR;
            }
            if ((name = mapper.map(path)) != null) {
                ZipEntry zipEntry = ZipEntryUtil.fromFile(name, file);
                out.putNextEntry(zipEntry);
                if (!isDir) {
                    FileUtils.copy(file, out);
                }
                out.closeEntry();
            }
            if (!isDir) continue;
            ZipUtil.pack(file, out, mapper, path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(File srcZip, File dstZip, int compressionLevel) {
        log.debug("Repacking '{}' into '{}'.", srcZip, (Object)dstZip);
        RepackZipEntryCallback callback = new RepackZipEntryCallback(dstZip, compressionLevel);
        try {
            ZipUtil.iterate(srcZip, (ZipEntryCallback)callback);
        }
        finally {
            callback.closeStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void repack(InputStream is, File dstZip, int compressionLevel) {
        log.debug("Repacking from input stream into '{}'.", dstZip);
        RepackZipEntryCallback callback = new RepackZipEntryCallback(dstZip, compressionLevel);
        try {
            ZipUtil.iterate(is, (ZipEntryCallback)callback);
        }
        finally {
            callback.closeStream();
        }
    }

    public static void repack(File zip2, int compressionLevel) {
        try {
            File tmpZip = FileUtils.getTempFileFor(zip2);
            ZipUtil.repack(zip2, tmpZip, compressionLevel);
            if (!zip2.delete()) {
                throw new IOException("Unable to delete the file: " + zip2);
            }
            FileUtils.moveFile(tmpZip, zip2);
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    public static void unexplode(File dir) {
        ZipUtil.unexplode(dir, -1);
    }

    public static void unexplode(File dir, int compressionLevel) {
        try {
            File zip2 = FileUtils.getTempFileFor(dir);
            ZipUtil.pack(dir, zip2, compressionLevel);
            FileUtils.deleteDirectory(dir);
            FileUtils.moveFile(zip2, dir);
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    public static void pack(ZipEntrySource[] entries, OutputStream os) {
        if (log.isDebugEnabled()) {
            log.debug("Creating stream from {}.", Arrays.asList(entries));
        }
        ZipUtil.pack(entries, os, false);
    }

    private static void pack(ZipEntrySource[] entries, OutputStream os, boolean closeStream) {
        try {
            ZipOutputStream out = new ZipOutputStream(os);
            for (int i = 0; i < entries.length; ++i) {
                ZipUtil.addEntry(entries[i], out);
            }
            out.flush();
            out.finish();
            if (closeStream) {
                out.close();
            }
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    public static void pack(ZipEntrySource[] entries, File zip2) {
        if (log.isDebugEnabled()) {
            log.debug("Creating '{}' from {}.", zip2, Arrays.asList(entries));
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(zip2));
            ZipUtil.pack(entries, (OutputStream)out, true);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static void addEntry(File zip2, String path, File file, File destZip) {
        ZipUtil.addEntry(zip2, new FileSource(path, file), destZip);
    }

    public static void addEntry(final File zip2, final String path, final File file) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip2, path, file, tmpFile);
                return true;
            }
        });
    }

    public static void addEntry(File zip2, String path, byte[] bytes, File destZip) {
        ZipUtil.addEntry(zip2, new ByteSource(path, bytes), destZip);
    }

    public static void addEntry(File zip2, String path, byte[] bytes, File destZip, int compressionMethod) {
        ZipUtil.addEntry(zip2, new ByteSource(path, bytes, compressionMethod), destZip);
    }

    public static void addEntry(final File zip2, final String path, final byte[] bytes) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip2, path, bytes, tmpFile);
                return true;
            }
        });
    }

    public static void addEntry(final File zip2, final String path, final byte[] bytes, final int compressionMethod) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip2, path, bytes, tmpFile, compressionMethod);
                return true;
            }
        });
    }

    public static void addEntry(File zip2, ZipEntrySource entry, File destZip) {
        ZipUtil.addEntries(zip2, new ZipEntrySource[]{entry}, destZip);
    }

    public static void addEntry(final File zip2, final ZipEntrySource entry) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addEntry(zip2, entry, tmpFile);
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntries(File zip2, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to '" + destZip + "' and adding " + Arrays.asList(entries) + ".");
        }
        BufferedOutputStream destOut = null;
        try {
            destOut = new BufferedOutputStream(new FileOutputStream(destZip));
            ZipUtil.addEntries(zip2, entries, (OutputStream)destOut);
        }
        catch (IOException e) {
            try {
                ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(destOut);
                throw throwable;
            }
            IOUtils.closeQuietly(destOut);
        }
        IOUtils.closeQuietly(destOut);
    }

    public static void addEntries(File zip2, ZipEntrySource[] entries, OutputStream destOut) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to a stream and adding " + Arrays.asList(entries) + ".");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(destOut);
            ZipUtil.copyEntries(zip2, out);
            for (int i = 0; i < entries.length; ++i) {
                ZipUtil.addEntry(entries[i], out);
            }
            out.finish();
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
        }
    }

    public static void addEntries(InputStream is, ZipEntrySource[] entries, OutputStream destOut) {
        if (log.isDebugEnabled()) {
            log.debug("Copying input stream to an output stream and adding " + Arrays.asList(entries) + ".");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(destOut);
            ZipUtil.copyEntries(is, out);
            for (int i = 0; i < entries.length; ++i) {
                ZipUtil.addEntry(entries[i], out);
            }
            out.finish();
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
        }
    }

    public static void addEntries(final File zip2, final ZipEntrySource[] entries) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addEntries(zip2, entries, tmpFile);
                return true;
            }
        });
    }

    public static void removeEntry(File zip2, String path, File destZip) {
        ZipUtil.removeEntries(zip2, new String[]{path}, destZip);
    }

    public static void removeEntry(final File zip2, final String path) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.removeEntry(zip2, path, tmpFile);
                return true;
            }
        });
    }

    public static void removeEntries(File zip2, String[] paths, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to '" + destZip + "' and removing paths " + Arrays.asList(paths) + ".");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            ZipUtil.copyEntries(zip2, out, new HashSet<String>(Arrays.asList(paths)));
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    public static void removeEntries(final File zip2, final String[] paths) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.removeEntries(zip2, paths, tmpFile);
                return true;
            }
        });
    }

    private static void copyEntries(File zip2, final ZipOutputStream out) {
        final HashSet names = new HashSet();
        ZipUtil.iterate(zip2, new ZipEntryCallback(){

            @Override
            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                String entryName = zipEntry.getName();
                if (names.add(entryName)) {
                    ZipEntryUtil.copyEntry(zipEntry, in, out);
                } else if (log.isDebugEnabled()) {
                    log.debug("Duplicate entry: {}", (Object)entryName);
                }
            }
        });
    }

    private static void copyEntries(InputStream is, final ZipOutputStream out) {
        final HashSet names = new HashSet();
        ZipUtil.iterate(is, new ZipEntryCallback(){

            @Override
            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                String entryName = zipEntry.getName();
                if (names.add(entryName)) {
                    ZipEntryUtil.copyEntry(zipEntry, in, out);
                } else if (log.isDebugEnabled()) {
                    log.debug("Duplicate entry: {}", (Object)entryName);
                }
            }
        });
    }

    private static void copyEntries(File zip2, final ZipOutputStream out, final Set<String> ignoredEntries) {
        final HashSet names = new HashSet();
        final Set<String> dirNames = ZipUtil.filterDirEntries(zip2, ignoredEntries);
        ZipUtil.iterate(zip2, new ZipEntryCallback(){

            @Override
            public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                String entryName = zipEntry.getName();
                if (ignoredEntries.contains(entryName)) {
                    return;
                }
                for (String dirName : dirNames) {
                    if (!entryName.startsWith(dirName)) continue;
                    return;
                }
                if (names.add(entryName)) {
                    ZipEntryUtil.copyEntry(zipEntry, in, out);
                } else if (log.isDebugEnabled()) {
                    log.debug("Duplicate entry: {}", (Object)entryName);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String> filterDirEntries(File zip2, Collection<String> names) {
        HashSet<String> dirs = new HashSet<String>();
        if (zip2 == null) {
            return dirs;
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(zip2);
            for (String entryName : names) {
                ZipEntry entry = zf.getEntry(entryName);
                if (entry == null) continue;
                if (entry.isDirectory()) {
                    dirs.add(entry.getName());
                    continue;
                }
                if (zf.getInputStream(entry) != null) continue;
                dirs.add(entry.getName() + PATH_SEPARATOR);
            }
        }
        catch (IOException e) {
            try {
                ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf);
                throw throwable;
            }
            ZipUtil.closeQuietly(zf);
        }
        ZipUtil.closeQuietly(zf);
        return dirs;
    }

    public static boolean replaceEntry(File zip2, String path, File file, File destZip) {
        return ZipUtil.replaceEntry(zip2, new FileSource(path, file), destZip);
    }

    public static boolean replaceEntry(final File zip2, final String path, final File file) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip2, new FileSource(path, file), tmpFile);
            }
        });
    }

    public static boolean replaceEntry(File zip2, String path, byte[] bytes, File destZip) {
        return ZipUtil.replaceEntry(zip2, new ByteSource(path, bytes), destZip);
    }

    public static boolean replaceEntry(final File zip2, final String path, final byte[] bytes) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip2, new ByteSource(path, bytes), tmpFile);
            }
        });
    }

    public static boolean replaceEntry(final File zip2, final String path, final byte[] bytes, final int compressionMethod) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip2, new ByteSource(path, bytes, compressionMethod), tmpFile);
            }
        });
    }

    public static boolean replaceEntry(File zip2, ZipEntrySource entry, File destZip) {
        return ZipUtil.replaceEntries(zip2, new ZipEntrySource[]{entry}, destZip);
    }

    public static boolean replaceEntry(final File zip2, final ZipEntrySource entry) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntry(zip2, entry, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceEntries(File zip2, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to '" + destZip + "' and replacing entries " + Arrays.asList(entries) + ".");
        }
        final Map<String, ZipEntrySource> entryByPath = ZipUtil.entriesByPath(entries);
        int entryCount = entryByPath.size();
        try {
            final ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            try {
                final HashSet names = new HashSet();
                ZipUtil.iterate(zip2, new ZipEntryCallback(){

                    @Override
                    public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                        if (names.add(zipEntry.getName())) {
                            ZipEntrySource entry = (ZipEntrySource)entryByPath.remove(zipEntry.getName());
                            if (entry != null) {
                                ZipUtil.addEntry(entry, out);
                            } else {
                                ZipEntryUtil.copyEntry(zipEntry, in, out);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
                        }
                    }
                });
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
        }
        return entryByPath.size() < entryCount;
    }

    public static boolean replaceEntries(final File zip2, final ZipEntrySource[] entries) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.replaceEntries(zip2, entries, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrReplaceEntries(File zip2, ZipEntrySource[] entries, File destZip) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to '" + destZip + "' and adding/replacing entries " + Arrays.asList(entries) + ".");
        }
        final Map<String, ZipEntrySource> entryByPath = ZipUtil.entriesByPath(entries);
        try {
            final ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
            try {
                final HashSet names = new HashSet();
                ZipUtil.iterate(zip2, new ZipEntryCallback(){

                    @Override
                    public void process(InputStream in, ZipEntry zipEntry) throws IOException {
                        if (names.add(zipEntry.getName())) {
                            ZipEntrySource entry = (ZipEntrySource)entryByPath.remove(zipEntry.getName());
                            if (entry != null) {
                                ZipUtil.addEntry(entry, out);
                            } else {
                                ZipEntryUtil.copyEntry(zipEntry, in, out);
                            }
                        } else if (log.isDebugEnabled()) {
                            log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
                        }
                    }
                });
                for (ZipEntrySource zipEntrySource : entryByPath.values()) {
                    ZipUtil.addEntry(zipEntrySource, out);
                }
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
        }
    }

    public static void addOrReplaceEntries(final File zip2, final ZipEntrySource[] entries) {
        ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                ZipUtil.addOrReplaceEntries(zip2, entries, tmpFile);
                return true;
            }
        });
    }

    static Map<String, ZipEntrySource> entriesByPath(ZipEntrySource ... entries) {
        HashMap<String, ZipEntrySource> result = new HashMap<String, ZipEntrySource>();
        for (int i = 0; i < entries.length; ++i) {
            ZipEntrySource source = entries[i];
            result.put(source.getPath(), source);
        }
        return result;
    }

    public static boolean transformEntry(File zip2, String path, ZipEntryTransformer transformer, File destZip) {
        if (zip2.equals(destZip)) {
            throw new IllegalArgumentException("Input (" + zip2.getAbsolutePath() + ") is the same as the destination!Please use the transformEntry method without destination for in-place transformation.");
        }
        return ZipUtil.transformEntry(zip2, new ZipEntryTransformerEntry(path, transformer), destZip);
    }

    public static boolean transformEntry(final File zip2, final String path, final ZipEntryTransformer transformer) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.transformEntry(zip2, path, transformer, tmpFile);
            }
        });
    }

    public static boolean transformEntry(File zip2, ZipEntryTransformerEntry entry, File destZip) {
        return ZipUtil.transformEntries(zip2, new ZipEntryTransformerEntry[]{entry}, destZip);
    }

    public static boolean transformEntry(final File zip2, final ZipEntryTransformerEntry entry) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.transformEntry(zip2, entry, tmpFile);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean transformEntries(File zip2, ZipEntryTransformerEntry[] entries, File destZip) {
        boolean bl;
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + zip2 + "' to '" + destZip + "' and transforming entries " + Arrays.asList(entries) + ".");
        }
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZip)));
        try {
            TransformerZipEntryCallback action = new TransformerZipEntryCallback(Arrays.asList(entries), out);
            ZipUtil.iterate(zip2, (ZipEntryCallback)action);
            bl = action.found();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            catch (IOException e) {
                throw ZipExceptionUtil.rethrow(e);
            }
        }
        IOUtils.closeQuietly(out);
        return bl;
    }

    public static boolean transformEntries(final File zip2, final ZipEntryTransformerEntry[] entries) {
        return ZipUtil.operateInPlace(zip2, new InPlaceAction(){

            @Override
            public boolean act(File tmpFile) {
                return ZipUtil.transformEntries(zip2, entries, tmpFile);
            }
        });
    }

    public static boolean transformEntry(InputStream is, String path, ZipEntryTransformer transformer, OutputStream os) {
        return ZipUtil.transformEntry(is, new ZipEntryTransformerEntry(path, transformer), os);
    }

    public static boolean transformEntry(InputStream is, ZipEntryTransformerEntry entry, OutputStream os) {
        return ZipUtil.transformEntries(is, new ZipEntryTransformerEntry[]{entry}, os);
    }

    public static boolean transformEntries(InputStream is, ZipEntryTransformerEntry[] entries, OutputStream os) {
        if (log.isDebugEnabled()) {
            log.debug("Copying '" + is + "' to '" + os + "' and transforming entries " + Arrays.asList(entries) + ".");
        }
        try {
            ZipOutputStream out = new ZipOutputStream(os);
            TransformerZipEntryCallback action = new TransformerZipEntryCallback(Arrays.asList(entries), out);
            ZipUtil.iterate(is, (ZipEntryCallback)action);
            out.finish();
            return action.found();
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    static Map<String, ZipEntryTransformer> transformersByPath(List<ZipEntryTransformerEntry> entries) {
        HashMap<String, ZipEntryTransformer> result = new HashMap<String, ZipEntryTransformer>();
        for (ZipEntryTransformerEntry entry : entries) {
            result.put(entry.getPath(), entry.getTransformer());
        }
        return result;
    }

    private static void addEntry(ZipEntrySource entry, ZipOutputStream out) throws IOException {
        out.putNextEntry(entry.getEntry());
        InputStream in = entry.getInputStream();
        if (in != null) {
            try {
                IOUtils.copy(in, out);
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        out.closeEntry();
    }

    public static boolean archiveEquals(File f1, File f2) {
        try {
            if (FileUtils.contentEquals(f1, f2)) {
                return true;
            }
            log.debug("Comparing archives '{}' and '{}'...", f1, (Object)f2);
            long start = System.currentTimeMillis();
            boolean result = ZipUtil.archiveEqualsInternal(f1, f2);
            long time = System.currentTimeMillis() - start;
            if (time > 0L) {
                log.debug("Archives compared in " + time + " ms.");
            }
            return result;
        }
        catch (Exception e) {
            log.debug("Could not compare '" + f1 + "' and '" + f2 + "':", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean archiveEqualsInternal(File f1, File f2) throws IOException {
        boolean bl;
        ZipEntry e2;
        String path;
        ZipEntry e1;
        ZipFile zf2;
        ZipFile zf1;
        block8: {
            zf1 = null;
            zf2 = null;
            zf1 = new ZipFile(f1);
            zf2 = new ZipFile(f2);
            if (zf1.size() == zf2.size()) break block8;
            log.debug("Number of entries changed (" + zf1.size() + " vs " + zf2.size() + ").");
            boolean bl2 = false;
            ZipUtil.closeQuietly(zf1);
            ZipUtil.closeQuietly(zf2);
            return bl2;
        }
        try {
            Enumeration<? extends ZipEntry> en = zf1.entries();
            while (en.hasMoreElements()) {
                e1 = en.nextElement();
                path = e1.getName();
                if (ZipUtil.metaDataEquals(path, e1, e2 = zf2.getEntry(path))) break block9;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            ZipUtil.closeQuietly(zf1);
            ZipUtil.closeQuietly(zf2);
            throw throwable;
        }
        {
            InputStream is2;
            InputStream is1;
            block10: {
                block9: {
                    ZipUtil.closeQuietly(zf1);
                    ZipUtil.closeQuietly(zf2);
                    return bl;
                }
                is1 = null;
                is2 = null;
                is1 = zf1.getInputStream(e1);
                is2 = zf2.getInputStream(e2);
                if (IOUtils.contentEquals(is1, is2)) break block10;
                log.debug("Entry '{}' content changed.", (Object)path);
                boolean bl3 = false;
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                ZipUtil.closeQuietly(zf1);
                ZipUtil.closeQuietly(zf2);
                return bl3;
            }
            IOUtils.closeQuietly(is1);
            IOUtils.closeQuietly(is2);
            continue;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is1);
                    IOUtils.closeQuietly(is2);
                    throw throwable;
                }
            }
        }
        ZipUtil.closeQuietly(zf1);
        ZipUtil.closeQuietly(zf2);
        log.debug("Archives are the same.");
        return true;
    }

    private static boolean metaDataEquals(String path, ZipEntry e1, ZipEntry e2) throws IOException {
        if (e2 == null) {
            log.debug("Entry '{}' removed.", (Object)path);
            return false;
        }
        if (e1.isDirectory()) {
            if (e2.isDirectory()) {
                return true;
            }
            log.debug("Entry '{}' not a directory any more.", (Object)path);
            return false;
        }
        if (e2.isDirectory()) {
            log.debug("Entry '{}' now a directory.", (Object)path);
            return false;
        }
        long size1 = e1.getSize();
        long size2 = e2.getSize();
        if (size1 != -1L && size2 != -1L && size1 != size2) {
            log.debug("Entry '" + path + "' size changed (" + size1 + " vs " + size2 + ").");
            return false;
        }
        long crc1 = e1.getCrc();
        long crc2 = e2.getCrc();
        if (crc1 != -1L && crc2 != -1L && crc1 != crc2) {
            log.debug("Entry '" + path + "' CRC changed (" + crc1 + " vs " + crc2 + ").");
            return false;
        }
        if (log.isTraceEnabled()) {
            long time1 = e1.getTime();
            long time2 = e2.getTime();
            if (time1 != -1L && time2 != -1L && time1 != time2) {
                log.trace("Entry '" + path + "' time changed (" + new Date(time1) + " vs " + new Date(time2) + ").");
            }
        }
        return true;
    }

    public static boolean entryEquals(File f1, File f2, String path) {
        return ZipUtil.entryEquals(f1, f2, path, path);
    }

    public static boolean entryEquals(File f1, File f2, String path1, String path2) {
        boolean bl;
        ZipFile zf1 = null;
        ZipFile zf2 = null;
        try {
            zf1 = new ZipFile(f1);
            zf2 = new ZipFile(f2);
            bl = ZipUtil.doEntryEquals(zf1, zf2, path1, path2);
        }
        catch (IOException e) {
            try {
                throw ZipExceptionUtil.rethrow(e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeQuietly(zf1);
                ZipUtil.closeQuietly(zf2);
                throw throwable;
            }
        }
        ZipUtil.closeQuietly(zf1);
        ZipUtil.closeQuietly(zf2);
        return bl;
    }

    public static boolean entryEquals(ZipFile zf1, ZipFile zf2, String path1, String path2) {
        try {
            return ZipUtil.doEntryEquals(zf1, zf2, path1, path2);
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doEntryEquals(ZipFile zf1, ZipFile zf2, String path1, String path2) throws IOException {
        InputStream is2;
        InputStream is1;
        block9: {
            block8: {
                ZipEntry e2;
                ZipEntry e1;
                block7: {
                    block6: {
                        boolean bl;
                        is1 = null;
                        is2 = null;
                        try {
                            e1 = zf1.getEntry(path1);
                            e2 = zf2.getEntry(path2);
                            if (e1 != null || e2 != null) break block6;
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is1);
                            IOUtils.closeQuietly(is2);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(is1);
                        IOUtils.closeQuietly(is2);
                        return bl;
                    }
                    if (e1 != null && e2 != null) break block7;
                    boolean bl = false;
                    IOUtils.closeQuietly(is1);
                    IOUtils.closeQuietly(is2);
                    return bl;
                }
                is1 = zf1.getInputStream(e1);
                is2 = zf2.getInputStream(e2);
                if (is1 != null || is2 != null) break block8;
                boolean bl = true;
                IOUtils.closeQuietly(is1);
                IOUtils.closeQuietly(is2);
                return bl;
            }
            if (is1 != null && is2 != null) break block9;
            boolean bl = false;
            IOUtils.closeQuietly(is1);
            IOUtils.closeQuietly(is2);
            return bl;
        }
        boolean bl = IOUtils.contentEquals(is1, is2);
        IOUtils.closeQuietly(is1);
        IOUtils.closeQuietly(is2);
        return bl;
    }

    public static void closeQuietly(ZipFile zf) {
        try {
            if (zf != null) {
                zf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean operateInPlace(File src, InPlaceAction action) {
        File tmp = null;
        try {
            tmp = File.createTempFile("zt-zip-tmp", ".zip");
            boolean result = action.act(tmp);
            if (result) {
                FileUtils.forceDelete(src);
                FileUtils.moveFile(tmp, src);
            }
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            throw ZipExceptionUtil.rethrow(e);
        }
        finally {
            FileUtils.deleteQuietly(tmp);
        }
    }

    private static abstract class InPlaceAction {
        private InPlaceAction() {
        }

        abstract boolean act(File var1);
    }

    private static class TransformerZipEntryCallback
    implements ZipEntryCallback {
        private final Map<String, ZipEntryTransformer> entryByPath;
        private final int entryCount;
        private final ZipOutputStream out;
        private final Set<String> names = new HashSet<String>();

        public TransformerZipEntryCallback(List<ZipEntryTransformerEntry> entries, ZipOutputStream out) {
            this.entryByPath = ZipUtil.transformersByPath(entries);
            this.entryCount = this.entryByPath.size();
            this.out = out;
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            if (this.names.add(zipEntry.getName())) {
                ZipEntryTransformer entry = this.entryByPath.remove(zipEntry.getName());
                if (entry != null) {
                    entry.transform(in, zipEntry, this.out);
                } else {
                    ZipEntryUtil.copyEntry(zipEntry, in, this.out);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Duplicate entry: {}", (Object)zipEntry.getName());
            }
        }

        public boolean found() {
            return this.entryByPath.size() < this.entryCount;
        }
    }

    private static final class RepackZipEntryCallback
    implements ZipEntryCallback {
        private ZipOutputStream out;

        private RepackZipEntryCallback(File dstZip, int compressionLevel) {
            try {
                this.out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dstZip)));
                this.out.setLevel(compressionLevel);
            }
            catch (IOException e) {
                ZipExceptionUtil.rethrow(e);
            }
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            ZipEntryUtil.copyEntry(zipEntry, in, this.out);
        }

        private void closeStream() {
            IOUtils.closeQuietly(this.out);
        }
    }

    private static class Unwrapper
    implements ZipEntryCallback {
        private final File outputDir;
        private final NameMapper mapper;
        private String rootDir;

        public Unwrapper(File outputDir, NameMapper mapper) {
            this.outputDir = outputDir;
            this.mapper = mapper;
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String root = this.getRootName(zipEntry.getName());
            if (this.rootDir == null) {
                this.rootDir = root;
            } else if (!this.rootDir.equals(root)) {
                throw new ZipException("Unwrapping with multiple roots is not supported, roots: " + this.rootDir + ", " + root);
            }
            String name = this.mapper.map(this.getUnrootedName(root, zipEntry.getName()));
            if (name != null) {
                File file = new File(this.outputDir, name);
                if (name.indexOf("..") != -1 && !file.getCanonicalPath().startsWith(this.outputDir.getCanonicalPath())) {
                    throw new ZipException("The file " + name + " is trying to leave the target output directory of " + this.outputDir + ". Ignoring this file.");
                }
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir(file);
                } else {
                    FileUtils.forceMkdir(file.getParentFile());
                    if (log.isDebugEnabled() && file.exists()) {
                        log.debug("Overwriting file '{}'.", (Object)zipEntry.getName());
                    }
                    FileUtils.copy(in, file);
                }
            }
        }

        private String getUnrootedName(String root, String name) {
            return name.substring(root.length());
        }

        private String getRootName(String name) {
            String newName = name.substring(FilenameUtils.getPrefixLength(name));
            int idx = newName.indexOf(ZipUtil.PATH_SEPARATOR);
            if (idx < 0) {
                throw new ZipException("Entry " + newName + " from the root of the zip is not supported");
            }
            return newName.substring(0, newName.indexOf(ZipUtil.PATH_SEPARATOR));
        }
    }

    public static class BackslashUnpacker
    implements ZipEntryCallback {
        private final File outputDir;
        private final NameMapper mapper;

        public BackslashUnpacker(File outputDir, NameMapper mapper) {
            this.outputDir = outputDir;
            this.mapper = mapper;
        }

        public BackslashUnpacker(File outputDir) {
            this(outputDir, IdentityNameMapper.INSTANCE);
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String name = this.mapper.map(zipEntry.getName());
            if (name != null) {
                if (name.indexOf(92) != -1) {
                    File parentDirectory = this.outputDir;
                    String[] dirs = name.split("\\\\");
                    for (int i = 0; i < dirs.length - 1; ++i) {
                        File file = new File(parentDirectory, dirs[i]);
                        if (!file.exists()) {
                            FileUtils.forceMkdir(file);
                        }
                        parentDirectory = file;
                    }
                    File destFile = new File(parentDirectory, dirs[dirs.length - 1]);
                    if (name.indexOf("..") != -1 && !destFile.getCanonicalPath().startsWith(this.outputDir.getCanonicalPath())) {
                        throw new ZipException("The file " + name + " is trying to leave the target output directory of " + this.outputDir + ". Ignoring this file.");
                    }
                    FileUtils.copy(in, destFile);
                } else {
                    File destFile = new File(this.outputDir, name);
                    if (name.indexOf("..") != -1 && !destFile.getCanonicalPath().startsWith(this.outputDir.getCanonicalPath())) {
                        throw new ZipException("The file " + name + " is trying to leave the target output directory of " + this.outputDir + ". Ignoring this file.");
                    }
                    FileUtils.copy(in, destFile);
                }
            }
        }
    }

    private static class Unpacker
    implements ZipEntryCallback {
        private final File outputDir;
        private final NameMapper mapper;

        public Unpacker(File outputDir, NameMapper mapper) {
            this.outputDir = outputDir;
            this.mapper = mapper;
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String name = this.mapper.map(zipEntry.getName());
            if (name != null) {
                File file = new File(this.outputDir, name);
                if (name.indexOf("..") != -1 && !file.getCanonicalPath().startsWith(this.outputDir.getCanonicalPath())) {
                    throw new ZipException("The file " + name + " is trying to leave the target output directory of " + this.outputDir + ". Ignoring this file.");
                }
                if (zipEntry.isDirectory()) {
                    FileUtils.forceMkdir(file);
                } else {
                    FileUtils.forceMkdir(file.getParentFile());
                    if (log.isDebugEnabled() && file.exists()) {
                        log.debug("Overwriting file '{}'.", (Object)zipEntry.getName());
                    }
                    FileUtils.copy(in, file);
                }
                ZTFilePermissions permissions = ZipEntryUtil.getZTFilePermissions(zipEntry);
                if (permissions != null) {
                    ZTFilePermissionsUtil.getDefaultStategy().setPermissions(file, permissions);
                }
            }
        }
    }

    private static class SingleZipEntryCallback
    implements ZipEntryCallback {
        private final String name;
        private final ZipEntryCallback action;
        private boolean found;

        public SingleZipEntryCallback(String name, ZipEntryCallback action) {
            this.name = name;
            this.action = action;
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            if (this.name.equals(zipEntry.getName())) {
                this.found = true;
                this.action.process(in, zipEntry);
            }
        }

        public boolean found() {
            return this.found;
        }
    }

    private static class FileUnpacker
    implements ZipEntryCallback {
        private final File file;

        public FileUnpacker(File file) {
            this.file = file;
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            FileUtils.copy(in, this.file);
        }
    }

    private static class ByteArrayUnpacker
    implements ZipEntryCallback {
        private byte[] bytes;

        private ByteArrayUnpacker() {
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            this.bytes = IOUtils.toByteArray(in);
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

