/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CMenuBar;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.peer.FramePeer;

public class CFrame
extends CWindow
implements FramePeer {
    private static final int kMinFrameWidth = 128;
    private static final int kMinFrameHeight = 37;
    private static final Dimension kMinFrameSize = new Dimension(128, 37);
    private Insets preFullScreenInsets;

    public static CFrame create(Frame frame) {
        CFrame cFrame = new CFrame((Component)frame);
        cFrame.initPeer();
        return cFrame;
    }

    public static CFrame create(Dialog dialog) {
        CFrame cFrame = new CFrame((Component)dialog);
        cFrame.initPeer();
        return cFrame;
    }

    CFrame(Component component) {
        super(component);
    }

    @Override
    protected String getTitle() {
        if (this.fTarget instanceof Frame) {
            return ((Frame)this.fTarget).getTitle();
        }
        return ((Dialog)this.fTarget).getTitle();
    }

    @Override
    public Dimension getMinimumSize() {
        return kMinFrameSize;
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
        CMenuBar cMenuBar = (CMenuBar)CToolkit.targetToPeer(menuBar);
        long l = 0L;
        if (cMenuBar != null) {
            l = cMenuBar.fModelPtr;
        }
        this.nativeSetMenuBar(this.fModelPtr, l);
    }

    @Override
    int jniModalType() {
        int n = 0;
        if (this.fTarget instanceof Dialog) {
            Dialog.ModalityType modalityType = ((Dialog)this.fTarget).getModalityType();
            if (modalityType == null || modalityType.equals((Object)Dialog.ModalityType.MODELESS)) {
                n = 0;
            } else if (modalityType.equals((Object)Dialog.ModalityType.DOCUMENT_MODAL)) {
                n = 1;
            } else if (modalityType.equals((Object)Dialog.ModalityType.APPLICATION_MODAL)) {
                n = 2;
            } else if (modalityType.equals((Object)Dialog.ModalityType.TOOLKIT_MODAL)) {
                n = 3;
            }
        }
        return n;
    }

    @Override
    public Rectangle getBoundsPrivate() {
        return this.getBounds();
    }

    public native void nativeSetMenuBar(long var1, long var3);

    private void updateWindowContent() {
        ComponentEvent componentEvent = new ComponentEvent((Component)this.fTarget, 101);
        CToolkit.postEvent(this, (AWTEvent)componentEvent);
    }

    private void updateDisplay() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CFrame.this.displayChanged();
            }
        });
    }

    @Override
    void windowWillEnterFullScreen() {
        this.preFullScreenInsets = this.fInsets;
        this.fInsets = new Insets(0, 0, 0, 0);
        this.updateWindowContent();
    }

    @Override
    void windowDidEnterFullScreen() {
        this.updateDisplay();
    }

    @Override
    void windowWillExitFullScreen() {
        this.fInsets = this.preFullScreenInsets;
        this.updateWindowContent();
    }

    @Override
    void windowDidExitFullScreen() {
        this.updateDisplay();
    }
}

