/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CButton;
import apple.awt.CCanvas;
import apple.awt.CCheckbox;
import apple.awt.CCheckboxMenuItem;
import apple.awt.CChoice;
import apple.awt.CClipboard;
import apple.awt.CColor;
import apple.awt.CComponent;
import apple.awt.CCustomCursor;
import apple.awt.CDesktopPeer;
import apple.awt.CDragSourceContextPeer;
import apple.awt.CEmbedded;
import apple.awt.CEmbeddedFrame;
import apple.awt.CFileDialog;
import apple.awt.CFrame;
import apple.awt.CGraphicsDevice;
import apple.awt.CGraphicsEnvironment;
import apple.awt.CImage;
import apple.awt.CInputMethod;
import apple.awt.CInputMethodDescriptor;
import apple.awt.CLabel;
import apple.awt.CList;
import apple.awt.CMenu;
import apple.awt.CMenuBar;
import apple.awt.CMenuItem;
import apple.awt.CMouseDragGestureRecognizer;
import apple.awt.CPanel;
import apple.awt.CPeerSurfaceData;
import apple.awt.CPopupMenu;
import apple.awt.CPrinterDialog;
import apple.awt.CPrinterDialogPeer;
import apple.awt.CRobot;
import apple.awt.CScrollPane;
import apple.awt.CScrollbar;
import apple.awt.CSystemTrayPeer;
import apple.awt.CTextArea;
import apple.awt.CTextField;
import apple.awt.CTrayIconPeer;
import apple.awt.CWindow;
import apple.awt.OSXImage;
import apple.awt.RuntimeOptions;
import com.apple.eawt.CocoaComponent;
import com.sun.imageio.plugins.tiff.TIFFImageReaderSpi;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.PlatformFont;
import sun.awt.SunToolkit;
import sun.awt.SunToolkitSubclass;
import sun.awt.image.ImageRepresentation;
import sun.font.FontDesignMetrics;
import sun.print.PrintJob2D;

public class CToolkit
extends SunToolkit {
    private static LookAndFeelChangeListener sLAFListener = new LookAndFeelChangeListener();
    static FontMetrics[] lastMetrics = new FontMetrics[5];
    static FontRenderContext sDefaultFrc = null;
    private static final int NUM_APPLE_COLORS = 3;
    public static final int KEYBOARD_FOCUS_COLOR = 0;
    public static final int INACTIVE_SELECTION_BACKGROUND_COLOR = 1;
    public static final int INACTIVE_SELECTION_FOREGROUND_COLOR = 2;
    private static int[] appleColors = new int[]{-8355712, -4144960, -13619152};
    protected static CToolkit sToolkit;
    protected static CInputMethodDescriptor sInputMethodDescriptor;
    protected float contentScaleFactor;
    protected final int defaultRenderer;
    private static Object sInitLock;
    public static final String DATA_TRANSFERER_CLASS_NAME = "apple.awt.CDataTransferer";
    private static long sMessageNumber;
    static final String nsImagePrefix = "NSImage://";
    static Clipboard sClipboard;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CToolkit() {
        Object object = sInitLock;
        synchronized (object) {
            if (sToolkit == null) {
                sToolkit = this;
            }
            if (CToolkit.getSystemProperty("sun.awt.exception.handler", null) == null) {
                CToolkit.setSystemProperty("sun.awt.exception.handler", EventQueueExceptionHandler.class.getName());
            }
            SunToolkit.setDataTransfererClassName((String)DATA_TRANSFERER_CLASS_NAME);
            this.init();
            this.contentScaleFactor = 1.0f;
            if (!CToolkit.isHeadless()) {
                this.contentScaleFactor = this.getContentScaleFactor();
            }
            this.defaultRenderer = RuntimeOptions.getRenderer();
            if (this.runningInHiDPI()) {
                RuntimeOptions.setRenderer(1);
                RuntimeOptions.setAntialiasing(2);
            }
        }
        this.registerDefaultServices();
    }

    public boolean runningInHiDPI() {
        return this.contentScaleFactor != 1.0f;
    }

    public static void notImplemented() {
        Thread.dumpStack();
    }

    private native void init();

    private native float getContentScaleFactor();

    private native void _loadSystemColors(int[] var1);

    private native void _loadAppleColors(int[] var1);

    @Override
    protected void loadSystemColors(int[] nArray) {
        this._loadAppleColors(appleColors);
        if (nArray == null) {
            return;
        }
        this._loadSystemColors(nArray);
    }

    public static Color getAppleColor(int n) {
        return new AppleSpecificColor(n);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public static boolean allowKeyboardNavigation() {
        return true;
    }

    static String getSystemProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    static String setSystemProperty(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.setProperty(string, string2);
            }
        });
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.equals("awt.dynamicLayoutSupported")) {
            return new Boolean(true);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    static boolean isHeadless() {
        String string = CToolkit.getSystemProperty("java.awt.headless", "false");
        return string.equals("true");
    }

    static boolean isSWTInWebStart() {
        String string = CToolkit.getSystemProperty("com.apple.javaws.usingSWT", "false");
        return string.equals("true");
    }

    @Override
    public int getMenuShortcutKeyMask() {
        return 4;
    }

    @Override
    public boolean getLockingKeyState(int n) throws UnsupportedOperationException {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        if (n == 20) {
            return this._getLockingKeyState(n);
        }
        throw new UnsupportedOperationException("Toolkit.getLockingKeyState");
    }

    private native boolean _getLockingKeyState(int var1);

    @Override
    public Dimension getBestCursorSize(int n, int n2) throws HeadlessException {
        return CCustomCursor.getBestCursorSize(n, n2);
    }

    @Override
    public int getMaximumCursorColors() throws HeadlessException {
        return Integer.MAX_VALUE;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        return new CCustomCursor(image, point, string);
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        assert (CToolkit.stdio("CToolkit.createScrollbar"));
        CScrollbar cScrollbar = CScrollbar.create(scrollbar);
        CToolkit.targetCreatedPeer(scrollbar, cScrollbar);
        return cScrollbar;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        assert (CToolkit.stdio("CToolkit.createTextArea"));
        CTextArea cTextArea = CTextArea.create(textArea);
        CToolkit.targetCreatedPeer(textArea, cTextArea);
        return cTextArea;
    }

    @Override
    public ButtonPeer createButton(Button button) {
        assert (CToolkit.stdio("CToolkit.createButton"));
        CButton cButton = CButton.create(button);
        CToolkit.targetCreatedPeer(button, cButton);
        return cButton;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        assert (CToolkit.stdio("CToolkit.createChoice"));
        CChoice cChoice = CChoice.create(choice);
        CToolkit.targetCreatedPeer(choice, cChoice);
        return cChoice;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        assert (CToolkit.stdio("CToolkit.createPanel"));
        CPanel cPanel = CPanel.create(panel);
        CToolkit.targetCreatedPeer(panel, cPanel);
        return cPanel;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        assert (CToolkit.stdio("CToolkit.createCanvas"));
        long l = canvas instanceof CocoaComponent ? ((CocoaComponent)canvas).createNSViewLong() : 0L;
        CCanvas cCanvas = CCanvas.create(canvas, l);
        CToolkit.targetCreatedPeer(canvas, cCanvas);
        return cCanvas;
    }

    public static void sendMessage(CocoaComponent cocoaComponent, int n, Object object) {
        CToolkit.sendMessage(((CCanvas)cocoaComponent.getPeer()).fInnerView, n, object);
    }

    static native void sendMessage(long var0, int var2, Object var3);

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        assert (CToolkit.stdio("CToolkit.createScrollPane"));
        CScrollPane cScrollPane = CScrollPane.create(scrollPane);
        CToolkit.targetCreatedPeer(scrollPane, cScrollPane);
        return cScrollPane;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        assert (CToolkit.stdio("CToolkit.createTextField"));
        CTextField cTextField = CTextField.create(textField);
        CToolkit.targetCreatedPeer(textField, cTextField);
        return cTextField;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        assert (CToolkit.stdio("CToolkit.createLabel"));
        CLabel cLabel = CLabel.create(label);
        CToolkit.targetCreatedPeer(label, cLabel);
        return cLabel;
    }

    @Override
    public ListPeer createList(List list) {
        assert (CToolkit.stdio("CToolkit.createList"));
        CList cList = CList.create(list);
        CToolkit.targetCreatedPeer(list, cList);
        return cList;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        assert (CToolkit.stdio("CToolkit.createCheckbox"));
        CCheckbox cCheckbox = CCheckbox.create(checkbox);
        CToolkit.targetCreatedPeer(checkbox, cCheckbox);
        return cCheckbox;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        assert (CToolkit.stdio("CToolkit.createFrame"));
        CFrame cFrame = CFrame.create(frame);
        CToolkit.targetCreatedPeer(frame, cFrame);
        return cFrame;
    }

    public CEmbedded createEmbeddedFrame(CEmbeddedFrame cEmbeddedFrame) {
        CEmbedded cEmbedded = CEmbedded.create(cEmbeddedFrame);
        CToolkit.targetCreatedPeer(cEmbeddedFrame, cEmbedded);
        return cEmbedded;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        assert (CToolkit.stdio("CToolkit.createWindow"));
        CWindow cWindow = CWindow.create(window);
        CToolkit.targetCreatedPeer(window, cWindow);
        return cWindow;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        assert (CToolkit.stdio("CToolkit.createDialog"));
        if (dialog instanceof CPrinterDialog) {
            return this.createCPrinterDialog((CPrinterDialog)dialog);
        }
        CFrame cFrame = CFrame.create(dialog);
        CToolkit.targetCreatedPeer(dialog, cFrame);
        return cFrame;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        assert (CToolkit.stdio("CToolkit.createFileDialog"));
        CFileDialog cFileDialog = new CFileDialog(fileDialog);
        CToolkit.targetCreatedPeer(fileDialog, cFileDialog);
        return cFileDialog;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        assert (CToolkit.stdio("CToolkit.createMenuBar"));
        CMenuBar cMenuBar = new CMenuBar(menuBar);
        CToolkit.targetCreatedPeer(menuBar, cMenuBar);
        return cMenuBar;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        assert (CToolkit.stdio("CToolkit.createMenu"));
        CMenu cMenu = new CMenu(menu);
        CToolkit.targetCreatedPeer(menu, cMenu);
        return cMenu;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        assert (CToolkit.stdio("CToolkit.createPopupMenu"));
        CPopupMenu cPopupMenu = new CPopupMenu(popupMenu);
        CToolkit.targetCreatedPeer(popupMenu, cPopupMenu);
        return cPopupMenu;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        assert (CToolkit.stdio("CToolkit.createMenuItem"));
        CMenuItem cMenuItem = new CMenuItem(menuItem);
        CToolkit.targetCreatedPeer(menuItem, cMenuItem);
        return cMenuItem;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        assert (CToolkit.stdio("CToolkit.createCheckboxMenuItem"));
        CCheckboxMenuItem cCheckboxMenuItem = new CCheckboxMenuItem(checkboxMenuItem);
        CToolkit.targetCreatedPeer(checkboxMenuItem, cCheckboxMenuItem);
        return cCheckboxMenuItem;
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        return new OSXPlatformFont(string, n);
    }

    CPrinterDialogPeer createCPrinterDialog(CPrinterDialog cPrinterDialog) {
        CPrinterDialogPeer cPrinterDialogPeer = new CPrinterDialogPeer(cPrinterDialog);
        CToolkit.targetCreatedPeer(cPrinterDialog, cPrinterDialogPeer);
        return cPrinterDialogPeer;
    }

    @Override
    protected void initializeDesktopProperties() {
        super.initializeDesktopProperties();
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        this.desktopProperties.put("DnD.isDragImageSupported", new Boolean(true));
        this.desktopProperties.put("DnD.Cursor.CopyDrop", new NamedCursor("DnD.Cursor.CopyDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveDrop", new NamedCursor("DnD.Cursor.MoveDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkDrop", new NamedCursor("DnD.Cursor.LinkDrop"));
        this.desktopProperties.put("DnD.Cursor.CopyNoDrop", new NamedCursor("DnD.Cursor.CopyNoDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveNoDrop", new NamedCursor("DnD.Cursor.MoveNoDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkNoDrop", new NamedCursor("DnD.Cursor.LinkNoDrop"));
        this.desktopProperties.put("awt.mouse.numButtons", new Integer(this.numberOfMouseButtons()));
        this.desktopProperties.put("awt.multiClickInterval", new Integer(this.doubleClickInterval()));
        this.desktopProperties.put("awt.font.desktophints", SunToolkit.getDesktopFontHints());
        this.desktopProperties.put("apple.awt.contentScaleFactor", new Float(this.contentScaleFactor));
    }

    @Override
    protected RenderingHints getDesktopAAHints() {
        return new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    private native int numberOfMouseButtons();

    private native int doubleClickInterval();

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new CRobot(robot, (CGraphicsDevice)graphicsDevice);
    }

    public int getScreenWidth() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.width;
    }

    public int getScreenHeight() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.height;
    }

    @Override
    public int getScreenResolution() {
        return ((CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getScreenResolution();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        return ((CGraphicsDevice)graphicsConfiguration.getDevice()).getScreenInsets();
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        CDragSourceContextPeer cDragSourceContextPeer = CDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
        return cDragSourceContextPeer;
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        CMouseDragGestureRecognizer cMouseDragGestureRecognizer = null;
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            cMouseDragGestureRecognizer = new CMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return (T)cMouseDragGestureRecognizer;
    }

    @Override
    public ColorModel getColorModel() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    @Override
    public void sync() {
        CPeerSurfaceData.finishLazyDrawingForAllSurfaces();
    }

    @Override
    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof OSXImage)) {
            return true;
        }
        OSXImage oSXImage = (OSXImage)image;
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (oSXImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = oSXImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    @Override
    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof OSXImage)) {
            return 32;
        }
        OSXImage oSXImage = (OSXImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : oSXImage.getImageRep().check(imageObserver);
        return oSXImage.check(imageObserver) | n3;
    }

    @Override
    public Image createImage(ImageProducer imageProducer) {
        return new OSXImage(imageProducer);
    }

    @Override
    public Image createImage(String string) {
        Image image = this.checkForNSImage(string);
        if (image != null) {
            return image;
        }
        return super.createImage(string);
    }

    @Override
    public Image getImage(String string) {
        Image image = this.checkForNSImage(string);
        if (image != null) {
            return image;
        }
        return super.getImage(string);
    }

    protected Image checkForNSImage(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith(nsImagePrefix)) {
            return null;
        }
        return CImage.getCreator().createImageFromName(string.substring(nsImagePrefix.length()));
    }

    @Override
    public native void beep();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        assert (CToolkit.stdio("CToolkit.getSystemClipboard"));
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        Object object = sInitLock;
        synchronized (object) {
            if (sClipboard == null) {
                sClipboard = new CClipboard();
            }
        }
        return sClipboard;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        final PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return printJob2D.printDialog();
            }
        });
        return bl != false ? printJob2D : null;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        Locale locale = CInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        if (sInputMethodDescriptor == null) {
            sInputMethodDescriptor = new CInputMethodDescriptor();
        }
        return sInputMethodDescriptor;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return CInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    @Override
    public boolean isFrameStateSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static void postEvent(CComponent cComponent, AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static void postEvent(AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static void invokeAndWait(Runnable runnable, Component component) throws InterruptedException, InvocationTargetException {
        CToolkit.invokeAndWait(runnable, component, true);
    }

    public static <T> T invokeAndWait(Callable<T> callable, Component component) throws Exception {
        CallableWrapper<T> callableWrapper = new CallableWrapper<T>(callable);
        CToolkit.invokeAndWait(callableWrapper, component);
        return callableWrapper.getResult();
    }

    public static void invokeAndWait(Runnable runnable, Component component, boolean bl) throws InterruptedException, InvocationTargetException {
        Object object;
        long l = CToolkit.createAWTRunLoopMediator();
        CPeerEvent cPeerEvent = new CPeerEvent(runnable, l);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, cPeerEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((CToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(cPeerEvent);
        }
        CToolkit.doAWTRunLoop(l, true, bl);
        object = cPeerEvent.getException();
        if (object != null) {
            if (object instanceof UndeclaredThrowableException) {
                object = ((UndeclaredThrowableException)object).getUndeclaredThrowable();
            }
            throw new InvocationTargetException((Throwable)object);
        }
    }

    public static void invokeLater(Runnable runnable, Component component) throws InvocationTargetException {
        Object object;
        CPeerEvent cPeerEvent = new CPeerEvent(runnable, 0L);
        if (component != null) {
            object = SunToolkit.targetToAppContext(component);
            SunToolkit.postEvent((AppContext)object, cPeerEvent);
            SunToolkitSubclass.flushPendingEvents((AppContext)object);
        } else {
            ((CToolkit)Toolkit.getDefaultToolkit()).getSystemEventQueueForInvokeAndWait().postEvent(cPeerEvent);
        }
        object = cPeerEvent.getException();
        if (object == null) {
            return;
        }
        if (object instanceof UndeclaredThrowableException) {
            throw new InvocationTargetException(((UndeclaredThrowableException)object).getUndeclaredThrowable());
        }
        throw new InvocationTargetException((Throwable)object);
    }

    EventQueue getSystemEventQueueForInvokeAndWait() {
        return this.getSystemEventQueueImpl();
    }

    public static native long createAWTRunLoopMediator();

    public static void doAWTRunLoop(long l, boolean bl) {
        CToolkit.doAWTRunLoop(l, bl, true);
    }

    public static native void doAWTRunLoop(long var0, boolean var2, boolean var3);

    public static void doAWTRunLoop(long l) {
        CToolkit.doAWTRunLoop(l, true);
    }

    public static native void stopAWTRunLoop(long var0);

    private static void dumpObject(Object object) {
        if (object != null) {
            System.err.println("Printing object of type : " + object.getClass());
            System.err.println(object.toString());
        } else {
            System.err.println("Printing object of type : <null>");
        }
    }

    static Field getField(final Class<?> clazz, final String string) {
        Field field = null;
        try {
            field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    Field field = clazz.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return field;
    }

    @Override
    public String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontRenderContext createDefaultFrcUsingRuntimeOptions() {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            if (sDefaultFrc == null) {
                AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                RuntimeOptions runtimeOptions = RuntimeOptions.getCurrentOptions();
                sDefaultFrc = new FontRenderContext(affineTransform, RuntimeOptions.getTextAntialiasing() == 2, runtimeOptions.FractionalMetrics == 2);
            }
            return sDefaultFrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontMetrics getFontMetrics(Font font) {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            FontMetrics fontMetrics;
            for (int i = 0; i < lastMetrics.length && (fontMetrics = lastMetrics[i]) != null; ++i) {
                if (fontMetrics.getFont() != font) continue;
                return fontMetrics;
            }
            FontDesignMetrics fontDesignMetrics = FontDesignMetrics.getMetrics(font, CToolkit.createDefaultFrcUsingRuntimeOptions());
            System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
            CToolkit.lastMetrics[0] = fontDesignMetrics;
            return fontDesignMetrics;
        }
    }

    void registerDefaultServices() {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(new TIFFImageReaderSpi(), ImageReaderSpi.class);
    }

    void screenParametersChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                float f = CToolkit.this.getContentScaleFactor();
                if (f != CToolkit.this.contentScaleFactor) {
                    CToolkit.this.contentScaleFactor = f;
                    CToolkit.this.setDesktopProperty("apple.awt.contentScaleFactor", new Float(CToolkit.this.contentScaleFactor));
                    if (CToolkit.this.runningInHiDPI()) {
                        RuntimeOptions.setRenderer(1);
                        RuntimeOptions.setAntialiasing(2);
                    } else {
                        RuntimeOptions.setRenderer(CToolkit.this.defaultRenderer);
                        RuntimeOptions.getAntialiasing();
                    }
                }
                CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
                cGraphicsEnvironment.displayChanged();
                cGraphicsEnvironment.paletteChanged();
                for (Window window : Window.getWindows()) {
                    window.repaint();
                }
            }
        });
    }

    void systemColorsChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CColor.updateSystemColors();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Method method = SystemColor.class.getDeclaredMethod("updateSystemColors", new Class[0]);
                            method.setAccessible(true);
                            method.invoke(null, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
        });
    }

    static boolean stdio(String string) {
        System.out.println("[AWT-" + sMessageNumber++ + "]:" + string);
        return true;
    }

    static boolean stderr(String string) {
        System.err.println("[AWT-" + sMessageNumber++ + "]:" + string);
        return true;
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) throws HeadlessException, AWTException {
        CTrayIconPeer cTrayIconPeer = CTrayIconPeer.create(trayIcon);
        CToolkit.targetCreatedPeer(trayIcon, cTrayIconPeer);
        return cTrayIconPeer;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) {
        return new CSystemTrayPeer();
    }

    @Override
    public boolean isTraySupported() {
        return true;
    }

    protected native boolean syncNativeQueue();

    @Override
    public void grab(Window window) {
        if (window.getPeer() != null) {
            ((CWindow)window.getPeer()).grab();
        }
    }

    @Override
    public void ungrab(Window window) {
        if (window.getPeer() != null) {
            ((CWindow)window.getPeer()).ungrab();
        }
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == null || modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    @Override
    public boolean isDesktopSupported() {
        return true;
    }

    @Override
    protected DesktopPeer createDesktopPeer(Desktop desktop) throws HeadlessException {
        return new CDesktopPeer();
    }

    public boolean isWindowOpacityControlSupported() {
        return true;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        return graphicsConfiguration.getColorModel().hasAlpha();
    }

    @Override
    public boolean isWindowShapingSupported() {
        return false;
    }

    public static void jdk16NotImplemented() {
        System.err.println("jdk16 bringup - not implemented");
        Thread.dumpStack();
    }

    static {
        sInitLock = new Object();
        sMessageNumber = 0L;
        sClipboard = null;
    }

    public static class CPeerEvent
    extends PeerEvent {
        private long _mediator = 0L;

        public CPeerEvent(Runnable runnable, long l) {
            super((Object)Toolkit.getDefaultToolkit(), runnable, null, true, 0L);
            this._mediator = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            try {
                super.dispatch();
            }
            finally {
                if (this._mediator != 0L) {
                    CToolkit.stopAWTRunLoop(this._mediator);
                }
            }
        }
    }

    static final class CallableWrapper<T>
    implements Runnable {
        final Callable<T> callable;
        T object;
        Exception e;

        public CallableWrapper(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                this.object = this.callable.call();
            }
            catch (Exception exception) {
                this.e = exception;
            }
        }

        public T getResult() throws Exception {
            if (this.e != null) {
                throw this.e;
            }
            return this.object;
        }
    }

    class OSXPlatformFont
    extends PlatformFont {
        public OSXPlatformFont(String string, int n) {
            super(string, n);
        }

        @Override
        protected char getMissingGlyphCharacter() {
            return '\ufff8';
        }
    }

    private static class AppleSpecificColor
    extends Color {
        int index;

        public AppleSpecificColor(int n) {
            super(appleColors[n]);
            this.index = n;
        }

        @Override
        public int getRGB() {
            return appleColors[this.index];
        }
    }

    public static class EventQueueExceptionHandler {
        public void handle(Throwable throwable) {
            assert (false);
            Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.currentThread().getUncaughtExceptionHandler();
            if (uncaughtExceptionHandler != null) {
                uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
            } else if (!(throwable instanceof ThreadDeath)) {
                System.err.print("Exception in thread \"" + Thread.currentThread().getName() + "\" ");
                throwable.printStackTrace(System.err);
            }
        }
    }

    static class NamedCursor
    extends Cursor {
        NamedCursor(String string) {
            super(string);
        }
    }

    static class LookAndFeelChangeListener
    implements PropertyChangeListener {
        public LookAndFeelChangeListener() {
            RuntimeOptions.getCurrentOptions().addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("apple.awt.RuntimeOptions")) {
                LookAndFeelChangeListener lookAndFeelChangeListener = this;
                synchronized (lookAndFeelChangeListener) {
                    sDefaultFrc = null;
                    lastMetrics = new FontMetrics[5];
                }
            }
        }
    }
}

