/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class AquaProgressBarUI
extends ProgressBarUI
implements ChangeListener,
PropertyChangeListener,
AncestorListener,
AquaUtilControlSize.Sizeable {
    private static final boolean ADJUSTTIMER = true;
    protected static final AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor> sizeDescriptor = new AquaUtils.LazySingleton<AquaUtilControlSize.SizeDescriptor>(){

        @Override
        protected AquaUtilControlSize.SizeDescriptor getInstance() {
            return new AquaUtilControlSize.SizeDescriptor(new AquaUtilControlSize.SizeVariant(146, 20)){

                @Override
                public AquaUtilControlSize.SizeVariant deriveSmall(AquaUtilControlSize.SizeVariant sizeVariant) {
                    sizeVariant.alterMinSize(0, -6);
                    return super.deriveSmall(sizeVariant);
                }
            };
        }
    };
    protected JRSUIConstants.Size sizeVariant = JRSUIConstants.Size.REGULAR;
    protected Color selectionForeground;
    private Animator animator;
    protected boolean isAnimating;
    protected boolean isCircular;
    protected final AquaPainter<JRSUIState.ValueState> painter = AquaPainter.create(JRSUIStateFactory.getProgressBar());
    protected JProgressBar progressBar;
    private final Rectangle fUpdateArea = new Rectangle(0, 0, 0, 0);
    private final Dimension fLastSize = new Dimension(0, 0);

    static AquaUtilControlSize.SizeDescriptor getSizeDescriptor() {
        return sizeDescriptor.get();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaProgressBarUI();
    }

    protected AquaProgressBarUI() {
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.stopAnimationTimer();
        this.progressBar = null;
    }

    protected void installDefaults() {
        this.progressBar.setOpaque(false);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.progressBar.addChangeListener(this);
        this.progressBar.addPropertyChangeListener(this);
        this.progressBar.addAncestorListener(this);
        AquaUtilControlSize.addSizePropertyListener(this.progressBar);
    }

    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.progressBar);
        this.progressBar.removeAncestorListener(this);
        this.progressBar.removePropertyChangeListener(this);
        this.progressBar.removeChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.progressBar.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("indeterminate".equals(string)) {
            if (!this.progressBar.isIndeterminate()) {
                return;
            }
            this.stopAnimationTimer();
            this.startAnimationTimer();
        }
        if ("JProgressBar.style".equals(string)) {
            this.isCircular = "circular".equalsIgnoreCase(propertyChangeEvent.getNewValue() + "");
            this.progressBar.repaint();
        }
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.stopAnimationTimer();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        if (!this.progressBar.isIndeterminate()) {
            return;
        }
        this.startAnimationTimer();
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.revalidateAnimationTimers();
        ((JRSUIState.ValueState)this.painter.state).set(this.getState(jComponent));
        ((JRSUIState.ValueState)this.painter.state).set(this.isHorizontal() ? JRSUIConstants.Orientation.HORIZONTAL : JRSUIConstants.Orientation.VERTICAL);
        ((JRSUIState.ValueState)this.painter.state).set(AquaUtils.isLeftToRight(jComponent) ? JRSUIConstants.UserInterfaceLayoutDirection.LEFT_TO_RIGHT : JRSUIConstants.UserInterfaceLayoutDirection.RIGHT_TO_LEFT);
        ((JRSUIState.ValueState)this.painter.state).set(this.isAnimating ? JRSUIConstants.Animating.YES : JRSUIConstants.Animating.NO);
        if (this.progressBar.isIndeterminate()) {
            if (this.isCircular) {
                ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_SPINNER);
                this.painter.paint(graphics, jComponent, 2, 2, 16, 16);
                return;
            }
            ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_INDETERMINATE_BAR);
            this.paint(graphics);
            return;
        }
        ((JRSUIState.ValueState)this.painter.state).set(JRSUIConstants.Widget.PROGRESS_BAR);
        ((JRSUIState.ValueState)this.painter.state).setValue(AquaProgressBarUI.checkValue(this.progressBar.getPercentComplete()));
        this.paint(graphics);
    }

    static double checkValue(double d) {
        return Double.isNaN(d) ? 0.0 : d;
    }

    protected void paint(Graphics graphics) {
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.bottom + insets.top);
        this.painter.paint(graphics, this.progressBar, insets.left, insets.top, n, n2);
        if (this.progressBar.isStringPainted() && !this.progressBar.isIndeterminate()) {
            this.paintString(graphics, insets.left, insets.top, n, n2);
        }
    }

    protected JRSUIConstants.State getState(JComponent jComponent) {
        if (!jComponent.isEnabled()) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!AquaFocusHandler.isActive(jComponent)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected void paintString(Graphics graphics, int n, int n2, int n3, int n4) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n, n2, n3, n4);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.isHorizontal()) {
            graphics2D.setColor(this.selectionForeground);
            graphics2D.drawString(string, point.x, point.y);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.transform(AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0));
            graphics2D.translate(-this.progressBar.getHeight(), 0);
            graphics2D.setColor(this.selectionForeground);
            graphics2D.drawString(string, point.x, point.y);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setClip(rectangle);
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        int n5 = fontMetrics.stringWidth(string);
        if (!this.isHorizontal()) {
            int n6 = n4;
            n4 = n3;
            n3 = n6;
            int n7 = n;
            n = n2;
            n2 = n7;
        }
        return new Point(n + Math.round(n3 / 2 - n5 / 2), n2 + (n4 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2 - 1);
    }

    static Dimension getCircularPreferredSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        Dimension dimension = this.isHorizontal() ? this.getPreferredHorizontalSize(fontMetrics) : this.getPreferredVerticalSize(fontMetrics);
        Insets insets = this.progressBar.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected Dimension getPreferredHorizontalSize(FontMetrics fontMetrics) {
        int n;
        AquaUtilControlSize.SizeVariant sizeVariant = AquaProgressBarUI.getSizeDescriptor().get(this.sizeVariant);
        Dimension dimension = new Dimension(sizeVariant.w, sizeVariant.h);
        if (!this.progressBar.isStringPainted()) {
            return dimension;
        }
        String string = this.progressBar.getString();
        int n2 = fontMetrics.stringWidth(string);
        if (n2 > dimension.width) {
            dimension.width = n2;
        }
        if ((n = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
            dimension.height = n;
        }
        return dimension;
    }

    protected Dimension getPreferredVerticalSize(FontMetrics fontMetrics) {
        int n;
        AquaUtilControlSize.SizeVariant sizeVariant = AquaProgressBarUI.getSizeDescriptor().get(this.sizeVariant);
        Dimension dimension = new Dimension(sizeVariant.h, sizeVariant.w);
        if (!this.progressBar.isStringPainted()) {
            return dimension;
        }
        String string = this.progressBar.getString();
        int n2 = fontMetrics.getHeight() + fontMetrics.getDescent();
        if (n2 > dimension.width) {
            dimension.width = n2;
        }
        if ((n = fontMetrics.stringWidth(string)) > dimension.height) {
            dimension.height = n;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.isCircular) {
            return AquaProgressBarUI.getCircularPreferredSize();
        }
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.isHorizontal()) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    @Override
    public void applySizeFor(JComponent jComponent, JRSUIConstants.Size size) {
        this.sizeVariant = size == JRSUIConstants.Size.MINI ? JRSUIConstants.Size.SMALL : this.sizeVariant;
        ((JRSUIState.ValueState)this.painter.state).set(this.sizeVariant);
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start();
        this.isAnimating = true;
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
        this.isAnimating = false;
    }

    protected Rectangle getRepaintRect() {
        int n = this.progressBar.getHeight();
        int n2 = this.progressBar.getWidth();
        if (this.isCircular) {
            return new Rectangle(20, 20);
        }
        if (this.fLastSize.height == n && this.fLastSize.width == n2) {
            return this.fUpdateArea;
        }
        int n3 = 0;
        int n4 = 0;
        this.fLastSize.height = n;
        this.fLastSize.width = n2;
        int n5 = this.getMaxProgressBarHeight();
        if (this.isHorizontal()) {
            int n6 = n - n5;
            n4 += n6 / 2;
            n = n5;
        } else {
            int n7 = n2 - n5;
            n3 += n7 / 2;
            n2 = n5;
        }
        this.fUpdateArea.setBounds(n3, n4, n2, n);
        return this.fUpdateArea;
    }

    protected int getMaxProgressBarHeight() {
        return AquaProgressBarUI.getSizeDescriptor().get((JRSUIConstants.Size)this.sizeVariant).h;
    }

    protected boolean isHorizontal() {
        return this.progressBar.getOrientation() == 0;
    }

    protected void revalidateAnimationTimers() {
        if (this.progressBar.isIndeterminate()) {
            return;
        }
        if (!this.isAnimating) {
            this.startAnimationTimer();
            return;
        }
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        double d = boundedRangeModel.getValue();
        if (d == (double)boundedRangeModel.getMaximum() || d == (double)boundedRangeModel.getMinimum()) {
            this.stopAnimationTimer();
        }
    }

    protected void repaint() {
        Rectangle rectangle = this.getRepaintRect();
        if (rectangle == null) {
            this.progressBar.repaint();
            return;
        }
        this.progressBar.repaint(rectangle);
    }

    protected class Animator
    implements ActionListener {
        private static final int MINIMUM_DELAY = 5;
        private Timer timer;
        private long previousDelay;
        private long lastCall;
        private int repaintInterval = UIManager.getInt("ProgressBar.repaintInterval");

        public Animator() {
            if (this.repaintInterval <= 0) {
                this.repaintInterval = 100;
            }
        }

        protected void start() {
            this.previousDelay = this.repaintInterval;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(this.repaintInterval, this);
            } else {
                this.timer.setDelay(this.repaintInterval);
            }
            this.timer.setRepeats(false);
            this.timer.setCoalesce(false);
            this.timer.start();
        }

        protected void stop() {
            this.timer.stop();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = System.currentTimeMillis();
            if (this.lastCall > 0L) {
                int n = (int)(this.previousDelay - l + this.lastCall + (long)this.repaintInterval);
                if (n < 5) {
                    n = 5;
                }
                this.timer.setInitialDelay(n);
                this.previousDelay = n;
            }
            this.timer.start();
            this.lastCall = l;
            AquaProgressBarUI.this.repaint();
        }
    }
}

