/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaCaret;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaHighlighter;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaTextFieldBorder;
import com.apple.laf.AquaTextFieldSearch;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class AquaTextFieldUI
extends BasicTextFieldUI {
    protected AquaUtils.JComponentPainter delegate;
    protected AquaFocusHandler handler;
    boolean oldDragState = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTextFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.handler = new AquaFocusHandler();
        JTextComponent jTextComponent = this.getComponent();
        jTextComponent.addFocusListener(this.handler);
        jTextComponent.addPropertyChangeListener(this.handler);
        LookAndFeel.installProperty(jTextComponent, "opaque", UIManager.getBoolean(this.getPropertyPrefix() + "opaque"));
        AquaUtilControlSize.addSizePropertyListener(jTextComponent);
        AquaTextFieldSearch.installSearchFieldListener(jTextComponent);
    }

    @Override
    protected void uninstallListeners() {
        JTextComponent jTextComponent = this.getComponent();
        AquaTextFieldSearch.uninstallSearchFieldListener(jTextComponent);
        AquaUtilControlSize.removeSizePropertyListener(jTextComponent);
        jTextComponent.removeFocusListener(this.handler);
        jTextComponent.removePropertyChangeListener(this.handler);
        this.handler = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.oldDragState = this.getComponent().getDragEnabled();
            this.getComponent().setDragEnabled(true);
        }
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (!GraphicsEnvironment.isHeadless()) {
            this.getComponent().setDragEnabled(this.oldDragState);
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        aquaKeyBindings.setDefaultAction(this.getKeymapName());
        aquaKeyBindings.installFullWordDeleteAction(this.getComponent());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = super.getVisibleEditorRect();
        if (rectangle == null) {
            return null;
        }
        if (!this.getComponent().isOpaque()) {
            rectangle.y -= 3;
            rectangle.height += 6;
        }
        return rectangle;
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        this.paintBackgroundSafely(graphics);
        super.paintSafely(graphics);
    }

    protected void paintBackgroundSafely(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        int n = jTextComponent.getWidth();
        int n2 = jTextComponent.getHeight();
        if (this.delegate != null) {
            this.delegate.paint(jTextComponent, graphics, 0, 0, n, n2);
            return;
        }
        boolean bl = jTextComponent.isOpaque();
        if (!(jTextComponent.getBorder() instanceof AquaTextFieldBorder)) {
            if (!bl && AquaUtils.hasOpaqueBeenExplicitlySet(jTextComponent)) {
                return;
            }
            graphics.setColor(jTextComponent.getBackground());
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        graphics.setColor(jTextComponent.getBackground());
        if (bl) {
            graphics.fillRect(0, 0, n, n2);
            return;
        }
        Insets insets = jTextComponent.getMargin();
        Insets insets2 = jTextComponent.getInsets();
        if (insets2 == null) {
            insets2 = new Insets(0, 0, 0, 0);
        }
        if (insets != null) {
            insets2.top -= insets.top;
            insets2.left -= insets.left;
            insets2.bottom -= insets.bottom;
            insets2.right -= insets.right;
        }
        int n3 = AquaTextFieldBorder.getShrinkageFor(jTextComponent, n2);
        graphics.fillRect(insets2.left - 2, insets2.top - n3 - 1, n - insets2.right - insets2.left + 4, n2 - insets2.bottom - insets2.top + n3 * 2 + 2);
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    @Override
    protected Caret createCaret() {
        JTextComponent jTextComponent = this.getComponent();
        Window window = SwingUtilities.getWindowAncestor(jTextComponent);
        return new AquaCaret(window, jTextComponent);
    }

    @Override
    protected Highlighter createHighlighter() {
        return new AquaHighlighter();
    }

    protected void setPaintingDelegate(AquaUtils.JComponentPainter jComponentPainter) {
        this.delegate = jComponentPainter;
    }
}

