% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TuneControl.R, R/TuneControlCMAES.R, R/TuneControlDesign.R, R/TuneControlGenSA.R, R/TuneControlGrid.R, R/TuneControlIrace.R, R/TuneControlRandom.R
\name{TuneControl}
\alias{TuneControl}
\alias{TuneControlCMAES}
\alias{TuneControlGenSA}
\alias{TuneControlGrid}
\alias{TuneControlIrace}
\alias{TuneControlRandom}
\alias{makeTuneControlCMAES}
\alias{makeTuneControlDesign}
\alias{makeTuneControlGenSA}
\alias{makeTuneControlGrid}
\alias{makeTuneControlIrace}
\alias{makeTuneControlRandom}
\title{Create control structures for tuning.}
\usage{
makeTuneControlCMAES(same.resampling.instance = TRUE, impute.val = NULL,
  start = NULL, tune.threshold = FALSE, tune.threshold.args = list(),
  log.fun = NULL, final.dw.perc = NULL, budget = NULL, ...)

makeTuneControlDesign(same.resampling.instance = TRUE, impute.val = NULL,
  design = NULL, tune.threshold = FALSE, tune.threshold.args = list(),
  log.fun = NULL, budget = NULL)

makeTuneControlGenSA(same.resampling.instance = TRUE, impute.val = NULL,
  start = NULL, tune.threshold = FALSE, tune.threshold.args = list(),
  log.fun = NULL, final.dw.perc = NULL, budget = NULL, ...)

makeTuneControlGrid(same.resampling.instance = TRUE, impute.val = NULL,
  resolution = 10L, tune.threshold = FALSE, tune.threshold.args = list(),
  log.fun = NULL, final.dw.perc = NULL, budget = NULL)

makeTuneControlIrace(impute.val = NULL, n.instances = 100L,
  show.irace.output = FALSE, tune.threshold = FALSE,
  tune.threshold.args = list(), log.fun = NULL, final.dw.perc = NULL,
  budget = NULL, ...)

makeTuneControlRandom(same.resampling.instance = TRUE, maxit = 100L,
  tune.threshold = FALSE, tune.threshold.args = list(), log.fun = NULL,
  final.dw.perc = NULL, budget = NULL)
}
\arguments{
\item{same.resampling.instance}{[\code{logical(1)}]\cr
Should the same resampling instance be used for all evaluations to reduce variance?
Default is \code{TRUE}.}

\item{impute.val}{[\code{numeric}]\cr
If something goes wrong during optimization (e.g, the learner crashes),
this value is fed back to the tuner, so the tuning algorithm does not abort.
It is not stored in the optimization path, an NA and a corresponding error message are
logged instead.
Note that this value is later multiplied by -1 for maximization measures internally, so you
need to enter a larger positive value for maximization here as well.
Default is the worst obtainable value of the performance measure you optimize for when
you aggregate by mean value, or \code{Inf} instead.
For multi-criteria optimization pass a vector of imputation values, one for each of your measures,
in the same order as your measures.}

\item{start}{[\code{list}]\cr
Named list of initial parameter values.}

\item{tune.threshold}{[\code{logical(1)}]\cr
Should the threshold be tuned for the measure at hand, after each hyperparameter evaluation,
via \code{\link{tuneThreshold}}?
Only works for classification if the predict type is \dQuote{prob}.
Default is \code{FALSE}.}

\item{tune.threshold.args}{[\code{list}]\cr
Further arguments for threshold tuning that are passed down to \code{\link{tuneThreshold}}.
Default is none.}

\item{log.fun}{[\code{function} | \code{NULL}]\cr
Function used for logging. If set to \code{NULL}, the internal default will be used.
Otherwise a function with arguments \code{learner}, \code{resampling}, \code{measures},
\code{par.set}, \code{control}, \code{opt.path}, \code{dob}, \code{x}, \code{y}, \code{remove.nas},
and \code{stage} is expected.
The default displays the performance measures, the time needed for evaluating,
the currently used memory and the max memory ever used before
(the latter two both taken from \code{\link{gc}}).
See the implementation for details.}

\item{final.dw.perc}{[\code{boolean}]\cr
If a Learner wrapped by a \code{\link{makeDownsampleWrapper}} is used, you can define the value of \code{dw.perc} which is used to train the Learner with the final parameter setting found by the tuning.
Default is \code{NULL} which will not change anything.}

\item{budget}{[\code{integer(1)}]\cr
Maximum budget for tuning. This value restricts the number of function
evaluations. In case of \code{makeTuneControlGrid} this number must be identical
to the size of the grid. For \code{makeTuneControlRandom} the
\code{budget} equals the number of iterations (\code{maxit}) performed by
the random search algorithm. Within the \code{\link[cmaes]{cma_es}} the
\code{budget} corresponds to the product of the number of generations
(\code{maxit}) and the number of offsprings per generation
(\code{lambda}). \code{\link[GenSA]{GenSA}} defines the \code{budget} via
the argument \code{max.call}. However, one should note that this algorithm
does not stop its local search before its end. This behaviour might lead
to an extension of the defined budget and will result in a warning. In
\code{irace}, \code{budget} is passed to \code{maxExperiments}.}

\item{...}{[any]\cr
Further control parameters passed to the \code{control} arguments of
\code{\link[cmaes]{cma_es}} or \code{\link[GenSA]{GenSA}}, as well as
towards the \code{tunerConfig} argument of \code{\link[irace]{irace}}.}

\item{design}{[\code{data.frame}]\cr
\code{data.frame} containing the different parameter settings to be evaluated.
The columns have to be named according to the \code{ParamSet} which will be used in \code{tune()}.
Proper designs can be created with \code{\link[ParamHelpers]{generateDesign}} for instance.}

\item{resolution}{[\code{integer}]\cr
Resolution of the grid for each numeric/integer parameter in \code{par.set}.
For vector parameters, it is the resolution per dimension.
Either pass one resolution for all parameters, or a named vector.
See \code{\link[ParamHelpers]{generateGridDesign}}.
Default is 10.}

\item{n.instances}{[\code{integer(1)}]\cr
Number of random resampling instances for irace, see details.
Default is 100.}

\item{show.irace.output}{[\code{logical(1)}]\cr
Show console output of irace while tuning?
Default is \code{FALSE}.}

\item{maxit}{[\code{integer(1)} | NULL]\cr
Number of iterations for random search.
Default is 100.}
}
\value{
[\code{\link{TuneControl}}]. The specific subclass is one of
  \code{\link{TuneControlGrid}}, \code{\link{TuneControlRandom}},
  \code{\link{TuneControlCMAES}}, \code{\link{TuneControlGenSA}},
  \code{\link{TuneControlIrace}}.
}
\description{
The following tuners are available:
\describe{
  \item{makeTuneControlGrid}{Grid search. All kinds of parameter types can be handled.
    You can either use their correct param type and \code{resolution},
    or discretize them yourself by always using \code{\link[ParamHelpers]{makeDiscreteParam}}
    in the \code{par.set} passed to \code{\link{tuneParams}}.}
  \item{makeTuneControlRandom}{Random search. All kinds of parameter types can be handled.}
  \item{makeTuneControlDesign}{Completely pre-specifiy a data.frame of design points to be evaluated
    during tuning. All kinds of parameter types can be handled.}
  \item{makeTuneControlCMAES}{CMA Evolution Strategy with method \code{\link[cmaes]{cma_es}}.
    Can handle numeric(vector) and integer(vector) hyperparameters, but no dependencies.
    For integers the internally proposed numeric values are automatically rounded.
    The sigma variance parameter is initialized to 1/4 of the span of box-constraints per
    parameter dimension.}
  \item{makeTuneControlGenSA}{Generalized simulated annealing with method \code{\link[GenSA]{GenSA}}.
    Can handle numeric(vector) and integer(vector) hyperparameters, but no dependencies.
    For integers the internally proposed numeric values are automatically rounded.}
  \item{makeTuneControlIrace}{Tuning with iterated F-Racing with method \code{\link[irace]{irace}}.
    All kinds of parameter types can be handled. We return the best of the final elite
    candidates found by irace in the last race. Its estimated performance is the mean of all
    evaluations ever done for that candidate.}
}

Some notes on irace: For resampling you have to pass a \code{\link{ResampleDesc}},
not a \code{\link{ResampleInstance}}.
The resampling strategy is randomly instantiated \code{n.instances} times and
these are the instances in the sense of irace (\code{instances} element of \code{tunerConfig}
in \code{\link[irace]{irace}}). Also note that irace will always
store its tuning results in a file on disk, see the package documentation for details on this
and how to change the file path.
}
\seealso{
Other tune: \code{\link{getNestedTuneResultsOptPathDf}},
  \code{\link{getNestedTuneResultsX}},
  \code{\link{getTuneResult}},
  \code{\link{makeModelMultiplexerParamSet}},
  \code{\link{makeModelMultiplexer}},
  \code{\link{makeTuneWrapper}}, \code{\link{tuneParams}},
  \code{\link{tuneThreshold}}
}

